/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Agent;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.Environment;
import com.mojang.authlib.EnvironmentParser;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ServicesKeyInfo;
import com.mojang.authlib.yggdrasil.YggdrasilEnvironment;
import com.mojang.authlib.yggdrasil.YggdrasilGameProfileRepository;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilServicesKeyInfo;
import com.mojang.authlib.yggdrasil.YggdrasilUserApiService;
import java.net.Proxy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YggdrasilAuthenticationService
implements AuthenticationService {
    private static final Logger logger = LogManager.getLogger(YggdrasilMinecraftSessionService.class);
    private final Environment environment;
    private final Proxy proxy;
    private final ServicesKeyInfo servicesKeyInfo = YggdrasilServicesKeyInfo.createFromResources();

    public YggdrasilAuthenticationService(Proxy proxy) {
        this(proxy, YggdrasilAuthenticationService.determineEnvironment());
    }

    public YggdrasilAuthenticationService(Proxy proxy, Environment environment) {
        this(proxy, null, environment);
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken) {
        this(proxy, clientToken, YggdrasilAuthenticationService.determineEnvironment());
        logger.debug("Patched AuthenticationService created: '{}'", (Object)clientToken);
    }

    public YggdrasilAuthenticationService(Proxy proxy, String clientToken, Environment environment) {
        this.proxy = proxy;
        this.environment = environment;
    }

    private static Environment determineEnvironment() {
        return EnvironmentParser.getEnvironmentFromProperties().orElse(YggdrasilEnvironment.PROD.getEnvironment());
    }

    @Override
    public UserAuthentication createUserAuthentication(Agent agent) {
        throw new UnsupportedOperationException("createUserAuthentication is used only by Mojang Launcher");
    }

    @Override
    public MinecraftSessionService createMinecraftSessionService() {
        return new YggdrasilMinecraftSessionService(this, this.environment);
    }

    @Override
    public GameProfileRepository createProfileRepository() {
        return new YggdrasilGameProfileRepository(this, this.environment);
    }

    public UserApiService createUserApiService(String accessToken) throws AuthenticationException {
        return new YggdrasilUserApiService(accessToken, this.proxy, this.environment);
    }

    public ServicesKeyInfo getServicesKey() {
        return this.servicesKeyInfo;
    }
}

