/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.text2speech;

import com.google.common.collect.Queues;
import com.mojang.text2speech.Narrator;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.WString;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarratorWindows
implements Narrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NarratorWindows.class);
    private static final boolean libraryFound = NarratorWindows.tryLoadNative();
    private static long voice;
    private static boolean stopping;
    private final NarratorThread narratorThread = new NarratorThread();
    private boolean crashed = false;

    private static boolean tryLoadNative() {
        try {
            Native.register(SAPIWrapperSolutionDLL.class, (NativeLibrary)NativeLibrary.getInstance((String)"SAPIWrapper_x64"));
            LOGGER.info("Narrator library for x64 successfully loaded");
            return true;
        }
        catch (Throwable e64) {
            try {
                Native.register(SAPIWrapperSolutionDLL.class, (NativeLibrary)NativeLibrary.getInstance((String)"SAPIWrapper_x86"));
                LOGGER.info("Narrator library for x86 successfully loaded");
                return true;
            }
            catch (Throwable e86) {
                LOGGER.error("Failed to load Narrator libraries");
                LOGGER.error("32-bit version failed to load", e86);
                LOGGER.error("64-bit version failed to load", e64);
                return false;
            }
        }
    }

    public NarratorWindows() {
        Thread thread = new Thread(this.narratorThread);
        thread.setName("Narrator");
        thread.start();
    }

    @Override
    public void say(String msg, boolean interrupt) {
        if (this.crashed) {
            return;
        }
        try {
            this.narratorThread.add(new Message(msg, interrupt));
        }
        catch (Throwable e) {
            this.crashed = true;
            LOGGER.error(String.format("Narrator crashed : %s", e));
        }
    }

    @Override
    public void clear() {
        this.narratorThread.clear();
        this.narratorThread.add(new Message("", true));
    }

    @Override
    public boolean active() {
        return libraryFound;
    }

    @Override
    public void destroy() {
        stopping = true;
        try {
            this.narratorThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SAPIWrapperSolutionDLL.uninit(voice);
    }

    static {
        if (libraryFound) {
            try {
                voice = SAPIWrapperSolutionDLL.init();
                if (voice == 0L) {
                    LOGGER.error("Couldn't create a voice");
                }
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.error("Couldn't load Narrator library", (Throwable)e);
            }
            catch (Throwable e) {
                LOGGER.error("Generic error while loading narrator", e);
            }
        }
    }

    private static class SAPIWrapperSolutionDLL {
        private SAPIWrapperSolutionDLL() {
        }

        public static native long init();

        public static native void uninit(long var0);

        public static native void queue(long var0, WString var2, boolean var3);
    }

    private static class NarratorThread
    extends Thread {
        protected final Queue<Message> msgs = Queues.newConcurrentLinkedQueue();

        private NarratorThread() {
        }

        @Override
        public void run() {
            while (!stopping) {
                if (this.msgs.peek() != null) {
                    this.msgs.poll().apply();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void add(Message msg) {
            this.msgs.add(msg);
        }

        public void clear() {
            this.msgs.clear();
        }
    }

    private class Message {
        final String text;
        final boolean interrupt;

        private Message(String text, boolean interrupt) {
            this.text = text;
            this.interrupt = interrupt;
        }

        public void apply() {
            SAPIWrapperSolutionDLL.queue(voice, new WString(this.text.replaceAll("[<>]", "")), this.interrupt);
        }
    }
}

