/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper.extension.mixin;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.tinyremapper.TinyRemapper;
import net.fabricmc.tinyremapper.api.TrClass;
import net.fabricmc.tinyremapper.api.TrEnvironment;
import net.fabricmc.tinyremapper.extension.mixin.common.Logger;
import net.fabricmc.tinyremapper.extension.mixin.common.data.CommonData;
import net.fabricmc.tinyremapper.extension.mixin.hard.HardTargetMixinClassVisitor;
import net.fabricmc.tinyremapper.extension.mixin.soft.SoftTargetMixinClassVisitor;
import org.objectweb.asm.ClassVisitor;

public class MixinExtension
implements TinyRemapper.Extension {
    private final Logger logger;
    private final Map<Integer, List<Consumer<CommonData>>> tasks;
    private final Set<AnnotationTarget> targets;

    public MixinExtension() {
        this(Logger.Level.WARN);
    }

    public MixinExtension(Logger.Level logLevel) {
        this(EnumSet.allOf(AnnotationTarget.class), logLevel);
    }

    public MixinExtension(Set<AnnotationTarget> targets) {
        this(targets, Logger.Level.WARN);
    }

    public MixinExtension(Set<AnnotationTarget> targets, Logger.Level logLevel) {
        this.logger = new Logger(logLevel);
        this.tasks = new HashMap<Integer, List<Consumer<CommonData>>>();
        this.targets = targets;
    }

    @Override
    public void attach(TinyRemapper.Builder builder) {
        if (this.targets.contains((Object)AnnotationTarget.HARD)) {
            builder.extraAnalyzeVisitor(this::analyzeVisitor).extraStateProcessor(this::stateProcessor);
        }
        if (this.targets.contains((Object)AnnotationTarget.SOFT)) {
            builder.extraPreApplyVisitor(this::preApplyVisitor);
        }
    }

    private ClassVisitor analyzeVisitor(int mrjVersion, String className, ClassVisitor next) {
        this.tasks.putIfAbsent(mrjVersion, new ArrayList());
        return new HardTargetMixinClassVisitor(this.tasks.get(mrjVersion), next);
    }

    private void stateProcessor(TrEnvironment environment) {
        CommonData data = new CommonData(environment, this.logger);
        for (Consumer<CommonData> task : this.tasks.get(environment.getMrjVersion())) {
            try {
                task.accept(data);
            }
            catch (RuntimeException e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    public ClassVisitor preApplyVisitor(TrClass cls, ClassVisitor next) {
        return new SoftTargetMixinClassVisitor(new CommonData(cls.getEnvironment(), this.logger), next);
    }

    public static enum AnnotationTarget {
        SOFT,
        HARD;

    }
}

