/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.shaderpack.DirectiveHolder;
import org.joml.Vector4f;

public class PackRenderTargetDirectives {
    public static final ImmutableList<String> LEGACY_RENDER_TARGETS = ImmutableList.of((Object)"gcolor", (Object)"gdepth", (Object)"gnormal", (Object)"composite", (Object)"gaux1", (Object)"gaux2", (Object)"gaux3", (Object)"gaux4");
    public static final Set<Integer> BASELINE_SUPPORTED_RENDER_TARGETS;
    private final Int2ObjectMap<RenderTargetSettings> renderTargetSettings = new Int2ObjectOpenHashMap();

    PackRenderTargetDirectives(Set<Integer> set) {
        set.forEach(n -> this.renderTargetSettings.put(n.intValue(), (Object)new RenderTargetSettings()));
    }

    public IntList getBuffersToBeCleared() {
        IntArrayList intArrayList = new IntArrayList();
        this.renderTargetSettings.forEach((arg_0, arg_1) -> PackRenderTargetDirectives.lambda$getBuffersToBeCleared$1((IntList)intArrayList, arg_0, arg_1));
        return intArrayList;
    }

    public Map<Integer, RenderTargetSettings> getRenderTargetSettings() {
        return Collections.unmodifiableMap(this.renderTargetSettings);
    }

    public void acceptDirectives(DirectiveHolder directiveHolder) {
        Optional.ofNullable((RenderTargetSettings)this.renderTargetSettings.get(7)).ifPresent(renderTargetSettings -> directiveHolder.acceptCommentStringDirective("GAUX4FORMAT", string -> {
            if ("RGBA32F".equals(string)) {
                renderTargetSettings.requestedFormat = InternalTextureFormat.RGBA32F;
            } else if ("RGB32F".equals(string)) {
                renderTargetSettings.requestedFormat = InternalTextureFormat.RGB32F;
            } else if ("RGB16".equals(string)) {
                renderTargetSettings.requestedFormat = InternalTextureFormat.RGB16;
            } else {
                Iris.logger.warn("Ignoring GAUX4FORMAT directive /* GAUX4FORMAT:" + string + "*/ because " + string + " must be RGBA32F, RGB32F, or RGB16. Use `const int colortex7Format = " + string + ";` + instead.");
            }
        }));
        Optional.ofNullable((RenderTargetSettings)this.renderTargetSettings.get(1)).ifPresent(renderTargetSettings -> directiveHolder.acceptUniformDirective("gdepth", () -> {
            if (renderTargetSettings.requestedFormat == InternalTextureFormat.RGBA) {
                renderTargetSettings.requestedFormat = InternalTextureFormat.RGBA32F;
            }
        }));
        this.renderTargetSettings.forEach((n, renderTargetSettings) -> {
            this.acceptBufferDirectives(directiveHolder, (RenderTargetSettings)renderTargetSettings, "colortex" + n);
            if (n < LEGACY_RENDER_TARGETS.size()) {
                this.acceptBufferDirectives(directiveHolder, (RenderTargetSettings)renderTargetSettings, (String)LEGACY_RENDER_TARGETS.get(n.intValue()));
            }
        });
    }

    private void acceptBufferDirectives(DirectiveHolder directiveHolder, RenderTargetSettings renderTargetSettings, String string) {
        directiveHolder.acceptConstStringDirective(string + "Format", string2 -> {
            Optional<InternalTextureFormat> optional = InternalTextureFormat.fromString(string2);
            if (optional.isPresent()) {
                renderTargetSettings.requestedFormat = optional.get();
            } else {
                Iris.logger.warn("Unrecognized internal texture format " + string2 + " specified for " + string + "Format, ignoring.");
            }
        });
        directiveHolder.acceptConstBooleanDirective(string + "Clear", bl -> {
            renderTargetSettings.clear = bl;
        });
        directiveHolder.acceptConstVec4Directive(string + "ClearColor", vector4f -> {
            renderTargetSettings.clearColor = vector4f;
        });
    }

    private static /* synthetic */ void lambda$getBuffersToBeCleared$1(IntList intList, Integer n, RenderTargetSettings renderTargetSettings) {
        if (renderTargetSettings.shouldClear()) {
            intList.add(n.intValue());
        }
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < 16; ++i) {
            builder.add((Object)i);
        }
        BASELINE_SUPPORTED_RENDER_TARGETS = builder.build();
    }

    public static final class RenderTargetSettings {
        private InternalTextureFormat requestedFormat = InternalTextureFormat.RGBA;
        private boolean clear = true;
        private Vector4f clearColor = null;

        public InternalTextureFormat getInternalFormat() {
            return this.requestedFormat;
        }

        public boolean shouldClear() {
            return this.clear;
        }

        public Optional<Vector4f> getClearColor() {
            return Optional.ofNullable(this.clearColor);
        }

        public String toString() {
            return "RenderTargetSettings{requestedFormat=" + this.requestedFormat + ", clear=" + this.clear + ", clearColor=" + this.clearColor + "}";
        }
    }
}

