/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.rendertarget.DepthTexture;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.shaderpack.PackShadowDirectives;

public class ShadowRenderTargets {
    private final RenderTarget[] targets;
    private final PackShadowDirectives shadowDirectives;
    private final DepthTexture mainDepth;
    private final DepthTexture noTranslucents;
    private final GlFramebuffer depthSourceFb;
    private final GlFramebuffer noTranslucentsDestFb;
    private final boolean[] flipped;
    private final List<GlFramebuffer> ownedFramebuffers;
    private final int resolution;
    private final WorldRenderingPipeline pipeline;
    private boolean fullClearRequired;
    private boolean translucentDepthDirty;
    private boolean[] hardwareFiltered;
    private boolean[] linearFiltered;
    private InternalTextureFormat[] formats;
    private IntList buffersToBeCleared;
    private int size;

    public ShadowRenderTargets(WorldRenderingPipeline worldRenderingPipeline, int n, PackShadowDirectives packShadowDirectives) {
        this.pipeline = worldRenderingPipeline;
        this.shadowDirectives = packShadowDirectives;
        this.size = worldRenderingPipeline.hasFeature(FeatureFlags.HIGHER_SHADOWCOLOR) ? 8 : 2;
        this.targets = new RenderTarget[this.size];
        this.formats = new InternalTextureFormat[this.size];
        this.flipped = new boolean[this.size];
        this.hardwareFiltered = new boolean[this.size];
        this.linearFiltered = new boolean[this.size];
        this.buffersToBeCleared = new IntArrayList();
        this.mainDepth = new DepthTexture(n, n, DepthBufferFormat.DEPTH);
        this.noTranslucents = new DepthTexture(n, n, DepthBufferFormat.DEPTH);
        for (int i = 0; i < packShadowDirectives.getDepthSamplingSettings().size(); ++i) {
            this.hardwareFiltered[i] = ((PackShadowDirectives.DepthSamplingSettings)packShadowDirectives.getDepthSamplingSettings().get(i)).getHardwareFiltering();
            this.linearFiltered[i] = !((PackShadowDirectives.DepthSamplingSettings)packShadowDirectives.getDepthSamplingSettings().get(i)).getNearest();
        }
        this.resolution = n;
        this.ownedFramebuffers = new ArrayList<GlFramebuffer>();
        this.fullClearRequired = true;
        this.depthSourceFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noTranslucentsDestFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noTranslucentsDestFb.addDepthAttachment(this.noTranslucents.getTextureId());
        this.translucentDepthDirty = true;
    }

    public void flip(int n) {
        this.flipped[n] = !this.flipped[n];
    }

    public boolean isFlipped(int n) {
        return this.flipped[n];
    }

    public void destroy() {
        for (GlFramebuffer glFramebuffer : this.ownedFramebuffers) {
            glFramebuffer.destroy();
        }
        for (RenderTarget renderTarget : this.targets) {
            if (renderTarget == null) continue;
            renderTarget.destroy();
        }
        this.mainDepth.destroy();
        this.noTranslucents.destroy();
    }

    public int getRenderTargetCount() {
        return this.targets.length;
    }

    public RenderTarget get(int n) {
        return this.targets[n];
    }

    public RenderTarget getOrCreate(int n) {
        if (this.targets[n] != null) {
            return this.targets[n];
        }
        this.create(n);
        return this.targets[n];
    }

    private void create(int n2) {
        if (n2 > this.size) {
            throw new IllegalStateException("Tried to access buffer higher than allowed limit of " + this.size + "! If you're trying to use shadowcolor2-7, you need to activate it's feature flag!");
        }
        PackShadowDirectives.SamplingSettings samplingSettings = (PackShadowDirectives.SamplingSettings)this.shadowDirectives.getColorSamplingSettings().computeIfAbsent(n2, n -> new PackShadowDirectives.SamplingSettings());
        this.targets[n2] = RenderTarget.builder().setDimensions(this.resolution, this.resolution).setInternalFormat(samplingSettings.getFormat()).setPixelFormat(samplingSettings.getFormat().getPixelFormat()).build();
        this.formats[n2] = samplingSettings.getFormat();
        if (samplingSettings.getClear()) {
            this.buffersToBeCleared.add(n2);
        }
        if (samplingSettings.getClear()) {
            this.buffersToBeCleared.add(n2);
        }
        this.fullClearRequired = true;
        this.pipeline.onShadowBufferChange();
    }

    public void createIfEmpty(int n) {
        if (this.targets[n] == null) {
            this.create(n);
        }
    }

    public int getResolution() {
        return this.resolution;
    }

    public DepthTexture getDepthTexture() {
        return this.mainDepth;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        return this.noTranslucents;
    }

    public GlFramebuffer getDepthSourceFb() {
        return this.depthSourceFb;
    }

    public void copyPreTranslucentDepth() {
        if (this.translucentDepthDirty) {
            this.translucentDepthDirty = false;
            IrisRenderSystem.blitFramebuffer(this.depthSourceFb.getId(), this.noTranslucentsDestFb.getId(), 0, 0, this.resolution, this.resolution, 0, 0, this.resolution, this.resolution, 256, 9728);
        } else {
            DepthCopyStrategy.fastest(false).copy(this.depthSourceFb, this.mainDepth.getTextureId(), this.noTranslucentsDestFb, this.noTranslucents.getTextureId(), this.resolution, this.resolution);
        }
    }

    public boolean isFullClearRequired() {
        return this.fullClearRequired;
    }

    public void onFullClear() {
        this.fullClearRequired = false;
    }

    public GlFramebuffer createFramebufferWritingToMain(int[] nArray) {
        return this.createFullFramebuffer(false, nArray);
    }

    public GlFramebuffer createFramebufferWritingToAlt(int[] nArray) {
        return this.createFullFramebuffer(true, nArray);
    }

    private ImmutableSet<Integer> invert(ImmutableSet<Integer> immutableSet, int[] nArray) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int n : nArray) {
            if (immutableSet.contains((Object)n)) continue;
            builder.add((Object)n);
        }
        return builder.build();
    }

    private GlFramebuffer createEmptyFramebuffer() {
        GlFramebuffer glFramebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(glFramebuffer);
        glFramebuffer.addDepthAttachment(this.mainDepth.getTextureId());
        glFramebuffer.addColorAttachment(0, this.get(0).getMainTexture());
        glFramebuffer.noDrawBuffers();
        return glFramebuffer;
    }

    public GlFramebuffer createShadowFramebuffer(ImmutableSet<Integer> immutableSet, int[] nArray) {
        if (nArray.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> immutableSet2 = this.invert(immutableSet, nArray);
        GlFramebuffer glFramebuffer = this.createColorFramebuffer(immutableSet2, nArray);
        glFramebuffer.addDepthAttachment(this.mainDepth.getTextureId());
        return glFramebuffer;
    }

    private GlFramebuffer createFullFramebuffer(boolean bl, int[] nArray) {
        if (nArray.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> immutableSet = ImmutableSet.of();
        if (!bl) {
            immutableSet = this.invert((ImmutableSet<Integer>)ImmutableSet.of(), nArray);
        }
        return this.createColorFramebufferWithDepth(immutableSet, nArray);
    }

    public GlFramebuffer createColorFramebufferWithDepth(ImmutableSet<Integer> immutableSet, int[] nArray) {
        GlFramebuffer glFramebuffer = this.createColorFramebuffer(immutableSet, nArray);
        glFramebuffer.addDepthAttachment(this.mainDepth.getTextureId());
        return glFramebuffer;
    }

    public GlFramebuffer createColorFramebuffer(ImmutableSet<Integer> immutableSet, int[] nArray) {
        int n;
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        GlFramebuffer glFramebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(glFramebuffer);
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = n;
            if (nArray[n] >= this.getRenderTargetCount()) {
                this.ownedFramebuffers.remove(glFramebuffer);
                glFramebuffer.destroy();
                return this.createColorFramebuffer(immutableSet, new int[]{0, 1});
            }
            RenderTarget renderTarget = this.getOrCreate(nArray[n]);
            int n2 = immutableSet.contains((Object)nArray[n]) ? renderTarget.getMainTexture() : renderTarget.getAltTexture();
            glFramebuffer.addColorAttachment(n, n2);
        }
        glFramebuffer.drawBuffers(nArray2);
        glFramebuffer.readBuffer(0);
        n = glFramebuffer.getStatus();
        if (n != 36053) {
            throw new IllegalStateException("Unexpected error while creating framebuffer");
        }
        return glFramebuffer;
    }

    public int getColorTextureId(int n) {
        return this.isFlipped(n) ? this.get(n).getAltTexture() : this.get(n).getMainTexture();
    }

    public boolean isHardwareFiltered(int n) {
        return this.hardwareFiltered[n];
    }

    public boolean isLinearFiltered(int n) {
        return this.linearFiltered[n];
    }

    public int getNumColorTextures() {
        return this.targets.length;
    }

    public InternalTextureFormat getColorTextureFormat(int n) {
        return this.formats[n];
    }

    public ImmutableSet<Integer> snapshot() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < this.flipped.length; ++i) {
            if (!this.flipped[i]) continue;
            builder.add((Object)i);
        }
        return builder.build();
    }

    public IntList getBuffersToBeCleared() {
        return this.buffersToBeCleared;
    }
}

