/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import com.mojang.blaze3d.systems.RenderSystem;
import net.coderbot.iris.gl.uniform.DynamicUniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import org.joml.Vector4f;

public class IrisInternalUniforms {
    private IrisInternalUniforms() {
    }

    public static void addFogUniforms(DynamicUniformHolder dynamicUniformHolder, FogMode fogMode) {
        dynamicUniformHolder.uniform4f(UniformUpdateFrequency.PER_FRAME, "iris_FogColor", () -> {
            float[] fArray = RenderSystem.getShaderFogColor();
            return new Vector4f(fArray[0], fArray[1], fArray[2], fArray[3]);
        });
        dynamicUniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "iris_FogStart", RenderSystem::getShaderFogStart).uniform1f(UniformUpdateFrequency.PER_FRAME, "iris_FogEnd", RenderSystem::getShaderFogEnd);
        dynamicUniformHolder.uniform1f("iris_FogDensity", () -> Math.max(0.0f, CapturedRenderingState.INSTANCE.getFogDensity()), runnable -> {});
        dynamicUniformHolder.uniform1f("iris_currentAlphaTest", CapturedRenderingState.INSTANCE::getCurrentAlphaTest, runnable -> {});
        dynamicUniformHolder.uniform1f("alphaTestRef", CapturedRenderingState.INSTANCE::getCurrentAlphaTest, runnable -> {});
    }
}

