/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vertices;

import java.nio.ByteBuffer;
import net.coderbot.iris.vertices.QuadView;

public class BufferBuilderPolygonView
implements QuadView {
    private ByteBuffer buffer;
    private int writePointer;
    private int stride = 48;
    private int vertexAmount;

    public void setup(ByteBuffer byteBuffer, int n, int n2, int n3) {
        this.buffer = byteBuffer;
        this.writePointer = n;
        this.stride = n2;
        this.vertexAmount = n3;
    }

    @Override
    public float x(int n) {
        return this.buffer.getFloat(this.writePointer - this.stride * (this.vertexAmount - n));
    }

    @Override
    public float y(int n) {
        return this.buffer.getFloat(this.writePointer + 4 - this.stride * (this.vertexAmount - n));
    }

    @Override
    public float z(int n) {
        return this.buffer.getFloat(this.writePointer + 8 - this.stride * (this.vertexAmount - n));
    }

    @Override
    public float u(int n) {
        return this.buffer.getFloat(this.writePointer + 16 - this.stride * (this.vertexAmount - n));
    }

    @Override
    public float v(int n) {
        return this.buffer.getFloat(this.writePointer + 20 - this.stride * (this.vertexAmount - n));
    }
}

