/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.config;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Mod.EventBusSubscriber(modid="advancementplaques")
public class AdvancementPlaquesConfig
extends Configuration {
    public static AdvancementPlaquesConfig INSTANCE;
    public boolean onTop;
    public int distance;
    public boolean hideWaila;
    public boolean tasks;
    public boolean goals;
    public boolean challenges;
    public String titleColor;
    public String nameColor;
    public float taskEffectFadeInTime;
    public float taskEffectFadeOutTime;
    public float taskDuration;
    public float goalEffectFadeInTime;
    public float goalEffectFadeOutTime;
    public float goalDuration;
    public float challengeEffectFadeInTime;
    public float challengeEffectFadeOutTime;
    public float challengeDuration;
    public List<String> whitelist;
    public List<String> blacklist;
    public boolean muteTasks;
    public boolean muteGoals;
    public boolean muteChallenges;

    public static void loadConfig(File file) {
        INSTANCE = new AdvancementPlaquesConfig(file);
    }

    public AdvancementPlaquesConfig(File file) {
        super(file);
        this.load();
        try {
            Field categoriesField = Configuration.class.getDeclaredField("categories");
            categoriesField.setAccessible(true);
            LinkedHashMap<String, ConfigCategory> categories = new LinkedHashMap<String, ConfigCategory>();
            categories.put("visual_options", this.getCategory("visual_options"));
            categories.put("duration_options", this.getCategory("duration_options"));
            categories.put("functionality_options", this.getCategory("functionality_options"));
            categoriesField.set((Object)this, categories);
        }
        catch (Exception e) {
            AdvancementPlaques.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        this.onTop = this.getBoolean("on_top", "visual_options", true, "If plaques should show on the top of the screen.");
        this.distance = this.getInt("distance", "visual_options", 16, 8, 256, "The distance from the top or bottom of the screen, in pixels.");
        this.hideWaila = this.getBoolean("hide_waila", "visual_options", false, "Hide waila/hwyla/jade popups while plaques are showing.");
        this.titleColor = this.getString("title_color", "visual_options", "#FF332200", "Text color to use for plaque titles (like \"Advancement made!\"). Enter as a 6-digit or 8-digit hex color code (\"#RRGGBB\" or \"#AARRGGBB\").");
        this.nameColor = this.getString("name_color", "visual_options", "#FFFFFFFF", "Text color to use for advancement names on plaques. Enter as a 6-digit or 8-digit hex color code (\"#RRGGBB\" or \"#AARRGGBB\").");
        this.taskEffectFadeInTime = this.getFloat("task_effect_fadein", "duration_options", 0.5f, 0.1f, 3.0f, "Duration of the shiny effect fade in for tasks.");
        this.taskEffectFadeOutTime = this.getFloat("task_effect_fadeout", "duration_options", 1.5f, 0.1f, 3.0f, "Duration of the shiny effect fade out for tasks.");
        this.taskDuration = this.getFloat("task_duration", "duration_options", 7.0f, 2.0f, 10.0f, "Duration of the plaques for tasks (minus the effect fade in/out durations).");
        this.goalEffectFadeInTime = this.getFloat("goal_effect_fadein", "duration_options", 0.5f, 0.1f, 3.0f, "Duration of the shiny effect fade in for goals.");
        this.goalEffectFadeOutTime = this.getFloat("goal_effect_fadeout", "duration_options", 1.5f, 0.1f, 3.0f, "Duration of the shiny effect fade out for goals.");
        this.goalDuration = this.getFloat("goal_duration", "duration_options", 7.0f, 2.0f, 10.0f, "Duration of the plaques for goals (minus the effect fade in/out durations).");
        this.challengeEffectFadeInTime = this.getFloat("challenge_effect_fadein", "duration_options", 1.25f, 0.1f, 3.0f, "Duration of the shiny effect fade in for challenges.");
        this.challengeEffectFadeOutTime = this.getFloat("challenge_effect_fadeout", "duration_options", 1.5f, 0.1f, 3.0f, "Duration of the shiny effect fade out for challenges.");
        this.challengeDuration = this.getFloat("challenge_duration", "duration_options", 7.0f, 2.0f, 10.0f, "Duration of the plaques for challenges (minus the effect fade in/out durations).");
        this.whitelist = Arrays.asList(this.getStringList("whitelist", "functionality_options", new String[0], "Whitelist of advancements to show plaques for.  Leave empty to display for all.\nSame options available as blacklist."));
        this.blacklist = Arrays.asList(this.getStringList("blacklist", "functionality_options", new String[0], "Blacklist of advancements to never show plaques for.  Takes precedence over whitelist if they conflict.\nOptions:\n Advancement ID (eg. minecraft:adventure/adventuring_time)\n Mod ID (Omit the colon, eg. minecraft)\n Advancement Category (End with a /, eg. minecraft:story/)"));
        this.tasks = this.getBoolean("tasks", "functionality_options", true, "If plaques should show for task advancements (normal advancements).");
        this.goals = this.getBoolean("goals", "functionality_options", true, "If plaques should show for goal advancements (medium-difficulty advancements).");
        this.challenges = this.getBoolean("challenges", "functionality_options", true, "If plaques should show for challenge advancements (high-difficulty advancements).");
        this.muteTasks = this.getBoolean("mute_tasks", "functionality_options", false, "If task sounds should be muted.");
        this.muteGoals = this.getBoolean("mute_goals", "functionality_options", false, "If goal sounds should be muted.");
        this.muteChallenges = this.getBoolean("mute_challenges", "functionality_options", false, "If challenge sounds should be muted.");
        this.save();
    }

    private static boolean advancementEntryMatches(Advancement advancement, String entry) {
        ResourceLocation advancementId = advancement.func_192067_g();
        if (advancementId.toString().equals(entry)) {
            return true;
        }
        if (!entry.contains(":") && advancementId.func_110624_b().toString().equals(entry)) {
            return true;
        }
        return entry.endsWith("/") && advancementId.toString().startsWith(entry);
    }

    public static boolean showPlaqueForAdvancement(Advancement advancement) {
        boolean advancementFiltered;
        DisplayInfo displayInfo = advancement.func_192068_c();
        for (String blacklistEntry : AdvancementPlaquesConfig.INSTANCE.blacklist) {
            if (!AdvancementPlaquesConfig.advancementEntryMatches(advancement, blacklistEntry)) continue;
            return false;
        }
        boolean bl = advancementFiltered = !(displayInfo.func_192291_d() == FrameType.TASK && AdvancementPlaquesConfig.INSTANCE.tasks || displayInfo.func_192291_d() == FrameType.GOAL && AdvancementPlaquesConfig.INSTANCE.goals || displayInfo.func_192291_d() == FrameType.CHALLENGE && AdvancementPlaquesConfig.INSTANCE.challenges);
        if (advancementFiltered) {
            for (String whitelistEntry : AdvancementPlaquesConfig.INSTANCE.whitelist) {
                if (!AdvancementPlaquesConfig.advancementEntryMatches(advancement, whitelistEntry)) continue;
                return true;
            }
        }
        return !advancementFiltered;
    }

    @SubscribeEvent
    public static void onLoad(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("advancementplaques")) {
            ConfigManager.sync((String)"advancementplaques", (Config.Type)Config.Type.INSTANCE);
        }
    }
}

