/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.ui;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.config.AdvancementPlaquesConfig;
import com.anthonyhilyard.advancementplaques.ui.render.AdvancementPlaque;
import com.anthonyhilyard.advancementplaques.util.CustomItemRenderer;
import com.google.common.collect.Queues;
import java.util.Arrays;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.toasts.AdvancementToast;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AdvancementPlaquesToastGui
extends GuiToast {
    private final AdvancementPlaque[] plaques = new AdvancementPlaque[1];
    private final Deque<AdvancementToast> advancementToastsQueue = Queues.newArrayDeque();
    private final Minecraft minecraft;
    private final CustomItemRenderer itemRenderer;

    public AdvancementPlaquesToastGui(Minecraft mcIn) {
        super(mcIn);
        this.minecraft = mcIn;
        this.itemRenderer = new CustomItemRenderer(this.minecraft);
    }

    public void func_192988_a(IToast toastIn) {
        if (toastIn instanceof AdvancementToast) {
            AdvancementToast advancementToast = (AdvancementToast)toastIn;
            if (AdvancementPlaquesConfig.showPlaqueForAdvancement(advancementToast.field_193679_c)) {
                this.advancementToastsQueue.add((AdvancementToast)toastIn);
                return;
            }
        }
        super.func_192988_a(toastIn);
    }

    public void func_191783_a(ScaledResolution resolution) {
        if (!this.minecraft.field_71474_y.field_74319_N) {
            try {
                super.func_191783_a(resolution);
                if (AdvancementPlaquesConfig.INSTANCE.hideWaila && Loader.isModLoaded((String)"waila")) {
                    boolean anyPlaques = false;
                    for (int i = 0; i < this.plaques.length; ++i) {
                        if (this.plaques[i] == null) continue;
                        anyPlaques = true;
                        break;
                    }
                    if (anyPlaques) {
                        Class.forName("com.anthonyhilyard.advancementplaques.compat.WailaHandler").getMethod("disableWaila", new Class[0]).invoke(null, new Object[0]);
                    } else {
                        Class.forName("com.anthonyhilyard.advancementplaques.compat.WailaHandler").getMethod("enableWaila", new Class[0]).invoke(null, new Object[0]);
                    }
                }
                for (int i = 0; i < this.plaques.length; ++i) {
                    AdvancementPlaque toastinstance = this.plaques[i];
                    if (toastinstance != null && toastinstance.render(resolution.func_78326_a(), resolution.func_78328_b(), i)) {
                        this.plaques[i] = null;
                    }
                    if (this.plaques[i] != null || this.advancementToastsQueue.isEmpty()) continue;
                    this.plaques[i] = new AdvancementPlaque(this.advancementToastsQueue.removeFirst(), this.minecraft, this.itemRenderer);
                }
            }
            catch (Exception e) {
                AdvancementPlaques.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public void func_191788_b() {
        super.func_191788_b();
        Arrays.fill(this.plaques, null);
        this.advancementToastsQueue.clear();
    }
}

