/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques.util;

public class ColorUtil {
    public static int parseColor(String colorString) {
        if (colorString.startsWith("#")) {
            colorString = colorString.substring(1);
        }
        if (colorString.startsWith("0x")) {
            colorString = colorString.substring(2);
        }
        try {
            return Integer.parseUnsignedInt(colorString, 16);
        }
        catch (NumberFormatException numberFormatException) {
            switch (colorString.toLowerCase()) {
                case "black": {
                    return -16777216;
                }
                case "dark_blue": {
                    return -16777046;
                }
                case "dark_green": {
                    return -16733696;
                }
                case "dark_aqua": {
                    return -16733526;
                }
                case "dark_red": {
                    return -5636096;
                }
                case "dark_purple": {
                    return -5635926;
                }
                case "gold": {
                    return -22016;
                }
                case "gray": {
                    return -5592406;
                }
                case "dark_gray": {
                    return -11184811;
                }
                case "blue": {
                    return -11184641;
                }
                case "green": {
                    return -11141291;
                }
                case "aqua": {
                    return -11141121;
                }
                case "red": {
                    return -43691;
                }
                case "light_purple": {
                    return -43521;
                }
                case "yellow": {
                    return -171;
                }
                case "white": {
                    return -1;
                }
            }
            return -1;
        }
    }
}

