/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.vec;

import com.creativemd.creativecore.client.rendering.RenderBox;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.common.utils.math.BooleanUtils;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.geo.NormalPlane;
import com.creativemd.creativecore.common.utils.math.geo.Ray2d;
import com.creativemd.creativecore.common.utils.math.geo.Ray3d;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class VectorFan {
    public static final float EPSILON = 1.0E-5f;
    private Vector3f[] coords;

    public VectorFan(Vector3f[] coords) {
        this.coords = coords;
    }

    public Vector3f[] getCoords() {
        return this.coords;
    }

    public Vector3f get(int index) {
        return this.coords[index];
    }

    public int count() {
        return this.coords.length;
    }

    public void generate(RenderBox.RenderInformationHolder holder, List<BakedQuad> quads) {
        int index;
        for (index = 0; index < this.coords.length - 3; index += 2) {
            this.generate(holder, this.coords[0], this.coords[index + 1], this.coords[index + 2], this.coords[index + 3], quads);
        }
        if (index < this.coords.length - 2) {
            this.generate(holder, this.coords[0], this.coords[index + 1], this.coords[index + 2], this.coords[index + 2], quads);
        }
    }

    protected void generate(RenderBox.RenderInformationHolder holder, Vector3f vec1, Vector3f vec2, Vector3f vec3, Vector3f vec4, List<BakedQuad> quads) {
        CreativeBakedQuad quad = new CreativeBakedQuad(holder.quad, holder.getBox(), holder.color, holder.shouldOverrideColor, holder.facing);
        RenderBox box = holder.getBox();
        for (int k = 0; k < 4; ++k) {
            float vOffset;
            float uOffset;
            float z;
            float y;
            float x;
            Vector3f vec = k == 0 ? vec1 : (k == 1 ? vec2 : (k == 2 ? vec3 : vec4));
            int index = k * quad.getFormat().func_181719_f();
            if (holder.scaleAndOffset) {
                x = holder.facing.func_176740_k() == EnumFacing.Axis.X || box.allowOverlap ? vec.x * holder.scaleX + holder.offsetX - (float)holder.offset.func_177958_n() : MathHelper.func_76131_a((float)(vec.x * holder.scaleX + holder.offsetX - (float)holder.offset.func_177958_n()), (float)holder.minX, (float)holder.maxX);
                y = holder.facing.func_176740_k() == EnumFacing.Axis.Y || box.allowOverlap ? vec.y * holder.scaleY + holder.offsetY - (float)holder.offset.func_177956_o() : MathHelper.func_76131_a((float)(vec.y * holder.scaleY + holder.offsetY - (float)holder.offset.func_177956_o()), (float)holder.minY, (float)holder.maxY);
                z = holder.facing.func_176740_k() == EnumFacing.Axis.Z || box.allowOverlap ? vec.z * holder.scaleZ + holder.offsetZ - (float)holder.offset.func_177952_p() : MathHelper.func_76131_a((float)(vec.z * holder.scaleZ + holder.offsetZ - (float)holder.offset.func_177952_p()), (float)holder.minZ, (float)holder.maxZ);
            } else {
                x = holder.facing.func_176740_k() == EnumFacing.Axis.X || box.allowOverlap ? vec.x - (float)holder.offset.func_177958_n() : MathHelper.func_76131_a((float)(vec.x - (float)holder.offset.func_177958_n()), (float)holder.minX, (float)holder.maxX);
                y = holder.facing.func_176740_k() == EnumFacing.Axis.Y || box.allowOverlap ? vec.y - (float)holder.offset.func_177956_o() : MathHelper.func_76131_a((float)(vec.y - (float)holder.offset.func_177956_o()), (float)holder.minY, (float)holder.maxY);
                z = holder.facing.func_176740_k() == EnumFacing.Axis.Z || box.allowOverlap ? vec.z - (float)holder.offset.func_177952_p() : MathHelper.func_76131_a((float)(vec.z - (float)holder.offset.func_177952_p()), (float)holder.minZ, (float)holder.maxZ);
            }
            float oldX = Float.intBitsToFloat(quad.func_178209_a()[index]);
            float oldY = Float.intBitsToFloat(quad.func_178209_a()[index + 1]);
            float oldZ = Float.intBitsToFloat(quad.func_178209_a()[index + 2]);
            quad.func_178209_a()[index] = Float.floatToIntBits(x + (float)holder.offset.func_177958_n());
            quad.func_178209_a()[index + 1] = Float.floatToIntBits(y + (float)holder.offset.func_177956_o());
            quad.func_178209_a()[index + 2] = Float.floatToIntBits(z + (float)holder.offset.func_177952_p());
            if (box.keepVU) continue;
            int uvIndex = index + quad.getFormat().func_177344_b(0) / 4;
            if (holder.uvInverted) {
                uOffset = (RotationUtils.getVFromFacing(holder.facing, oldX, oldY, oldZ) - RotationUtils.getVFromFacing(holder.facing, x, y, z)) / RotationUtils.getVFromFacing(holder.facing, holder.sizeX, holder.sizeY, holder.sizeZ) * holder.sizeU;
                vOffset = (RotationUtils.getUFromFacing(holder.facing, oldX, oldY, oldZ) - RotationUtils.getUFromFacing(holder.facing, x, y, z)) / RotationUtils.getUFromFacing(holder.facing, holder.sizeX, holder.sizeY, holder.sizeZ) * holder.sizeV;
            } else {
                uOffset = (RotationUtils.getUFromFacing(holder.facing, oldX, oldY, oldZ) - RotationUtils.getUFromFacing(holder.facing, x, y, z)) / RotationUtils.getUFromFacing(holder.facing, holder.sizeX, holder.sizeY, holder.sizeZ) * holder.sizeU;
                vOffset = (RotationUtils.getVFromFacing(holder.facing, oldX, oldY, oldZ) - RotationUtils.getVFromFacing(holder.facing, x, y, z)) / RotationUtils.getVFromFacing(holder.facing, holder.sizeX, holder.sizeY, holder.sizeZ) * holder.sizeV;
            }
            quad.func_178209_a()[uvIndex] = Float.floatToIntBits(Float.intBitsToFloat(quad.func_178209_a()[uvIndex]) - uOffset);
            quad.func_178209_a()[uvIndex + 1] = Float.floatToIntBits(Float.intBitsToFloat(quad.func_178209_a()[uvIndex + 1]) - vOffset);
        }
        quads.add(quad);
    }

    public void renderPreview(int red, int green, int blue, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i < this.coords.length; ++i) {
            Vector3f vec = this.coords[i];
            bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181669_b(red, green, blue, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public void renderLines(int red, int green, int blue, int alpha) {
        Vector3f vec;
        int i;
        int index;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (index = 0; index < this.coords.length - 3; index += 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 4; ++i) {
                vec = this.coords[i];
                bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181669_b(red, green, blue, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        if (index < this.coords.length - 2) {
            bufferbuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
            for (i = index; i < index + 3; ++i) {
                vec = this.coords[i];
                bufferbuilder.func_181662_b((double)vec.x, (double)vec.y, (double)vec.z).func_181669_b(red, green, blue, alpha).func_181675_d();
            }
            tessellator.func_78381_a();
        }
    }

    private static boolean isPointBetween(Vector3f start, Vector3f end, Vector3f between) {
        float x = (end.y - start.y) * (between.z - start.z) - (end.z - start.z) * (between.y - start.y);
        float y = (between.x - start.x) * (end.z - start.z) - (between.z - start.z) * (end.x - start.x);
        float z = (end.x - start.x) * (between.y - start.y) - (end.y - start.y) * (between.x - start.x);
        float test = Math.abs(x) + Math.abs(y) + Math.abs(z);
        return Math.abs(test) < 1.0E-5f;
    }

    public void add(List<Vector3f> list, Vector3f toAdd) {
        if (!list.isEmpty() && list.get(list.size() - 1).equals((Tuple3f)toAdd)) {
            return;
        }
        if (list.size() > 1 && VectorFan.isPointBetween(list.get(list.size() - 2), toAdd, list.get(list.size() - 1))) {
            list.set(list.size() - 1, toAdd);
        } else {
            list.add(toAdd);
        }
    }

    public void set(VectorFan fan) {
        this.set(fan.coords);
    }

    public void set(Vector3f[] coords) {
        this.coords = new Vector3f[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            this.coords[i] = coords[i];
        }
    }

    public boolean cutWithoutCopy(NormalPlane[] planes) {
        for (int i = 0; i < planes.length; ++i) {
            this.cutWithoutCopy(planes[i]);
            if (!this.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void cutWithoutCopy(NormalPlane plane) {
        List<Vector3f> result = this.cutInternal(plane);
        this.coords = result != null ? result.toArray(new Vector3f[result.size()]) : null;
    }

    public boolean isEmpty() {
        return this.coords == null;
    }

    protected List<Vector3f> cutInternal(NormalPlane plane) {
        ArrayList<Vector3f> result = new ArrayList<Vector3f>();
        boolean inside = false;
        Boolean outsideBefore = null;
        for (int i = 0; i <= this.coords.length; ++i) {
            boolean last = i == this.coords.length;
            Vector3f vec = last ? this.coords[0] : this.coords[i];
            Boolean outside = plane.isInFront(vec);
            if (inside) {
                if (outside == null || !outside.booleanValue()) {
                    if (last) continue;
                    this.add(result, vec);
                } else {
                    if (BooleanUtils.isFalse(outsideBefore)) {
                        this.add(result, plane.intersect(last ? this.coords[this.coords.length - 1] : this.coords[i - 1], vec));
                    }
                    inside = false;
                }
            } else if (outside == null) {
                if (!last) {
                    this.add(result, vec);
                }
            } else if (!outside.booleanValue()) {
                if (BooleanUtils.isTrue(outsideBefore)) {
                    this.add(result, plane.intersect(last ? this.coords[this.coords.length - 1] : this.coords[i - 1], vec));
                }
                if (!last) {
                    this.add(result, vec);
                }
                inside = true;
            }
            outsideBefore = outside;
        }
        if (result.isEmpty() || result.size() < 3) {
            return null;
        }
        if (VectorFan.isPointBetween((Vector3f)result.get(result.size() - 2), (Vector3f)result.get(0), (Vector3f)result.get(result.size() - 1))) {
            result.remove(result.size() - 1);
        }
        if (result.size() >= 3 && VectorFan.isPointBetween((Vector3f)result.get(result.size() - 1), (Vector3f)result.get(1), (Vector3f)result.get(0))) {
            result.remove(0);
        }
        if (result.size() >= 3) {
            return result;
        }
        return null;
    }

    public VectorFan cut(NormalPlane plane) {
        List<Vector3f> result = this.cutInternal(plane);
        if (result != null) {
            return new VectorFan(result.toArray(new Vector3f[result.size()]));
        }
        return null;
    }

    public void move(int x, int y, int z) {
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i].x += (float)x;
            this.coords[i].y += (float)y;
            this.coords[i].z += (float)z;
        }
    }

    public void scale(float ratio) {
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i].scale(ratio);
        }
    }

    public void divide(float ratio) {
        this.scale(1.0f / ratio);
    }

    public boolean intersects(NormalPlane plane1, NormalPlane plane2) {
        Boolean beforeOne = null;
        Boolean beforeTwo = null;
        Vector3f before = null;
        for (int i = 0; i <= this.coords.length; ++i) {
            Vector3f intersection;
            Vector3f vec = i == this.coords.length ? this.coords[0] : this.coords[i];
            Boolean one = plane1.isInFront(vec);
            Boolean two = plane2.isInFront(vec);
            if (BooleanUtils.isTrue(one) && BooleanUtils.isTrue(two)) {
                return true;
            }
            if (i > 0 && BooleanUtils.isTrue(one) != BooleanUtils.isTrue(beforeOne) && BooleanUtils.isTrue(two) != BooleanUtils.isTrue(beforeTwo) && (intersection = plane1.intersect(before, vec)) != null && BooleanUtils.isTrue(plane2.isInFront(intersection))) {
                return true;
            }
            before = vec;
            beforeOne = one;
            beforeTwo = two;
        }
        return false;
    }

    public VectorFan copy() {
        Vector3f[] coordsCopy = new Vector3f[this.coords.length];
        for (int i = 0; i < coordsCopy.length; ++i) {
            coordsCopy[i] = new Vector3f(this.coords[i]);
        }
        return new VectorFan(coordsCopy);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VectorFan) {
            int start;
            VectorFan other = (VectorFan)obj;
            if (this.coords.length != other.coords.length) {
                return false;
            }
            for (start = 0; start < this.coords.length && !this.coords[start].equals((Tuple3f)other.coords[0]); ++start) {
            }
            if (start < this.coords.length) {
                for (int i = 1; i < other.coords.length; ++i) {
                    if (this.coords[start = (start + 1) % this.coords.length].equals((Tuple3f)other.coords[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    protected static Vec3d calculateIntercept(Ray3d ray, Vector3f triangle0, Vector3f triangle1, Vector3f triangle2) throws ParallelException {
        Vector3f edge1 = new Vector3f();
        Vector3f edge2 = new Vector3f();
        Vector3f h = new Vector3f();
        Vector3f s = new Vector3f();
        Vector3f q = new Vector3f();
        edge1.sub((Tuple3f)triangle1, (Tuple3f)triangle0);
        edge2.sub((Tuple3f)triangle2, (Tuple3f)triangle0);
        h.cross(ray.direction, edge2);
        double a = edge1.dot(h);
        if (a > (double)-1.0E-5f && a < (double)1.0E-5f) {
            throw new ParallelException();
        }
        double f = 1.0 / a;
        s.sub((Tuple3f)ray.origin, (Tuple3f)triangle0);
        double u = f * (double)s.dot(h);
        if (u < 0.0 || u > 1.0) {
            return null;
        }
        q.cross(s, edge1);
        double v = f * (double)ray.direction.dot(q);
        if (v < 0.0 || u + v > 1.0) {
            return null;
        }
        double t = f * (double)edge2.dot(q);
        return new Vec3d((double)ray.direction.x * t + (double)ray.origin.x, (double)ray.direction.y * t + (double)ray.origin.y, (double)ray.direction.z * t + (double)ray.origin.z);
    }

    public Vec3d calculateIntercept(Ray3d ray) {
        try {
            Vector3f origin = this.coords[0];
            for (int i = 0; i < this.coords.length - 2; ++i) {
                Vec3d result = VectorFan.calculateIntercept(ray, this.coords[0], this.coords[i + 1], this.coords[i + 2]);
                if (result == null) continue;
                return result;
            }
        }
        catch (ParallelException parallelException) {
            // empty catch block
        }
        return null;
    }

    public NormalPlane createPlane() {
        Vector3f a = new Vector3f(this.coords[1]);
        a.sub((Tuple3f)this.coords[0]);
        Vector3f b = new Vector3f(this.coords[2]);
        b.sub((Tuple3f)this.coords[0]);
        Vector3f normal = new Vector3f();
        normal.cross(a, b);
        return new NormalPlane(this.coords[0], normal);
    }

    public boolean isInside(List<List<NormalPlane>> shapes) {
        for (int j = 0; j < shapes.size(); ++j) {
            List<NormalPlane> shape = shapes.get(j);
            Boolean[] firstOutside = null;
            Boolean[] beforeOutside = null;
            Vector3f before = null;
            for (int i = 0; i <= this.coords.length; ++i) {
                int k;
                Vector3f vec = i == this.coords.length ? this.coords[0] : this.coords[i];
                Boolean[] outside = new Boolean[shape.size()];
                boolean inside = true;
                for (k = 0; k < shape.size(); ++k) {
                    Boolean front = shape.get(k).isInFront(vec);
                    if (!BooleanUtils.isFalse(front)) {
                        inside = false;
                    }
                    outside[k] = front;
                }
                if (inside) {
                    return true;
                }
                if (i > 0) {
                    for (k = 0; k < shape.size(); ++k) {
                        if (!VectorFan.isInside(shape, before, vec, beforeOutside[k], outside[k], k)) continue;
                        return true;
                    }
                    if (i < this.coords.length - 1 && i % 2 == 0) {
                        for (k = 0; k < shape.size(); ++k) {
                            if (!VectorFan.isInside(shape, this.coords[0], vec, firstOutside[k], outside[k], k)) continue;
                            return true;
                        }
                    }
                } else {
                    firstOutside = outside;
                }
                before = vec;
                beforeOutside = outside;
            }
        }
        return false;
    }

    public List<VectorFan> cut2d(List<VectorFan> cutters, EnumFacing.Axis one, EnumFacing.Axis two, boolean inverse, boolean takeInner) {
        ArrayList<VectorFan> temp = new ArrayList<VectorFan>();
        ArrayList<VectorFan> next = new ArrayList<VectorFan>();
        temp.add(this);
        for (VectorFan cutter : cutters) {
            for (VectorFan fan2 : temp) {
                next.addAll(fan2.cut2d(cutter, one, two, inverse, takeInner));
            }
            temp.clear();
            temp.addAll(next);
            next.clear();
        }
        return temp;
    }

    public List<VectorFan> cut2d(VectorFan cutter, EnumFacing.Axis one, EnumFacing.Axis two, boolean inverse, boolean takeInner) {
        ArrayList<VectorFan> done = new ArrayList<VectorFan>();
        VectorFan toCut = this;
        Vector3f before = cutter.coords[0];
        Ray2d ray = new Ray2d(one, two, 0.0, 0.0, 0.0, 0.0);
        for (int i = 1; i <= cutter.coords.length; ++i) {
            boolean last = i == cutter.coords.length;
            Vector3f vec = last ? cutter.coords[0] : cutter.coords[i];
            ray.originOne = RotationUtils.get(one, (Tuple3f)before);
            ray.originTwo = RotationUtils.get(two, (Tuple3f)before);
            ray.directionOne = RotationUtils.get(one, (Tuple3f)vec) - RotationUtils.get(one, (Tuple3f)before);
            ray.directionTwo = RotationUtils.get(two, (Tuple3f)vec) - RotationUtils.get(two, (Tuple3f)before);
            if ((toCut = toCut.cut2d(ray, one, two, takeInner ? null : done, inverse)) == null) {
                return done;
            }
            before = vec;
        }
        if (takeInner) {
            done.add(toCut);
        }
        return done;
    }

    protected VectorFan cut2d(Ray2d ray, EnumFacing.Axis one, EnumFacing.Axis two, List<VectorFan> done, boolean inverse) {
        boolean allTheSame = true;
        Boolean allValue = null;
        Boolean[] cutted = new Boolean[this.coords.length];
        for (int i = 0; i < cutted.length; ++i) {
            cutted[i] = ray.isCoordinateToTheRight(RotationUtils.get(one, (Tuple3f)this.coords[i]), RotationUtils.get(two, (Tuple3f)this.coords[i]));
            if (inverse && cutted[i] != null) {
                cutted[i] = cutted[i] == false;
            }
            if (!allTheSame) continue;
            if (i == 0) {
                allValue = cutted[i];
                continue;
            }
            if (allValue == null) {
                allValue = cutted[i];
                continue;
            }
            if (allValue == cutted[i] || cutted[i] == null) continue;
            allTheSame = false;
        }
        if (allTheSame) {
            if (allValue == null) {
                return null;
            }
            if (allValue.booleanValue()) {
                return this;
            }
            if (done != null) {
                done.add(this);
            }
            return null;
        }
        float thirdAxisValue = RotationUtils.get(RotationUtils.getDifferentAxis(one, two), (Tuple3f)this.coords[0]);
        ArrayList<Vector3f> left = new ArrayList<Vector3f>();
        ArrayList<Vector3f> right = new ArrayList<Vector3f>();
        Boolean beforeCutted = cutted[cutted.length - 1];
        Vector3f beforeVec = this.coords[this.coords.length - 1];
        for (int i = 0; i < this.coords.length; ++i) {
            Vector3f intersection;
            Vector3f vec = this.coords[i];
            if (BooleanUtils.isTrue(cutted[i])) {
                if (BooleanUtils.isFalse(beforeCutted)) {
                    intersection = ray.intersect(vec, beforeVec, thirdAxisValue);
                    left.add(intersection);
                    right.add(intersection);
                }
                right.add(vec);
            } else if (BooleanUtils.isFalse(cutted[i])) {
                if (BooleanUtils.isTrue(beforeCutted)) {
                    intersection = ray.intersect(vec, beforeVec, thirdAxisValue);
                    left.add(intersection);
                    right.add(intersection);
                }
                left.add(vec);
            } else {
                left.add(vec);
                right.add(vec);
            }
            beforeCutted = cutted[i];
            beforeVec = vec;
        }
        if (left.size() >= 3 && done != null) {
            done.add(new VectorFan(left.toArray(new Vector3f[left.size()])));
        }
        if (right.size() < 3) {
            return null;
        }
        return new VectorFan(right.toArray(new Vector3f[right.size()]));
    }

    public static boolean isInside(List<NormalPlane> shape, Vector3f before, Vector3f vec, Boolean beforeOutside, Boolean outside, int currentPlane) {
        Vector3f intersection;
        return BooleanUtils.isFalse(beforeOutside) ? (outside == null ? VectorFan.isInside(shape, vec, currentPlane) : outside == true && (intersection = shape.get(currentPlane).intersect(before, vec)) != null && VectorFan.isInside(shape, intersection, currentPlane)) : BooleanUtils.isFalse(outside) && (beforeOutside == null ? VectorFan.isInside(shape, before, currentPlane) : beforeOutside == true && (intersection = shape.get(currentPlane).intersect(before, vec)) != null && VectorFan.isInside(shape, intersection, currentPlane));
    }

    public static boolean isInside(List<NormalPlane> shape, Vector3f vec, int toSkip) {
        for (int i = 0; i < shape.size(); ++i) {
            if (i == toSkip || BooleanUtils.isFalse(shape.get(i).isInFront(vec))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.coords);
    }

    public static class ParallelException
    extends Exception {
    }
}

