/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.mc;

import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.util.Color;

public class ColorUtils {
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int LIGHT_BLUE = -16740609;
    public static final int ORANGE = -23296;
    public static final int YELLOW = -256;
    public static final int CYAN = 0xFF0001;
    public static final int MAGENTA = -65281;
    public static final int BLACK = -16777216;

    public static float getAlphaDecimal(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static float getRedDecimal(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreenDecimal(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlueDecimal(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int RGBAToInt(int red, int green, int blue, int alpha) {
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int RGBAToInt(Color color) {
        return (color.getAlpha() & 0xFF) << 24 | (color.getRed() & 0xFF) << 16 | (color.getGreen() & 0xFF) << 8 | color.getBlue() & 0xFF;
    }

    public static Color IntToRGBA(int color) {
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return new Color(r, g, b, a);
    }

    public static int RGBToInt(Vec3i color) {
        return 0xFF000000 | (color.func_177958_n() & 0xFF) << 16 | (color.func_177956_o() & 0xFF) << 8 | color.func_177952_p() & 0xFF;
    }

    public static Vec3i IntToRGB(int color) {
        float r = color >> 16 & 0xFF;
        float g = color >> 8 & 0xFF;
        float b = color & 0xFF;
        return new Vec3i((double)r, (double)g, (double)b);
    }

    public static Vec3d IntToVec(int color) {
        float r = color >> 16 & 0xFF;
        float g = color >> 8 & 0xFF;
        float b = color & 0xFF;
        return new Vec3d((double)(r / 255.0f), (double)(g / 255.0f), (double)(b / 255.0f));
    }

    public static int VecToInt(Vec3d color) {
        return ColorUtils.RGBToInt(new Vec3i(color.field_72450_a * 255.0, color.field_72448_b * 255.0, color.field_72449_c * 255.0));
    }

    public static Vec3i colorToVec(Color color) {
        return new Vec3i(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static boolean isWhite(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return r == 255 && g == 255 && b == 255;
    }

    public static boolean isTransparent(int color) {
        int a = color >> 24 & 0xFF;
        return a < 255;
    }

    public static boolean isInvisible(int color) {
        int a = color >> 24 & 0xFF;
        return a == 0;
    }

    public static int blend(int i1, int i2) {
        return ColorUtils.blend(i1, i2, 0.5f);
    }

    public static int blend(int i1, int i2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int a1 = i1 >> 24 & 0xFF;
        int r1 = (i1 & 0xFF0000) >> 16;
        int g1 = (i1 & 0xFF00) >> 8;
        int b1 = i1 & 0xFF;
        int a2 = i2 >> 24 & 0xFF;
        int r2 = (i2 & 0xFF0000) >> 16;
        int g2 = (i2 & 0xFF00) >> 8;
        int b2 = i2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static enum ColorPart {
        RED{

            @Override
            public int getColor(Color color) {
                return color.getRed();
            }

            @Override
            public void setColor(Color color, int intenstiy) {
                color.setRed(intenstiy);
            }

            @Override
            public int getBrightest() {
                return 0xFF0000;
            }
        }
        ,
        GREEN{

            @Override
            public int getColor(Color color) {
                return color.getGreen();
            }

            @Override
            public void setColor(Color color, int intenstiy) {
                color.setGreen(intenstiy);
            }

            @Override
            public int getBrightest() {
                return 65280;
            }
        }
        ,
        BLUE{

            @Override
            public int getColor(Color color) {
                return color.getBlue();
            }

            @Override
            public void setColor(Color color, int intenstiy) {
                color.setBlue(intenstiy);
            }

            @Override
            public int getBrightest() {
                return 255;
            }
        }
        ,
        ALPHA{

            @Override
            public int getColor(Color color) {
                return color.getAlpha();
            }

            @Override
            public void setColor(Color color, int intenstiy) {
                color.setAlpha(intenstiy);
            }

            @Override
            public int getBrightest() {
                return 255;
            }
        };


        public abstract int getColor(Color var1);

        public abstract void setColor(Color var1, int var2);

        public abstract int getBrightest();
    }
}

