/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketScoreboardObjective;
import net.minecraft.network.play.server.SPacketUpdateScore;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import noppes.npcs.NPCSpawning;
import noppes.npcs.Server;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.client.AnalyticsTracking;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.MassBlockController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.entity.data.DataScenes;

public class ServerTickHandler {
    public int ticks = 0;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        PlayerData data = PlayerData.get(player);
        data.visibility.onUpdate((EntityPlayerMP)player);
        if (data.updateClient) {
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNC_END, 8, data.getSyncNBT());
            data.updateClient = false;
        }
        data.prevHeldItem = player.func_184614_ca();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            WorldWrapper worldWrapper = (WorldWrapper)NpcAPI.Instance().getIWorld((WorldServer)event.world);
            worldWrapper.getTimers().update();
            ++worldWrapper.tickTime;
            if (worldWrapper.tickTime >= 10) {
                ScriptController.Instance.forgeScripts.runScript("worldTick", (Event)new IWorldTick(worldWrapper));
                worldWrapper.tickTime = 0;
            }
            NPCSpawning.findChunksForSpawning((WorldServer)event.world);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START && this.ticks++ >= 20) {
            SchematicController.Instance.updateBuilding();
            MassBlockController.Update();
            this.ticks = 0;
            for (DataScenes.SceneState state : DataScenes.StartedScenes.values()) {
                if (state.paused) continue;
                DataScenes.SceneState sceneState = state;
                ++sceneState.ticks;
            }
            for (DataScenes.SceneContainer entry : DataScenes.ScenesToRun) {
                entry.update();
            }
            DataScenes.ScenesToRun = new ArrayList<DataScenes.SceneContainer>();
        }
    }

    @SubscribeEvent
    public void playerLogin(final PlayerEvent.PlayerLoggedInEvent event) {
        final EntityPlayerMP player = (EntityPlayerMP)event.player;
        MinecraftServer server = event.player.func_184102_h();
        for (WorldServer world : server.field_71305_c) {
            ServerScoreboard board = (ServerScoreboard)world.field_96442_D;
            for (String objective : Availability.scores) {
                ScoreObjective so = board.func_96518_b(objective);
                if (so == null) continue;
                if (board.func_96552_h(so) == 0) {
                    player.field_71135_a.func_147359_a((Packet)new SPacketScoreboardObjective(so, 0));
                }
                Score sco = board.func_96529_a(player.func_70005_c_(), so);
                player.field_71135_a.func_147359_a((Packet)new SPacketUpdateScore(sco));
            }
        }
        event.player.field_71069_bz.func_75132_a(new IContainerListener(){

            public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
            }

            public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
                if (player.field_70170_p.field_72995_K) {
                    return;
                }
                PlayerQuestData playerdata = PlayerData.get((EntityPlayer)event.player).questData;
                playerdata.checkQuestCompletion((EntityPlayer)player, 0);
            }

            public void func_175173_a(Container containerIn, IInventory inventory) {
            }

            public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
            }
        });
        if (server.func_70002_Q()) {
            String serverName = null;
            serverName = server.func_71262_S() ? "server" : (((IntegratedServer)server).func_71344_c() ? "lan" : "local");
            AnalyticsTracking.sendData(event.player, "join", serverName);
        }
        SyncController.syncPlayer(player);
    }

    public static class IWorldTick
    extends Event {
        public IWorld world;

        IWorldTick(IWorld world) {
            this.world = world;
        }
    }
}

