/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.gui.CustomGuiButtonWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemSlotWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.api.wrapper.gui.ItemRenderWrapper;

public abstract class CustomGuiComponentWrapper
implements ICustomGuiComponent {
    int id;
    int posX;
    int posY;
    String[] hoverText;
    private ItemStack hoverItem = null;

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public ICustomGuiComponent setID(int id) {
        this.id = id;
        return this;
    }

    @Override
    public int getPosX() {
        return this.posX;
    }

    @Override
    public int getPosY() {
        return this.posY;
    }

    @Override
    public ICustomGuiComponent setPos(int x, int y) {
        this.posX = x;
        this.posY = y;
        return this;
    }

    @Override
    public boolean hasHoverText() {
        return this.hoverText != null && this.hoverText.length > 0 || this.hoverItem != null;
    }

    @Override
    public String[] getHoverText() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT && this.hoverItem != null) {
            return this.getHoverItemHoverText();
        }
        return this.hoverText;
    }

    @SideOnly(value=Side.CLIENT)
    private String[] getHoverItemHoverText() {
        boolean advanced = Minecraft.func_71410_x().field_71474_y.field_82882_x;
        return this.hoverItem.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(advanced ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)).toArray(new String[0]);
    }

    @Override
    public ICustomGuiComponent setHoverText(String text) {
        this.hoverText = new String[]{text};
        return this;
    }

    @Override
    public ICustomGuiComponent setHoverText(IItemStack stack) {
        this.hoverItem = stack.getMCItemStack();
        return this;
    }

    public IItemStack getHoverItem() {
        return NpcAPI.Instance().getIItemStack(this.hoverItem);
    }

    @Override
    public ICustomGuiComponent setHoverText(String[] text) {
        this.hoverText = text;
        return this;
    }

    public abstract int getType();

    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("id", this.id);
        nbt.func_74783_a("pos", new int[]{this.posX, this.posY});
        nbt.func_74768_a("type", this.getType());
        if (this.hoverItem != null) {
            nbt.func_74782_a("hover_item", (NBTBase)this.hoverItem.serializeNBT());
            return nbt;
        }
        if (this.hoverText != null) {
            NBTTagList list = new NBTTagList();
            for (String s : this.hoverText) {
                if (s == null || s.isEmpty()) continue;
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            if (list.func_74745_c() > 0) {
                nbt.func_74782_a("hover", (NBTBase)list);
            }
        }
        return nbt;
    }

    public CustomGuiComponentWrapper fromNBT(NBTTagCompound nbt) {
        this.setID(nbt.func_74762_e("id"));
        this.setPos(nbt.func_74759_k("pos")[0], nbt.func_74759_k("pos")[1]);
        if (nbt.func_74764_b("hover_item")) {
            this.hoverItem = new ItemStack(nbt.func_74775_l("hover_item"));
            return this;
        }
        if (nbt.func_74764_b("hover")) {
            NBTTagList list = nbt.func_150295_c("hover", 8);
            String[] hoverText = new String[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                hoverText[i] = ((NBTTagString)list.func_179238_g(i)).func_150285_a_();
            }
            this.setHoverText(hoverText);
        }
        return this;
    }

    public static CustomGuiComponentWrapper createFromNBT(NBTTagCompound nbt) {
        switch (nbt.func_74762_e("type")) {
            case 0: {
                return new CustomGuiButtonWrapper().fromNBT(nbt);
            }
            case 1: {
                return new CustomGuiLabelWrapper().fromNBT(nbt);
            }
            case 2: {
                return new CustomGuiTexturedRectWrapper().fromNBT(nbt);
            }
            case 3: {
                return new CustomGuiTextFieldWrapper().fromNBT(nbt);
            }
            case 4: {
                return new CustomGuiScrollWrapper().fromNBT(nbt);
            }
            case 5: {
                return new CustomGuiItemSlotWrapper().fromNBT(nbt);
            }
            case 6: {
                return new ItemRenderWrapper().fromNBT(nbt);
            }
        }
        return null;
    }
}

