/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.blocks.BlockNpcDoorInterface;
import noppes.npcs.blocks.tiles.TileScriptedDoor;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.util.IPermission;

public class BlockScriptedDoor
extends BlockNpcDoorInterface
implements IPermission {
    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileScriptedDoor();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate1;
        if (world.field_72995_K) {
            return true;
        }
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem != null && (currentItem.func_77973_b() == CustomItems.wand || currentItem.func_77973_b() == CustomItems.scripter || currentItem.func_77973_b() == CustomItems.scriptedDoorTool)) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.ScriptDoor, null, blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
            return true;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(blockpos1);
        if (EventHooks.onScriptBlockInteract(tile, player, side.func_176745_a(), hitX, hitY, hitZ)) {
            return false;
        }
        this.func_176512_a(world, blockpos1, ((Boolean)iblockstate1.func_177229_b((IProperty)BlockDoor.field_176519_b)).equals(false));
        return true;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos pos2) {
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos1 = pos.func_177977_b();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.func_189540_a(iblockstate1, worldIn, blockpos1, neighborBlock, blockpos1);
            }
        } else {
            BlockPos blockpos2 = pos.func_177984_a();
            IBlockState iblockstate2 = worldIn.func_180495_p(blockpos2);
            if (iblockstate2.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else {
                boolean flag;
                TileScriptedDoor tile = (TileScriptedDoor)worldIn.func_175625_s(pos);
                if (!worldIn.field_72995_K) {
                    EventHooks.onScriptBlockNeighborChanged(tile, pos2);
                }
                boolean bl = flag = worldIn.func_175640_z(pos) || worldIn.func_175640_z(blockpos2);
                if ((flag || neighborBlock.func_176223_P().func_185897_m()) && neighborBlock != this && flag != (Boolean)iblockstate2.func_177229_b((IProperty)field_176522_N)) {
                    worldIn.func_180501_a(blockpos2, iblockstate2.func_177226_a((IProperty)field_176522_N, (Comparable)Boolean.valueOf(flag)), 2);
                    if (flag != (Boolean)state.func_177229_b((IProperty)field_176519_b)) {
                        this.func_176512_a(worldIn, pos, flag);
                    }
                }
                int power = 0;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int p = worldIn.func_175651_c(pos.func_177972_a(enumfacing), enumfacing);
                    if (p <= power) continue;
                    power = p;
                }
                tile.newPower = power;
            }
        }
    }

    public void func_176512_a(World worldIn, BlockPos pos, boolean open) {
        TileScriptedDoor tile = (TileScriptedDoor)worldIn.func_175625_s(pos);
        if (EventHooks.onScriptBlockDoorToggle(tile)) {
            return;
        }
        super.func_176512_a(worldIn, pos, open);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        IBlockState iblockstate1;
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (iblockstate1.func_177230_c() != this) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(blockpos1);
        EventHooks.onScriptBlockClicked(tile, playerIn);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IBlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (!world.field_72995_K && iblockstate1.func_177230_c() == this) {
            TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(pos);
            EventHooks.onScriptBlockBreak(tile);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileScriptedDoor tile;
        if (!world.field_72995_K && EventHooks.onScriptBlockHarvest(tile = (TileScriptedDoor)world.func_175625_s(pos), player)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void onEntityCollision(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        if (world.field_72995_K) {
            return;
        }
        TileScriptedDoor tile = (TileScriptedDoor)world.func_175625_s(pos);
        EventHooks.onScriptBlockCollide(tile, entityIn);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        IBlockState iblockstate1;
        BlockPos blockpos1 = state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER ? pos : pos.func_177977_b();
        IBlockState iBlockState = iblockstate1 = pos.equals((Object)blockpos1) ? state : world.func_180495_p(blockpos1);
        if (player.field_71075_bZ.field_75098_d && iblockstate1.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.LOWER && iblockstate1.func_177230_c() == this) {
            world.func_175698_g(blockpos1);
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((TileScriptedDoor)world.func_175625_s((BlockPos)pos)).blockHardness;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return ((TileScriptedDoor)world.func_175625_s((BlockPos)pos)).blockResistance;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.ScriptDoorDataSave;
    }
}

