/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.util.NaturalOrderComparator;
import org.lwjgl.input.Mouse;

public class GuiCustomScroll
extends GuiScreen {
    public static ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/misc.png");
    private List<String> list;
    public int id;
    public int guiLeft = 0;
    public int guiTop = 0;
    public int selected;
    private HashSet<String> selectedList;
    private int hover;
    private int listHeight;
    private int scrollY;
    private int maxScrollY;
    private int scrollHeight;
    private boolean isScrolling;
    private boolean multipleSelection = false;
    private ICustomScrollListener listener;
    private boolean isSorted = true;
    public boolean visible = true;
    private boolean selectable = true;
    private int lastClickedItem;
    private long lastClickedTime = 0L;

    public GuiCustomScroll(GuiScreen parent, int id) {
        this.field_146294_l = 176;
        this.field_146295_m = 159;
        this.selected = -1;
        this.hover = -1;
        this.selectedList = new HashSet();
        this.listHeight = 0;
        this.scrollY = 0;
        this.scrollHeight = 0;
        this.isScrolling = false;
        if (parent instanceof ICustomScrollListener) {
            this.listener = (ICustomScrollListener)parent;
        }
        this.list = new ArrayList<String>();
        this.id = id;
    }

    public GuiCustomScroll(GuiScreen parent, int id, boolean multipleSelection) {
        this(parent, id);
        this.multipleSelection = multipleSelection;
    }

    public void setSize(int x, int y) {
        this.field_146295_m = y;
        this.field_146294_l = x;
        this.listHeight = 14 * this.list.size();
        this.scrollHeight = this.listHeight > 0 ? (int)((double)(this.field_146295_m - 8) / (double)this.listHeight * (double)(this.field_146295_m - 8)) : Integer.MAX_VALUE;
        this.maxScrollY = this.listHeight - (this.field_146295_m - 8) - 1;
    }

    public int getWidth() {
        return this.field_146294_l;
    }

    public int getHeight() {
        return this.field_146295_m;
    }

    public void drawScreen(int i, int j, float f, int mouseScrolled) {
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.guiLeft, this.guiTop, this.field_146294_l + this.guiLeft, this.field_146295_m + this.guiTop, -1072689136, -804253680);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(resource);
        if (this.scrollHeight < this.field_146295_m - 8) {
            this.drawScrollBar();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectable) {
            this.hover = this.getMouseOver(i, j);
        }
        this.drawItems();
        GlStateManager.func_179121_F();
        if (this.scrollHeight < this.field_146295_m - 8) {
            i -= this.guiLeft;
            j -= this.guiTop;
            if (Mouse.isButtonDown((int)0)) {
                if (i >= this.field_146294_l - 11 && i < this.field_146294_l - 6 && j >= 4 && j < this.field_146295_m) {
                    this.isScrolling = true;
                }
            } else {
                this.isScrolling = false;
            }
            if (this.isScrolling) {
                this.scrollY = (j - 8) * this.listHeight / (this.field_146295_m - 8) - this.scrollHeight;
                if (this.scrollY < 0) {
                    this.scrollY = 0;
                }
                if (this.scrollY > this.maxScrollY) {
                    this.scrollY = this.maxScrollY;
                }
            }
            if (mouseScrolled != 0) {
                this.scrollY += mouseScrolled > 0 ? -14 : 14;
                if (this.scrollY > this.maxScrollY) {
                    this.scrollY = this.maxScrollY;
                }
                if (this.scrollY < 0) {
                    this.scrollY = 0;
                }
            }
        }
    }

    public boolean mouseInOption(int i, int j, int k) {
        int l = 4;
        int i2 = 14 * k + 4 - this.scrollY;
        return i >= l - 1 && i < l + this.field_146294_l - 11 && j >= i2 - 1 && j < i2 + 8;
    }

    protected void drawItems() {
        for (int i = 0; i < this.list.size(); ++i) {
            int j = 4;
            int k = 14 * i + 4 - this.scrollY;
            if (k < 4 || k + 12 >= this.field_146295_m) continue;
            int xOffset = this.scrollHeight < this.field_146295_m - 8 ? 0 : 10;
            String[] values = this.list.get(i).split("&t");
            for (int id = 0; id < values.length; ++id) {
                values[id] = I18n.func_135052_a((String)values[id], (Object[])new Object[0]);
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (values.length != 0) {
                for (String value : values) {
                    stringBuilder.append(value);
                }
            } else {
                stringBuilder.append(this.list.get(i));
            }
            String displayString = stringBuilder.toString();
            String text = "";
            float maxWidth = (float)(this.field_146294_l + xOffset - 8) * 0.8f;
            if ((float)this.field_146289_q.func_78256_a(displayString) > maxWidth) {
                for (int h = 0; h < displayString.length(); ++h) {
                    char c = displayString.charAt(h);
                    if ((float)this.field_146289_q.func_78256_a(text = text + c) > maxWidth) break;
                }
                if (displayString.length() > text.length()) {
                    text = text + "...";
                }
            } else {
                text = displayString;
            }
            if (this.multipleSelection && this.selectedList.contains(text) || !this.multipleSelection && this.selected == i) {
                this.func_73728_b(j - 2, k - 4, k + 10, -1);
                this.func_73728_b(j + this.field_146294_l - 18 + xOffset, k - 4, k + 10, -1);
                this.func_73730_a(j - 2, j + this.field_146294_l - 18 + xOffset, k - 3, -1);
                this.func_73730_a(j - 2, j + this.field_146294_l - 18 + xOffset, k + 10, -1);
                this.field_146289_q.func_78276_b(text, j, k, 0xFFFFFF);
                continue;
            }
            if (i == this.hover) {
                this.field_146289_q.func_78276_b(text, j, k, 65280);
                continue;
            }
            this.field_146289_q.func_78276_b(text, j, k, 0xFFFFFF);
        }
    }

    public String getSelected() {
        if (this.selected == -1 || this.selected >= this.list.size()) {
            return null;
        }
        return this.list.get(this.selected);
    }

    private int getMouseOver(int i, int j) {
        if ((i -= this.guiLeft) >= 4 && i < this.field_146294_l - 4 && (j -= this.guiTop) >= 4 && j < this.field_146295_m) {
            for (int j2 = 0; j2 < this.list.size(); ++j2) {
                if (!this.mouseInOption(i, j, j2)) continue;
                return j2;
            }
        }
        return -1;
    }

    public void func_73864_a(int i, int j, int k) {
        if (k != 0 || this.hover < 0) {
            return;
        }
        if (this.multipleSelection) {
            if (this.selectedList.contains(this.list.get(this.hover))) {
                this.selectedList.remove(this.list.get(this.hover));
            } else {
                this.selectedList.add(this.list.get(this.hover));
            }
        } else {
            if (this.hover >= 0) {
                this.selected = this.hover;
            }
            this.hover = -1;
        }
        if (this.listener != null) {
            long time = System.currentTimeMillis();
            this.listener.scrollClicked(i, j, k, this);
            if (this.selected >= 0 && this.selected == this.lastClickedItem && time - this.lastClickedTime < 500L) {
                this.listener.scrollDoubleClicked(this.list.get(this.selected), this);
            }
            this.lastClickedTime = time;
            this.lastClickedItem = this.selected;
        }
    }

    private void drawScrollBar() {
        int k;
        int i = this.guiLeft + this.field_146294_l - 9;
        int j = k = this.guiTop + (int)((double)this.scrollY / (double)this.listHeight * (double)(this.field_146295_m - 8)) + 4;
        this.func_73729_b(i, k, this.field_146294_l, 9, 5, 1);
        ++k;
        while (k < j + this.scrollHeight - 1) {
            this.func_73729_b(i, k, this.field_146294_l, 10, 5, 1);
            ++k;
        }
        this.func_73729_b(i, k, this.field_146294_l, 11, 5, 1);
    }

    public boolean hasSelected() {
        return this.selected >= 0;
    }

    public void setList(List<String> list) {
        if (this.isSameList(list)) {
            return;
        }
        this.isSorted = true;
        this.scrollY = 0;
        Collections.sort(list, new NaturalOrderComparator());
        this.list = list;
        this.setSize(this.field_146294_l, this.field_146295_m);
    }

    public void setUnsortedList(List<String> list) {
        if (this.isSameList(list)) {
            return;
        }
        this.isSorted = false;
        this.scrollY = 0;
        this.list = list;
        this.setSize(this.field_146294_l, this.field_146295_m);
    }

    private boolean isSameList(List<String> list) {
        if (this.list.size() != list.size()) {
            return false;
        }
        for (String s : this.list) {
            if (list.contains(s)) continue;
            return false;
        }
        return true;
    }

    public void replace(String old, String name) {
        String select = this.getSelected();
        this.list.remove(old);
        this.list.add(name);
        if (this.isSorted) {
            Collections.sort(this.list, new NaturalOrderComparator());
        }
        if (old.equals(select)) {
            select = name;
        }
        this.selected = this.list.indexOf(select);
        this.setSize(this.field_146294_l, this.field_146295_m);
    }

    public void setSelected(String name) {
        this.selected = this.list.indexOf(name);
    }

    public void clear() {
        this.list = new ArrayList<String>();
        this.selected = -1;
        this.scrollY = 0;
        this.setSize(this.field_146294_l, this.field_146295_m);
    }

    public List<String> getList() {
        return this.list;
    }

    public HashSet<String> getSelectedList() {
        return this.selectedList;
    }

    public void setSelectedList(HashSet<String> selectedList) {
        this.selectedList = selectedList;
    }

    public GuiCustomScroll setUnselectable() {
        this.selectable = false;
        return this;
    }

    public void scrollTo(String name) {
        int i = this.list.indexOf(name);
        if (i < 0 || this.scrollHeight >= this.field_146295_m - 8) {
            return;
        }
        int pos = (int)(1.0f * (float)i / (float)this.list.size() * (float)this.listHeight);
        if (pos > this.maxScrollY) {
            pos = this.maxScrollY;
        }
        this.scrollY = pos;
    }

    public boolean isMouseOver(int x, int y) {
        return x >= this.guiLeft && x <= this.guiLeft + this.field_146294_l && y >= this.guiTop && y <= this.guiTop + this.field_146295_m;
    }
}

