/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.IGui;
import noppes.npcs.client.gui.util.IKeyListener;
import noppes.npcs.client.gui.util.IMouseListener;
import noppes.npcs.client.gui.util.ITextChangeListener;
import noppes.npcs.client.gui.util.TextContainer;
import noppes.npcs.config.TrueTypeFont;
import org.lwjgl.input.Mouse;

public class GuiTextArea
extends Gui
implements IGui,
IKeyListener,
IMouseListener {
    public int id;
    public int x;
    public int y;
    public int width;
    public int height;
    private int cursorCounter;
    private ITextChangeListener listener;
    private static TrueTypeFont font;
    public String text = null;
    private TextContainer container = null;
    public boolean active = false;
    public boolean enabled = true;
    public boolean visible = true;
    public boolean clicked = false;
    public boolean doubleClicked = false;
    public boolean clickScrolling = false;
    private int startSelection;
    private int endSelection;
    private int cursorPosition;
    private int scrolledLine = 0;
    private boolean enableCodeHighlighting = false;
    private static char colorChar;
    public List<UndoData> undoList = new ArrayList<UndoData>();
    public List<UndoData> redoList = new ArrayList<UndoData>();
    public boolean undoing = false;
    private long lastClicked = 0L;

    public GuiTextArea(int id, int x, int y, int width, int height, String text) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.undoing = true;
        this.setText(text);
        this.undoing = false;
        font.setSpecial('\uffff');
    }

    @Override
    public void drawScreen(int xMouse, int yMouse) {
        if (!this.visible) {
            return;
        }
        GuiTextArea.func_73734_a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)-6250336);
        GuiTextArea.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
        this.container.visibleLines = this.height / this.container.lineHeight;
        if (this.clicked) {
            this.clicked = Mouse.isButtonDown((int)0);
            int i = this.getSelectionPos(xMouse, yMouse);
            if (i != this.cursorPosition) {
                if (this.doubleClicked) {
                    int cursorPosition;
                    this.endSelection = cursorPosition = this.cursorPosition;
                    this.startSelection = cursorPosition;
                    this.doubleClicked = false;
                }
                this.setCursor(i, true);
            }
        } else if (this.doubleClicked) {
            this.doubleClicked = false;
        }
        if (this.clickScrolling) {
            this.clickScrolling = Mouse.isButtonDown((int)0);
            int diff = this.container.linesCount - this.container.visibleLines;
            this.scrolledLine = Math.min(Math.max((int)(1.0f * (float)diff * (float)(yMouse - this.y) / (float)this.height), 0), diff);
        }
        int startBracket = 0;
        int endBracket = 0;
        if (this.endSelection - this.startSelection == 1 || this.startSelection == this.endSelection && this.startSelection < this.text.length()) {
            char c = this.text.charAt(this.startSelection);
            int found = 0;
            if (c == '{') {
                found = this.findClosingBracket(this.text.substring(this.startSelection), '{', '}');
            } else if (c == '[') {
                found = this.findClosingBracket(this.text.substring(this.startSelection), '[', ']');
            } else if (c == '(') {
                found = this.findClosingBracket(this.text.substring(this.startSelection), '(', ')');
            } else if (c == '}') {
                found = this.findOpeningBracket(this.text.substring(0, this.startSelection + 1), '{', '}');
            } else if (c == ']') {
                found = this.findOpeningBracket(this.text.substring(0, this.startSelection + 1), '[', ']');
            } else if (c == ')') {
                found = this.findOpeningBracket(this.text.substring(0, this.startSelection + 1), '(', ')');
            }
            if (found != 0) {
                startBracket = this.startSelection;
                endBracket = this.startSelection + found;
            }
        }
        ArrayList<TextContainer.LineData> list = new ArrayList<TextContainer.LineData>(this.container.lines);
        String wordHightLight = null;
        if (this.startSelection != this.endSelection) {
            Matcher m = this.container.regexWord.matcher(this.text);
            while (m.find()) {
                if (m.start() != this.startSelection || m.end() != this.endSelection) continue;
                wordHightLight = this.text.substring(this.startSelection, this.endSelection);
            }
        }
        for (int j = 0; j < list.size(); ++j) {
            int posY;
            int e;
            TextContainer.LineData data = (TextContainer.LineData)list.get(j);
            String line = data.text;
            int w = line.length();
            if (startBracket != endBracket) {
                int s;
                if (startBracket >= data.start && startBracket < data.end) {
                    s = font.width(line.substring(0, startBracket - data.start));
                    e = font.width(line.substring(0, startBracket - data.start + 1)) + 1;
                    posY = this.y + 1 + (j - this.scrolledLine) * this.container.lineHeight;
                    GuiTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY, (int)(this.x + 1 + e), (int)(posY + this.container.lineHeight + 1), (int)-1728001024);
                }
                if (endBracket >= data.start && endBracket < data.end) {
                    s = font.width(line.substring(0, endBracket - data.start));
                    e = font.width(line.substring(0, endBracket - data.start + 1)) + 1;
                    posY = this.y + 1 + (j - this.scrolledLine) * this.container.lineHeight;
                    GuiTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY, (int)(this.x + 1 + e), (int)(posY + this.container.lineHeight + 1), (int)-1728001024);
                }
            }
            if (j < this.scrolledLine || j >= this.scrolledLine + this.container.visibleLines) continue;
            if (wordHightLight != null) {
                Matcher k = this.container.regexWord.matcher(line);
                while (k.find()) {
                    if (!line.substring(k.start(), k.end()).equals(wordHightLight)) continue;
                    int s2 = font.width(line.substring(0, k.start()));
                    int e2 = font.width(line.substring(0, k.end())) + 1;
                    int posY2 = this.y + 1 + (j - this.scrolledLine) * this.container.lineHeight;
                    GuiTextArea.func_73734_a((int)(this.x + 1 + s2), (int)posY2, (int)(this.x + 1 + e2), (int)(posY2 + this.container.lineHeight + 1), (int)-1728033792);
                }
            }
            if (this.startSelection != this.endSelection && this.endSelection > data.start && this.startSelection <= data.end && this.startSelection < data.end) {
                int s = font.width(line.substring(0, Math.max(this.startSelection - data.start, 0)));
                e = font.width(line.substring(0, Math.min(this.endSelection - data.start, w))) + 1;
                posY = this.y + 1 + (j - this.scrolledLine) * this.container.lineHeight;
                GuiTextArea.func_73734_a((int)(this.x + 1 + s), (int)posY, (int)(this.x + 1 + e), (int)(posY + this.container.lineHeight + 1), (int)-1728052993);
            }
            int yPos = this.y + (j - this.scrolledLine) * this.container.lineHeight + 1;
            font.draw(data.getFormattedString(), this.x + 1, yPos, -2039584);
            if (!this.active || !this.isEnabled() || this.cursorCounter / 6 % 2 != 0 || this.cursorPosition < data.start || this.cursorPosition >= data.end) continue;
            int posX = this.x + font.width(line.substring(0, this.cursorPosition - data.start));
            GuiTextArea.func_73734_a((int)(posX + 1), (int)yPos, (int)(posX + 2), (int)(yPos + 1 + this.container.lineHeight), (int)-3092272);
        }
        if (this.hasVerticalScrollbar()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiCustomScroll.resource);
            int sbSize = Math.max((int)(1.0f * (float)this.container.visibleLines / (float)this.container.linesCount * (float)this.height), 2);
            int posX2 = this.x + this.width - 6;
            int posY3 = (int)((float)this.y + 1.0f * (float)this.scrolledLine / (float)this.container.linesCount * (float)(this.height - 4)) + 1;
            GuiTextArea.func_73734_a((int)posX2, (int)posY3, (int)(posX2 + 5), (int)(posY3 + sbSize), (int)-2039584);
        }
    }

    private int findClosingBracket(String str, char s, char e) {
        int found = 0;
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == s) {
                ++found;
                continue;
            }
            if (c != e || --found != 0) continue;
            return i;
        }
        return 0;
    }

    private int findOpeningBracket(String str, char s, char e) {
        int found = 0;
        char[] chars = str.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            char c = chars[i];
            if (c == e) {
                ++found;
                continue;
            }
            if (c != s || --found != 0) continue;
            return i - chars.length + 1;
        }
        return 0;
    }

    private int getSelectionPos(int xMouse, int yMouse) {
        xMouse -= this.x + 1;
        yMouse -= this.y + 1;
        ArrayList<TextContainer.LineData> list = new ArrayList<TextContainer.LineData>(this.container.lines);
        for (int i = 0; i < list.size(); ++i) {
            int yPos;
            TextContainer.LineData data = (TextContainer.LineData)list.get(i);
            if (i < this.scrolledLine || i >= this.scrolledLine + this.container.visibleLines || yMouse < (yPos = (i - this.scrolledLine) * this.container.lineHeight) || yMouse >= yPos + this.container.lineHeight) continue;
            int lineWidth = 0;
            char[] chars = data.text.toCharArray();
            for (int j = 1; j <= chars.length; ++j) {
                int w = font.width(data.text.substring(0, j));
                if (xMouse < lineWidth + (w - lineWidth) / 2) {
                    return data.start + j - 1;
                }
                lineWidth = w;
            }
            return data.end - 1;
        }
        return this.container.text.length();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void keyTyped(char c, int i) {
        if (!this.active) {
            return;
        }
        if (GuiScreen.func_175278_g((int)i)) {
            int n;
            this.cursorPosition = n = 0;
            this.startSelection = n;
            this.endSelection = this.text.length();
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        String original = this.text;
        if (i == 203) {
            int j = 1;
            if (GuiScreen.func_146271_m()) {
                Matcher m = this.container.regexWord.matcher(this.text.substring(0, this.cursorPosition));
                while (m.find()) {
                    if (m.start() == m.end()) continue;
                    j = this.cursorPosition - m.start();
                }
            }
            this.setCursor(this.cursorPosition - j, GuiScreen.func_146272_n());
            return;
        }
        if (i == 205) {
            Matcher m;
            int j = 1;
            if (GuiScreen.func_146271_m() && ((m = this.container.regexWord.matcher(this.text.substring(this.cursorPosition))).find() && m.start() > 0 || m.find())) {
                j = m.start();
            }
            this.setCursor(this.cursorPosition + j, GuiScreen.func_146272_n());
            return;
        }
        if (i == 200) {
            this.setCursor(this.cursorUp(), GuiScreen.func_146272_n());
            return;
        }
        if (i == 208) {
            this.setCursor(this.cursorDown(), GuiScreen.func_146272_n());
            return;
        }
        if (i == 211) {
            int startSelection;
            String s = this.getSelectionAfterText();
            if (!s.isEmpty() && this.startSelection == this.endSelection) {
                s = s.substring(1);
            }
            this.setText(this.getSelectionBeforeText() + s);
            this.cursorPosition = startSelection = this.startSelection;
            this.endSelection = startSelection;
            return;
        }
        if (i == 14) {
            int startSelection2;
            String s = this.getSelectionBeforeText();
            if (this.startSelection > 0 && this.startSelection == this.endSelection) {
                s = s.substring(0, s.length() - 1);
                --this.startSelection;
            }
            this.setText(s + this.getSelectionAfterText());
            this.cursorPosition = startSelection2 = this.startSelection;
            this.endSelection = startSelection2;
            return;
        }
        if (GuiScreen.func_175277_d((int)i)) {
            if (this.startSelection != this.endSelection) {
                int length;
                NoppesStringUtils.setClipboardContents(this.text.substring(this.startSelection, this.endSelection));
                String s = this.getSelectionBeforeText();
                this.setText(s + this.getSelectionAfterText());
                this.cursorPosition = length = s.length();
                this.startSelection = length;
                this.endSelection = length;
            }
            return;
        }
        if (GuiScreen.func_175280_f((int)i)) {
            if (this.startSelection != this.endSelection) {
                NoppesStringUtils.setClipboardContents(this.text.substring(this.startSelection, this.endSelection));
            }
            return;
        }
        if (GuiScreen.func_175279_e((int)i)) {
            this.addText(NoppesStringUtils.getClipboardContents());
            return;
        }
        if (i == 44 && GuiScreen.func_146271_m()) {
            int cursorPosition;
            if (this.undoList.isEmpty()) {
                return;
            }
            this.undoing = true;
            this.redoList.add(new UndoData(this.text, this.cursorPosition));
            UndoData data = this.undoList.remove(this.undoList.size() - 1);
            this.setText(data.text);
            this.cursorPosition = cursorPosition = data.cursorPosition;
            this.startSelection = cursorPosition;
            this.endSelection = cursorPosition;
            this.undoing = false;
        } else {
            int cursorPosition2;
            if (i != 21 || !GuiScreen.func_146271_m()) {
                if (i == 15) {
                    this.addText("\t");
                }
                if (i == 28) {
                    this.addText(Character.toString('\n') + this.getIndentCurrentLine());
                }
                if (ChatAllowedCharacters.func_71566_a((char)c)) {
                    this.addText(Character.toString(c));
                }
                return;
            }
            if (this.redoList.isEmpty()) {
                return;
            }
            this.undoing = true;
            this.undoList.add(new UndoData(this.text, this.cursorPosition));
            UndoData data = this.redoList.remove(this.redoList.size() - 1);
            this.setText(data.text);
            this.cursorPosition = cursorPosition2 = data.cursorPosition;
            this.startSelection = cursorPosition2;
            this.endSelection = cursorPosition2;
            this.undoing = false;
        }
    }

    private String getIndentCurrentLine() {
        for (TextContainer.LineData data : this.container.lines) {
            int i;
            if (this.cursorPosition <= data.start || this.cursorPosition > data.end) continue;
            for (i = 0; i < data.text.length() && data.text.charAt(i) == ' '; ++i) {
            }
            return data.text.substring(0, i);
        }
        return "";
    }

    private void setCursor(int i, boolean select) {
        if ((i = Math.min(Math.max(i, 0), this.text.length())) == this.cursorPosition) {
            return;
        }
        if (!select) {
            int endSelection;
            this.cursorPosition = endSelection = i;
            this.startSelection = endSelection;
            this.endSelection = endSelection;
            return;
        }
        int diff = this.cursorPosition - i;
        if (this.cursorPosition == this.startSelection) {
            this.startSelection -= diff;
        } else if (this.cursorPosition == this.endSelection) {
            this.endSelection -= diff;
        }
        if (this.startSelection > this.endSelection) {
            int j = this.endSelection;
            this.endSelection = this.startSelection;
            this.startSelection = j;
        }
        this.cursorPosition = i;
    }

    private void addText(String s) {
        int endSelection;
        this.setText(this.getSelectionBeforeText() + s + this.getSelectionAfterText());
        this.cursorPosition = endSelection = this.startSelection + s.length();
        this.startSelection = endSelection;
        this.endSelection = endSelection;
    }

    private int cursorUp() {
        for (int i = 0; i < this.container.lines.size(); ++i) {
            TextContainer.LineData data = this.container.lines.get(i);
            if (this.cursorPosition < data.start || this.cursorPosition >= data.end) continue;
            if (i == 0) {
                return 0;
            }
            int linePos = this.cursorPosition - data.start;
            return this.getSelectionPos(this.x + 1 + font.width(data.text.substring(0, this.cursorPosition - data.start)), this.y + 1 + (i - 1 - this.scrolledLine) * this.container.lineHeight);
        }
        return 0;
    }

    private int cursorDown() {
        for (int i = 0; i < this.container.lines.size(); ++i) {
            TextContainer.LineData data = this.container.lines.get(i);
            if (this.cursorPosition < data.start || this.cursorPosition >= data.end) continue;
            int linePos = this.cursorPosition - data.start;
            return this.getSelectionPos(this.x + 1 + font.width(data.text.substring(0, this.cursorPosition - data.start)), this.y + 1 + (i + 1 - this.scrolledLine) * this.container.lineHeight);
        }
        return this.text.length();
    }

    public String getSelectionBeforeText() {
        if (this.startSelection == 0) {
            return "";
        }
        return this.text.substring(0, this.startSelection);
    }

    public String getSelectionAfterText() {
        return this.text.substring(this.endSelection);
    }

    @Override
    public boolean mouseClicked(int xMouse, int yMouse, int mouseButton) {
        boolean bl = this.active = xMouse >= this.x && xMouse < this.x + this.width && yMouse >= this.y && yMouse < this.y + this.height;
        if (this.active) {
            int selectionPos;
            this.cursorPosition = selectionPos = this.getSelectionPos(xMouse, yMouse);
            this.endSelection = selectionPos;
            this.startSelection = selectionPos;
            this.clicked = mouseButton == 0;
            this.doubleClicked = false;
            long time = System.currentTimeMillis();
            if (this.clicked && this.container.linesCount * this.container.lineHeight > this.height && xMouse > this.x + this.width - 8) {
                this.clicked = false;
                this.clickScrolling = true;
            } else if (time - this.lastClicked < 500L) {
                this.doubleClicked = true;
                Matcher m = this.container.regexWord.matcher(this.text);
                while (m.find()) {
                    if (this.cursorPosition <= m.start() || this.cursorPosition >= m.end()) continue;
                    this.startSelection = m.start();
                    this.endSelection = m.end();
                    break;
                }
            }
            this.lastClicked = time;
        }
        return this.active;
    }

    @Override
    public void updateScreen() {
        ++this.cursorCounter;
        int k2 = Mouse.getDWheel();
        if (k2 != 0) {
            this.scrolledLine += k2 > 0 ? -1 : 1;
            this.scrolledLine = Math.max(Math.min(this.scrolledLine, this.container.linesCount - this.height / this.container.lineHeight), 0);
        }
    }

    public void setText(String text) {
        text = text.replace("\r", "");
        if (this.text != null && this.text.equals(text)) {
            return;
        }
        if (this.listener != null) {
            this.listener.textUpdate(text);
        }
        if (!this.undoing) {
            this.undoList.add(new UndoData(this.text, this.cursorPosition));
            this.redoList.clear();
        }
        this.text = text;
        this.container = new TextContainer(text);
        this.container.init(font, this.width, this.height);
        if (this.enableCodeHighlighting) {
            this.container.formatCodeText();
        }
        if (this.scrolledLine > this.container.linesCount - this.container.visibleLines) {
            this.scrolledLine = Math.max(0, this.container.linesCount - this.container.visibleLines);
        }
    }

    public String getText() {
        return this.text;
    }

    public boolean isEnabled() {
        return this.enabled && this.visible;
    }

    public boolean hasVerticalScrollbar() {
        return this.container.visibleLines < this.container.linesCount;
    }

    public void enableCodeHighlighting() {
        this.enableCodeHighlighting = true;
        this.container.formatCodeText();
    }

    public void setListener(ITextChangeListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    static {
        colorChar = (char)65535;
        font = new TrueTypeFont(new Font("Arial Unicode MS", 0, CustomNpcs.FontSize), 1.0f);
    }

    class UndoData {
        public String text;
        public int cursorPosition;

        public UndoData(String text, int cursorPosition) {
            this.text = text;
            this.cursorPosition = cursorPosition;
        }
    }
}

