/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.entity.EntityNPCInterface;

@Mod.EventBusSubscriber(modid="customnpcs")
public class VisibilityController {
    public static HashSet<UUID> npcs = new HashSet();
    public Map<UUID, EntityNPCInterface> trackedEntityHashTable = new TreeMap<UUID, EntityNPCInterface>();

    public void trackNpc(EntityNPCInterface npc) {
        this.trackedEntityHashTable.put(npc.func_110124_au(), npc);
    }

    public void onUpdate(EntityPlayerMP player) {
        if (!CustomNpcs.EnableInvisibleNpcs) {
            return;
        }
        for (Map.Entry<UUID, EntityNPCInterface> entry : this.trackedEntityHashTable.entrySet()) {
            VisibilityController.checkIsVisible(entry.getValue(), player);
        }
    }

    public static void checkIsVisible(EntityNPCInterface npc, EntityPlayerMP playerMP) {
        if (!CustomNpcs.EnableInvisibleNpcs) {
            return;
        }
        boolean is = VisibilityController.is(npc, playerMP);
        if (is) {
            npc.setVisible(playerMP);
        } else {
            npc.setInvisible(playerMP);
        }
    }

    public static boolean is(EntityNPCInterface npc, EntityPlayerMP playerMP) {
        return npc.display.isVisibleTo(playerMP) || playerMP.func_184614_ca().func_77973_b() == CustomItems.wand;
    }

    @SubscribeEvent
    public static void onTeleport(PlayerEvent.Clone event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            Server.sendData((EntityPlayerMP)event.getEntity(), EnumPacketClient.CLEAR_VISIBLE, new Object[0]);
        }
    }
}

