/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data.dsc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.data.IData;

public class SinglePlayerData {
    private final List<Integer> activeQuestBattles = new ArrayList<Integer>();
    private final Map<Integer, Integer> questIdBattlesIdMap = new HashMap<Integer, Integer>();

    public void generateBattleId(int questID) {
        int battleId = new Random().nextInt();
        this.questIdBattlesIdMap.put(questID, battleId);
        this.activeQuestBattles.add(battleId);
    }

    public Integer getBattleId(int questID) {
        return this.questIdBattlesIdMap.get(questID);
    }

    public void removeQuestBattle(int questID) {
        int battleId = this.questIdBattlesIdMap.get(questID);
        this.activeQuestBattles.removeIf(integer -> integer == battleId);
        this.questIdBattlesIdMap.remove(questID);
    }

    public boolean hasBattleId(int battleId) {
        return this.activeQuestBattles.contains(battleId);
    }

    public static SinglePlayerData get(EntityPlayerMP playerMP) {
        IData data = NpcAPI.Instance().getIEntity((Entity)playerMP).getTempdata();
        if (data.has("SinglePlayerData")) {
            return (SinglePlayerData)data.get("SinglePlayerData");
        }
        SinglePlayerData singlePlayerData = new SinglePlayerData();
        data.put("SinglePlayerData", singlePlayerData);
        return singlePlayerData;
    }
}

