/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.dsc;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.entity.dsc.DataKeys;
import noppes.npcs.entity.dsc.RenderConditionType;
import org.jetbrains.annotations.NotNull;

public interface RenderConditionController {
    public EntityLivingBase getEntity();

    default public void entityInit() {
        this.getEntity().func_184212_Q().func_187214_a(DataKeys.playerName, (Object)"");
        this.getEntity().func_184212_Q().func_187214_a(DataKeys.renderConditionId, (Object)0);
    }

    default public RenderConditionType getRenderCondition() {
        return RenderConditionType.get((Integer)this.getEntity().func_184212_Q().func_187225_a(DataKeys.renderConditionId));
    }

    default public void setRenderCondition(RenderConditionType renderConditionType) {
        this.getEntity().func_184212_Q().func_187227_b(DataKeys.renderConditionId, (Object)renderConditionType.getId());
        this.onSwapCondition();
    }

    default public void setRenderCondition(int renderConditionId) {
        this.getEntity().func_184212_Q().func_187227_b(DataKeys.renderConditionId, (Object)renderConditionId);
    }

    default public void onSwapCondition() {
        if (this.getRenderCondition() == RenderConditionType.STANDARD) {
            this.setPlayerName("");
        }
    }

    default public String getPlayerName() {
        return (String)this.getEntity().func_184212_Q().func_187225_a(DataKeys.playerName);
    }

    default public void setPlayerName(String name) {
        this.getEntity().func_184212_Q().func_187227_b(DataKeys.playerName, (Object)name);
    }

    default public void onUpdateClient() {
        if (this.getRenderCondition() == RenderConditionType.ON_PLAYER) {
            this.setCanRender(Minecraft.func_71410_x().field_71439_g.func_70005_c_().equals(this.getPlayerName()));
        } else {
            this.setCanRender(true);
        }
    }

    public boolean canRender();

    public void setCanRender(boolean var1);

    @NotNull
    default public void writeDataToNBT(@NotNull NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("getPlayerName", this.getPlayerName());
        tagCompound.func_74768_a("RenderCondition", this.getRenderCondition().getId());
    }

    default public void readDataFromNBT(@NotNull NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("getPlayerName")) {
            this.setPlayerName(tagCompound.func_74779_i("getPlayerName"));
        }
        if (tagCompound.func_74764_b("RenderCondition")) {
            this.setRenderCondition(tagCompound.func_74762_e("RenderCondition"));
        }
    }
}

