/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.dsc;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.common.FMLCommonHandler;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.dsc.SinglePlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;
import ru.justagod.cutter.invoke.Invoke;

public interface SinglePlayerMob {
    public EntityLivingBase getEntity();

    public String getPlayerName();

    public int getQuestId();

    public int getBattleId();

    public void setQuestId(int var1);

    public void setBattleId(int var1);

    default public boolean isMobOnPlayer(String playerName) {
        return this.getPlayerName().equals(playerName);
    }

    default public boolean isGetDamage(DamageSource damageSrc) {
        if (damageSrc.func_76346_g() != null) {
            return this.isMobOnPlayer(damageSrc.func_76346_g().func_70005_c_()) && damageSrc.func_76346_g() instanceof EntityPlayer;
        }
        if (damageSrc.func_76364_f() != null) {
            return this.isMobOnPlayer(damageSrc.func_76364_f().func_70005_c_()) && damageSrc.func_76364_f() instanceof EntityPlayer;
        }
        return false;
    }

    default public boolean isAttackTarget(@Nullable EntityLivingBase entitylivingbaseIn) {
        return this.isMobOnPlayer(entitylivingbaseIn.func_70005_c_()) && entitylivingbaseIn instanceof EntityPlayer;
    }

    default public void checkHasPlayer() {
        this.tryCheck((EntityNPCInterface)this.getEntity());
    }

    default public void tryCheck(EntityNPCInterface npcInterface) {
        Invoke.server(() -> {
            if (!this.getEntity().field_70170_p.field_72995_K) {
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(this.getPlayerName());
                if (player == null) {
                    npcInterface.delete();
                } else {
                    SinglePlayerData playerData = SinglePlayerData.get(player);
                    if (!playerData.hasBattleId(this.getBattleId())) {
                        npcInterface.delete();
                        return;
                    }
                    PlayerData customNpcPlayerData = PlayerData.get((EntityPlayer)player);
                    if (customNpcPlayerData != null && !customNpcPlayerData.questData.activeQuests.containsKey(this.getQuestId())) {
                        npcInterface.delete();
                    }
                }
            }
        });
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    default public void onUpdateServer() {
        if (this.getEntity().field_70173_aa % 20 == 0) {
            this.checkHasPlayer();
        }
    }

    default public void writeSingleDataToNBT(@NotNull NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("getQuestID", this.getQuestId());
        tagCompound.func_74768_a("battleID", this.getBattleId());
    }

    default public void readSingleDataFromNBT(@NotNull NBTTagCompound tagCompound) {
        if (tagCompound.func_74764_b("getQuestID")) {
            this.setQuestId(tagCompound.func_74762_e("getQuestID"));
        }
        if (tagCompound.func_74764_b("battleID")) {
            this.setBattleId(tagCompound.func_74762_e("battleID"));
        }
    }
}

