/*
 * Decompiled with CFR 0.152.
 */
package net.decentstudio.jutsublocker.network.mod;

import io.netty.buffer.ByteBuf;
import net.decentstudio.jutsublocker.dto.RegionDTO;
import net.decentstudio.jutsublocker.manager.RegionsManager;
import net.decentstudio.jutsublocker.util.Pair;
import net.decentstudio.jutsublocker.util.RegionDTOMapper;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class C2AddRegionPacket
implements IMessage {
    public Pair<Integer, RegionDTO> regionDTO = null;

    public C2AddRegionPacket() {
    }

    public C2AddRegionPacket(Pair<Integer, RegionDTO> regionDTO) {
        this.regionDTO = regionDTO;
    }

    public void fromBytes(ByteBuf buf) {
        String region = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.regionDTO = RegionDTOMapper.toRegionDTO(region);
    }

    public void toBytes(ByteBuf buf) {
        if (this.regionDTO != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)RegionDTOMapper.toBatch(this.regionDTO.getKey(), this.regionDTO.getValue()));
        }
    }

    public static class Handler
    implements IMessageHandler<C2AddRegionPacket, IMessage> {
        public IMessage onMessage(C2AddRegionPacket packet, MessageContext ctx) {
            RegionsManager.addRegion(packet.regionDTO.getKey(), packet.regionDTO.getValue());
            return null;
        }
    }
}

