/*
 * Decompiled with CFR 0.152.
 */
package net.decentstudio.jutsublocker.network.plugin;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.EnumMap;
import net.decentstudio.jutsublocker.network.plugin.BasePacket;
import net.decentstudio.jutsublocker.network.plugin.EnumPacket;
import net.minecraft.network.Packet;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PacketHandlerClient {
    public static final String CHANNEL_NAME = "jutsublockerplugin";
    private final EnumMap<Side, FMLEmbeddedChannel> channels = NetworkRegistry.INSTANCE.newChannel("jutsublockerplugin", new io.netty.channel.ChannelHandler[]{new ChannelCodec()});

    public PacketHandlerClient() {
        FMLEmbeddedChannel clientChannel = this.channels.get(Side.CLIENT);
        String codec = clientChannel.findChannelHandlerNameForType(ChannelCodec.class);
        clientChannel.pipeline().addAfter(codec, CHANNEL_NAME, (io.netty.channel.ChannelHandler)new ChannelHandler());
    }

    public Packet createPacketFrom(BasePacket msg, Side side) {
        return this.channels.get(side).generatePacketFrom((Object)msg);
    }

    public void sendPacketToServer(Packet packet) {
        this.channels.get(Side.CLIENT).writeOutbound(new Object[]{packet});
    }

    public void sendPacketToServer(BasePacket packet) {
        Packet generatedPacket = this.createPacketFrom(packet, Side.SERVER);
        this.sendPacketToServer(generatedPacket);
    }

    private static class ChannelCodec
    extends FMLIndexedMessageToMessageCodec<BasePacket> {
        public ChannelCodec() {
            for (EnumPacket type : EnumPacket.values()) {
                this.addDiscriminator(type.ordinal(), type.getPacketClass());
            }
        }

        public void encodeInto(ChannelHandlerContext ctx, BasePacket msg, ByteBuf target) throws Exception {
            msg.write(target);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, BasePacket msg) {
            msg.read(source);
        }
    }

    private static class ChannelHandler
    extends SimpleChannelInboundHandler<BasePacket> {
        private ChannelHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, BasePacket packet) throws Exception {
            System.out.println("Got packet: " + packet.getClass().getSimpleName());
        }
    }
}

