/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.ModConfig;
import net.narutomod.NarutomodMod;
import net.narutomod.PlayerTracker;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.gui.overlay.OverlayChakraDisplay;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class Chakra
extends ElementsNarutomodMod.ModElement {
    private static final Map<EntityPlayer, PathwayPlayer> playerMap = Maps.newHashMap();
    private static final Map<EntityLivingBase, Pathway> livingMap = Maps.newHashMap();
    private static final String DATAKEY = "ChakraPathwaySystem";
    private static PathwayPlayer clientPlayerPathway = null;

    public Chakra(ElementsNarutomodMod instance) {
        super(instance, 395);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isInitialized(EntityPlayer player) {
        return clientPlayerPathway != null && Chakra.clientPlayerPathway.user == player;
    }

    public static Collection<PathwayPlayer> getPlayerMap() {
        return playerMap.values();
    }

    public static double getLevel(EntityLivingBase entity) {
        Pathway cp = Chakra.pathway(entity);
        return MathHelper.func_76133_a((double)Math.max(cp.getAmount(), cp.getMax()));
    }

    public static double getChakraModifier(EntityLivingBase entity) {
        return ProcedureUtils.getCDModifier(Chakra.getLevel(entity));
    }

    public static Pathway pathway(EntityLivingBase user) {
        if (user instanceof EntityPlayer) {
            return Chakra.pathway((EntityPlayer)user);
        }
        if (user instanceof EntityNinjaMob.Base) {
            return ((EntityNinjaMob.Base)user).getChakraPathway();
        }
        Pathway<EntityLivingBase> p = livingMap.get(user);
        if (p == null) {
            p = new Pathway<EntityLivingBase>(user);
            livingMap.put(user, p);
        }
        return p;
    }

    public static PathwayPlayer pathway(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            if (clientPlayerPathway == null || Chakra.clientPlayerPathway.user != player) {
                clientPlayerPathway = new PathwayPlayer(player);
            }
            return clientPlayerPathway;
        }
        PathwayPlayer p = playerMap.get(player);
        return p != null ? p : new PathwayPlayer(player);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(PathwayPlayer.ServerMessage.Handler.class, PathwayPlayer.ServerMessage.class, Side.CLIENT);
        this.elements.addNetworkMessage(PathwayPlayer.ConsumeMessage.Handler.class, PathwayPlayer.ConsumeMessage.class, Side.SERVER);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PathwayPlayer.PlayerHook());
    }

    public static class PathwayPlayer
    extends Pathway<EntityPlayer> {
        private boolean forceSync;
        private int motionlessTime;
        private double prevX;
        private double prevZ;

        protected PathwayPlayer(EntityPlayer playerIn) {
            super(playerIn);
            this.setMax(PlayerTracker.getBattleXp(playerIn) * 0.5);
            this.set(playerIn.getEntityData().func_74769_h(Chakra.DATAKEY));
            if (this.getAmount() < 0.0) {
                this.set(this.getMax());
            }
            this.prevX = playerIn.field_70165_t;
            this.prevZ = playerIn.field_70161_v;
            if (!playerIn.field_70170_p.field_72995_K) {
                playerMap.put(playerIn, this);
                this.sendToClient();
            }
        }

        @Override
        public void warningDisplay() {
            OverlayChakraDisplay.notEnoughChakraWarning((EntityPlayer)this.user);
        }

        private void sendToClient() {
            if (this.user instanceof EntityPlayerMP) {
                ServerMessage.sendToSelf((EntityPlayerMP)this.user, this.getAmount(), this.getMax());
            }
        }

        @Override
        protected void set(double amountIn) {
            if (amountIn != this.getAmount()) {
                super.set(amountIn);
                ((EntityPlayer)this.user).getEntityData().func_74780_a(Chakra.DATAKEY, amountIn);
                this.sendToClient();
                this.motionlessTime = 0;
            }
        }

        @Override
        public boolean consume(double amountIn, boolean ignoreMax) {
            boolean flag = super.consume(amountIn, ignoreMax);
            if (amountIn > 0.0 && !flag) {
                this.warningDisplay();
            }
            return flag;
        }

        @Override
        protected void onUpdate() {
            double d;
            super.onUpdate();
            if (((EntityPlayer)this.user).field_70170_p instanceof WorldServer && ((WorldServer)((EntityPlayer)this.user).field_70170_p).func_73056_e()) {
                this.consume(-0.6f);
            }
            ++this.motionlessTime;
            if (((EntityPlayer)this.user).field_70165_t != this.prevX || ((EntityPlayer)this.user).field_70161_v != this.prevZ || !((EntityPlayer)this.user).field_70122_E || ((EntityPlayer)this.user).field_82175_bq) {
                this.motionlessTime = 0;
            }
            if (this.motionlessTime > 80) {
                this.consume(-ModConfig.CHAKRA_REGEN_RATE - 0.001f * ((EntityPlayer)this.user).func_71024_bL().func_75115_e());
            }
            if ((d = PlayerTracker.getBattleXp((EntityPlayer)this.user) * 0.5) != this.getMax() || this.forceSync) {
                this.forceSync = false;
                this.setMax(d);
                this.sendToClient();
            }
            this.prevX = ((EntityPlayer)this.user).field_70165_t;
            this.prevZ = ((EntityPlayer)this.user).field_70161_v;
        }

        public static class ConsumeMessage
        implements IMessage {
            public double amount;

            public ConsumeMessage() {
            }

            public ConsumeMessage(double amountIn) {
                this.amount = amountIn;
            }

            public static void sendToServer(double amountIn) {
                NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new ConsumeMessage(amountIn));
            }

            public void toBytes(ByteBuf buf) {
                buf.writeDouble(this.amount);
            }

            public void fromBytes(ByteBuf buf) {
                this.amount = buf.readDouble();
            }

            public static class Handler
            implements IMessageHandler<ConsumeMessage, IMessage> {
                public IMessage onMessage(ConsumeMessage message, MessageContext context) {
                    EntityPlayerMP entity = context.getServerHandler().field_147369_b;
                    entity.func_71121_q().func_152344_a(() -> Chakra.pathway((EntityPlayer)entity).consume(message.amount));
                    return null;
                }
            }
        }

        public static class ServerMessage
        implements IMessage {
            double amount;
            double max;

            public ServerMessage() {
            }

            public ServerMessage(double amountIn, double maxIn) {
                this.amount = amountIn;
                this.max = maxIn;
            }

            public static void sendToSelf(EntityPlayerMP player, double d1, double d2) {
                NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new ServerMessage(d1, d2), player);
            }

            public void toBytes(ByteBuf buf) {
                buf.writeDouble(this.amount);
                buf.writeDouble(this.max);
            }

            public void fromBytes(ByteBuf buf) {
                this.amount = buf.readDouble();
                this.max = buf.readDouble();
            }

            public static class Handler
            implements IMessageHandler<ServerMessage, IMessage> {
                @SideOnly(value=Side.CLIENT)
                public IMessage onMessage(ServerMessage message, MessageContext context) {
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                        if (player != null) {
                            Chakra.pathway((EntityPlayer)player).setMax(message.max).set(message.amount);
                        }
                    });
                    return null;
                }
            }
        }

        public static class PlayerHook {
            @SubscribeEvent
            public void onDeath(LivingDeathEvent event) {
                EntityLivingBase entity = event.getEntityLiving();
                if (entity instanceof EntityPlayer) {
                    if (entity.field_70170_p.field_72995_K) {
                        clientPlayerPathway = null;
                    } else {
                        Pathway p = (Pathway)playerMap.get((EntityPlayer)entity);
                        if (p != null) {
                            p.set(Math.min(PlayerTracker.keepNinjaXp(entity.field_70170_p) && PlayerTracker.getBattleXp((EntityPlayer)entity) > 10.0 ? 10.0 : 0.0, p.getMax()));
                            playerMap.remove((EntityPlayer)entity);
                        }
                    }
                }
            }

            @SubscribeEvent
            public void onTick(TickEvent.PlayerTickEvent event) {
                if (PlayerTracker.isNinja(event.player) && event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K) {
                    Pathway p = (Pathway)playerMap.get(event.player);
                    if (p != null) {
                        p.onUpdate();
                    } else if (event.player.field_71068_ca >= 10) {
                        Chakra.pathway(event.player);
                    }
                }
            }

            @SubscribeEvent
            public void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
                if (event.player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)event.player).field_71135_a.func_147359_a((Packet)new SPacketSetExperience(event.player.field_71106_cc, event.player.field_71067_cb, event.player.field_71068_ca));
                    PathwayPlayer p = (PathwayPlayer)playerMap.get(event.player);
                    if (p != null) {
                        p.forceSync = true;
                    }
                }
            }

            @SubscribeEvent
            public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
                if (!event.player.field_70170_p.field_72995_K && PlayerTracker.isNinja(event.player) && event.player.field_71068_ca >= 10) {
                    Chakra.pathway(event.player);
                }
            }

            @SubscribeEvent(priority=EventPriority.LOWEST)
            public void onRespawn(PlayerEvent.Clone event) {
                EntityPlayer oldPlayer = event.getOriginal();
                EntityPlayer newPlayer = event.getEntityPlayer();
                PathwayPlayer p = (PathwayPlayer)playerMap.get(oldPlayer);
                if (p != null) {
                    if (oldPlayer == newPlayer) {
                        p.forceSync = true;
                    } else {
                        PathwayPlayer pnew = Chakra.pathway(newPlayer);
                        pnew.set(p.getAmount());
                        pnew.forceSync = true;
                        playerMap.remove(oldPlayer);
                    }
                }
            }
        }
    }

    public static class Pathway<T extends EntityLivingBase> {
        protected final T user;
        private double amount;
        private double max;

        protected Pathway(T userIn) {
            this.user = userIn;
        }

        public double getMax() {
            return this.max;
        }

        public Pathway<T> setMax(double maxIn) {
            this.max = maxIn;
            return this;
        }

        protected void set(double amountIn) {
            this.amount = amountIn;
        }

        public boolean consume(double amountIn, boolean ignoreMax) {
            double max;
            double d = this.getAmount();
            double d1 = d - amountIn;
            d1 = d1 > (max = this.getMax()) ? (ignoreMax ? d1 : (amountIn > 0.0 ? d1 : (d > max ? d : max))) : (d1 > 0.0 ? d1 : d);
            this.set(d1);
            return d != d1;
        }

        public boolean consume(double amountIn) {
            return this.consume(amountIn, false);
        }

        public void consume(float percent) {
            this.consume(percent, false);
        }

        public void consume(float percent, boolean ignoreMax) {
            this.consume(this.getMax() * (double)percent, ignoreMax);
        }

        public void clear() {
            this.set(0.0);
        }

        public boolean isFull() {
            return this.getAmount() >= this.getMax();
        }

        public double getAmount() {
            return this.amount;
        }

        protected void onUpdate() {
            double d1;
            double d = this.getAmount();
            if (d > (d1 = this.getMax()) * 4.0 && this.user.func_70089_S()) {
                this.user.func_70097_a(DamageSource.field_191291_g, Float.MAX_VALUE);
                return;
            }
            if (d > d1 && ((EntityLivingBase)this.user).field_70173_aa % 20 == 0) {
                this.consume(10.0);
            }
            if (d < 10.0 && d1 > 150.0 && (!(this.user instanceof EntityPlayer) || !((EntityPlayer)this.user).func_184812_l_())) {
                this.user.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 3));
                this.user.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 3));
                this.user.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 3));
            }
        }

        public void warningDisplay() {
        }

        public String toString() {
            return "Chakra:{amount:" + this.getAmount() + ",max:" + this.getMax() + "," + this.user.func_70005_c_() + "}";
        }
    }
}

