/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.narutomod.ElementsNarutomodMod;

@ElementsNarutomodMod.ModElement.Tag
public class EntityTracker
extends ElementsNarutomodMod.ModElement {
    private static final Map<UUID, SessionDataHolder> entityMap = Maps.newHashMap();

    public EntityTracker(ElementsNarutomodMod instance) {
        super(instance, 532);
    }

    public static SessionDataHolder getOrCreate(Entity entity) {
        SessionDataHolder p = entityMap.get(entity.func_110124_au());
        if (p == null || !p.entity.isAddedToWorld()) {
            if (p != null) {
                p.remove();
            }
            p = new SessionDataHolder(entity);
        }
        return p;
    }

    public static void clearRemovedData() {
        Iterator<SessionDataHolder> iter = entityMap.values().iterator();
        while (iter.hasNext()) {
            if (iter.next().entity.isAddedToWorld()) continue;
            iter.remove();
        }
    }

    public static int trackingTotal() {
        return entityMap.size();
    }

    public static class SessionDataHolder {
        public final Entity entity;
        public BlockPos prevBlockPos;
        public AxisAlignedBB lastBB;
        public int lastLoggedXpTime;

        public SessionDataHolder(Entity entityIn) {
            this.entity = entityIn;
            entityMap.put(entityIn.func_110124_au(), this);
        }

        public static SessionDataHolder get(Entity entityIn) {
            return (SessionDataHolder)entityMap.get(entityIn.func_110124_au());
        }

        public void remove() {
            entityMap.remove(this.entity.func_110124_au());
        }

        public void saveBB() {
            this.lastBB = this.entity.func_174813_aQ();
        }

        public double lastPosX() {
            return this.lastBB.field_72340_a + (this.lastBB.field_72336_d - this.lastBB.field_72340_a) / 2.0;
        }

        public double lastPosY() {
            return this.lastBB.field_72338_b;
        }

        public double lastPosZ() {
            return this.lastBB.field_72339_c + (this.lastBB.field_72334_f - this.lastBB.field_72339_c) / 2.0;
        }

        public String toString() {
            return "lastBB:" + this.lastBB;
        }
    }
}

