/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBlockDust;
import net.minecraft.client.particle.ParticleRain;
import net.minecraft.client.particle.ParticleSimpleAnimated;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.entity.EntityItachi;
import net.narutomod.potion.PotionCorrosion;
import net.narutomod.procedure.ProcedureUtils;
import org.lwjgl.util.glu.Sphere;

@ElementsNarutomodMod.ModElement.Tag
public class Particles
extends ElementsNarutomodMod.ModElement {
    private static final Random rand = new Random();

    public Particles(ElementsNarutomodMod instance) {
        super(instance, 294);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(ParticleRenderer.Message.Handler.class, ParticleRenderer.Message.class, Side.CLIENT);
        this.elements.addNetworkMessage(BurningAsh.Message.Handler.class, BurningAsh.Message.class, Side.SERVER);
        this.elements.addNetworkMessage(AcidSpit.Message.Handler.class, AcidSpit.Message.class, Side.SERVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.SMOKE.getID(), (IParticleFactory)new Smoke.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.SUSPENDED.getID(), (IParticleFactory)new Suspend.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.FALLING_DUST.getID(), (IParticleFactory)new FallingDust.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.FLAME.getID(), (IParticleFactory)new Flame.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.MOB_APPEARANCE.getID(), (IParticleFactory)new MobAppearance.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.BURNING_ASH.getID(), (IParticleFactory)new BurningAsh.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.HOMING_ORB.getID(), (IParticleFactory)new HomingOrb.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.PORTAL_SPIRAL.getID(), (IParticleFactory)new SpiralPortal.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.EXPANDING_SPHERE.getID(), (IParticleFactory)new ExpandingSphere.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.SEAL_FORMULA.getID(), (IParticleFactory)new SealFormula.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.ACID_SPIT.getID(), (IParticleFactory)new AcidSpit.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.WHIRLPOOL.getID(), (IParticleFactory)new Whirlpool.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.SONIC_BOOM.getID(), (IParticleFactory)new SonicBoom.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.BLOCK_DUST.getID(), (IParticleFactory)new BlockDust.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.SAND.getID(), (IParticleFactory)new Sand.Factory());
        Minecraft.func_71410_x().field_71452_i.func_178929_a(Types.WATER_SPLASH.getID(), (IParticleFactory)new WaterSplash.Factory());
    }

    public static void spawnParticle(World world, Types type, double x, double y, double z, int count, double xOff, double yOff, double zOff, double xSpeed, double ySpeed, double zSpeed, int ... args) {
        Particles.spawnParticle(world, type, x, y, z, count, xOff, yOff, zOff, xSpeed, ySpeed, zSpeed, 64.0, args);
    }

    public static void spawnParticle(World world, Types type, double x, double y, double z, int count, double xOff, double yOff, double zOff, double xSpeed, double ySpeed, double zSpeed, double renderDistance, int ... args) {
        if (world.field_72995_K) {
            new Renderer().spawnParticles(type, x, y, z, count, xOff, yOff, zOff, xSpeed, ySpeed, zSpeed, args);
        } else {
            NarutomodMod.PACKET_HANDLER.sendToAllAround((IMessage)new ParticleRenderer.Message(new ParticleRenderer.MessageContents(type, x, y, z, count, xOff, yOff, zOff, xSpeed, ySpeed, zSpeed, args)), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, renderDistance));
        }
    }

    public static enum Types {
        SMOKE("smoke_colored", 54678400, 6),
        SUSPENDED("suspended_colored", 54678401, 3),
        FALLING_DUST("falling_dust", 54678402, 1),
        FLAME("flame_colored", 54678403, 2),
        MOB_APPEARANCE("mob_appearance", 54678404, 1),
        BURNING_ASH("burning_ash", 54678405, 1),
        HOMING_ORB("homing_orb", 54678406, 2),
        EXPANDING_SPHERE("expanding_sphere", 54678407, 3),
        PORTAL_SPIRAL("portal_spiral", 54678408, 3),
        SEAL_FORMULA("seal_formula", 54678409, 3),
        ACID_SPIT("acid_spit", 54678410, 2),
        WHIRLPOOL("whirlpool", 54678411, 4),
        BLOCK_DUST("block_dust", 54678412, 2),
        SONIC_BOOM("sonic_boom", 54678413, 4),
        SAND("sand_colored", 54678414, 4),
        WATER_SPLASH("water_splash", 54678415, 1);

        private final String particleName;
        private final int particleID;
        private final int argumentCount;
        private static final Map<Integer, Types> PARTICLES;

        private Types(String name, int id, int args) {
            this.particleName = name;
            this.particleID = id;
            this.argumentCount = args;
        }

        public String getName() {
            return this.particleName;
        }

        public int getID() {
            return this.particleID;
        }

        public int getArgsCount() {
            return this.argumentCount;
        }

        public static Types getTypeFromId(int id) {
            return PARTICLES.get(id);
        }

        static {
            PARTICLES = Maps.newHashMap();
            for (Types type : Types.values()) {
                PARTICLES.put(type.getID(), type);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class WaterSplash
    extends ParticleRain {
        protected WaterSplash(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, float scale) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn);
            this.func_70536_a(19 + this.field_187136_p.nextInt(3));
            this.field_70544_f *= scale;
            this.field_187129_i = xSpeedIn;
            this.field_187130_j = ySpeedIn;
            this.field_187131_k = zSpeedIn;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                float arg0 = parameters.length > 0 ? (float)parameters[0] / 10.0f : 1.0f;
                return new WaterSplash(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, arg0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Sand
    extends Smoke {
        protected Sand(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, int color, float scale, int maxAge, double floatSpeed) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, motionX, motionY, motionZ, color, scale, maxAge, 0, -1, floatSpeed);
            this.field_94055_c = 0;
            this.field_70544_f = scale;
            this.field_187129_i = motionX;
            this.field_187130_j = motionY;
            this.field_187131_k = motionZ;
        }

        @Override
        public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            this.textureManager.func_110577_a(Smoke.TEXTURE);
            float f0 = (float)this.field_94054_b / 8.0f;
            float f1 = f0 + 0.124875f;
            float f2 = (float)this.field_94055_c / 8.0f;
            float f3 = f2 + 0.124875f;
            float f4 = 0.1f * this.field_70544_f;
            float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            float f8 = this.field_82339_as;
            int i = this.func_189214_a(partialTicks);
            int j = i >> 16 & 0xFFFF;
            int k = i & 0xFFFF;
            Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
            buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f8).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f8).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)f0, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f8).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)f0, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f8).func_187314_a(j, k).func_181675_d();
        }

        @Override
        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            if (this.field_70547_e == 0 || this.field_70546_d++ >= this.field_70547_e) {
                this.func_187112_i();
                return;
            }
            double d = MathHelper.func_76133_a((double)(this.field_187129_i * this.field_187129_i + this.field_187130_j * this.field_187130_j + this.field_187131_k * this.field_187131_k));
            this.field_94054_b = (this.field_94054_b + (d > 0.01 ? 1 : 0)) % 8;
            this.field_187130_j += this.floatMotionY;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= 0.96;
            this.field_187130_j *= 0.96;
            this.field_187131_k *= 0.96;
            if (this.field_187132_l) {
                this.field_187129_i *= 0.7;
                this.field_187131_k *= 0.7;
            }
        }

        @Override
        public boolean func_187111_c() {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                double arg3 = parameters.length > 3 ? (double)parameters[3] / 1000.0 : -0.004;
                int arg2 = parameters.length > 2 ? parameters[2] : 0;
                float arg1 = parameters.length > 1 ? (float)parameters[1] / 10.0f : 1.0f;
                int arg0 = parameters.length > 0 ? parameters[0] : -1;
                return new Sand(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, arg0, arg1, arg2, arg3);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class BlockDust
    extends ParticleBlockDust {
        protected BlockDust(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, IBlockState state, float size) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, state);
            this.field_70544_f *= size;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            @Nullable
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... params) {
                IBlockState iblockstate = Block.func_176220_d((int)params[0]);
                float arg1 = params.length > 1 ? (float)params[1] / 10.0f : 1.0f;
                return iblockstate.func_185901_i() == EnumBlockRenderType.INVISIBLE ? null : new BlockDust(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, iblockstate, arg1).func_174845_l();
            }
        }
    }

    public static class SonicBoom
    extends TextureAsParticle {
        private static final ResourceLocation TEXTURE = new ResourceLocation("narutomod:textures/sonicboom.png");

        protected SonicBoom(TextureManager textureManagerIn, World worldIn, double x, double y, double z, double speedX, double speedY, double speedZ, int color, float scale, int maxAge, int brightness) {
            super(textureManagerIn, worldIn, x, y, z, speedX, speedY, speedZ, color, scale, maxAge, brightness);
            this.rotateX = ProcedureUtils.getPitchFromVec(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.rotateY = ProcedureUtils.getYawFromVec(this.field_187129_i, this.field_187131_k);
            this.rotateZ = this.field_187136_p.nextFloat() * 360.0f;
        }

        @Override
        protected ResourceLocation getTexture() {
            return TEXTURE;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double x, double y, double z, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                int arg3 = parameters.length > 3 ? parameters[3] : 0;
                int arg2 = parameters.length > 2 ? parameters[2] : 0;
                float arg1 = parameters.length > 1 ? (float)parameters[1] / 10.0f : 1.0f;
                int arg0 = parameters.length > 0 ? parameters[0] : -1;
                return new SonicBoom(Minecraft.func_71410_x().func_110434_K(), worldIn, x, y, z, xSpeedIn, ySpeedIn, zSpeedIn, arg0, arg1, arg2, arg3);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Whirlpool
    extends TextureAsParticle {
        private static final ResourceLocation TEXTURE = new ResourceLocation("narutomod:textures/swirl_white_2.png");

        protected Whirlpool(TextureManager textureManagerIn, World worldIn, double x, double y, double z, double speedX, double speedY, double speedZ, int color, float scale, int maxAge, int brightness) {
            super(textureManagerIn, worldIn, x, y, z, speedX, speedY, speedZ, color, scale, maxAge, brightness);
            this.rotateX = ProcedureUtils.getPitchFromVec(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.rotateY = ProcedureUtils.getYawFromVec(this.field_187129_i, this.field_187131_k);
            this.rotateZ = this.field_187136_p.nextFloat() * 360.0f;
        }

        @Override
        protected ResourceLocation getTexture() {
            return TEXTURE;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double x, double y, double z, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                int arg3 = parameters.length > 3 ? parameters[3] : 0;
                int arg2 = parameters.length > 2 ? parameters[2] : 0;
                float arg1 = parameters.length > 1 ? (float)parameters[1] / 10.0f : 1.0f;
                int arg0 = parameters.length > 0 ? parameters[0] : -1;
                return new Whirlpool(Minecraft.func_71410_x().func_110434_K(), worldIn, x, y, z, xSpeedIn, ySpeedIn, zSpeedIn, arg0, arg1, arg2, arg3);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class SealFormula
    extends TextureAsParticle {
        private static final ResourceLocation TEXTURE = new ResourceLocation("narutomod:textures/seal_black_512.png");
        private final int growTime;

        protected SealFormula(TextureManager textureManagerIn, World worldIn, double x, double y, double z, double speedX, double speedY, double speedZ, float size, float yRotation, int maxAge) {
            super(textureManagerIn, worldIn, x, y, z, 0.0, 0.0, 0.0, -1, size, maxAge, 0);
            this.field_187129_i = 0.0;
            this.field_187130_j = 0.0;
            this.field_187131_k = 0.0;
            this.rotateY = yRotation;
            this.field_70544_f = size;
            this.growTime = Math.min(this.field_70547_e, 20);
        }

        @Override
        protected ResourceLocation getTexture() {
            return TEXTURE;
        }

        @Override
        public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            this.textureManager.func_110577_a(TEXTURE);
            float f0 = partialTicks + (float)this.field_70546_d;
            float f1 = 0.5f;
            float f2 = 0.0f;
            float f4 = 1.0f;
            if (f0 >= 0.8f * (float)this.field_70547_e) {
                f4 = Math.max(1.0f - (f0 - 0.8f * (float)this.field_70547_e) / (0.2f * (float)this.field_70547_e), 0.0f);
            }
            float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            float f8 = Math.min(f0 / (float)this.growTime, 1.0f);
            float f3 = this.field_70544_f * f8;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)f5, (float)f6, (float)f7);
            GlStateManager.func_179114_b((float)(-this.rotateY), (float)0.0f, (float)1.0f, (float)0.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            buffer.func_181662_b((double)(-f1 * f3), (double)(-f2 * f3), (double)(-0.5f * f3)).func_187315_a(0.5 * (1.0 - (double)f8), 0.5 * (1.0 + (double)f8)).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buffer.func_181662_b((double)(-f1 * f3), (double)(-f2 * f3), (double)(0.5f * f3)).func_187315_a(0.5 * (1.0 - (double)f8), 0.5 * (1.0 - (double)f8)).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buffer.func_181662_b((double)(f1 * f3), (double)(f2 * f3), (double)(0.5f * f3)).func_187315_a(0.5 * (1.0 + (double)f8), 0.5 * (1.0 - (double)f8)).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buffer.func_181662_b((double)(f1 * f3), (double)(f2 * f3), (double)(-0.5f * f3)).func_187315_a(0.5 * (1.0 + (double)f8), 0.5 * (1.0 + (double)f8)).func_181666_a(1.0f, 1.0f, 1.0f, f4).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double x, double y, double z, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                int arg2 = parameters.length > 2 ? parameters[2] : 20;
                float arg1 = parameters.length > 1 ? (float)parameters[1] / 10.0f : 0.0f;
                float arg0 = parameters.length > 0 ? (float)parameters[0] / 10.0f : 1.0f;
                return new SealFormula(Minecraft.func_71410_x().func_110434_K(), worldIn, x, y, z, xSpeedIn, ySpeedIn, zSpeedIn, arg0, arg1, arg2);
            }
        }
    }

    public static abstract class TextureAsParticle
    extends Particle {
        protected final TextureManager textureManager;
        protected int particleBrightness;
        protected float rotateY;
        protected float rotateX;
        protected float rotateZ;

        protected TextureAsParticle(TextureManager textureManagerIn, World worldIn, double x, double y, double z, double speedX, double speedY, double speedZ, int color, float scale, int maxAge, int brightness) {
            super(worldIn, x, y, z, 0.0, 0.0, 0.0);
            this.textureManager = textureManagerIn;
            this.field_82339_as = (float)(color >> 24 & 0xFF) / 255.0f;
            this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(color & 0xFF) / 255.0f;
            float f = (this.field_187136_p.nextFloat() - 0.5f) * 0.1f;
            if (this.field_70552_h + f >= 0.0f && this.field_70552_h + f <= 1.0f) {
                this.field_70552_h += f;
            }
            if (this.field_70553_i + f >= 0.0f && this.field_70553_i + f <= 1.0f) {
                this.field_70553_i += f;
            }
            if (this.field_70551_j + f >= 0.0f && this.field_70551_j + f <= 1.0f) {
                this.field_70551_j += f;
            }
            this.field_70544_f *= scale;
            this.field_187129_i *= 0.02;
            this.field_187130_j *= 0.02;
            this.field_187131_k *= 0.02;
            this.field_187129_i += speedX;
            this.field_187130_j += speedY;
            this.field_187131_k += speedZ;
            if (maxAge > 0) {
                this.field_70547_e = maxAge;
            } else {
                this.field_70547_e = (int)(4.0 / (this.field_187136_p.nextDouble() * 0.8 + 0.2));
                this.field_70547_e = (int)((float)this.field_70547_e * scale);
            }
            if (brightness != 0) {
                this.particleBrightness = brightness;
            }
        }

        protected abstract ResourceLocation getTexture();

        public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            this.textureManager.func_110577_a(this.getTexture());
            float f1 = (float)this.field_70546_d + partialTicks;
            float f2 = f1 / (float)this.field_70547_e;
            float f3 = this.field_70544_f * (f2 * 0.6f + 0.7f);
            float f4 = this.field_82339_as * (1.0f - (f2 - 0.1f) * (f2 - 0.1f));
            if (f2 <= 0.1f) {
                f4 = f2 / 0.1f;
            }
            float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            int i = this.func_189214_a(partialTicks);
            int j = i >> 16 & 0xFFFF;
            int k = i & 0xFFFF;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)f5, (float)f6, (float)f7);
            GlStateManager.func_179114_b((float)(-this.rotateY), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.rotateX, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(this.rotateZ - 30.0f * f1), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179092_a((int)516, (float)0.001f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            buffer.func_181662_b(-0.5 * (double)f3, -0.5 * (double)f3, 0.0).func_187315_a(0.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f4).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(0.5 * (double)f3, -0.5 * (double)f3, 0.0).func_187315_a(1.0, 1.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f4).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(0.5 * (double)f3, 0.5 * (double)f3, 0.0).func_187315_a(1.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f4).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b(-0.5 * (double)f3, 0.5 * (double)f3, 0.0).func_187315_a(0.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f4).func_187314_a(j, k).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }

        public void func_187110_a(double x, double y, double z) {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
            this.func_187118_j();
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            if (this.field_70546_d++ >= this.field_70547_e) {
                this.func_187112_i();
            }
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= 0.98;
            this.field_187130_j *= 0.98;
            this.field_187131_k *= 0.98;
        }

        public int func_189214_a(float p_189214_1_) {
            return this.particleBrightness != 0 ? this.particleBrightness << 16 | this.particleBrightness : super.func_189214_a(p_189214_1_);
        }

        public int func_70537_b() {
            return 3;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ExpandingSphere
    extends Particle {
        private static final ResourceLocation TEXTURE = new ResourceLocation("narutomod:textures/white_square.png");
        private int sphereIdOutside;
        private int sphereIdInside;
        private Sphere sphere;
        private final TextureManager textureManager;

        protected ExpandingSphere(TextureManager textureManagerIn, World worldIn, double x, double y, double z, double speedX, double speedY, double speedZ, float size, int life, int color) {
            super(worldIn, x, y, z, 0.0, 0.0, 0.0);
            this.field_187129_i = speedX;
            this.field_187130_j = speedY;
            this.field_187131_k = speedZ;
            this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(color & 0xFF) / 255.0f;
            this.field_70544_f = size;
            this.field_70547_e = life;
            this.textureManager = textureManagerIn;
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            if (this.field_70546_d++ >= this.field_70547_e) {
                this.func_187112_i();
            }
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        }

        private void compileDisplayList() {
            this.sphere = new Sphere();
            this.sphere.setDrawStyle(100012);
            this.sphere.setNormals(100000);
            this.sphere.setOrientation(100020);
            this.sphereIdOutside = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.sphereIdOutside, (int)4864);
            this.textureManager.func_110577_a(TEXTURE);
            this.sphere.draw(1.0f, 32, 32);
            GlStateManager.func_187415_K();
            this.sphere.setOrientation(100021);
            this.sphereIdInside = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.sphereIdInside, (int)4864);
            this.textureManager.func_110577_a(TEXTURE);
            this.sphere.draw(1.0f, 32, 32);
            GlStateManager.func_187415_K();
        }

        public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            float f1 = 1.0f;
            if ((float)this.field_70546_d > 0.8f * (float)this.field_70547_e) {
                f1 = 1.0f - ((float)this.field_70546_d - 0.8f * (float)this.field_70547_e) / (0.2f * (float)this.field_70547_e);
            }
            if (this.sphere == null) {
                this.compileDisplayList();
            }
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            float scale = (float)this.field_70546_d * 0.5f;
            int i = 0;
            while (scale > 0.0f) {
                if (scale <= this.field_70544_f) {
                    float r = 1.0f - 0.05f * (float)i * (1.0f - this.field_70552_h);
                    float g = 1.0f - 0.05f * (float)i * (1.0f - this.field_70553_i);
                    float b = 1.0f - 0.05f * (float)i * (1.0f - this.field_70551_j);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)(0.05f * f1));
                    GlStateManager.func_179109_b((float)f5, (float)f6, (float)f7);
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                    GlStateManager.func_179148_o((int)this.sphereIdOutside);
                    GlStateManager.func_179148_o((int)this.sphereIdInside);
                    GlStateManager.func_179121_F();
                }
                scale = (float)(this.field_70546_d - ++i) * 0.5f;
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }

        public int func_70537_b() {
            return 3;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double x, double y, double z, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                int arg2 = parameters.length > 2 ? parameters[2] : -1;
                int arg1 = parameters.length > 1 ? parameters[1] : 1;
                float arg0 = parameters.length > 0 ? (float)parameters[0] / 10.0f : 1.0f;
                return new ExpandingSphere(Minecraft.func_71410_x().func_110434_K(), worldIn, x, y, z, xSpeedIn, ySpeedIn, zSpeedIn, arg0, arg1, arg2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class AcidSpit
    extends Smoke {
        private static int PARTICLE_ID = -1;
        private final int id = PARTICLE_ID--;
        private final Entity excludedEntity;
        private EntityLivingBase affectedEntity;
        private double heightOffset;

        protected AcidSpit(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int excludeEntityId, int color) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, color, 0.5f + rand.nextFloat() * 4.5f, 0, 0, -1, -0.005f);
            this.excludedEntity = worldIn.func_73045_a(excludeEntityId);
            this.func_187115_a(this.field_187134_n * this.field_70544_f, this.field_187135_o * this.field_70544_f);
        }

        @Override
        public void func_189213_a() {
            super.func_189213_a();
            if (this.func_187113_k()) {
                if (this.affectedEntity == null) {
                    for (EntityLivingBase entity : this.field_187122_b.func_72872_a(EntityLivingBase.class, this.func_187116_l())) {
                        if (entity.equals((Object)this.excludedEntity)) continue;
                        NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new Message(entity.func_145782_y(), this.field_70547_e - this.field_70546_d));
                        this.affectedEntity = entity;
                        this.heightOffset = this.field_187127_g - entity.field_70163_u;
                    }
                } else {
                    this.func_187109_b(this.affectedEntity.field_70165_t, this.affectedEntity.field_70163_u + this.heightOffset, this.affectedEntity.field_70161_v);
                    this.heightOffset += this.floatMotionY;
                }
                BlockPos pos = ProcedureUtils.getNearestNonAirBlock(this.field_187122_b, this.func_187116_l().func_186662_g(0.01), new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h), 50.0f, true);
                if (pos != null) {
                    Minecraft.func_71410_x().field_71438_f.func_180441_b(this.id, pos, 5);
                }
            }
        }

        public static class Message
        implements IMessage {
            int id;
            int ticks;

            public Message() {
            }

            public Message(int entityId, int t) {
                this.id = entityId;
                this.ticks = t;
            }

            public void toBytes(ByteBuf buf) {
                buf.writeInt(this.id);
                buf.writeInt(this.ticks);
            }

            public void fromBytes(ByteBuf buf) {
                this.id = buf.readInt();
                this.ticks = buf.readInt();
            }

            public static class Handler
            implements IMessageHandler<Message, IMessage> {
                public IMessage onMessage(Message message, MessageContext context) {
                    WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                    world.func_152344_a(() -> {
                        Entity entity = world.func_73045_a(message.id);
                        if (entity instanceof EntityLivingBase) {
                            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(PotionCorrosion.potion, message.ticks, 1));
                        }
                    });
                    return null;
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                int arg1 = parameters.length > 1 ? parameters[1] : -2130716998;
                int arg0 = parameters.length > 0 ? parameters[0] : -1;
                return new AcidSpit(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, arg0, arg1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class BurningAsh
    extends Smoke {
        private final Entity excludeEntity;

        protected BurningAsh(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int excludeEntityId) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, -10461088, 8.0f + rand.nextFloat() * 5.0f, 100, 0, -1, 0.0);
            this.excludeEntity = worldIn.func_73045_a(excludeEntityId);
        }

        @Override
        public void func_189213_a() {
            List list;
            super.func_189213_a();
            if (this.func_187113_k() && !(list = this.field_187122_b.func_72872_a(EntityLivingBase.class, this.func_187116_l().func_186662_g(1.0))).isEmpty()) {
                for (EntityLivingBase entity : list) {
                    if (entity.equals((Object)this.excludeEntity)) continue;
                    NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new Message(entity.func_145782_y(), 10));
                }
            }
        }

        public static class Message
        implements IMessage {
            int id;
            int sec;

            public Message() {
            }

            public Message(int entityId, int seconds) {
                this.id = entityId;
                this.sec = seconds;
            }

            public void toBytes(ByteBuf buf) {
                buf.writeInt(this.id);
                buf.writeInt(this.sec);
            }

            public void fromBytes(ByteBuf buf) {
                this.id = buf.readInt();
                this.sec = buf.readInt();
            }

            public static class Handler
            implements IMessageHandler<Message, IMessage> {
                public IMessage onMessage(Message message, MessageContext context) {
                    WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                    world.func_152344_a(() -> {
                        Entity entity = world.func_73045_a(message.id);
                        if (entity instanceof EntityLivingBase) {
                            entity.func_70015_d(message.sec);
                        }
                    });
                    return null;
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                int arg0 = parameters.length > 0 ? parameters[0] : -1;
                return new BurningAsh(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, arg0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class SpiralPortal
    extends Particle {
        private final double portalX;
        private final double portalY;
        private final double portalZ;
        private final ProcedureUtils.Vec2f ogRotation;
        private final double ogLength;

        protected SpiralPortal(World worldIn, double xIn, double yIn, double zIn, double radiusIn, int color, float scaleIn) {
            super(worldIn, xIn, yIn, zIn, 0.0, 0.0, 0.0);
            if (radiusIn == 0.0) {
                radiusIn = this.field_187136_p.nextDouble() * 4.0 + 1.0;
            }
            this.func_187109_b(xIn + (this.field_187136_p.nextDouble() - 0.5) * radiusIn * 2.0, yIn + (this.field_187136_p.nextDouble() - 0.5) * radiusIn * 2.0, zIn + (this.field_187136_p.nextDouble() - 0.5) * radiusIn * 2.0);
            this.portalX = xIn;
            this.portalY = yIn;
            this.portalZ = zIn;
            this.field_70547_e = this.field_187136_p.nextInt(11) + 50;
            Vec3d vec = new Vec3d(this.field_187126_f - xIn, this.field_187127_g - yIn, this.field_187128_h - zIn);
            this.ogRotation = ProcedureUtils.getYawPitchFromVec(vec);
            this.ogLength = vec.func_72433_c();
            this.func_70536_a(0);
            this.field_82339_as = (float)(color >> 24 & 0xFF) / 255.0f;
            this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(color & 0xFF) / 255.0f;
            float f = (this.field_187136_p.nextFloat() - 0.5f) * 0.1f;
            if (this.field_70552_h + f >= 0.0f && this.field_70552_h + f <= 1.0f) {
                this.field_70552_h += f;
            }
            if (this.field_70553_i + f >= 0.0f && this.field_70553_i + f <= 1.0f) {
                this.field_70553_i += f;
            }
            if (this.field_70551_j + f >= 0.0f && this.field_70551_j + f <= 1.0f) {
                this.field_70551_j += f;
            }
            if (scaleIn != 0.0f) {
                this.field_70544_f *= scaleIn;
            }
        }

        public void func_187110_a(double x, double y, double z) {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
            this.func_187118_j();
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            if (++this.field_70546_d >= this.field_70547_e) {
                this.func_187112_i();
            }
            float f = (float)this.field_70546_d / (float)this.field_70547_e;
            float f1 = (this.ogRotation.x + 180.0f) / 90.0f;
            float f2 = f1 > 3.0f ? -f : (f1 > 2.0f ? f : (f1 > 1.0f ? -f : f));
            Vec3d vec = new Vec3d(0.0, 0.0, this.ogLength * (1.0 - (double)f)).func_178789_a((-this.ogRotation.y + f2 * 360.0f) * (float)Math.PI / 180.0f).func_178785_b(-this.ogRotation.x * (float)Math.PI / 180.0f).func_72441_c(this.portalX, this.portalY, this.portalZ).func_178786_a(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            this.field_187129_i = vec.field_72450_a;
            this.field_187130_j = vec.field_72448_b;
            this.field_187131_k = vec.field_72449_c;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        }

        public boolean func_187111_c() {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                float arg2 = parameters.length > 2 ? (float)parameters[2] / 10.0f : 0.0f;
                int arg1 = parameters.length > 1 ? parameters[1] : -1;
                double arg0 = parameters.length > 0 ? (double)parameters[0] : 0.0;
                return new SpiralPortal(worldIn, xCoordIn, yCoordIn, zCoordIn, arg0, arg1, arg2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class HomingOrb
    extends Particle {
        protected HomingOrb(World worldIn, double xIn, double yIn, double zIn, double radiusIn, float scaleIn) {
            super(worldIn, xIn, yIn, zIn, 0.0, 0.0, 0.0);
            if (radiusIn == 0.0) {
                radiusIn = Math.random() * 4.0 + 1.0;
            }
            this.func_187109_b(xIn + this.field_187136_p.nextGaussian() * radiusIn, yIn + this.field_187136_p.nextGaussian() * radiusIn, zIn + this.field_187136_p.nextGaussian() * radiusIn);
            double d0 = xIn - this.field_187126_f;
            double d1 = yIn - this.field_187127_g;
            double d2 = zIn - this.field_187128_h;
            this.field_70547_e = (int)(Math.random() * 10.0) + 50;
            this.field_187129_i = d0 / (double)this.field_70547_e;
            this.field_187130_j = d1 / (double)this.field_70547_e;
            this.field_187131_k = d2 / (double)this.field_70547_e;
            if (scaleIn != 0.0f) {
                this.field_70544_f *= scaleIn;
            }
            this.func_70536_a(this.field_187136_p.nextBoolean() ? 49 : 97);
        }

        public void func_187110_a(double x, double y, double z) {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
            this.func_187118_j();
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            if (this.field_70546_d++ >= this.field_70547_e) {
                this.func_187112_i();
            }
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        }

        public int func_189214_a(float p_189214_1_) {
            return 0xF000F0;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                float arg1 = parameters.length > 1 ? (float)parameters[1] / 10.0f : 0.0f;
                double arg0 = parameters.length > 0 ? (double)parameters[0] : 0.0;
                return new HomingOrb(worldIn, xCoordIn, yCoordIn, zCoordIn, arg0, arg1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class MobAppearance
    extends Particle {
        private static final Map<Integer, Class<? extends Entity>> particleEntities = ImmutableMap.of((Object)118, EntityItachi.Entity4MobAppearance.class);
        private Entity entity;
        private int entityTypeId;

        protected MobAppearance(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, int id) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
            this.field_70552_h = 1.0f;
            this.field_70553_i = 1.0f;
            this.field_70551_j = 1.0f;
            this.field_187129_i = 0.0;
            this.field_187130_j = 0.0;
            this.field_187131_k = 0.0;
            this.field_70545_g = 0.0f;
            this.field_70547_e = 30;
            this.entityTypeId = id;
            if (particleEntities.containsKey(id)) {
                try {
                    this.entity = particleEntities.get(this.entityTypeId).getConstructor(World.class).newInstance(this.field_187122_b);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unregistered custom mob appearance particle type " + this.entityTypeId, e);
                }
            }
        }

        public int func_70537_b() {
            return 3;
        }

        public void func_189213_a() {
            Entity entity1;
            super.func_189213_a();
            if (this.entity == null && (entity1 = this.field_187122_b.func_73045_a(this.entityTypeId)) instanceof EntityPlayer) {
                this.entity = entity1;
            }
        }

        public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            if (this.entity != null) {
                RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
                rendermanager.func_178628_a(Particle.field_70556_an, Particle.field_70554_ao, Particle.field_70555_ap);
                float f1 = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179147_l();
                GlStateManager.func_179126_j();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GlStateManager.func_179094_E();
                float f3 = 0.05f + 0.5f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f3);
                GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
                GlStateManager.func_179114_b((float)(180.0f - entityIn.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
                float f4 = 1.0f + f1 * 1.5f;
                GlStateManager.func_179109_b((float)0.0f, (float)(-f4 * 1.5f), (float)-1.5f);
                GlStateManager.func_179152_a((float)f4, (float)f4, (float)f4);
                float f5 = this.entity.field_70177_z;
                float f6 = this.entity.field_70126_B;
                float f7 = 0.0f;
                float f8 = 0.0f;
                this.entity.field_70177_z = 0.0f;
                this.entity.field_70126_B = 0.0f;
                if (this.entity instanceof EntityLivingBase) {
                    f7 = ((EntityLivingBase)this.entity).field_70759_as;
                    f8 = ((EntityLivingBase)this.entity).field_70758_at;
                    ((EntityLivingBase)this.entity).field_70759_as = 0.0f;
                    ((EntityLivingBase)this.entity).field_70758_at = 0.0f;
                }
                rendermanager.func_188391_a(this.entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, false);
                this.entity.field_70177_z = f5;
                this.entity.field_70126_B = f6;
                if (this.entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)this.entity).field_70759_as = f7;
                    ((EntityLivingBase)this.entity).field_70758_at = f8;
                }
                GlStateManager.func_179121_F();
                GlStateManager.func_179126_j();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                int arg0 = parameters.length > 0 ? parameters[0] : 117;
                return new MobAppearance(worldIn, xCoordIn, yCoordIn, zCoordIn, arg0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Flame
    extends Particle {
        private static final ResourceLocation TEXTURE = new ResourceLocation("narutomod:textures/particles.png");
        private final TextureManager textureManager;
        private final float flameScale;

        protected Flame(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int color, float scale) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
            this.field_187129_i = this.field_187129_i * (double)0.01f + xSpeedIn;
            this.field_187130_j = this.field_187130_j * (double)0.01f + ySpeedIn;
            this.field_187131_k = this.field_187131_k * (double)0.01f + zSpeedIn;
            this.field_187126_f += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
            this.field_187127_g += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
            this.field_187128_h += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f);
            this.flameScale = this.field_70544_f * scale;
            this.field_82339_as = (float)(color >> 24 & 0xFF) / 255.0f;
            this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(color & 0xFF) / 255.0f;
            float f = (this.field_187136_p.nextFloat() - 0.5f) * 0.1f;
            if (this.field_70552_h + f >= 0.0f && this.field_70552_h + f <= 1.0f) {
                this.field_70552_h += f;
            }
            if (this.field_70553_i + f >= 0.0f && this.field_70553_i + f <= 1.0f) {
                this.field_70553_i += f;
            }
            if (this.field_70551_j + f >= 0.0f && this.field_70551_j + f <= 1.0f) {
                this.field_70551_j += f;
            }
            this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 4;
            this.field_94055_c = 1;
            this.textureManager = Minecraft.func_71410_x().func_110434_K();
        }

        public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            this.textureManager.func_110577_a(TEXTURE);
            float f = Math.min(((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e, 1.0f);
            float f11 = f - 0.5f;
            float f8 = 1.0f - f11 * f11 * 3.5f;
            this.field_70544_f = this.flameScale * f8;
            float f0 = (float)this.field_94054_b / 8.0f;
            float f1 = f0 + 0.124875f;
            float f2 = (float)this.field_94055_c / 8.0f;
            float f3 = f2 + 0.124875f;
            float f4 = 0.1f * this.field_70544_f;
            float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            float f9 = this.field_82339_as * f8;
            float f10 = this.field_70553_i * (1.0f - f);
            int j = 240;
            int k = 240;
            Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
            buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, f10, this.field_70551_j, f9).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, f10, this.field_70551_j, f9).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)f0, (double)f2).func_181666_a(this.field_70552_h, f10, this.field_70551_j, f9).func_187314_a(j, k).func_181675_d();
            buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)f0, (double)f3).func_181666_a(this.field_70552_h, f10, this.field_70551_j, f9).func_187314_a(j, k).func_181675_d();
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            if (this.field_70546_d++ >= this.field_70547_e) {
                this.func_187112_i();
            }
            this.field_94054_b = this.field_70546_d / 2 % 8;
            this.field_187130_j += 0.003;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= (double)0.96f;
            this.field_187130_j *= (double)0.96f;
            this.field_187131_k *= (double)0.96f;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }

        public boolean func_187111_c() {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                float arg1 = parameters.length > 1 ? (float)parameters[1] / 10.0f : 1.0f;
                int arg0 = parameters.length > 0 ? parameters[0] : -1;
                return new Flame(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, arg0, arg1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class FallingDust
    extends ParticleSimpleAnimated {
        public FallingDust(World world, double x, double y, double z, double xMotion, double yMotion, double zMotion, int color) {
            super(world, x, y, z, 176, 4, -0.025f);
            this.field_187129_i = xMotion;
            this.field_187130_j = yMotion;
            this.field_187131_k = zMotion;
            this.field_82339_as = (float)(color >> 24 & 0xFF) / 255.0f;
            this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(color & 0xFF) / 255.0f;
            float f = (this.field_187136_p.nextFloat() - 0.5f) * 0.1f;
            if (this.field_70552_h + f >= 0.0f && this.field_70552_h + f <= 1.0f) {
                this.field_70552_h += f;
            }
            if (this.field_70553_i + f >= 0.0f && this.field_70553_i + f <= 1.0f) {
                this.field_70553_i += f;
            }
            if (this.field_70551_j + f >= 0.0f && this.field_70551_j + f <= 1.0f) {
                this.field_70551_j += f;
            }
            this.field_70544_f *= 0.75f;
            this.field_70547_e = 60 + this.field_187136_p.nextInt(12);
            this.func_191238_f(0.2f);
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                int arg0 = parameters.length > 0 ? parameters[0] : -1;
                return new FallingDust(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, arg0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Suspend
    extends Particle {
        protected Suspend(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int color, float scale, int age) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn);
            this.field_82339_as = (float)(color >> 24 & 0xFF) / 255.0f;
            this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(color & 0xFF) / 255.0f;
            float f = (this.field_187136_p.nextFloat() - 0.5f) * 0.1f;
            if (this.field_70552_h + f >= 0.0f && this.field_70552_h + f <= 1.0f) {
                this.field_70552_h += f;
            }
            if (this.field_70553_i + f >= 0.0f && this.field_70553_i + f <= 1.0f) {
                this.field_70553_i += f;
            }
            if (this.field_70551_j + f >= 0.0f && this.field_70551_j + f <= 1.0f) {
                this.field_70551_j += f;
            }
            this.func_70536_a(0);
            this.func_187115_a(0.02f * scale, 0.02f * scale);
            this.field_70544_f *= scale * (this.field_187136_p.nextFloat() * 0.6f + 0.5f);
            this.field_187129_i *= (double)0.02f;
            this.field_187130_j *= (double)0.02f;
            this.field_187131_k *= (double)0.02f;
            this.field_187129_i += xSpeedIn;
            this.field_187130_j += ySpeedIn;
            this.field_187131_k += zSpeedIn;
            this.field_70547_e = age > 0 ? (int)((this.field_187136_p.nextFloat() * 0.4f + 0.8f) * (float)age) : (int)(20.0 / (this.field_187136_p.nextDouble() * 0.8 + 0.2));
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= 0.8;
            this.field_187130_j *= 0.8;
            this.field_187131_k *= 0.8;
            if (this.field_70547_e-- <= 0) {
                this.func_187112_i();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                int arg2 = parameters.length > 2 ? parameters[2] : 0;
                float arg1 = parameters.length > 1 ? (float)parameters[1] / 10.0f : 1.0f;
                int arg0 = parameters.length > 0 ? parameters[0] : -1;
                return new Suspend(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, arg0, arg1, arg2);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Smoke
    extends Particle {
        private static final ResourceLocation TEXTURE = new ResourceLocation("narutomod:textures/particles.png");
        protected final TextureManager textureManager;
        protected float smokeParticleScale;
        private int particleBrightness;
        protected double floatMotionY;
        private int viewerId;

        protected Smoke(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double motionX, double motionY, double motionZ, int color, float scale, int maxAge, int brightness, int playerId, double floatSpeed) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
            this.field_94055_c = 2;
            this.textureManager = Minecraft.func_71410_x().func_110434_K();
            this.field_187129_i *= 0.1;
            this.field_187130_j *= 0.1;
            this.field_187131_k *= 0.1;
            this.field_187129_i += motionX;
            this.field_187130_j += motionY;
            this.field_187131_k += motionZ;
            this.field_82339_as = (float)(color >> 24 & 0xFF) / 255.0f;
            this.field_70552_h = (float)(color >> 16 & 0xFF) / 255.0f;
            this.field_70553_i = (float)(color >> 8 & 0xFF) / 255.0f;
            this.field_70551_j = (float)(color & 0xFF) / 255.0f;
            float f = (this.field_187136_p.nextFloat() - 0.5f) * 0.1f;
            if (this.field_70552_h + f >= 0.0f && this.field_70552_h + f <= 1.0f) {
                this.field_70552_h += f;
            }
            if (this.field_70553_i + f >= 0.0f && this.field_70553_i + f <= 1.0f) {
                this.field_70553_i += f;
            }
            if (this.field_70551_j + f >= 0.0f && this.field_70551_j + f <= 1.0f) {
                this.field_70551_j += f;
            }
            this.field_70544_f *= 0.75f;
            this.field_70544_f *= scale;
            this.smokeParticleScale = this.field_70544_f;
            if (maxAge > 0) {
                this.field_70547_e = maxAge;
            } else {
                this.field_70547_e = (int)(8.0 / (this.field_187136_p.nextDouble() * 0.8 + 0.2));
                this.field_70547_e = (int)((float)this.field_70547_e * scale);
            }
            if (brightness != 0) {
                this.particleBrightness = brightness;
            }
            this.floatMotionY = floatSpeed;
            this.viewerId = playerId >= 0 ? playerId : -1;
        }

        public int func_189214_a(float p_189214_1_) {
            return this.particleBrightness != 0 ? this.particleBrightness << 16 | this.particleBrightness : super.func_189214_a(p_189214_1_);
        }

        public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            if (entityIn.func_145782_y() != this.viewerId || Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
                float f = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
                this.field_70544_f = this.smokeParticleScale * MathHelper.func_76131_a((float)(f * 32.0f), (float)0.0f, (float)1.0f);
                this.textureManager.func_110577_a(TEXTURE);
                float f0 = (float)this.field_94054_b / 8.0f;
                float f1 = f0 + 0.124875f;
                float f2 = (float)this.field_94055_c / 8.0f;
                float f3 = f2 + 0.124875f;
                float f4 = 0.1f * this.field_70544_f;
                float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
                float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
                float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
                float f8 = this.field_82339_as * (1.0f - f * f * 0.5f);
                int i = this.func_189214_a(partialTicks);
                int j = i >> 16 & 0xFFFF;
                int k = i & 0xFFFF;
                Vec3d[] avec3d = new Vec3d[]{new Vec3d((double)(-rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(-rotationYZ * f4 - rotationXZ * f4)), new Vec3d((double)(-rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(-rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 + rotationXY * f4), (double)(rotationZ * f4), (double)(rotationYZ * f4 + rotationXZ * f4)), new Vec3d((double)(rotationX * f4 - rotationXY * f4), (double)(-rotationZ * f4), (double)(rotationYZ * f4 - rotationXZ * f4))};
                buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a((double)f1, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f8).func_187314_a(j, k).func_181675_d();
                buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a((double)f1, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f8).func_187314_a(j, k).func_181675_d();
                buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a((double)f0, (double)f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f8).func_187314_a(j, k).func_181675_d();
                buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a((double)f0, (double)f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, f8).func_187314_a(j, k).func_181675_d();
            }
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            if (this.field_70547_e == 0 || this.field_70546_d++ >= this.field_70547_e) {
                this.func_187112_i();
                return;
            }
            this.field_94054_b = MathHelper.func_76125_a((int)(7 - this.field_70546_d * 8 / this.field_70547_e), (int)0, (int)7);
            this.field_187130_j += this.floatMotionY;
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            if (this.field_187127_g == this.field_187124_d) {
                this.field_187129_i *= 1.1;
                this.field_187131_k *= 1.1;
            }
            this.field_187129_i *= (double)0.96f;
            this.field_187130_j *= (double)0.96f;
            this.field_187131_k *= (double)0.96f;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }

        public boolean func_187111_c() {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public static class Factory
        implements IParticleFactory {
            public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... parameters) {
                double arg5 = parameters.length > 5 ? (double)parameters[5] / 1000.0 : 0.004;
                int arg4 = parameters.length > 4 ? parameters[4] : -1;
                int arg3 = parameters.length > 3 ? parameters[3] : 0;
                int arg2 = parameters.length > 2 ? parameters[2] : 0;
                float arg1 = parameters.length > 1 ? (float)parameters[1] / 10.0f : 1.0f;
                int arg0 = parameters.length > 0 ? parameters[0] : -1;
                return new Smoke(worldIn, xCoordIn, yCoordIn, zCoordIn, xSpeedIn, ySpeedIn, zSpeedIn, arg0, arg1, arg2, arg3, arg4, arg5);
            }
        }
    }

    public static class Renderer
    extends ParticleRenderer {
        public Renderer() {
        }

        public Renderer(World worldIn) {
            this(worldIn, 64.0);
        }

        public Renderer(World worldIn, double renderDistanceIn) {
            super(worldIn, renderDistanceIn);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void spawnParticles(Types type, double x, double y, double z, int count, double xOff, double yOff, double zOff, double xSpeed, double ySpeed, double zSpeed, int ... args) {
            if (this.world instanceof WorldServer) {
                super.spawnParticles(type, x, y, z, count, xOff, yOff, zOff, xSpeed, ySpeed, zSpeed, args);
            } else {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.func_175606_aa() != null && mc.field_71452_i != null) {
                    for (int i = 0; i < count; ++i) {
                        double d1 = rand.nextGaussian() * xOff;
                        double d2 = rand.nextGaussian() * yOff;
                        double d3 = rand.nextGaussian() * zOff;
                        if (count > 5) {
                            xSpeed *= rand.nextDouble() * 0.3 + 0.85;
                            ySpeed *= rand.nextDouble() * 0.3 + 0.85;
                            zSpeed *= rand.nextDouble() * 0.3 + 0.85;
                        }
                        mc.field_71452_i.func_178927_a(type.getID(), x + d1, y + d2, z + d3, xSpeed, ySpeed, zSpeed, args);
                    }
                }
            }
        }
    }

    public static abstract class ParticleRenderer {
        private final List<MessageContents> msgQueue = Lists.newArrayList();
        protected final World world;
        protected final double renderDistance;

        public ParticleRenderer() {
            this(null, 64.0);
        }

        public ParticleRenderer(World worldIn, double renderDistanceIn) {
            this.world = worldIn;
            this.renderDistance = renderDistanceIn;
        }

        public void spawnParticles(Types type, double x, double y, double z, int count, double xOff, double yOff, double zOff, double xSpeed, double ySpeed, double zSpeed, int ... args) {
            this.msgQueue.add(new MessageContents(type, x, y, z, count, xOff, yOff, zOff, xSpeed, ySpeed, zSpeed, args));
        }

        public void send() {
            if (this.world instanceof WorldServer && !this.msgQueue.isEmpty()) {
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                for (MessageContents msgc : this.msgQueue) {
                    x += msgc.x;
                    y += msgc.y;
                    z += msgc.z;
                }
                NarutomodMod.PACKET_HANDLER.sendToAllAround((IMessage)new Message(this.msgQueue), new NetworkRegistry.TargetPoint(this.world.field_73011_w.getDimension(), x /= (double)this.msgQueue.size(), y /= (double)this.msgQueue.size(), z /= (double)this.msgQueue.size(), this.renderDistance));
            }
        }

        public static class Message
        implements IMessage {
            List<MessageContents> list;

            public Message() {
            }

            public Message(MessageContents msgcontents) {
                this.list = Lists.newArrayList((Object[])new MessageContents[]{msgcontents});
            }

            public Message(List<MessageContents> listIn) {
                this.list = listIn;
            }

            public void toBytes(ByteBuf buf) {
                buf.writeInt(this.list.size());
                for (MessageContents msg : this.list) {
                    msg.toBytes(buf);
                }
            }

            public void fromBytes(ByteBuf buf) {
                int j = buf.readInt();
                this.list = Lists.newArrayList();
                for (int i = 0; i < j; ++i) {
                    this.list.add(new MessageContents(buf));
                }
            }

            public static class Handler
            implements IMessageHandler<Message, IMessage> {
                @SideOnly(value=Side.CLIENT)
                public IMessage onMessage(Message message, MessageContext context) {
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        Renderer render = new Renderer();
                        for (MessageContents msgc : message.list) {
                            render.spawnParticles(msgc.type, msgc.x, msgc.y, msgc.z, msgc.count, msgc.ox, msgc.oy, msgc.oz, msgc.speedx, msgc.speedy, msgc.speedz, msgc.parms);
                        }
                    });
                    return null;
                }
            }
        }

        public static class MessageContents {
            Types type;
            int count;
            double x;
            double y;
            double z;
            double ox;
            double oy;
            double oz;
            double speedx;
            double speedy;
            double speedz;
            int args;
            int[] parms;

            public MessageContents(Types typeIn, double xIn, double yIn, double zIn, int countIn, double xOff, double yOff, double zOff, double xSpeed, double ySpeed, double zSpeed, int ... argsIn) {
                this.type = typeIn;
                this.count = countIn;
                this.x = xIn;
                this.y = yIn;
                this.z = zIn;
                this.ox = xOff;
                this.oy = yOff;
                this.oz = zOff;
                this.speedx = xSpeed;
                this.speedy = ySpeed;
                this.speedz = zSpeed;
                this.args = argsIn.length;
                this.parms = argsIn;
            }

            public MessageContents(ByteBuf buf) {
                this.fromBytes(buf);
            }

            public void toBytes(ByteBuf buf) {
                buf.writeInt(this.type.getID());
                buf.writeInt(this.count);
                buf.writeDouble(this.x);
                buf.writeDouble(this.y);
                buf.writeDouble(this.z);
                buf.writeDouble(this.ox);
                buf.writeDouble(this.oy);
                buf.writeDouble(this.oz);
                buf.writeDouble(this.speedx);
                buf.writeDouble(this.speedy);
                buf.writeDouble(this.speedz);
                buf.writeInt(this.args);
                for (int j = 0; j < this.type.getArgsCount() && j < this.args; ++j) {
                    buf.writeInt(this.parms[j]);
                }
            }

            public void fromBytes(ByteBuf buf) {
                this.type = Types.getTypeFromId(buf.readInt());
                this.count = buf.readInt();
                this.x = buf.readDouble();
                this.y = buf.readDouble();
                this.z = buf.readDouble();
                this.ox = buf.readDouble();
                this.oy = buf.readDouble();
                this.oz = buf.readDouble();
                this.speedx = buf.readDouble();
                this.speedy = buf.readDouble();
                this.speedz = buf.readDouble();
                this.args = buf.readInt();
                int i = Math.min(this.type.getArgsCount(), this.args);
                this.parms = new int[i];
                for (int j = 0; j < i; ++j) {
                    this.parms[j] = buf.readInt();
                }
            }

            public String toString() {
                String s = "";
                for (int i = 0; i < this.parms.length; ++i) {
                    s = s + this.parms[i] + ", ";
                }
                return "" + (Object)((Object)this.type) + ", " + this.count + ", (" + this.x + ", " + this.y + ", " + this.z + "), (" + this.ox + ", " + this.oy + ", " + this.oz + "), (" + this.speedx + ", " + this.speedy + ", " + this.speedz + "), " + s;
            }
        }
    }
}

