/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.procedure.ProcedureUtils;
import org.lwjgl.input.Mouse;

@ElementsNarutomodMod.ModElement.Tag
public class PlayerInput
extends ElementsNarutomodMod.ModElement {
    private static final Hook INPUTHOOK = new Hook();

    public PlayerInput(ElementsNarutomodMod instance) {
        super(instance, 611);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(Hook.MovementPacket.ServerHandler.class, Hook.MovementPacket.class, Side.SERVER);
        this.elements.addNetworkMessage(Hook.MovementPacket.ClientHandler.class, Hook.MovementPacket.class, Side.CLIENT);
        this.elements.addNetworkMessage(Hook.MousePacket.ServerHandler.class, Hook.MousePacket.class, Side.SERVER);
        this.elements.addNetworkMessage(Hook.MousePacket.ClientHandler.class, Hook.MousePacket.class, Side.CLIENT);
        this.elements.addNetworkMessage(Hook.CopyInput.ClientHandler.class, Hook.CopyInput.class, Side.CLIENT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)INPUTHOOK);
    }

    public static class Hook {
        private List<Integer> handlerList = Lists.newArrayList();
        private boolean haltAllInput;
        private boolean newMovementInput;
        private float strafe;
        private float forward;
        private boolean forwardKeyDown;
        private boolean backKeyDown;
        private boolean leftKeyDown;
        private boolean rightKeyDown;
        private boolean jump;
        private boolean sneak;
        private boolean newMouseEvent;
        private float mouseSensitivity;
        private int dx;
        private int dy;
        private boolean attackPressed;
        private boolean useItemPressed;

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onMovementInput(InputUpdateEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (!this.handlerList.isEmpty()) {
                MovementInput mi = player.field_71158_b;
                Iterator<Integer> iter = this.handlerList.iterator();
                while (iter.hasNext()) {
                    Entity entity = mc.field_71441_e.func_73045_a(iter.next().intValue());
                    if (entity instanceof IHandler) {
                        MovementPacket.sendToServer(entity, mi.field_78902_a, mi.field_192832_b, mi.field_187255_c, mi.field_187256_d, mi.field_187257_e, mi.field_187258_f, mi.field_78901_c, mi.field_78899_d);
                        continue;
                    }
                    iter.remove();
                }
            } else {
                if (this.newMovementInput) {
                    this.newMovementInput = false;
                    player.field_71158_b.field_78902_a = this.strafe;
                    player.field_71158_b.field_192832_b = this.forward;
                    player.field_71158_b.field_187255_c = this.forwardKeyDown;
                    player.field_71158_b.field_187256_d = this.backKeyDown;
                    player.field_71158_b.field_187257_e = this.leftKeyDown;
                    player.field_71158_b.field_187258_f = this.rightKeyDown;
                    player.field_71158_b.field_78901_c = this.jump;
                    player.field_71158_b.field_78899_d = this.sneak;
                }
                if (this.newMouseEvent) {
                    this.newMouseEvent = false;
                    float f = mc.field_71474_y.field_74341_c * 1.2f + 0.4f;
                    float f1 = f * f * f * 8.0f;
                    float f2 = (float)this.dx * f1;
                    float f3 = (float)this.dy * f1;
                    player.func_70082_c(f2, f3 * (mc.field_71474_y.field_74338_d ? -1.0f : 1.0f));
                    if (this.attackPressed) {
                        this.simulateLeftMouseClick();
                    }
                    if (this.useItemPressed) {
                        this.simulateRightMouseClick();
                    } else if (player.func_184587_cr()) {
                        mc.field_71442_b.func_78766_c((EntityPlayer)player);
                    }
                }
            }
        }

        public void handleMovement(EntityLivingBase entity) {
            this.clearMovementInput();
            if (entity instanceof EntityPlayerMP) {
                MovementPacket.sendToClient((EntityPlayerMP)entity, this.strafe, this.forward, this.forwardKeyDown, this.backKeyDown, this.leftKeyDown, this.rightKeyDown, this.jump, this.sneak);
            } else {
                if (this.jump && entity.field_70122_E) {
                    entity.field_70181_x = 0.42;
                    entity.field_70160_al = true;
                }
                entity.func_191958_b(this.strafe, 0.0f, this.forward, 0.2f);
                entity.func_70091_d(MoverType.SELF, entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
                if (!entity.func_189652_ae()) {
                    entity.field_70181_x += -0.08;
                }
                entity.field_70159_w *= 0.1;
                entity.field_70179_y *= 0.1;
                entity.field_70181_x *= 0.98;
                entity.func_70095_a(this.sneak);
            }
        }

        public void handleMouseEvent(EntityLivingBase entity) {
            this.clearMouseEvent();
            if (entity instanceof EntityPlayerMP) {
                MousePacket.sendToClient((EntityPlayerMP)entity, this.dx, this.dy, this.attackPressed, this.useItemPressed);
            } else {
                float f1 = this.mouseSensitivity > 0.0f ? this.mouseSensitivity * 20.0f : 6.0f;
                float f2 = (float)this.dx * f1;
                float f3 = (float)this.dy * f1;
                entity.field_70177_z = entity.field_70759_as = (float)((double)entity.field_70759_as + (double)f2 * 0.15);
                entity.field_70125_A = (float)((double)entity.field_70125_A - (double)f3 * 0.15);
                entity.field_70125_A = MathHelper.func_76131_a((float)entity.field_70125_A, (float)-90.0f, (float)90.0f);
                if (this.attackPressed) {
                    entity.func_184609_a(EnumHand.MAIN_HAND);
                    RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 3.0);
                    if (res.field_72308_g != null) {
                        entity.func_70652_k(res.field_72308_g);
                    }
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onMouseInput(InputEvent.MouseInputEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP player = mc.field_71439_g;
            if (!this.handlerList.isEmpty()) {
                Iterator<Integer> iter = this.handlerList.iterator();
                while (iter.hasNext()) {
                    Entity entity = mc.field_71441_e.func_73045_a(iter.next().intValue());
                    if (entity instanceof IHandler) {
                        MousePacket.sendToServer(entity, Mouse.getEventDX(), Mouse.getEventDY(), mc.field_71474_y.field_74341_c, mc.field_71474_y.field_74312_F.func_151468_f(), mc.field_71474_y.field_74313_G.func_151468_f());
                        continue;
                    }
                    iter.remove();
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void simulateLeftMouseClick() {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71476_x != null && !mc.field_71439_g.func_184838_M()) {
                if (mc.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY) {
                    mc.field_71442_b.func_78764_a((EntityPlayer)mc.field_71439_g, mc.field_71476_x.field_72308_g);
                } else {
                    mc.field_71439_g.func_184821_cY();
                }
                mc.field_71439_g.func_184609_a(EnumHand.MAIN_HAND);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void simulateRightMouseClick() {
            Minecraft mc = Minecraft.func_71410_x();
            if (!mc.field_71442_b.func_181040_m() && !mc.field_71439_g.func_184838_M()) {
                for (EnumHand enumhand : EnumHand.values()) {
                    ItemStack itemstack = mc.field_71439_g.func_184586_b(enumhand);
                    if (mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY && (mc.field_71442_b.func_187102_a((EntityPlayer)mc.field_71439_g, mc.field_71476_x.field_72308_g, mc.field_71476_x, enumhand) == EnumActionResult.SUCCESS || mc.field_71442_b.func_187097_a((EntityPlayer)mc.field_71439_g, mc.field_71476_x.field_72308_g, enumhand) == EnumActionResult.SUCCESS)) {
                        return;
                    }
                    if (itemstack.func_190926_b() || mc.field_71442_b.func_187101_a((EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e, enumhand) != EnumActionResult.SUCCESS) continue;
                    mc.field_71460_t.field_78516_c.func_187460_a(enumhand);
                    return;
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onTickPre(TickEvent.ClientTickEvent event) {
            if (this.haltAllInput && event.phase == TickEvent.Phase.START) {
                Minecraft mc = Minecraft.func_71410_x();
                if (!(mc.field_71462_r instanceof GuiChat)) {
                    mc.func_147108_a((GuiScreen)new GuiChat());
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onGuiOpen(GuiOpenEvent event) {
            if (this.haltAllInput && !(event.getGui() instanceof GuiChat)) {
                event.setCanceled(true);
            }
        }

        public static void copyInputFrom(EntityPlayerMP sourcePlayer, IHandler handlerEntity, boolean copy) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new CopyInput(handlerEntity instanceof Entity ? ((Entity)handlerEntity).func_145782_y() : 0, copy), sourcePlayer);
        }

        public static void haltTargetInput(EntityLivingBase target, boolean halt) {
            if (target instanceof EntityPlayerMP) {
                NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new CopyInput(-1, halt), (EntityPlayerMP)target);
            } else if (target instanceof EntityLiving) {
                ((EntityLiving)target).func_94061_f(halt);
            }
        }

        public void copyMovementInput(MovementPacket packet) {
            this.strafe = packet.moveStrafe;
            this.forward = packet.moveForward;
            this.forwardKeyDown = packet.forwardKeyDown;
            this.backKeyDown = packet.backKeyDown;
            this.leftKeyDown = packet.leftKeyDown;
            this.rightKeyDown = packet.rightKeyDown;
            this.jump = packet.jump;
            this.sneak = packet.sneak;
            this.newMovementInput = true;
        }

        public void copyMouseInput(MousePacket packet) {
            this.dx = packet.dx;
            this.dy = packet.dy;
            this.mouseSensitivity = packet.sensitivity;
            this.attackPressed = packet.attackPressed;
            this.useItemPressed = packet.useItemPressed;
            this.newMouseEvent = true;
        }

        public boolean isInputHalted() {
            return this.haltAllInput;
        }

        public boolean hasNewMovementInput() {
            return this.newMovementInput;
        }

        public void clearMovementInput() {
            this.newMovementInput = false;
        }

        public float getStrafe() {
            return this.strafe;
        }

        public float getForward() {
            return this.forward;
        }

        public boolean isForwardKeyDown() {
            return this.forwardKeyDown;
        }

        public boolean isBackKeyDown() {
            return this.backKeyDown;
        }

        public boolean isLeftKeyDown() {
            return this.leftKeyDown;
        }

        public boolean isRightKeyDown() {
            return this.rightKeyDown;
        }

        public boolean isJumpKeyDown() {
            return this.jump;
        }

        public boolean isSneakKeyDown() {
            return this.sneak;
        }

        public boolean hasNewMouseEvent() {
            return this.newMouseEvent;
        }

        public void clearMouseEvent() {
            this.newMouseEvent = false;
        }

        public int getDX() {
            return this.dx;
        }

        public int getDY() {
            return this.dy;
        }

        public boolean isAttackPressed() {
            return this.attackPressed;
        }

        public boolean isUseItemPressed() {
            return this.useItemPressed;
        }

        public String movementPacketToString() {
            return "strafe:" + this.strafe + ", forward=" + this.forward + ", forwardKeyDown:" + this.forwardKeyDown + ", backKeyDown:" + this.backKeyDown + ", leftKeyDown:" + this.leftKeyDown + ", rightKeyDown:" + this.rightKeyDown + ", jump:" + this.jump + ", sneak:" + this.sneak;
        }

        public String mousePacketToString() {
            return "dx=" + this.dx + ", dy=" + this.dy + ", attackPressed:" + this.attackPressed + ", useItemPressed:" + this.useItemPressed;
        }

        public static interface IHandler {
            public void handlePacket(@Nullable MovementPacket var1, @Nullable MousePacket var2);
        }

        public static class MousePacket
        implements IMessage {
            int id;
            int dx;
            int dy;
            float sensitivity;
            boolean attackPressed;
            boolean useItemPressed;

            public MousePacket() {
            }

            public MousePacket(int eid, int i1, int i2, float f1, boolean b1, boolean b2) {
                this.id = eid;
                this.dx = i1;
                this.dy = i2;
                this.sensitivity = f1;
                this.attackPressed = b1;
                this.useItemPressed = b2;
            }

            public static void sendToClient(EntityPlayerMP target, int x, int y, boolean ap, boolean uip) {
                NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new MousePacket(0, x, y, 0.0f, ap, uip), target);
            }

            public static void sendToServer(Entity entity, int x, int y, float f, boolean ap, boolean uip) {
                NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new MousePacket(entity.func_145782_y(), x, y, f, ap, uip));
            }

            public void toBytes(ByteBuf buf) {
                buf.writeInt(this.id);
                buf.writeInt(this.dx);
                buf.writeInt(this.dy);
                buf.writeFloat(this.sensitivity);
                buf.writeBoolean(this.attackPressed);
                buf.writeBoolean(this.useItemPressed);
            }

            public void fromBytes(ByteBuf buf) {
                this.id = buf.readInt();
                this.dx = buf.readInt();
                this.dy = buf.readInt();
                this.sensitivity = buf.readFloat();
                this.attackPressed = buf.readBoolean();
                this.useItemPressed = buf.readBoolean();
            }

            public static class ServerHandler
            implements IMessageHandler<MousePacket, IMessage> {
                public IMessage onMessage(MousePacket message, MessageContext context) {
                    WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                    world.func_152344_a(() -> {
                        Entity entity = world.func_73045_a(message.id);
                        if (entity instanceof IHandler) {
                            ((IHandler)entity).handlePacket(null, message);
                        }
                    });
                    return null;
                }
            }

            public static class ClientHandler
            implements IMessageHandler<MousePacket, IMessage> {
                @SideOnly(value=Side.CLIENT)
                public IMessage onMessage(MousePacket message, MessageContext context) {
                    Minecraft mc = Minecraft.func_71410_x();
                    mc.func_152344_a(() -> {
                        if (message.id == 0) {
                            INPUTHOOK.newMouseEvent = true;
                            INPUTHOOK.dx = message.dx;
                            INPUTHOOK.dy = message.dy;
                            INPUTHOOK.attackPressed = message.attackPressed;
                            INPUTHOOK.useItemPressed = message.useItemPressed;
                        } else if (message.id == -1) {
                            INPUTHOOK.newMouseEvent = false;
                        }
                    });
                    return null;
                }
            }
        }

        public static class MovementPacket
        implements IMessage {
            int id;
            float moveStrafe;
            float moveForward;
            boolean forwardKeyDown;
            boolean backKeyDown;
            boolean leftKeyDown;
            boolean rightKeyDown;
            boolean jump;
            boolean sneak;

            public MovementPacket() {
            }

            public MovementPacket(int entityId, float f1, float f2, boolean forwardKey, boolean backKey, boolean leftKey, boolean rightKey, boolean j, boolean s) {
                this.id = entityId;
                this.moveStrafe = f1;
                this.moveForward = f2;
                this.forwardKeyDown = forwardKey;
                this.backKeyDown = backKey;
                this.leftKeyDown = leftKey;
                this.rightKeyDown = rightKey;
                this.jump = j;
                this.sneak = s;
            }

            public static void sendToServer(Entity entity, float strafe, float forward, boolean forwardKey, boolean backKey, boolean leftKey, boolean rightKey, boolean jp, boolean sn) {
                NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new MovementPacket(entity.func_145782_y(), strafe, forward, forwardKey, backKey, leftKey, rightKey, jp, sn));
            }

            public static void sendToClient(EntityPlayerMP target, float strafe, float forward, boolean forwardKey, boolean backKey, boolean leftKey, boolean rightKey, boolean jp, boolean sn) {
                NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new MovementPacket(-1, strafe, forward, forwardKey, backKey, leftKey, rightKey, jp, sn), target);
            }

            public void toBytes(ByteBuf buf) {
                buf.writeInt(this.id);
                buf.writeFloat(this.moveStrafe);
                buf.writeFloat(this.moveForward);
                buf.writeBoolean(this.forwardKeyDown);
                buf.writeBoolean(this.backKeyDown);
                buf.writeBoolean(this.leftKeyDown);
                buf.writeBoolean(this.rightKeyDown);
                buf.writeBoolean(this.jump);
                buf.writeBoolean(this.sneak);
            }

            public void fromBytes(ByteBuf buf) {
                this.id = buf.readInt();
                this.moveStrafe = buf.readFloat();
                this.moveForward = buf.readFloat();
                this.forwardKeyDown = buf.readBoolean();
                this.backKeyDown = buf.readBoolean();
                this.leftKeyDown = buf.readBoolean();
                this.rightKeyDown = buf.readBoolean();
                this.jump = buf.readBoolean();
                this.sneak = buf.readBoolean();
            }

            public static class ServerHandler
            implements IMessageHandler<MovementPacket, IMessage> {
                public IMessage onMessage(MovementPacket message, MessageContext context) {
                    WorldServer world = context.getServerHandler().field_147369_b.func_71121_q();
                    world.func_152344_a(() -> {
                        Entity entity = world.func_73045_a(message.id);
                        if (entity instanceof IHandler) {
                            ((IHandler)entity).handlePacket(message, null);
                        }
                    });
                    return null;
                }
            }

            public static class ClientHandler
            implements IMessageHandler<MovementPacket, IMessage> {
                @SideOnly(value=Side.CLIENT)
                public IMessage onMessage(MovementPacket message, MessageContext context) {
                    Minecraft mc = Minecraft.func_71410_x();
                    mc.func_152344_a(() -> {
                        INPUTHOOK.newMovementInput = true;
                        INPUTHOOK.strafe = message.moveStrafe;
                        INPUTHOOK.forward = message.moveForward;
                        INPUTHOOK.forwardKeyDown = message.forwardKeyDown;
                        INPUTHOOK.backKeyDown = message.backKeyDown;
                        INPUTHOOK.leftKeyDown = message.leftKeyDown;
                        INPUTHOOK.rightKeyDown = message.rightKeyDown;
                        INPUTHOOK.jump = message.jump;
                        INPUTHOOK.sneak = message.sneak;
                    });
                    return null;
                }
            }
        }

        public static class CopyInput
        implements IMessage {
            int handler;
            boolean flag;

            public CopyInput() {
            }

            public CopyInput(int handlerId, boolean b) {
                this.handler = handlerId;
                this.flag = b;
            }

            public void toBytes(ByteBuf buf) {
                buf.writeInt(this.handler);
                buf.writeBoolean(this.flag);
            }

            public void fromBytes(ByteBuf buf) {
                this.handler = buf.readInt();
                this.flag = buf.readBoolean();
            }

            public static class ClientHandler
            implements IMessageHandler<CopyInput, IMessage> {
                @SideOnly(value=Side.CLIENT)
                public IMessage onMessage(CopyInput message, MessageContext context) {
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        switch (message.handler) {
                            case -1: {
                                INPUTHOOK.haltAllInput = message.flag;
                                break;
                            }
                            case 0: {
                                INPUTHOOK.handlerList.clear();
                                break;
                            }
                            default: {
                                if (message.flag) {
                                    INPUTHOOK.handlerList.add(message.handler);
                                    break;
                                }
                                INPUTHOOK.handlerList.remove((Object)message.handler);
                            }
                        }
                    });
                    return null;
                }
            }
        }
    }
}

