/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.ModConfig;
import net.narutomod.item.ItemBijuCloak;
import net.narutomod.item.ItemOnBody;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class PlayerRender
extends ElementsNarutomodMod.ModElement {
    private static PlayerRender INSTANCE;
    private static final String CLONETARGETID = "SkinCloningTargetId";
    private static final String CLONETARGETLAYERS = "SkinCloningRenderTargetLayers";
    private static final String PLAYERTRANSPARENT = "PlayerRenderTransparent";
    private static final String COLORMULTIPLIER = "SkinColorMultiplier";
    private RenderPlayer playerRenderer;

    public PlayerRender(ElementsNarutomodMod instance) {
        super(instance, 608);
        INSTANCE = this;
    }

    public static PlayerRender getInstance() {
        return INSTANCE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void init(FMLInitializationEvent event) {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        this.playerRenderer = new Renderer(renderManager);
        try {
            Field renderer;
            Field skinMap = ProcedureUtils.getFieldByIndex(renderManager.getClass(), RenderManager.class, 1);
            if (skinMap.getType() == Map.class) {
                Map map = (Map)skinMap.get(renderManager);
                map.put("default", this.playerRenderer);
                map.put("slim", new Renderer(renderManager, true));
            }
            if ((renderer = ProcedureUtils.getFieldByIndex(renderManager.getClass(), RenderManager.class, 2)).getType() == RenderPlayer.class) {
                renderer.set(renderManager, this.playerRenderer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("RenderManager hook");
        }
    }

    public static void setSkinCloneTarget(EntityPlayer entity, @Nullable EntityPlayer target) {
        PlayerRender.setSkinCloneTarget(entity, target, true);
    }

    public static void setSkinCloneTarget(EntityPlayer entity, @Nullable EntityPlayer target, boolean renderLayers) {
        if (target != null) {
            ProcedureSync.EntityNBTTag.setAndSync((Entity)entity, CLONETARGETID, target.func_145782_y());
            ProcedureSync.EntityNBTTag.setAndSync((Entity)entity, CLONETARGETLAYERS, renderLayers);
        } else {
            ProcedureSync.EntityNBTTag.removeAndSync((Entity)entity, CLONETARGETID);
            ProcedureSync.EntityNBTTag.removeAndSync((Entity)entity, CLONETARGETLAYERS);
        }
    }

    @Nullable
    public static boolean hasSkinCloneTarget(EntityPlayer entity) {
        return entity.getEntityData().func_74764_b(CLONETARGETID);
    }

    public static void setTransparent(EntityPlayer entity, boolean set) {
        if (set) {
            ProcedureSync.EntityNBTTag.setAndSync((Entity)entity, PLAYERTRANSPARENT, true);
        } else {
            ProcedureSync.EntityNBTTag.removeAndSync((Entity)entity, PLAYERTRANSPARENT);
        }
    }

    public static boolean isTransparent(EntityPlayer entity) {
        return entity.getEntityData().func_74767_n(PLAYERTRANSPARENT);
    }

    public static void setColorMultiplier(EntityPlayer entity, int color) {
        if ((color >> 24 & 0xFF) == 0) {
            ProcedureSync.EntityNBTTag.removeAndSync((Entity)entity, COLORMULTIPLIER);
        } else {
            ProcedureSync.EntityNBTTag.setAndSync((Entity)entity, COLORMULTIPLIER, color);
        }
    }

    public static int getColorMultiplier(EntityPlayer entity) {
        return entity.getEntityData().func_74764_b(COLORMULTIPLIER) ? entity.getEntityData().func_74762_e(COLORMULTIPLIER) : 0;
    }

    public static boolean shouldNarutoRun(Entity entity) {
        return ModConfig.NARUTO_RUN && !entity.func_184218_aH() && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75100_b) && entity.func_174791_d().func_178786_a(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U).func_189985_c() >= 0.125;
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerArmorCustom
    extends LayerBipedArmor {
        private final Renderer renderer;

        public LayerArmorCustom(Renderer rendererIn) {
            super((RenderLivingBase)rendererIn);
            this.renderer = rendererIn;
        }

        public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST);
            this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
            this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
            this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
        }

        private void renderArmorLayer(EntityLivingBase entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slotIn) {
            ItemArmor itemarmor;
            ItemStack itemstack = entityIn.func_184582_a(slotIn);
            if (itemstack.func_77973_b() instanceof ItemArmor && (itemarmor = (ItemArmor)itemstack.func_77973_b()).func_185083_B_() == slotIn) {
                ModelBiped t = (ModelBiped)this.func_188360_a(slotIn);
                t = this.getArmorModelHook(entityIn, itemstack, slotIn, t);
                ModelPlayer wearerModel = this.renderer.func_177087_b();
                t.func_178686_a((ModelBase)wearerModel);
                t.func_78086_a(entityIn, limbSwing, limbSwingAmount, partialTicks);
                this.func_188359_a(t, slotIn);
                this.renderer.func_110776_a(this.getArmorResource((Entity)entityIn, itemstack, slotIn, null));
                if (itemarmor.hasOverlay(itemstack)) {
                    int i = itemarmor.func_82814_b(itemstack);
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)1.0f);
                    this.renderArmorModel(t, (Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                    this.renderer.func_110776_a(this.getArmorResource((Entity)entityIn, itemstack, slotIn, "overlay"));
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.renderArmorModel(t, (Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                if (itemstack.func_77962_s()) {
                    LayerArmorCustom.func_188364_a((RenderLivingBase)this.renderer, (EntityLivingBase)entityIn, (ModelBase)t, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
                }
            }
        }

        private void renderArmorModel(ModelBiped model, Entity entityIn, float f0, float f1, float f2, float f3, float f4, float f5) {
            if ((model.field_178723_h.field_78806_j || model.field_178724_i.field_78806_j) && PlayerRender.shouldNarutoRun(entityIn) && model.field_78095_p == 0.0f && model.field_187076_m == ModelBiped.ArmPose.EMPTY && model.field_187075_l == ModelBiped.ArmPose.EMPTY) {
                if (model instanceof ItemBijuCloak.ModelBijuCloak) {
                    ((ItemBijuCloak.ModelBijuCloak)model).setNarutoRunPose(true);
                    model.func_78088_a(entityIn, f0, f1, f2, f3, f4, f5);
                    ((ItemBijuCloak.ModelBijuCloak)model).setNarutoRunPose(false);
                } else {
                    this.renderer.renderNarutoRun(model, entityIn, f0, f1, f2, f3, f4, f5);
                }
            } else {
                model.func_78088_a(entityIn, f0, f1, f2, f3, f4, f5);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerInventoryItem
    implements LayerRenderer<AbstractClientPlayer> {
        private final RenderPlayer playerRenderer;
        private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

        public LayerInventoryItem(RenderPlayer playerRendererIn) {
            this.playerRenderer = playerRendererIn;
        }

        public void doRenderLayer(AbstractClientPlayer entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            if (!entityIn.func_175149_v()) {
                for (int i = 0; i < entityIn.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = entityIn.field_71071_by.func_70301_a(i);
                    if (!(stack.func_77973_b() instanceof ItemOnBody.Interface)) continue;
                    ItemOnBody.Interface item = (ItemOnBody.Interface)stack.func_77973_b();
                    if (item.showSkinLayer()) {
                        this.renderSkinLayer(stack, entityIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                    }
                    if (item.showOnBody() == ItemOnBody.BodyPart.NONE || i == entityIn.field_71071_by.field_70461_c || i == 40) continue;
                    this.renderItemOnBody(stack, entityIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
                }
            }
        }

        private void renderSkinLayer(ItemStack stack, AbstractClientPlayer entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            String s;
            ModelBiped model = stack.func_77973_b().getArmorModel((EntityLivingBase)entityIn, stack, EntityEquipmentSlot.HEAD, new ModelBiped(1.0f));
            if (model != null && (s = stack.func_77973_b().getArmorTexture(stack, (Entity)entityIn, EntityEquipmentSlot.HEAD, null)) != null) {
                ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s);
                if (resourcelocation == null) {
                    resourcelocation = new ResourceLocation(s);
                    ARMOR_TEXTURE_RES_MAP.put(s, resourcelocation);
                }
                model.field_78117_n = this.playerRenderer.func_177087_b().field_78117_n;
                model.func_78086_a((EntityLivingBase)entityIn, limbSwing, limbSwingAmount, partialTicks);
                this.playerRenderer.func_110776_a(resourcelocation);
                model.func_78088_a((Entity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            }
        }

        private void renderItemOnBody(ItemStack stack, AbstractClientPlayer entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            Vec3d offset = ((ItemOnBody.Interface)stack.func_77973_b()).getOffset();
            ItemOnBody.BodyPart bodypart = ((ItemOnBody.Interface)stack.func_77973_b()).showOnBody();
            GlStateManager.func_179094_E();
            ModelPlayer model = this.playerRenderer.func_177087_b();
            if (entityIn.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            switch (bodypart) {
                case HEAD: {
                    model.field_78116_c.func_78794_c(0.0625f);
                    break;
                }
                case TORSO: {
                    model.field_78115_e.func_78794_c(0.0625f);
                    break;
                }
                case RIGHT_ARM: {
                    model.field_178723_h.func_78794_c(0.0625f);
                    break;
                }
                case LEFT_ARM: {
                    model.field_178724_i.func_78794_c(0.0625f);
                    break;
                }
                case RIGHT_LEG: {
                    model.field_178721_j.func_78794_c(0.0625f);
                    break;
                }
                case LEFT_LEG: {
                    model.field_178722_k.func_78794_c(0.0625f);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)offset.field_72450_a, (double)(-0.25 + offset.field_72448_b), (double)offset.field_72449_c);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.625f, (float)-0.625f, (float)-0.625f);
            Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)entityIn, stack, ItemCameraTransforms.TransformType.HEAD);
            GlStateManager.func_179121_F();
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class Renderer
    extends RenderPlayer {
        public Renderer(RenderManager renderManager) {
            this(renderManager, false);
        }

        public Renderer(RenderManager renderManager, boolean useSmallArms) {
            super(renderManager, useSmallArms);
            Iterator iter = this.field_177097_h.iterator();
            while (iter.hasNext()) {
                LayerRenderer renderer = (LayerRenderer)iter.next();
                if (!(renderer instanceof LayerBipedArmor)) continue;
                iter.remove();
            }
            this.func_177094_a((LayerRenderer)new LayerArmorCustom(this));
            this.func_177094_a(new LayerInventoryItem(this));
        }

        protected void renderModel(AbstractClientPlayer entityIn, float f0, float f1, float f2, float f3, float f4, float f5) {
            if (PlayerRender.isTransparent((EntityPlayer)entityIn)) {
                if (this.func_180548_c((Entity)entityIn)) {
                    GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                    this.field_77045_g.func_78088_a((Entity)entityIn, f0, f1, f2, f3, f4, f5);
                    GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                }
            } else {
                boolean flag1;
                boolean flag = this.func_193115_c((EntityLivingBase)entityIn);
                boolean bl = flag1 = !flag && !entityIn.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                if (flag || flag1) {
                    if (flag1) {
                        GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                    }
                    this.func_180548_c((Entity)entityIn);
                    ModelPlayer model = this.func_177087_b();
                    if (PlayerRender.shouldNarutoRun((Entity)entityIn) && model.field_78095_p == 0.0f && model.field_187076_m == ModelBiped.ArmPose.EMPTY && model.field_187075_l == ModelBiped.ArmPose.EMPTY) {
                        this.renderNarutoRun((ModelBiped)model, (Entity)entityIn, f0, f1, f2, f3, f4, f5);
                    } else {
                        model.func_78088_a((Entity)entityIn, f0, f1, f2, f3, f4, f5);
                    }
                    if (flag1) {
                        GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                    }
                }
            }
        }

        public void renderNarutoRun(ModelBiped model, Entity entityIn, float f0, float f1, float f2, float f3, float f4, float scale) {
            model.field_78117_n = true;
            model.func_78087_a(f0, f1, f2, f3, f4, scale, entityIn);
            model.field_178723_h.field_78795_f = 1.4835f;
            model.field_178723_h.field_78796_g = -0.3927f;
            model.field_178724_i.field_78795_f = 1.4835f;
            model.field_178724_i.field_78796_g = 0.3927f;
            if (model instanceof ModelPlayer) {
                ((ModelPlayer)model).field_178732_b.field_78795_f = model.field_178723_h.field_78795_f;
                ((ModelPlayer)model).field_178732_b.field_78796_g = model.field_178723_h.field_78796_g;
                ((ModelPlayer)model).field_178734_a.field_78795_f = model.field_178724_i.field_78795_f;
                ((ModelPlayer)model).field_178734_a.field_78796_g = model.field_178724_i.field_78796_g;
            }
            GlStateManager.func_179094_E();
            if (model.field_78091_s) {
                float f = 2.0f;
                GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * scale), (float)0.0f);
                model.field_78116_c.func_78785_a(scale);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
                model.field_78115_e.func_78785_a(scale);
                model.field_178723_h.func_78785_a(scale);
                model.field_178724_i.func_78785_a(scale);
                model.field_178721_j.func_78785_a(scale);
                model.field_178722_k.func_78785_a(scale);
                model.field_178720_f.func_78785_a(scale);
                if (model instanceof ModelPlayer) {
                    ((ModelPlayer)model).field_178733_c.func_78785_a(scale);
                    ((ModelPlayer)model).field_178731_d.func_78785_a(scale);
                    ((ModelPlayer)model).field_178734_a.func_78785_a(scale);
                    ((ModelPlayer)model).field_178732_b.func_78785_a(scale);
                    ((ModelPlayer)model).field_178730_v.func_78785_a(scale);
                }
            } else {
                if (entityIn.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                }
                model.field_78116_c.func_78785_a(scale);
                model.field_78115_e.func_78785_a(scale);
                model.field_178723_h.func_78785_a(scale);
                model.field_178724_i.func_78785_a(scale);
                model.field_178721_j.func_78785_a(scale);
                model.field_178722_k.func_78785_a(scale);
                model.field_178720_f.func_78785_a(scale);
                if (model instanceof ModelPlayer) {
                    ((ModelPlayer)model).field_178733_c.func_78785_a(scale);
                    ((ModelPlayer)model).field_178731_d.func_78785_a(scale);
                    ((ModelPlayer)model).field_178734_a.func_78785_a(scale);
                    ((ModelPlayer)model).field_178732_b.func_78785_a(scale);
                    ((ModelPlayer)model).field_178730_v.func_78785_a(scale);
                }
            }
            GlStateManager.func_179121_F();
        }

        protected void renderLayers(AbstractClientPlayer entity, float f0, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (!entity.func_82150_aj() || !entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                AbstractClientPlayer target = this.getSkinCloneTarget((Entity)entity);
                if (target != null && entity.getEntityData().func_74767_n(PlayerRender.CLONETARGETLAYERS)) {
                    if (target.func_70093_af()) {
                        GlStateManager.func_179109_b((float)0.0f, (float)-0.2f, (float)0.0f);
                    }
                    if (entity.func_70093_af()) {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
                    }
                } else {
                    target = entity;
                }
                super.func_177093_a((EntityLivingBase)target, f0, f1, f2, f3, f4, f5, f6);
            }
        }

        public ResourceLocation func_110775_a(AbstractClientPlayer entity) {
            AbstractClientPlayer target = this.getSkinCloneTarget((Entity)entity);
            return target != null ? target.func_110306_p() : super.func_110775_a(entity);
        }

        protected void func_188296_a(AbstractClientPlayer entityIn, double x, double y, double z, String name, double distanceSq) {
            if (entityIn.func_174833_aM()) {
                AbstractClientPlayer target = this.getSkinCloneTarget((Entity)entityIn);
                if (target != null) {
                    super.func_188296_a(entityIn, x, y, z, target.func_70005_c_(), distanceSq);
                } else {
                    super.func_188296_a(entityIn, x, y, z, name, distanceSq);
                }
            }
        }

        protected int getColorMultiplier(AbstractClientPlayer entityIn, float lightBrightness, float partialTickTime) {
            int color = PlayerRender.getColorMultiplier((EntityPlayer)entityIn);
            if ((color >> 24 & 0xFF) > 0) {
                return color;
            }
            return super.func_77030_a((EntityLivingBase)entityIn, lightBrightness, partialTickTime);
        }

        @Nullable
        private AbstractClientPlayer getSkinCloneTarget(Entity entity) {
            if (entity.getEntityData().func_74764_b(PlayerRender.CLONETARGETID)) {
                EntityPlayer target = null;
                for (EntityPlayer player : this.field_76990_c.field_78722_g.field_73010_i) {
                    if (player.func_145782_y() != entity.getEntityData().func_74762_e(PlayerRender.CLONETARGETID)) continue;
                    target = player;
                    break;
                }
                if (target instanceof AbstractClientPlayer) {
                    return (AbstractClientPlayer)target;
                }
                entity.getEntityData().func_82580_o(PlayerRender.CLONETARGETID);
            }
            return null;
        }
    }
}

