/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.ModConfig;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityTailedBeast;

@ElementsNarutomodMod.ModElement.Tag
public class SpawnTailedBeasts
extends ElementsNarutomodMod.ModElement {
    private static final int SPAWN_MAX_RADIUS = 100000;
    private static final int SPAWN_MIN_RADIUS = 10000;
    private static final int REQUIRED_DISTANCE = 100;
    private static final int TIME_FOR_RESPAWN = 3600;
    private boolean resetSpawnPos = true;

    public SpawnTailedBeasts(ElementsNarutomodMod instance) {
        super(instance, 835);
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.func_82737_E() % 20L != 0L) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (!ModConfig.SPAWN_TAILED_BEASTS) {
            if (this.resetSpawnPos) {
                EntityBijuManager.resetAllSpawnPos();
                this.resetSpawnPos = false;
            }
            return;
        }
        this.resetSpawnPos = true;
        for (EntityBijuManager bm : EntityBijuManager.getBMList()) {
            BlockPos spawnPos;
            if (bm.isAddedToWorld() || bm.isSealed() || bm.getTails() == 10) continue;
            if (bm.getHasLived()) {
                if (bm.hasSpawnPos()) {
                    bm.setSpawnPos(null);
                }
                if (bm.getTicksSinceDeath() < 3600) {
                    bm.setTicksSinceDeath(bm.getTicksSinceDeath() + 1);
                    continue;
                }
                bm.setHasLived(false);
            }
            if (bm.hasSpawnPos()) {
                spawnPos = bm.getSpawnPos();
            } else {
                int height;
                int z;
                int x = world.field_73012_v.nextInt(90000) + 10000 + world.func_175694_M().func_177958_n();
                spawnPos = new BlockPos((double)x, 0.0, (double)(z = world.field_73012_v.nextInt(90000) + 10000 + world.func_175694_M().func_177952_p()));
                Biome biome = world.func_180494_b(new BlockPos(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p()));
                if (!bm.canSpawnInBiome(biome)) continue;
                Chunk chunk = world.func_175726_f(new BlockPos((double)spawnPos.func_177958_n(), 0.0, (double)spawnPos.func_177952_p()));
                for (int y = height = chunk.func_76611_b(spawnPos.func_177958_n() & 0xF, spawnPos.func_177952_p() & 0xF); y >= 0; --y) {
                    BlockPos currentPos = new BlockPos(spawnPos.func_177958_n(), y, spawnPos.func_177952_p());
                    IBlockState state = chunk.func_177435_g(currentPos);
                    if (state.func_177230_c().isAir(state, (IBlockAccess)world, currentPos)) continue;
                    height = y;
                    break;
                }
                if (height == -1) continue;
                bm.setSpawnPos(spawnPos.func_177963_a(0.0, (double)height, 0.0));
            }
            boolean playerInRange = false;
            for (EntityPlayer player : world.field_73010_i) {
                double distanceSq = player.func_70092_e((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
                if (!(distanceSq < 10000.0)) continue;
                playerInRange = true;
                break;
            }
            if (!playerInRange) continue;
            Object entity = bm.spawnEntity(world, spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p(), (world.field_73012_v.nextFloat() - 0.5f) * 360.0f);
            ((EntityTailedBeast.Base)entity).func_180482_a(world.func_175649_E(spawnPos), null);
        }
    }
}

