/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityGedoStatue;
import net.narutomod.entity.EntityTailedBeast;
import net.narutomod.item.ItemBijuCloak;
import net.narutomod.item.ItemSenjutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public abstract class EntityBijuManager<T extends EntityTailedBeast.Base> {
    public static final int ENTITYID = 337;
    public static final int ENTITYID_RANGED = 338;
    private static final Map<Class<? extends EntityTailedBeast.Base>, EntityBijuManager> mapByClass = Maps.newHashMap();
    private static final Map<Integer, EntityBijuManager> mapByTailnum = Maps.newHashMap();
    private static final int[] ZERO = new int[]{0, 0, 0};
    private UUID vesselUuid;
    private long vesselSetTime;
    private EntityPlayer jinchurikiPlayer;
    private long jinchurikiLastActiveTime;
    private String vesselName = "";
    private T entity;
    private final Class<T> entityClass;
    private final int tails;
    private int cloakLevel;
    private long cloakCD;
    private final int[] cloakXp = new int[3];
    private double chakraBeforeCloak;
    private BlockPos spawnPos;
    private int ticksSinceDeath;
    private boolean hasLived;
    private static final Random rand = new Random();
    private static final List<List<Biome>> spawns = Lists.newArrayList((Object[])new List[]{Arrays.asList(Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_150589_Z), Arrays.asList(Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_76780_h), Arrays.asList(Biomes.field_150575_M, Biomes.field_76771_b, Biomes.field_76787_r), Arrays.asList(Biomes.field_76768_g, Biomes.field_76784_u, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x), Arrays.asList(Biomes.field_76772_c, Biomes.field_150588_X, Biomes.field_150587_Y), Arrays.asList(Biomes.field_76781_i, Biomes.field_76780_h), Arrays.asList(Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_185448_Z, Biomes.field_185444_T), Arrays.asList(Biomes.field_76771_b, Biomes.field_150576_N), Arrays.asList(Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_150585_R)});

    public static Collection<EntityBijuManager> getBMList() {
        return ImmutableList.copyOf(mapByClass.values());
    }

    @Nullable
    protected static EntityBijuManager getBijuManagerFrom(EntityPlayer player) {
        for (EntityBijuManager bm : mapByClass.values()) {
            if (!player.equals((Object)bm.getJinchurikiPlayer())) continue;
            return bm;
        }
        return null;
    }

    public static boolean isJinchuriki(EntityPlayer player) {
        return EntityBijuManager.getBijuManagerFrom(player) != null;
    }

    public static boolean isJinchurikiOf(EntityPlayer player, Class<? extends EntityTailedBeast.Base> clazz) {
        EntityBijuManager tb = mapByClass.get(clazz);
        return tb != null && player.equals((Object)tb.getJinchurikiPlayer());
    }

    @Nullable
    public static EntityTailedBeast.Base getBijuOfPlayerInWorld(EntityPlayer player) {
        EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(player);
        return bm != null ? (EntityTailedBeast.Base)bm.getEntityInWorld(player.field_70170_p) : null;
    }

    public static int availableBijus() {
        int i = 0;
        for (int j = 1; j <= 9; ++j) {
            if (!mapByTailnum.containsKey(j) || mapByTailnum.get(j).isSealed()) continue;
            ++i;
        }
        return i;
    }

    public static int getRandomAvailableBiju() {
        int i = EntityBijuManager.availableBijus();
        if (i > 0) {
            i = rand.nextInt(i);
            int j = 0;
            for (int k = 1; k <= 9; ++k) {
                EntityBijuManager bm = mapByTailnum.get(k);
                if (bm == null || bm.isSealed()) continue;
                if (j == i) {
                    return bm.getTails();
                }
                ++j;
            }
        }
        return 0;
    }

    public static boolean anyBijuAddedToWorld() {
        for (EntityBijuManager bm : mapByClass.values()) {
            if (!bm.isAddedToWorld()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBijuAddedToWorld(int tails) {
        EntityBijuManager bm = mapByTailnum.get(tails);
        return bm != null && bm.isAddedToWorld();
    }

    public static void unsetPlayerAsJinchuriki(EntityPlayer player) {
        EntityBijuManager.unsetEntityAsVessel((Entity)player);
    }

    public static void unsetEntityAsVessel(Entity entityIn) {
        for (EntityBijuManager bm : mapByClass.values()) {
            if (bm.getVesselUuid() == null || !bm.getVesselUuid().equals(entityIn.func_110124_au())) continue;
            bm.setVesselEntity(null);
        }
    }

    public static boolean setVesselByTails(Entity entityIn, int tailnum) {
        EntityBijuManager bm = mapByTailnum.get(tailnum);
        if (bm != null && !bm.isSealed()) {
            bm.setVesselEntity(entityIn);
            return true;
        }
        return false;
    }

    public static void revokeJinchurikiByTails(int tailnum) {
        EntityBijuManager bm = mapByTailnum.get(tailnum);
        if (bm != null) {
            bm.setVesselEntity(null);
        }
    }

    public static void revokeAllJinchuriki() {
        for (EntityBijuManager bm : mapByClass.values()) {
            bm.setVesselEntity(null);
        }
    }

    @Nullable
    public static EntityTailedBeast.Base getEntityByTails(int tailnum) {
        EntityBijuManager bm = mapByTailnum.get(tailnum);
        return bm != null ? (EntityTailedBeast.Base)bm.getEntity() : null;
    }

    @Nullable
    public static BlockPos getPositionByTails(int tailnum) {
        EntityBijuManager bm = mapByTailnum.get(tailnum);
        return bm != null ? bm.getPosition() : null;
    }

    public static int getTails(EntityPlayer player) {
        EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(player);
        return bm != null ? bm.getTails() : 0;
    }

    public static String getNameOfJinchurikisBiju(EntityPlayer player) {
        EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(player);
        return bm != null ? bm.getEntityLocalizedName() : null;
    }

    public static void toggleBijuCloak(EntityPlayer player) {
        EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(player);
        if (bm != null) {
            bm.toggleBijuCloak();
        }
    }

    public static int increaseCloakLevel(EntityPlayer player) {
        EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(player);
        return bm != null ? bm.increaseCloakLevel() : 0;
    }

    public static int cloakLevel(EntityPlayer player) {
        EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(player);
        return bm != null ? bm.getCloakLevel() : 0;
    }

    public static void addCloakXp(EntityPlayer player, int xp) {
        EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(player);
        if (bm != null) {
            bm.addCloakXp(xp);
        }
    }

    public static int getCloakXp(EntityPlayer player) {
        EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(player);
        return bm != null ? bm.getCloakXp() : 0;
    }

    public static int getCloakXp(EntityPlayer player, int level) {
        EntityBijuManager bm = EntityBijuManager.getBijuManagerFrom(player);
        return bm != null && level >= 0 && level < bm.cloakXp.length ? bm.getCloakXPs()[level] : 0;
    }

    public static List<String> listJinchuriki() {
        ArrayList list = Lists.newArrayList();
        for (EntityBijuManager bm : mapByClass.values()) {
            list.add(bm.toString());
        }
        return list;
    }

    public static EntityBijuManager getClosestBiju(EntityPlayer player) {
        EntityBijuManager closest = null;
        for (EntityBijuManager bm : mapByClass.values()) {
            if (!bm.hasSpawnPos() || bm.isSealed()) continue;
            double distance = bm.distanceToPlayer(player);
            if (closest != null && !(distance < closest.distanceToPlayer(player))) continue;
            closest = bm;
        }
        return closest;
    }

    public static void resetAllSpawnPos() {
        for (EntityBijuManager bm : mapByClass.values()) {
            bm.setSpawnPos(null);
        }
    }

    public EntityBijuManager(Class<T> clazz, int tailnum) {
        this.entityClass = clazz;
        this.tails = tailnum;
        this.setCloakXPs(ZERO);
        mapByClass.put(clazz, this);
        mapByTailnum.put(tailnum, this);
    }

    public void reset() {
        this.setVesselEntity(null, false);
        this.cloakCD = 0L;
        this.spawnPos = null;
        this.entity = null;
        this.hasLived = false;
        this.ticksSinceDeath = 0;
    }

    public int getTicksSinceDeath() {
        return this.ticksSinceDeath;
    }

    public void setTicksSinceDeath(int ticks) {
        this.setTicksSinceDeath(ticks, true);
    }

    public void setTicksSinceDeath(int ticksSinceDeath, boolean dirty) {
        this.ticksSinceDeath = ticksSinceDeath;
        if (dirty) {
            this.markDirty();
        }
    }

    public boolean getHasLived() {
        return this.hasLived;
    }

    public void setHasLived(boolean lived) {
        this.setHasLived(lived, true);
    }

    public void setHasLived(boolean hasLived, boolean dirty) {
        this.hasLived = hasLived;
        if (dirty) {
            this.markDirty();
        }
    }

    public BlockPos getPosition() {
        return this.isAddedToWorld() ? this.locateEntity() : this.spawnPos;
    }

    public double distanceToPlayer(EntityPlayer player) {
        return player.func_174818_b(this.getPosition());
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public void setSpawnPos(BlockPos pos) {
        this.setSpawnPos(pos, true);
    }

    public void setSpawnPos(BlockPos spawnPos, boolean dirty) {
        this.spawnPos = spawnPos;
        if (dirty) {
            this.markDirty();
        }
    }

    public boolean hasSpawnPos() {
        return this.spawnPos != null;
    }

    public boolean canSpawnInBiome(Biome biome) {
        return spawns.get(this.tails - 1).contains(biome);
    }

    public void onAddedToWorld(T entityIn) {
        this.onAddedToWorld(entityIn, true);
    }

    public void onAddedToWorld(T entityIn, boolean dirty) {
        this.hasLived = true;
        this.ticksSinceDeath = 0;
        this.entity = entityIn;
        if (dirty) {
            this.markDirty();
        }
    }

    public void onRemovedFromWorld(T entityIn) {
        this.onRemovedFromWorld(entityIn, true);
    }

    public void onRemovedFromWorld(T entityIn, boolean dirty) {
        this.entity = null;
        if (dirty) {
            this.markDirty();
        }
    }

    public boolean isAddedToWorld() {
        return this.entity != null;
    }

    public boolean isAddedToWorld(World world) {
        return this.entity != null && ((EntityTailedBeast.Base)this.entity).field_70170_p == world;
    }

    public void loadEntityFromNBT(NBTTagCompound compound) {
        this.entity.func_70020_e(compound);
    }

    public boolean isSealed() {
        return this.vesselUuid != null;
    }

    public boolean hasJinchuriki() {
        return this.vesselUuid != null && !this.vesselUuid.equals(EntityGedoStatue.ENTITY_UUID);
    }

    @Nullable
    public UUID getVesselUuid() {
        return this.vesselUuid;
    }

    public void setVesselUuid(@Nullable UUID uuid) {
        this.vesselUuid = uuid;
        if (this.tails < 10) {
            EntityGedoStatue.setBijuSealed(this.tails - 1, EntityGedoStatue.ENTITY_UUID.equals(uuid));
        }
    }

    public String getVesselName() {
        return this.vesselName;
    }

    public void setVesselName(String name) {
        this.vesselName = name;
    }

    @Nullable
    public EntityPlayer getJinchurikiPlayer() {
        return this.jinchurikiPlayer;
    }

    public void setVesselEntity(@Nullable Entity entityIn) {
        this.setVesselEntity(entityIn, true);
        this.vesselSetTime = entityIn != null ? MinecraftServer.func_130071_aq() : 0L;
    }

    public void setVesselEntity(@Nullable Entity entityIn, boolean dirty) {
        if (entityIn == null) {
            this.setVesselUuid(null);
            if (this.getCloakLevel() != 0) {
                this.toggleBijuCloak();
            }
            this.setCloakXPs(ZERO);
            this.vesselName = "";
            if (this.tails == 10 && dirty) {
                this.hasLived = false;
            }
        } else {
            this.setVesselUuid(entityIn.func_110124_au());
            this.vesselName = entityIn.func_70005_c_();
            if (this.entity != null) {
                ((EntityTailedBeast.Base)this.entity).func_70106_y();
            }
        }
        if (entityIn instanceof EntityPlayer) {
            this.jinchurikiPlayer = (EntityPlayer)entityIn;
            this.setJinchurikiLastActiveTime(MinecraftServer.func_130071_aq(), false);
        } else {
            this.jinchurikiPlayer = null;
            this.setJinchurikiLastActiveTime(0L, false);
        }
        if (dirty) {
            this.markDirty();
        }
    }

    public void setVesselTime(long time) {
        this.vesselSetTime = time;
    }

    public long getVesselSetTime() {
        return this.isSealed() ? this.vesselSetTime : 0L;
    }

    public void setJinchurikiLastActiveTime(long time) {
        this.setJinchurikiLastActiveTime(time, true);
    }

    public void setJinchurikiLastActiveTime(long time, boolean markDirty) {
        this.jinchurikiLastActiveTime = time;
        if (markDirty) {
            this.markDirty();
        }
    }

    public long getJinchurikiLastActiveTime() {
        return this.jinchurikiPlayer != null ? this.jinchurikiLastActiveTime : 0L;
    }

    public void verifyVesselEntity(Entity entityIn) {
        if (entityIn.func_110124_au().equals(this.vesselUuid)) {
            this.setVesselEntity(entityIn, true);
            System.out.println(this.toString());
        }
    }

    public int[] getCloakXPs() {
        return this.cloakXp;
    }

    public void setCloakXPs(int[] xps) {
        this.cloakXp[0] = xps[0];
        this.cloakXp[1] = xps[1];
        this.cloakXp[2] = xps[2];
    }

    private void saveAndResetWearingTicks(int level) {
        if (level < 3 || this.isAddedToWorld()) {
            int i = level == 3 ? ((EntityTailedBeast.Base)this.entity).getAge() : ItemBijuCloak.getWearingTicks((Entity)this.jinchurikiPlayer);
            int n = level - 1;
            this.cloakXp[n] = this.cloakXp[n] + i / 20;
            if (level < 3) {
                ItemBijuCloak.setWearingTicks((Entity)this.jinchurikiPlayer, 0);
            }
            this.cloakCD += (long)(i + (int)((float)level * 2.0f * (float)i / Math.max(MathHelper.func_76129_c((float)MathHelper.func_76129_c((float)this.cloakXp[level - 1])) - 3.0f, 1.0f)));
            this.markDirty();
        }
    }

    public void addCloakXp(int xp) {
        if (this.cloakLevel >= 1 && this.cloakLevel <= 3) {
            int n = this.cloakLevel - 1;
            this.cloakXp[n] = this.cloakXp[n] + xp;
            this.markDirty();
        }
    }

    public int getCloakXp() {
        return this.cloakLevel >= 1 && this.cloakLevel <= 3 ? this.cloakXp[this.cloakLevel - 1] : 0;
    }

    public long getCloakCD() {
        return this.cloakCD;
    }

    public void setCloakCD(long time) {
        this.cloakCD = time;
    }

    public void toggleBijuCloak() {
        if (this.jinchurikiPlayer != null && this.tails < 10) {
            int i;
            Chakra.PathwayPlayer cp = Chakra.pathway(this.jinchurikiPlayer);
            int n = i = this.cloakLevel <= 0 ? 1 : 0;
            if (i == 1) {
                ItemStack stack;
                double d;
                long l = this.jinchurikiPlayer.field_70170_p.func_82737_E();
                if (l < this.cloakCD && !this.jinchurikiPlayer.func_184812_l_()) {
                    if (!this.jinchurikiPlayer.field_70170_p.field_72995_K) {
                        this.jinchurikiPlayer.func_146105_b((ITextComponent)new TextComponentTranslation("chattext.cooldown.formatted", new Object[]{(this.cloakCD - l) / 20L}), true);
                    }
                    return;
                }
                if (ItemSenjutsu.isSageModeActivated(this.jinchurikiPlayer) && this.cloakXp[1] < 800) {
                    ItemSenjutsu.deactivateSageMode((EntityLivingBase)this.jinchurikiPlayer);
                }
                if ((d = 5000.0 + (double)this.getCloakXp()) > cp.getMax() * 4.0 && !this.jinchurikiPlayer.func_184812_l_()) {
                    this.jinchurikiPlayer.func_146105_b((ITextComponent)new TextComponentTranslation("chattext.bijumanager.tooweak", new Object[]{this.getEntityLocalizedName()}), false);
                    return;
                }
                double d1 = cp.getMax() * 4.0 - cp.getAmount();
                d1 = d <= d1 || this.jinchurikiPlayer.func_184812_l_() ? d : d1;
                this.chakraBeforeCloak = cp.getAmount();
                ((Chakra.Pathway)cp).consume(-d1, true);
                this.cloakCD = l;
                if (((ItemStack)this.jinchurikiPlayer.field_71071_by.field_70460_b.get(3)).func_77973_b() != ItemBijuCloak.helmet) {
                    stack = new ItemStack(ItemBijuCloak.helmet);
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74768_a("Tails", this.tails);
                    ProcedureUtils.swapItemToSlot(this.jinchurikiPlayer, EntityEquipmentSlot.HEAD, stack);
                }
                if (((ItemStack)this.jinchurikiPlayer.field_71071_by.field_70460_b.get(2)).func_77973_b() != ItemBijuCloak.body) {
                    stack = new ItemStack(ItemBijuCloak.body, 1, this.tails);
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74768_a("Tails", this.tails);
                    ProcedureUtils.swapItemToSlot(this.jinchurikiPlayer, EntityEquipmentSlot.CHEST, stack);
                }
                if (((ItemStack)this.jinchurikiPlayer.field_71071_by.field_70460_b.get(1)).func_77973_b() != ItemBijuCloak.legs) {
                    stack = new ItemStack(ItemBijuCloak.legs);
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74768_a("Tails", this.tails);
                    ProcedureUtils.swapItemToSlot(this.jinchurikiPlayer, EntityEquipmentSlot.LEGS, stack);
                }
            } else {
                this.saveAndResetWearingTicks(this.cloakLevel);
                ItemStack stack = this.jinchurikiPlayer.func_184582_a(EntityEquipmentSlot.CHEST);
                if (stack.func_77973_b() == ItemBijuCloak.body) {
                    ItemBijuCloak.revertOriginal(this.jinchurikiPlayer, stack);
                }
                ItemBijuCloak.clearCloakItems(this.jinchurikiPlayer);
                T biju = this.getEntityInWorld(this.jinchurikiPlayer.field_70170_p);
                if (biju != null && !((EntityTailedBeast.Base)biju).field_70128_L) {
                    ((EntityTailedBeast.Base)biju).func_70106_y();
                }
                if (cp.getAmount() > this.chakraBeforeCloak && this.chakraBeforeCloak > 0.0) {
                    cp.consume(cp.getAmount() - this.chakraBeforeCloak);
                    this.chakraBeforeCloak = 0.0;
                }
            }
            this.cloakLevel = i;
        }
    }

    public int increaseCloakLevel() {
        if (this.cloakLevel < 3) {
            if (this.jinchurikiPlayer != null && (this.cloakLevel == 1 && this.cloakXp[0] >= 3600 || this.cloakLevel == 2 && this.cloakXp[1] >= 4800)) {
                Chakra.PathwayPlayer chakra = Chakra.pathway(this.jinchurikiPlayer);
                double d = 5000.0 + (double)this.getCloakXp();
                if (chakra.getAmount() + d > chakra.getMax() * 4.0 && !this.jinchurikiPlayer.func_184812_l_()) {
                    this.jinchurikiPlayer.func_146105_b((ITextComponent)new TextComponentTranslation("chattext.bijumanager.tooweak", new Object[]{this.getEntityLocalizedName()}), false);
                } else {
                    ((Chakra.Pathway)chakra).consume(-d, true);
                    this.saveAndResetWearingTicks(this.cloakLevel++);
                }
            }
        } else {
            this.cloakLevel = 3;
        }
        if (this.cloakLevel == 3 && this.jinchurikiPlayer != null) {
            ItemBijuCloak.clearCloakItems(this.jinchurikiPlayer);
            T biju = this.spawnEntity(this.jinchurikiPlayer);
            if (biju != null) {
                ((EntityTailedBeast.Base)biju).setLifeSpan(this.cloakXp[2] * 5 + 200);
            }
        }
        return this.cloakLevel;
    }

    public int getCloakLevel() {
        return this.cloakLevel;
    }

    @Nullable
    public BlockPos locateEntity() {
        return this.entity != null ? this.entity.func_180425_c() : null;
    }

    public int getTails() {
        return this.tails;
    }

    private T createEntity(World world) {
        try {
            return (T)((EntityTailedBeast.Base)this.entityClass.getConstructor(World.class).newInstance(world));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    public T spawnEntity(World world, double x, double y, double z, float yaw) {
        T biju = this.createEntity(world);
        ((EntityTailedBeast.Base)biju).field_98038_p = true;
        ((EntityTailedBeast.Base)biju).field_70759_as = yaw;
        biju.func_70012_b(x, y, z, yaw, 0.0f);
        world.func_72838_d(biju);
        ((EntityTailedBeast.Base)biju).field_98038_p = false;
        return biju;
    }

    private T spawnEntity(EntityPlayer jinchuriki) {
        try {
            EntityTailedBeast.Base biju = (EntityTailedBeast.Base)this.entityClass.getConstructor(EntityPlayer.class).newInstance(jinchuriki);
            biju.field_98038_p = true;
            jinchuriki.field_70170_p.func_72838_d((Entity)biju);
            biju.field_98038_p = false;
            return (T)biju;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    @Nullable
    public T getEntity() {
        return this.entity;
    }

    @Nullable
    public T getEntityInWorld(World world) {
        if (this.entity != null) {
            Entity entity1 = world.func_73045_a(this.entity.func_145782_y());
            return (T)(entity1 != null && entity1.getClass() == this.entityClass ? (EntityTailedBeast.Base)entity1 : null);
        }
        return null;
    }

    public abstract void markDirty();

    public String getEntityLocalizedName() {
        StringBuilder stringBuilder = new StringBuilder().append("entity.");
        EntityRegistry.instance();
        return I18n.func_74838_a((String)stringBuilder.append(EntityRegistry.getEntry(this.entityClass).getName()).append(".name").toString());
    }

    public String toString() {
        EntityPlayer jinchuriki = this.getJinchurikiPlayer();
        return " >> " + this.getEntityLocalizedName() + " is sealed in " + TextFormatting.GREEN + (jinchuriki != null ? jinchuriki.func_70005_c_() : this.vesselName) + TextFormatting.RESET;
    }

    public static interface ITailBeast {
        public void fuuinIntoVessel(Entity var1, int var2);

        public boolean isFuuinInProgress();

        public void cancelFuuin();

        public void incFuuinProgress(int var1);

        public float getFuuinProgress();
    }
}

