/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.entity.EntityEarthBlocks;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.event.EventSphericalExplosion;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureGravityPower;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityChibakuTenseiBall
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 130;
    public static final int ENTITYID_RANGED = 131;

    public EntityChibakuTenseiBall(ElementsNarutomodMod instance) {
        super(instance, 375);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "chibaku_tensei_ball"), 130).name("chibaku_tensei_ball").tracker(64, 3, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(Satellite.class).id(new ResourceLocation("narutomod", "chibaku_satellite"), 131).name("chibaku_satellite").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderCustom(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelBall
    extends ModelBase {
        private final ModelRenderer bb_main;

        public ModelBall() {
            this.field_78090_t = 16;
            this.field_78089_u = 16;
            this.bb_main = new ModelRenderer((ModelBase)this);
            this.bb_main.func_78793_a(0.0f, 2.0f, 0.0f);
            this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, 0, 0, -2.0f, -4.0f, -2.0f, 4, 4, 4, 0.0f, false));
        }

        public void func_78088_a(Entity entityIn, float f0, float f1, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
            this.bb_main.func_78785_a(scale);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EntityCustom> {
        protected ModelBase mainModel;

        public RenderCustom(RenderManager renderManagerIn) {
            super(renderManagerIn);
            this.mainModel = new ModelBall();
        }

        public void doRender(EntityCustom entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.func_180548_c(entity);
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            float scale = entity.getEntityScale();
            GlStateManager.func_179137_b((double)x, (double)(y + (double)(0.125f * scale)), (double)z);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)((float)entity.field_70173_aa * 10.0f), (float)1.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.mainModel.func_78088_a((Entity)entity, 0.0f, 0.0f, partialTicks + (float)entity.field_70173_aa, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
            super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        }

        protected ResourceLocation getEntityTexture(EntityCustom entity) {
            return new ResourceLocation(entity.getEntityScale() > 80.0f * 0.4f ? "narutomod:textures/blank.png" : "narutomod:textures/truthhseekerball.png");
        }
    }

    public static class Satellite
    extends EntityEarthBlocks.Base {
        private EntityLivingBase summoner;
        private boolean explosionSet;

        public Satellite(World world) {
            super(world);
        }

        public Satellite(EntityLivingBase summonerIn, List<? extends BlockPos> list) {
            super(summonerIn.field_70170_p, list);
            this.summoner = summonerIn;
            this.func_189654_d(true);
            this.field_70181_x = -0.1;
            this.setFallTime(1200);
        }

        @Override
        protected void onImpact(float impact) {
            if (!this.field_70170_p.field_72995_K && !this.explosionSet && this.getTicksAlive() - this.fallTicks <= 1200) {
                if (this.summoner != null) {
                    this.summoner.getEntityData().func_74780_a(NarutomodModVariables.InvulnerableTime, 300.0);
                }
                new EventSphericalExplosion(this.field_70170_p, (Entity)this.summoner, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 60, 0L, 0.3f){

                    @Override
                    protected void doOnTick(int currentTick) {
                        ProcedureAoeCommand.set(this.getWorld(), this.getX0(), this.getY0(), this.getZ0(), 0.0, this.getRadius()).exclude(this.getEntity()).damageEntities(DamageSource.field_82729_p, (float)this.getRadius());
                    }
                };
                this.explosionSet = true;
                this.explodeOnImpact(true);
            }
            super.onImpact(impact);
        }

        @Override
        public boolean griefingAllowed() {
            return this.getTicksAlive() == 1 ? true : super.griefingAllowed();
        }
    }

    public static class EntityCustom
    extends EntityScalableProjectile.Base {
        private final float maxScale = 80.0f;
        private final int launchTime = 100;
        private final List<Entity> affectedEntities = Lists.newArrayList();
        private List<BlockPos> airBlocks;
        private List<BlockPos> blockList;
        private boolean maxSizeReached;
        private int dropTime;
        private double stationaryX;
        private double stationaryY;
        private double stationaryZ;

        public EntityCustom(World world) {
            super(world);
            this.setOGSize(0.25f, 0.25f);
        }

        public EntityCustom(EntityLivingBase shooter) {
            super(shooter);
            this.setOGSize(0.25f, 0.25f);
            this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.field_70131_O + 0.5, shooter.field_70161_v);
            shooter.getEntityData().func_74757_a("chibakutensei_active", true);
        }

        @Override
        public void func_70186_c(double x, double y, double z, float speed, float inaccuracy) {
            this.func_70106_y();
            List<BlockPos> list = ProcedureUtils.getNonAirBlocks(this.field_70170_p, this.func_174813_aQ().func_186662_g(1.0));
            if (!list.isEmpty() && this.shootingEntity != null) {
                this.field_70170_p.func_72838_d((Entity)new Satellite(this.shootingEntity, list));
            }
        }

        public void createEntitiesAndBlocksList() {
            AxisAlignedBB aabb = this.func_174813_aQ().func_186662_g(100.0);
            this.blockList = ProcedureUtils.getNonAirBlocks(this.field_70170_p, aabb, true);
            this.blockList.sort(new ProcedureUtils.BlockposSorter(new BlockPos((Entity)this)));
        }

        public void func_70106_y() {
            if (this.shootingEntity != null) {
                this.shootingEntity.getEntityData().func_74757_a("chibakutensei_active", false);
            }
            this.resetAffectedEntityGravity();
            super.func_70106_y();
        }

        private Vec3d getCenter() {
            AxisAlignedBB aabb = this.func_174813_aQ();
            return new Vec3d(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5, aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
        }

        private void doBlackholeThings() {
            Object entity;
            if (!this.maxSizeReached && this.field_70146_Z.nextInt(10) == 0 && (entity = ProcedureUtils.findNearestEntityWithinAABB(this.field_70170_p, EntityLivingBase.class, this.func_174813_aQ().func_186662_g(128.0), this, new Predicate<EntityLivingBase>(){

                public boolean apply(@Nullable EntityLivingBase e) {
                    return ItemJutsu.canTarget((Entity)e) && !e.equals((Object)shootingEntity) && (!(e instanceof EntityPlayer) || !((EntityPlayer)e).func_184812_l_()) && !affectedEntities.contains(e);
                }
            })) != null) {
                this.affectedEntities.add((Entity)entity);
            }
            if (!this.maxSizeReached && this.field_70146_Z.nextInt(10) == 0) {
                entity = null;
                while (entity == null && !this.blockList.isEmpty()) {
                    BlockPos pos = this.blockList.get(0);
                    this.blockList.remove(0);
                    if (this.field_70170_p.func_175623_d(pos) || (entity = ProcedureGravityPower.dislodgeBlocks(this.field_70170_p, pos, 6 + this.field_70146_Z.nextInt(4))) == null) continue;
                    ((EntityEarthBlocks.Base)((Object)entity)).field_70181_x = 0.1;
                    this.affectedEntities.add((Entity)entity);
                    Iterator<BlockPos> iter = this.blockList.iterator();
                    while (iter.hasNext()) {
                        BlockPos pos1 = iter.next();
                        for (BlockPos blockPos : ((EntityEarthBlocks.Base)((Object)entity)).getBlockposList()) {
                            if (!pos1.equals((Object)blockPos)) continue;
                            iter.remove();
                        }
                    }
                }
            }
            Iterator<Entity> iter1 = this.affectedEntities.iterator();
            while (iter1.hasNext()) {
                Entity ent = iter1.next();
                if (ItemJutsu.canTarget(ent)) {
                    Vec3d vec = this.getCenter().func_178786_a(ent.field_70165_t, ent.field_70163_u + (double)(ent.field_70131_O / 2.0f), ent.field_70161_v).func_72432_b().func_186678_a(0.1);
                    ent.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                    ent.field_70133_I = true;
                    continue;
                }
                iter1.remove();
            }
        }

        private void resetAffectedEntityGravity() {
            Iterator<Entity> iter = this.affectedEntities.iterator();
            while (iter.hasNext()) {
                Entity entity = iter.next();
                entity.func_189654_d(false);
                ProcedureUtils.setVelocity(entity, entity.field_70159_w, entity.field_70181_x - 0.1, entity.field_70179_y);
                iter.remove();
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.ticksAlive < this.launchTime) {
                this.field_70181_x += 0.03;
                float f = this.maxScale * 0.2f * (float)this.ticksAlive;
                ((Object)((Object)this)).getClass();
                this.setEntityScale(Math.max(f / 100.0f, 1.0f));
            } else if (!this.maxSizeReached || this.dropTime > 0) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (this.ticksAlive == this.launchTime) {
                    this.stationaryX = this.field_70165_t;
                    this.stationaryY = this.field_70163_u;
                    this.stationaryZ = this.field_70161_v;
                } else {
                    this.func_70107_b(this.stationaryX, this.stationaryY, this.stationaryZ);
                }
                if (!this.field_70170_p.field_72995_K) {
                    if (this.blockList == null) {
                        this.createEntitiesAndBlocksList();
                        this.setEntityScale(this.maxScale);
                    } else {
                        this.doBlackholeThings();
                        this.collideWithNearbyEntities();
                    }
                }
            } else {
                this.func_70186_c(0.0, 0.0, 0.0, 0.0f, 0.0f);
            }
            if (this.dropTime > 0) {
                --this.dropTime;
            }
            this.field_70181_x *= 0.98;
        }

        protected void collideWithNearbyEntities() {
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(6.0))) {
                if (!entity.func_174813_aQ().func_72326_a(this.func_174813_aQ())) continue;
                Vec3d vec = this.getCenter();
                if (entity instanceof EntityLivingBase && !(entity.func_70011_f(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c) <= (double)(this.field_70130_N / 2.0f))) continue;
                this.func_70108_f(entity);
            }
        }

        public void func_70108_f(Entity entity) {
            if (!this.field_70170_p.field_72995_K) {
                if (entity instanceof EntityEarthBlocks.Base) {
                    Vec3d vec = this.getCenter();
                    if (this.airBlocks == null) {
                        this.airBlocks = ProcedureUtils.getAllAirBlocks(this.field_70170_p, this.func_174813_aQ().func_186662_g(this.maxRadius() - (double)(this.field_70130_N / 2.0f)).func_72317_d(0.0, 1.0, 0.0));
                        this.airBlocks.sort(new ProcedureUtils.BlockposSorter(new BlockPos(vec)));
                    }
                    if (!this.airBlocks.isEmpty()) {
                        Map<Vec3d, IBlockState> map = ((EntityEarthBlocks.Base)entity).getBlocksMap();
                        ArrayList list = Lists.newArrayList(map.values());
                        Iterator<BlockPos> iter = this.airBlocks.iterator();
                        for (int i = 0; iter.hasNext() && i < list.size(); ++i) {
                            BlockPos pos = iter.next();
                            this.field_70170_p.func_180501_a(pos, (IBlockState)list.get(i), 3);
                            iter.remove();
                        }
                        map.clear();
                        entity.func_70106_y();
                        if (!this.maxSizeReached && this.airBlocks.get(0).func_177957_d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c) >= (double)(this.field_70130_N * this.field_70130_N / 4.0f)) {
                            this.maxSizeReached = true;
                            this.dropTime = 30;
                        }
                    }
                } else {
                    entity.func_70097_a(DamageSource.field_188406_j, 10.0f);
                    if (entity instanceof EntityLivingBase) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76419_f, 2, 3, false, false));
                    }
                }
            }
        }

        private double maxRadius() {
            AxisAlignedBB aabb = this.func_174813_aQ();
            double d0 = (aabb.field_72336_d - aabb.field_72340_a) / 2.0;
            double d1 = (aabb.field_72337_e - aabb.field_72338_b) / 2.0;
            double d2 = (aabb.field_72334_f - aabb.field_72339_c) / 2.0;
            return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
        }

        @Override
        protected void onImpact(RayTraceResult result) {
        }

        @Override
        protected void checkOnGround() {
        }
    }
}

