/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityEarthBlocks
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 152;
    public static final int ENTITYID_RANGED = 153;

    public EntityEarthBlocks(ElementsNarutomodMod instance) {
        super(instance, 410);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(Base.class).id(new ResourceLocation("narutomod", "earth_blocks"), 152).name("earth_blocks").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(Base.class, renderManager -> new RenderEarthBlocks(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderEarthBlocks
    extends Render<Base> {
        public RenderEarthBlocks(RenderManager renderManagerIn) {
            super(renderManagerIn);
        }

        private void renderBlock(Base entity, IBlockState iblockstate, Vec3d blockvec, double x, double y, double z) {
            if (iblockstate.func_185901_i() == EnumBlockRenderType.MODEL) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                GlStateManager.func_179137_b((double)(x + blockvec.field_72450_a - 0.5), (double)(y + blockvec.field_72448_b), (double)(z + blockvec.field_72449_c - 0.5));
                BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)entity.field_70170_p, blockrendererdispatcher.func_184389_a(iblockstate), iblockstate, BlockPos.field_177992_a, bufferbuilder, false);
                tessellator.func_78381_a();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
        }

        private boolean isFullySurrounded(Base entity, Vec3d vec, Vec3d viewer) {
            Vec3d vec1 = vec.func_178787_e(entity.func_174791_d());
            return !(!(viewer.field_72448_b <= vec1.field_72448_b) && !entity.blocksMap.containsKey(vec.func_72441_c(0.0, 1.0, 0.0)) || !(viewer.field_72448_b >= vec1.field_72448_b) && !entity.blocksMap.containsKey(vec.func_72441_c(0.0, -1.0, 0.0)) || !(viewer.field_72450_a <= vec1.field_72450_a) && !entity.blocksMap.containsKey(vec.func_72441_c(1.0, 0.0, 0.0)) || !(viewer.field_72450_a >= vec1.field_72450_a) && !entity.blocksMap.containsKey(vec.func_72441_c(-1.0, 0.0, 0.0)) || !(viewer.field_72449_c <= vec1.field_72449_c) && !entity.blocksMap.containsKey(vec.func_72441_c(0.0, 0.0, 1.0)) || !(viewer.field_72449_c >= vec1.field_72449_c) && !entity.blocksMap.containsKey(vec.func_72441_c(0.0, 0.0, -1.0)));
        }

        public void doRender(Base entity, double x, double y, double z, float entityYaw, float partialTicks) {
            block4: {
                if (entity.blocksMap.isEmpty() || entity.blocksMap.size() != entity.blocksTotal) break block4;
                this.field_76989_e = 0.8f * entity.field_70130_N;
                this.func_110776_a(TextureMap.field_110575_b);
                EntityPlayerSP viewer = Minecraft.func_71410_x().field_71439_g;
                if ((double)viewer.func_70032_d((Entity)entity) < (double)entity.field_70130_N + 2.0) {
                    for (Map.Entry entry : entity.blocksMap.entrySet()) {
                        this.renderBlock(entity, (IBlockState)entry.getValue(), (Vec3d)entry.getKey(), x, y, z);
                    }
                } else {
                    Vec3d viewereyes = viewer.func_174824_e(1.0f);
                    for (Map.Entry entry : entity.blocksMap.entrySet()) {
                        if (this.isFullySurrounded(entity, (Vec3d)entry.getKey(), viewereyes)) continue;
                        this.renderBlock(entity, (IBlockState)entry.getValue(), (Vec3d)entry.getKey(), x, y, z);
                    }
                }
            }
        }

        protected ResourceLocation getEntityTexture(Base entity) {
            return TextureMap.field_110575_b;
        }
    }

    public static class BlocksMoveHelper {
        private static final Predicate NOT_FALLINGBLOCK = new Predicate<Entity>(){

            public boolean apply(@Nullable Entity p) {
                return p != null && p.func_70089_S() && !(p instanceof EntityFallingBlock);
            }
        };
        private List<EntityFallingBlock> toMove = Lists.newArrayList();
        private AxisAlignedBB boundingBox;
        public double motionX;
        public double motionY;
        public double motionZ;
        public boolean collided;
        public boolean canMoveThrough;
        private List<Entity> collidedEntities = Lists.newArrayList();
        private List<BlockPos> collidedBlocks = Lists.newArrayList();
        private List<AxisAlignedBB> collidedAABB = Lists.newArrayList();

        public BlocksMoveHelper(World worldIn, List<BlockPos> list) {
            if (list == null || list.isEmpty()) {
                return;
            }
            this.boundingBox = new AxisAlignedBB(list.get(0));
            for (BlockPos pos : list) {
                double d1;
                double d0;
                EntityFallingBlock entity = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                entity.func_189654_d(true);
                worldIn.func_72838_d((Entity)entity);
                this.toMove.add(entity);
                double d = (double)pos.func_177958_n() < this.boundingBox.field_72340_a ? -1.0 : (d0 = (double)pos.func_177958_n() + 1.0 > this.boundingBox.field_72336_d ? 1.0 : 0.0);
                double d2 = (double)pos.func_177956_o() < this.boundingBox.field_72338_b ? -1.0 : (d1 = (double)pos.func_177956_o() + 1.0 > this.boundingBox.field_72337_e ? 1.0 : 0.0);
                double d22 = (double)pos.func_177952_p() < this.boundingBox.field_72339_c ? -1.0 : ((double)pos.func_177952_p() + 1.0 > this.boundingBox.field_72334_f ? 1.0 : 0.0);
                this.boundingBox = this.boundingBox.func_72321_a(d0, d1, d22);
            }
        }

        private void someSetup() {
            double d1;
            double d0;
            double d = this.motionX > 0.0 ? this.boundingBox.field_72340_a - 1.0 : (d0 = this.motionX < 0.0 ? this.boundingBox.field_72336_d + 1.0 : this.boundingBox.field_72340_a + (this.boundingBox.field_72336_d - this.boundingBox.field_72340_a) / 2.0);
            double d2 = this.motionY > 0.0 ? this.boundingBox.field_72338_b - 1.0 : (d1 = this.motionY < 0.0 ? this.boundingBox.field_72337_e + 1.0 : this.boundingBox.field_72338_b + (this.boundingBox.field_72337_e - this.boundingBox.field_72338_b) / 2.0);
            double d22 = this.motionZ > 0.0 ? this.boundingBox.field_72339_c - 1.0 : (this.motionZ < 0.0 ? this.boundingBox.field_72334_f + 1.0 : this.boundingBox.field_72339_c + (this.boundingBox.field_72334_f - this.boundingBox.field_72339_c) / 2.0);
            this.toMove.sort(new ProcedureUtils.EntitySorter(d0, d1, d22));
            ArrayList list = Lists.newArrayList();
            Iterator<EntityFallingBlock> iter = this.toMove.iterator();
            while (iter.hasNext()) {
                EntityFallingBlock entity = iter.next();
                EntityFallingBlock entity1 = new EntityFallingBlock(entity.field_70170_p);
                entity1.func_70020_e(entity.func_189511_e(new NBTTagCompound()));
                entity.field_70170_p.func_72973_f((Entity)entity);
                entity1.field_70170_p.func_72838_d((Entity)entity1);
                list.add(entity1);
                iter.remove();
            }
            this.toMove = list;
        }

        public void move(double mX, double mY, double mZ) {
            if (!this.toMove.isEmpty()) {
                this.motionX = mX;
                this.motionY = mY;
                this.motionZ = mZ;
                if (this.toMove.get((int)0).field_145812_b == 0) {
                    return;
                }
                this.someSetup();
                double dX = mX;
                double dY = mY;
                double dZ = mZ;
                this.collidedBlocks.clear();
                this.collidedAABB.clear();
                for (EntityFallingBlock entity : this.toMove) {
                    AxisAlignedBB aabb = entity.func_174813_aQ().func_72321_a(mX, mY, mZ);
                    List list1 = entity.field_70170_p.func_184144_a(null, aabb);
                    ProcedureUtils.CollisionHelper stat = new ProcedureUtils.CollisionHelper((Entity)entity);
                    stat.collideWithAABBs(list1, mX, mY, mZ);
                    this.addToCollidedBlocks(BlocksMoveHelper.convert2BlockposList(list1));
                    dX = stat.minX(dX);
                    dY = stat.minY(dY);
                    dZ = stat.minZ(dZ);
                    List list2 = entity.field_70170_p.func_175647_a(EntityFallingBlock.class, aabb, (Predicate)new Predicate<Entity>(){

                        public boolean apply(@Nullable Entity p_apply_1_) {
                            return p_apply_1_ != null && !toMove.contains(p_apply_1_);
                        }
                    });
                    ProcedureUtils.CollisionHelper stat2 = new ProcedureUtils.CollisionHelper((Entity)entity);
                    List<AxisAlignedBB> list3 = BlocksMoveHelper.convert2BoundingboxList(list2);
                    stat2.collideWithAABBs(list3, mX, mY, mZ);
                    this.addToCollidedAABB(list3);
                    dX = stat2.minX(dX);
                    dY = stat2.minY(dY);
                    dZ = stat2.minZ(dZ);
                }
                for (EntityFallingBlock entity : this.toMove) {
                    entity.func_174826_a(entity.func_174813_aQ().func_72317_d(dX, dY, dZ));
                    entity.func_174829_m();
                    List list2 = entity.field_70170_p.func_175674_a(null, entity.func_174813_aQ(), NOT_FALLINGBLOCK);
                    for (Entity entity1 : list2) {
                        BlocksMoveHelper.collideWithEntity((Entity)entity, entity1, new Vec3d(dX, dY, dZ));
                    }
                    this.collidedEntities.addAll(list2);
                }
                this.boundingBox = this.boundingBox.func_72317_d(dX, dY, dZ);
                this.collided = mX != dX || mY != dY || mZ != dZ;
                this.canMoveThrough = true;
                if (this.collided) {
                    this.canMoveThrough = this.collidedBlocks.size() + this.collidedAABB.size() < this.toMove.size() / 5;
                }
            }
        }

        public float destroyHardness() {
            return MathHelper.func_76131_a((float)MathHelper.func_76129_c((float)this.toMove.size()), (float)0.5f, (float)50.0f);
        }

        public double velocity() {
            return new Vec3d(this.motionX, this.motionY, this.motionZ).func_72433_c();
        }

        public int mass() {
            return this.toMove.size();
        }

        public float collisionForce() {
            return (float)(this.velocity() * (double)this.mass());
        }

        @Nullable
        public static EnumFacing getCollidingSide(AxisAlignedBB aabb1, AxisAlignedBB aabb2) {
            if (aabb1.func_72326_a(aabb2)) {
                AxisAlignedBB aabbI = aabb1.func_191500_a(aabb2);
                return aabbI.field_72340_a == aabb1.field_72340_a ? EnumFacing.WEST : (aabbI.field_72336_d == aabb1.field_72336_d ? EnumFacing.EAST : (aabbI.field_72339_c == aabb1.field_72339_c ? EnumFacing.NORTH : (aabbI.field_72334_f == aabb1.field_72334_f ? EnumFacing.SOUTH : (aabbI.field_72338_b == aabb1.field_72338_b ? EnumFacing.DOWN : (aabbI.field_72337_e == aabb1.field_72337_e ? EnumFacing.UP : null)))));
            }
            return null;
        }

        public static EnumFacing collideWithEntity(Entity entity, Entity target, Vec3d entityMotion) {
            AxisAlignedBB bb = entity.func_174813_aQ();
            EnumFacing hitFace = BlocksMoveHelper.getCollidingSide(bb, target.func_174813_aQ());
            if (hitFace == EnumFacing.UP && target.field_70181_x - entityMotion.field_72448_b < 0.0) {
                target.func_70107_b(target.field_70165_t, bb.field_72337_e, target.field_70161_v);
                ProcedureUtils.setVelocity(target, target.field_70159_w, 0.0, target.field_70179_y);
                target.field_70122_E = true;
            } else if (hitFace == EnumFacing.WEST) {
                double d = (entityMotion.field_72450_a - target.field_70159_w) * 0.1;
                target.func_70107_b(bb.field_72340_a - (double)(target.field_70130_N / 2.0f) + d, target.field_70163_u, target.field_70161_v);
                ProcedureUtils.setVelocity(target, d, target.field_70181_x, target.field_70179_y);
            } else if (hitFace == EnumFacing.EAST) {
                double d = (entityMotion.field_72450_a - target.field_70159_w) * 0.1;
                target.func_70107_b(bb.field_72336_d + (double)(target.field_70130_N / 2.0f) + d, target.field_70163_u, target.field_70161_v);
                ProcedureUtils.setVelocity(target, d, target.field_70181_x, target.field_70179_y);
            } else if (hitFace == EnumFacing.NORTH) {
                double d = (entityMotion.field_72449_c - target.field_70179_y) * 0.1;
                target.func_70107_b(target.field_70165_t, target.field_70163_u, bb.field_72339_c - (double)(target.field_70130_N / 2.0f) + d);
                ProcedureUtils.setVelocity(target, target.field_70159_w, target.field_70181_x, d);
            } else if (hitFace == EnumFacing.SOUTH) {
                double d = (entityMotion.field_72449_c - target.field_70179_y) * 0.1;
                target.func_70107_b(target.field_70165_t, target.field_70163_u, bb.field_72334_f + (double)(target.field_70130_N / 2.0f) + d);
                ProcedureUtils.setVelocity(target, target.field_70159_w, target.field_70181_x, d);
            } else if (hitFace == EnumFacing.DOWN && !target.field_70122_E) {
                double d = (entityMotion.field_72448_b - target.field_70181_x) * 0.8;
                target.func_70107_b(target.field_70165_t, bb.field_72338_b - (double)target.field_70131_O + d, target.field_70161_v);
                ProcedureUtils.setVelocity(target, target.field_70159_w, d, target.field_70179_y);
            }
            return hitFace;
        }

        public static EnumFacing collideWithEntity(Entity entity, Entity target) {
            return BlocksMoveHelper.collideWithEntity(entity, target, ProcedureUtils.getMotion(entity));
        }

        public void fall() {
            if (!this.toMove.isEmpty()) {
                for (int i = this.toMove.size() - 1; i >= 0; --i) {
                    this.toMove.get(i).func_189654_d(false);
                }
            }
        }

        public AxisAlignedBB getBoundingBox() {
            return this.boundingBox;
        }

        public List<Entity> getCollidedEntities() {
            return this.collidedEntities;
        }

        public List<BlockPos> getCollidedBlocks() {
            return this.collidedBlocks;
        }

        public static float getBlocksTotalResistance(World world, List<BlockPos> list) {
            float resistance = 0.0f;
            for (BlockPos pos : list) {
                resistance += world.func_180495_p(pos).func_177230_c().func_149638_a(null);
            }
            return resistance;
        }

        public static List<BlockPos> convert2BlockposList(List<AxisAlignedBB> list) {
            ArrayList newlist = Lists.newArrayList();
            for (AxisAlignedBB aabb : list) {
                newlist.add(new BlockPos(ProcedureUtils.BB.getCenter(aabb)));
            }
            return newlist;
        }

        public static List<AxisAlignedBB> convert2BoundingboxList(List<Entity> list) {
            ArrayList newlist = Lists.newArrayList();
            for (Entity entity : list) {
                newlist.add(entity.func_174813_aQ());
            }
            return newlist;
        }

        private void addToCollidedBlocks(List<BlockPos> list) {
            for (BlockPos pos : list) {
                boolean flag = false;
                for (BlockPos pos2 : this.collidedBlocks) {
                    if (!pos.equals((Object)pos2)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                this.collidedBlocks.add(pos);
            }
        }

        private void addToCollidedAABB(List<AxisAlignedBB> list) {
            for (AxisAlignedBB aabb : list) {
                boolean flag = false;
                for (AxisAlignedBB aabb1 : this.collidedAABB) {
                    if (!aabb.equals((Object)aabb1)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                this.collidedAABB.add(aabb);
            }
        }

        public String toString() {
            return "-- collided:" + this.collided + ", cMT:" + this.canMoveThrough + ", motion:(" + this.motionX + "," + this.motionY + "," + this.motionZ + "), bb:" + this.boundingBox;
        }
    }

    public static class Base
    extends Entity {
        private List<? extends BlockPos> ogList;
        private final Map<Vec3d, IBlockState> blocksMap = Maps.newHashMap();
        private final Map<Entity, Vec3d> entityMap = Maps.newHashMap();
        private int fallTime = 600;
        private int ticksAlive;
        protected int fallTicks;
        private int blocksTotal;
        private boolean breakOnImpact;

        public Base(World world) {
            super(world);
            this.field_70178_ae = true;
        }

        public Base(World world, List<? extends BlockPos> list) {
            this(world);
            if (list.isEmpty()) {
                return;
            }
            AxisAlignedBB aabb = new AxisAlignedBB(list.get(0));
            for (BlockPos blockPos : list) {
                double d1;
                double d0;
                double d = (double)blockPos.func_177958_n() < aabb.field_72340_a ? -1.0 : (d0 = (double)blockPos.func_177958_n() + 1.0 > aabb.field_72336_d ? 1.0 : 0.0);
                double d2 = (double)blockPos.func_177956_o() < aabb.field_72338_b ? -1.0 : (d1 = (double)blockPos.func_177956_o() + 1.0 > aabb.field_72337_e ? 1.0 : 0.0);
                double d22 = (double)blockPos.func_177952_p() < aabb.field_72339_c ? -1.0 : ((double)blockPos.func_177952_p() + 1.0 > aabb.field_72334_f ? 1.0 : 0.0);
                aabb = aabb.func_72321_a(d0, d1, d22);
            }
            this.func_70105_a((float)Math.max(aabb.field_72336_d - aabb.field_72340_a, aabb.field_72334_f - aabb.field_72339_c), (float)(aabb.field_72337_e - aabb.field_72338_b));
            this.func_70107_b(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) / 2.0, aabb.field_72338_b, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) / 2.0);
            for (BlockPos blockPos : list) {
                IBlockState blockstate = this.field_70170_p.func_180495_p(blockPos);
                if (this.isAirOrLiquid(blockstate, blockPos)) continue;
                Vec3d vec = new Vec3d((Vec3i)blockPos).func_72441_c(0.5, 0.0, 0.5).func_178788_d(this.func_174791_d());
                this.blocksMap.put(vec, blockstate);
            }
            this.blocksTotal = this.blocksMap.size();
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())) {
                AxisAlignedBB bb = this.func_174813_aQ().func_191500_a(entity.func_174813_aQ());
                if (!(this.getBBVolume(bb) > this.getBBVolume(entity.func_174813_aQ()) * 0.66667)) continue;
                this.entityMap.put(entity, entity.func_174791_d().func_178788_d(this.func_174791_d()));
            }
            this.ogList = new ArrayList<BlockPos>(list);
        }

        private boolean isAirOrLiquid(IBlockState blockstate, BlockPos pos) {
            return blockstate.func_177230_c().isAir(blockstate, (IBlockAccess)this.field_70170_p, pos) || blockstate.func_185904_a().func_76224_d();
        }

        protected void func_70088_a() {
        }

        private Vec3d getCenter() {
            AxisAlignedBB bb = this.func_174813_aQ();
            return new Vec3d(bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) * 0.5, bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) * 0.5, bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) * 0.5);
        }

        public boolean func_70067_L() {
            return true;
        }

        public boolean func_70104_M() {
            return false;
        }

        public AxisAlignedBB func_70046_E() {
            return this.func_174813_aQ();
        }

        public void setFallTime(int ticks) {
            this.fallTime = ticks;
        }

        public void explodeOnImpact(boolean explode) {
            this.breakOnImpact = explode;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (!this.field_70170_p.field_72995_K && amount > 3.0f * (float)this.mass()) {
                this.breakOnImpact = true;
                this.onImpact(amount);
                return true;
            }
            return false;
        }

        public void func_70108_f(Entity entityIn) {
            EnumFacing hitface;
            if (!entityIn.field_70145_X && !entityIn.func_184207_aI() && (hitface = BlocksMoveHelper.getCollidingSide(this.func_70046_E(), entityIn.func_174813_aQ())) != null) {
                if (hitface == EnumFacing.UP) {
                    if (this.field_70181_x > 0.0) {
                        entityIn.func_70107_b(entityIn.field_70165_t, this.func_70046_E().field_72337_e, entityIn.field_70161_v);
                    }
                } else if (!this.entityMap.containsKey(entityIn) && (this.getVelocity() > 0.4 || hitface == EnumFacing.DOWN && entityIn.field_70122_E)) {
                    entityIn.func_70097_a(DamageSource.field_82729_p, this.getCollisionDamage());
                }
            }
        }

        private Vec3d getMotion() {
            return new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }

        private double getVelocity() {
            return this.getMotion().func_72433_c();
        }

        private float collisionForce() {
            return (float)(this.getVelocity() * (double)this.mass());
        }

        private float getCollisionDamage() {
            return this.collisionForce() * 0.5f;
        }

        private int mass() {
            return this.blocksTotal;
        }

        private double getBBVolume(AxisAlignedBB bb) {
            return (bb.field_72336_d - bb.field_72340_a) * (bb.field_72337_e - bb.field_72338_b) * (bb.field_72334_f - bb.field_72339_c);
        }

        public Map<Vec3d, IBlockState> getBlocksMap() {
            return this.blocksMap;
        }

        public List<? extends BlockPos> getBlockposList() {
            return this.ogList;
        }

        public boolean griefingAllowed() {
            return ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, null);
        }

        public int getTicksAlive() {
            return this.ticksAlive;
        }

        @SideOnly(value=Side.CLIENT)
        public void handleServerPacket(ProcedureSync.SPacketEarthBlocks packet) {
            this.blocksTotal = packet.blocks;
            this.blocksMap.put(new Vec3d(packet.x, packet.y, packet.z), Block.func_176220_d((int)packet.state));
        }

        public void handleClientPacket(EntityPlayerMP player, ProcedureSync.CPacketEarthBlocks packet) {
            if (packet.op == 0) {
                for (Map.Entry<Vec3d, IBlockState> entry : this.blocksMap.entrySet()) {
                    ProcedureSync.SPacketEarthBlocks.sendToPlayer(player, this, this.blocksTotal, entry.getKey(), entry.getValue());
                }
                ProcedureSync.ResetBoundingBox.sendToPlayer(this, player);
            } else if (packet.op == 1) {
                this.onImpact(packet.amount);
            }
        }

        public void func_70071_h_() {
            if (this.blocksMap.isEmpty() && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            } else {
                if (this.blocksMap.isEmpty() && this.field_70148_d) {
                    ProcedureSync.CPacketEarthBlocks.sendToServer(0, this);
                }
                ++this.ticksAlive;
                this.field_70169_q = this.field_70165_t;
                this.field_70167_r = this.field_70163_u;
                this.field_70166_s = this.field_70161_v;
                boolean flag = this.griefingAllowed();
                if (!this.field_70170_p.field_72995_K) {
                    BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
                    for (Map.Entry<Vec3d, IBlockState> entry : this.blocksMap.entrySet()) {
                        Vec3d vec = this.func_174791_d().func_178787_e(entry.getKey());
                        pos.func_189532_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                        if (this.ticksAlive < 15 || this.field_70146_Z.nextInt(this.ticksAlive) == 0) {
                            ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, 0.5 + (double)pos.func_177958_n(), 0.5 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), 5, 0.2, 0.2, 0.2, this.ticksAlive > 15 ? 0.0 : 0.15, new int[]{Block.func_149682_b((Block)entry.getValue().func_177230_c())});
                        }
                        if (!flag || this.ticksAlive != 1 || this.field_70170_p.func_180495_p((BlockPos)pos).func_177230_c() != entry.getValue().func_177230_c()) continue;
                        this.field_70170_p.func_175698_g((BlockPos)pos);
                    }
                    pos.func_185344_t();
                }
                if (!this.func_189652_ae()) {
                    this.field_70181_x -= 0.04;
                    ++this.fallTicks;
                } else if (!this.field_70170_p.field_72995_K && this.ticksAlive > this.fallTime) {
                    this.func_189654_d(false);
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                for (Map.Entry<Entity, Vec3d> entry : this.entityMap.entrySet()) {
                    Vec3d vec = this.func_174791_d().func_178787_e(entry.getValue());
                    entry.getKey().func_70634_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
                for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_70046_E())) {
                    this.func_70108_f(entity);
                }
                if (this.field_70122_E && !this.func_189652_ae()) {
                    this.onImpact(this.collisionForce());
                }
                this.field_70159_w *= 0.98;
                this.field_70181_x *= 0.98;
                this.field_70179_y *= 0.98;
            }
            this.field_70148_d = false;
        }

        public void func_70091_d(MoverType type, double x, double y, double z) {
            if (type != MoverType.SELF) {
                return;
            }
            double dx = x;
            double dy = y;
            double dz = z;
            List list = this.field_70170_p.func_184144_a((Entity)this, this.func_70046_E().func_72321_a(x, y, z));
            ProcedureUtils.CollisionHelper ch = new ProcedureUtils.CollisionHelper(this);
            ch.collideWithAABBs(list, x, y, z);
            x = ch.minX(x);
            y = ch.minY(y);
            z = ch.minZ(z);
            this.func_174826_a(this.func_174813_aQ().func_72317_d(x, y, z));
            this.func_174829_m();
            this.field_70123_F = dx != x || dz != z;
            this.field_70124_G = dy != y;
            boolean bl = this.field_70132_H = this.field_70123_F || this.field_70124_G;
            if (!this.field_70170_p.field_72995_K) {
                boolean canMoveThrough = true;
                if (dx != x || dy != y || dz != z) {
                    List<BlockPos> list1 = ch.getHitBlocks();
                    float f = BlocksMoveHelper.getBlocksTotalResistance(this.field_70170_p, list1);
                    float hitarea = f / this.collisionForce() * 0.2f;
                    canMoveThrough = this.ticksAlive > 20 ? f < 1000.0f && hitarea < 1.0f : true;
                    double d = MathHelper.func_151237_a((double)(1.0 - (double)hitarea), (double)0.0, (double)0.8);
                    this.field_70159_w *= d;
                    this.field_70181_x *= d;
                    this.field_70179_y *= d;
                    if (canMoveThrough && !this.field_70170_p.field_72995_K) {
                        for (BlockPos pos : list1) {
                            ProcedureUtils.breakBlockAndDropWithChance(this.field_70170_p, pos, this.destroyHardness(), this.collisionForce() * 0.1f, 0.3f, false);
                        }
                    }
                }
                this.field_70122_E = this.field_70124_G && dy < 0.0 && (!canMoveThrough || !this.griefingAllowed());
                ProcedureSync.EntityState.sendToTracking(this);
            }
        }

        private float destroyHardness() {
            return MathHelper.func_76131_a((float)MathHelper.func_76129_c((float)this.mass()), (float)5.0f, (float)50.0f);
        }

        private boolean containsUnbreakableBlocks(List<AxisAlignedBB> list) {
            for (AxisAlignedBB aabb : list) {
                BlockPos pos = new BlockPos(ProcedureUtils.BB.getCenter(aabb));
                IBlockState blockstate = this.field_70170_p.func_180495_p(pos);
                float hardness = blockstate.func_185887_b(this.field_70170_p, pos);
                if (!(hardness < 0.0f) && !(hardness > this.destroyHardness())) continue;
                return true;
            }
            return false;
        }

        protected void onImpact(float impactDamage) {
            if (this.field_70170_p.field_72995_K) {
                ProcedureSync.CPacketEarthBlocks.sendToServer(1, this, impactDamage);
            } else {
                for (Map.Entry<Entity, Vec3d> entry : this.entityMap.entrySet()) {
                    entry.getKey().func_70097_a(DamageSource.field_82729_p, this.getCollisionDamage());
                }
                boolean flag = this.griefingAllowed();
                impactDamage = MathHelper.func_76129_c((float)impactDamage) * 0.002236f;
                BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
                for (Map.Entry<Vec3d, IBlockState> entry : this.blocksMap.entrySet()) {
                    Vec3d vec = this.func_174791_d().func_178787_e(entry.getKey());
                    vec = new Vec3d((Vec3i)pos.func_189532_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)).func_72441_c(0.5, 0.0, 0.5);
                    if (this.breakOnImpact) {
                        if (!(this.field_70146_Z.nextFloat() <= 0.3f)) continue;
                        this.field_70170_p.func_180501_a((BlockPos)pos, entry.getValue(), 3);
                        EntityFallingBlock entity = new EntityFallingBlock(this.field_70170_p, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, entry.getValue());
                        this.field_70170_p.func_72838_d((Entity)entity);
                        entity.field_70159_w = entry.getKey().field_72450_a * (this.field_70146_Z.nextDouble() * 0.2 + (double)impactDamage);
                        entity.field_70181_x = entry.getKey().field_72448_b * (this.field_70146_Z.nextDouble() * 0.2 + (double)impactDamage);
                        entity.field_70179_y = entry.getKey().field_72449_c * (this.field_70146_Z.nextDouble() * 0.2 + (double)impactDamage);
                        ReflectionHelper.setPrivateValue(EntityFallingBlock.class, (Object)entity, (Object)(!flag ? 1 : 0), (int)3);
                        continue;
                    }
                    ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.BLOCK_DUST, vec.field_72450_a, vec.field_72448_b + 0.5, vec.field_72449_c, 50, 0.2, 0.2, 0.2, 0.2, new int[]{Block.func_149682_b((Block)entry.getValue().func_177230_c())});
                    if (!flag) continue;
                    this.field_70170_p.func_180501_a((BlockPos)pos, entry.getValue(), 3);
                }
                pos.func_185344_t();
                this.blocksMap.clear();
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
            NBTTagCompound nbttagcompound;
            int i;
            NBTTagList nbttaglist;
            this.ticksAlive = compound.func_74762_e("ticksAlive");
            this.fallTime = compound.func_74762_e("fallTime");
            this.func_70105_a(compound.func_74760_g("width"), compound.func_74760_g("height"));
            if (compound.func_150297_b("blocksMap", 9)) {
                nbttaglist = compound.func_150295_c("blocksMap", 10);
                this.blocksTotal = nbttaglist.func_74745_c();
                for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    nbttagcompound = nbttaglist.func_150305_b(i);
                    this.blocksMap.put(new Vec3d(nbttagcompound.func_74769_h("vecX"), nbttagcompound.func_74769_h("vecY"), nbttagcompound.func_74769_h("vecZ")), Block.func_176220_d((int)nbttagcompound.func_74762_e("blockstate")));
                }
            }
            if (compound.func_150297_b("entityMap", 9)) {
                nbttaglist = compound.func_150295_c("entityMap", 10);
                for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    nbttagcompound = nbttaglist.func_150305_b(i);
                    Entity entity = ((WorldServer)this.field_70170_p).func_175733_a(nbttagcompound.func_186857_a("entityUUID"));
                    if (entity == null) continue;
                    this.entityMap.put(entity, new Vec3d(nbttagcompound.func_74769_h("vecX"), nbttagcompound.func_74769_h("vecY"), nbttagcompound.func_74769_h("vecZ")));
                }
            }
        }

        protected void func_70014_b(NBTTagCompound compound) {
            compound.func_74768_a("ticksAlive", this.ticksAlive);
            compound.func_74768_a("fallTime", this.fallTime);
            compound.func_74776_a("width", this.field_70130_N);
            compound.func_74776_a("height", this.field_70131_O);
            NBTTagList nbttaglist = new NBTTagList();
            for (Map.Entry<Vec3d, IBlockState> entry : this.blocksMap.entrySet()) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74780_a("vecX", entry.getKey().field_72450_a);
                nbttagcompound.func_74780_a("vecY", entry.getKey().field_72448_b);
                nbttagcompound.func_74780_a("vecZ", entry.getKey().field_72449_c);
                nbttagcompound.func_74768_a("blockstate", Block.func_176210_f((IBlockState)entry.getValue()));
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            if (!nbttaglist.func_82582_d()) {
                compound.func_74782_a("blocksMap", (NBTBase)nbttaglist);
            }
            NBTTagList nbttaglist2 = new NBTTagList();
            for (Map.Entry<Entity, Vec3d> entry : this.entityMap.entrySet()) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_186854_a("entityUUID", entry.getKey().func_110124_au());
                nbttagcompound.func_74780_a("vecX", entry.getValue().field_72450_a);
                nbttagcompound.func_74780_a("vecY", entry.getValue().field_72448_b);
                nbttagcompound.func_74780_a("vecZ", entry.getValue().field_72449_c);
                nbttaglist2.func_74742_a((NBTBase)nbttagcompound);
            }
            if (!nbttaglist2.func_82582_d()) {
                compound.func_74782_a("entityMap", (NBTBase)nbttaglist2);
            }
        }
    }
}

