/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.PlayerTracker;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureRenderView;
import net.narutomod.procedure.ProcedureSync;

@ElementsNarutomodMod.ModElement.Tag
public class EntityEightTrigrams
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 56;
    public static final int ENTITYID_RANGED = 57;
    private static final int VIEW_DISTANCE = 2;

    public EntityEightTrigrams(ElementsNarutomodMod instance) {
        super(instance, 260);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "eighttrigramsentity"), 56).name("eighttrigramsentity").tracker(64, 1, true).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EntityCustom.AttackHook());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderEightTrigrams(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelEightTrigrams
        extends ModelBase {
            private final ModelRenderer bb_main;

            public ModelEightTrigrams() {
                this.field_78090_t = 64;
                this.field_78089_u = 16;
                this.bb_main = new ModelRenderer((ModelBase)this);
                this.bb_main.func_78793_a(0.0f, 0.0f, 0.0f);
                this.bb_main.field_78804_l.add(new ModelBox(this.bb_main, 0, 0, -8.0f, 0.0f, -8.0f, 16, 0, 16, 0.0f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                this.bb_main.func_78785_a(f5);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderEightTrigrams
        extends Render<EntityCustom> {
            private final ResourceLocation texture;
            protected ModelBase mainModel;

            public RenderEightTrigrams(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.texture = new ResourceLocation("narutomod:textures/eight_trigrams.png");
                this.mainModel = new ModelEightTrigrams();
            }

            public boolean shouldRender(EntityCustom livingEntity, ICamera camera, double camX, double camY, double camZ) {
                return true;
            }

            public void doRender(EntityCustom entity, double x, double y, double z, float entityYaw, float partialTicks) {
                this.func_180548_c(entity);
                GlStateManager.func_179094_E();
                GlStateManager.func_179129_p();
                GlStateManager.func_179137_b((double)x, (double)(y + (double)0.1f), (double)(z - (double)0.4f));
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179140_f();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.mainModel.func_78088_a((Entity)entity, 0.0f, 0.0f, partialTicks + (float)entity.field_70173_aa, 0.0f, 0.0f, 1.0f);
                GlStateManager.func_179145_e();
                GlStateManager.func_179084_k();
                GlStateManager.func_179118_c();
                GlStateManager.func_179089_o();
                GlStateManager.func_179121_F();
                super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
            }

            protected ResourceLocation getEntityTexture(EntityCustom entity) {
                return this.texture;
            }
        }
    }

    public static class EntityCustom
    extends Entity
    implements ProcedureSync.RenderDistance.IHandler {
        private static final String JUTSUACTIVEKEY = "HakkeRokujuuyonshouActive";
        private EntityLivingBase ownerPlayer;
        private boolean canDie;
        private final Map<EntityPlayer, Integer> pMap = Maps.newHashMap();
        public final double effectRadius;
        public final int effectDuration;

        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(0.1f, 0.1f);
            this.field_70178_ae = true;
            this.field_70158_ak = true;
            this.func_184224_h(true);
            this.canDie = false;
            this.ownerPlayer = null;
            this.effectRadius = 16.0;
            this.effectDuration = 240;
        }

        public EntityCustom(EntityLivingBase userIn) {
            this(userIn.field_70170_p);
            this.setOwnerPlayer(userIn);
            this.func_70012_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v, 0.0f, 0.0f);
        }

        protected void func_70088_a() {
        }

        public EntityLivingBase getOwnerPlayer() {
            return this.ownerPlayer;
        }

        public void setOwnerPlayer(EntityLivingBase player) {
            this.ownerPlayer = player;
            player.getEntityData().func_74757_a(JUTSUACTIVEKEY, true);
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            return false;
        }

        public void func_70106_y() {
            if (this.canDie) {
                if (this.ownerPlayer != null) {
                    this.ownerPlayer.getEntityData().func_82580_o(JUTSUACTIVEKEY);
                }
                super.func_70106_y();
            }
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70173_aa == 2) {
                    for (EntityPlayer entityPlayer : this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(this.effectRadius))) {
                        if (this.pMap.containsKey(entityPlayer)) continue;
                        ProcedureRenderView.changeFog((Entity)entityPlayer, 1.0, 100, 0, 0.0f, 0.0f, 0.0f, 0.0f);
                        ProcedureSync.RenderDistance.sendToSelf((EntityPlayerMP)entityPlayer, 2, this);
                    }
                }
                if (this.field_70173_aa > 3 && this.field_70173_aa < 20) {
                    ProcedureAoeCommand.set(this, 0.0, this.effectRadius).exclude((Entity)this.ownerPlayer).effect(MobEffects.field_76421_d, 15, 4).effect(MobEffects.field_76437_t, 15, 255).effect(MobEffects.field_76419_f, 15, 5);
                }
                if (this.ownerPlayer instanceof EntityPlayer) {
                    ((EntityPlayer)this.ownerPlayer).func_146105_b((ITextComponent)new TextComponentString(I18n.func_74838_a((String)"tooltip.byakugan.jutsu2")), true);
                    if (this.field_70173_aa % 40 == 4) {
                        this.ownerPlayer.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 50, (int)(PlayerTracker.getNinjaLevel((EntityPlayer)this.ownerPlayer) + (double)this.field_70173_aa) / 30));
                        this.ownerPlayer.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 50, 3));
                    }
                }
                if (this.field_70173_aa == 100) {
                    for (Map.Entry entry : this.pMap.entrySet()) {
                        ProcedureSync.RenderDistance.sendToSelf((EntityPlayerMP)entry.getKey(), (Integer)entry.getValue(), null);
                    }
                }
            }
            if (this.field_70173_aa > this.effectDuration || !this.field_70170_p.field_72995_K && (this.ownerPlayer == null || !this.ownerPlayer.func_70089_S())) {
                this.canDie = true;
                this.func_70106_y();
            }
        }

        private void resetRenderDistance(EntityPlayer player) {
            if (!this.field_70170_p.field_72995_K && this.pMap.containsKey(player)) {
                ProcedureSync.RenderDistance.sendToSelf((EntityPlayerMP)player, this.pMap.get(player), null);
                this.pMap.remove(player);
            }
        }

        @Override
        public void handleClientPacket(EntityPlayer player, int oldChunkDistance) {
            this.pMap.put(player, oldChunkDistance);
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class AttackHook {
            @SubscribeEvent
            public void onAttacked(LivingHurtEvent event) {
                Entity source = event.getSource().func_76364_f();
                if (source != null && source.getEntityData().func_74767_n(EntityCustom.JUTSUACTIVEKEY)) {
                    Chakra.pathway(event.getEntityLiving()).consume(0.125f);
                    event.getEntityLiving().getEntityData().func_74757_a("TempData_disableKnockback", true);
                }
            }

            @SubscribeEvent
            public void onLivingDeath(LivingDeathEvent event) {
                EntityCustom jutsuEntity;
                Entity entity = event.getEntity();
                if (entity instanceof EntityPlayer && (jutsuEntity = (EntityCustom)entity.field_70170_p.func_72857_a(EntityCustom.class, entity.func_174813_aQ().func_186662_g(32.0), entity)) != null) {
                    jutsuEntity.resetRenderDistance((EntityPlayer)entity);
                }
            }
        }
    }
}

