/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.item.ItemJutsu;

@ElementsNarutomodMod.ModElement.Tag
public class EntityEnhancedStrength
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 215;
    public static final int ENTITYID_RANGED = 216;

    public EntityEnhancedStrength(ElementsNarutomodMod instance) {
        super(instance, 528);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "enhanced_strength"), 215).name("enhanced_strength").tracker(64, 3, true).build());
    }

    public static class EC
    extends Entity {
        private EntityLivingBase user;
        private ItemStack enchantedTool = ItemStack.field_190927_a;
        private int ogEnchantmentLevel = 0;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase userIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
        }

        protected void func_70088_a() {
        }

        private void removeEfficiencyEnhancement() {
            Map map = EnchantmentHelper.func_82781_a((ItemStack)this.enchantedTool);
            if (map.containsKey(Enchantments.field_185305_q)) {
                int slot = this.getSlotFor(this.enchantedTool);
                System.out.println(">>> in slot: " + slot);
                if (this.ogEnchantmentLevel > 0) {
                    map.put(Enchantments.field_185305_q, this.ogEnchantmentLevel);
                } else {
                    map.remove(Enchantments.field_185305_q);
                }
                EnchantmentHelper.func_82782_a((Map)map, (ItemStack)this.enchantedTool);
                if (slot >= 0) {
                    ((EntityPlayer)this.user).field_71071_by.func_70299_a(slot, this.enchantedTool);
                }
            }
        }

        private void incEfficiencyEnchantment() {
            Map map = EnchantmentHelper.func_82781_a((ItemStack)this.enchantedTool);
            this.ogEnchantmentLevel = map.containsKey(Enchantments.field_185305_q) ? (Integer)map.get(Enchantments.field_185305_q) : 0;
            map.put(Enchantments.field_185305_q, this.ogEnchantmentLevel + 1);
            EnchantmentHelper.func_82782_a((Map)map, (ItemStack)this.enchantedTool);
        }

        private boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
            return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
        }

        private int getSlotFor(ItemStack stack) {
            if (this.user instanceof EntityPlayer) {
                int i = 0;
                for (ItemStack stack1 : ((EntityPlayer)this.user).field_71071_by.field_70462_a) {
                    if (!stack1.func_190926_b() && this.stackEqualExact(stack, stack1)) {
                        return i;
                    }
                    ++i;
                }
                for (ItemStack stack1 : ((EntityPlayer)this.user).field_71071_by.field_70460_b) {
                    if (!stack1.func_190926_b() && this.stackEqualExact(stack, stack1)) {
                        return i;
                    }
                    ++i;
                }
                for (ItemStack stack1 : ((EntityPlayer)this.user).field_71071_by.field_184439_c) {
                    if (!stack1.func_190926_b() && this.stackEqualExact(stack, stack1)) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        public void func_70071_h_() {
            if (this.user != null) {
                ItemStack stack;
                this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                if (this.field_70173_aa % 4 == 0 && !ItemStack.func_77989_b((ItemStack)(stack = this.user.func_184614_ca()), (ItemStack)this.enchantedTool)) {
                    if (!this.enchantedTool.func_190926_b()) {
                        this.removeEfficiencyEnhancement();
                        this.enchantedTool = ItemStack.field_190927_a;
                    }
                    if (!stack.func_190926_b()) {
                        this.enchantedTool = stack;
                        this.incEfficiencyEnchantment();
                    }
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "IryoEnhancedStrengthEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                Entity entity1 = entity.field_70170_p.func_73045_a(entity.getEntityData().func_74762_e(ID_KEY));
                if (entity1 instanceof EC) {
                    entity1.func_70106_y();
                    return false;
                }
                entity1 = new EC(entity);
                entity.field_70170_p.func_72838_d(entity1);
                entity.getEntityData().func_74768_a(ID_KEY, entity1.func_145782_y());
                return true;
            }
        }
    }
}

