/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.vecmath.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.entity.EntityParticle;
import net.narutomod.item.ItemJutsu;

@ElementsNarutomodMod.ModElement.Tag
public class EntityFirestream
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 421;
    public static final int ENTITYID_RANGED = 422;

    public EntityFirestream(ElementsNarutomodMod instance) {
        super(instance, 844);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "firestream"), 421).name("firestream").tracker(64, 3, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(FlameParticle.class).id(new ResourceLocation("narutomod", "fireparticle"), 422).name("fireparticle").tracker(64, 3, true).build());
    }

    public static class FlameParticle
    extends EntityParticle.Base {
        private EntityLivingBase shooter;
        private float damage;

        public FlameParticle(World w) {
            super(w);
        }

        public FlameParticle(EntityLivingBase shooterIn, double x, double y, double z, double mX, double mY, double mZ, int color, float scale, float damageIn) {
            super(shooterIn.field_70170_p, x, y, z, mX, mY, mZ, color, scale, 0);
            this.setMaxAge((int)(8.0 / (this.field_70146_Z.nextDouble() * 0.8 + 0.2)) + 4);
            this.shooter = shooterIn;
            this.damage = damageIn;
        }

        @Override
        public void func_70071_h_() {
            RayTraceResult res;
            int age = this.getAge();
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (age > this.getMaxAge()) {
                this.onDeath();
            }
            this.setParticleTextureOffset(age / 2 % 8);
            this.field_70181_x += 0.003;
            if (this.shooter != null && (res = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (boolean)true, (Entity)this.shooter)) != null && res.field_72313_a != RayTraceResult.Type.MISS) {
                this.onImpact(res);
            }
            this.move(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.96;
            this.field_70181_x *= 0.96;
            this.field_70179_y *= 0.96;
            if (this.field_70122_E) {
                this.field_70159_w *= 0.7;
                this.field_70179_y *= 0.7;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.setAge(++age);
            }
        }

        public void onImpact(RayTraceResult result) {
            BlockPos pos;
            int i = this.field_70146_Z.nextInt(10);
            if (result.field_72308_g != null) {
                result.field_72308_g.func_70097_a(ItemJutsu.causeJutsuDamage(this, this.shooter).func_76348_h().func_76361_j(), this.damage);
                result.field_72308_g.func_70015_d(10);
            } else if (i == 0 && this.field_70170_p.func_175623_d(pos = result.func_178782_a().func_177972_a(result.field_178784_b))) {
                this.field_70170_p.func_180501_a(pos, Blocks.field_150480_ab.func_176223_P(), 3);
            }
        }

        @Override
        protected int getTexV() {
            return 1;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_70070_b() {
            return 0xF000F0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public float getScale(float partialTicks) {
            float f = Math.min(((float)this.getAge() + partialTicks) / (float)this.getMaxAge(), 1.0f);
            float f11 = f - 0.5f;
            float f8 = 1.0f - f11 * f11 * 3.5f;
            return this.getScale() * f8;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public Vector4f getColor(float partialTicks) {
            float f = Math.min(((float)this.getAge() + partialTicks) / (float)this.getMaxAge(), 1.0f);
            float f11 = f - 0.5f;
            float f8 = 1.0f - f11 * f11 * 3.5f;
            Vector4f vec4f = this.getColor();
            return new Vector4f(vec4f.x, vec4f.y * (1.0f - f), vec4f.z, vec4f.w * f8);
        }

        @Override
        public boolean shouldDisableDepth() {
            return true;
        }
    }

    public static class EC
    extends Entity {
        private int wait = 50;
        private int maxLife = 110;
        private EntityLivingBase shooter;
        private double width;
        private double range;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase shooterIn, double widthIn, double rangeIn) {
            this(shooterIn.field_70170_p);
            this.shooter = shooterIn;
            this.setIdlePosition();
            this.width = widthIn;
            this.range = rangeIn;
        }

        protected void func_70088_a() {
        }

        protected void setIdlePosition() {
            if (this.shooter != null) {
                Vec3d vec3d = this.shooter.func_70040_Z();
                this.func_70107_b(this.shooter.field_70165_t + vec3d.field_72450_a, this.shooter.field_70163_u + (double)this.shooter.func_70047_e() + vec3d.field_72448_b - 0.2, this.shooter.field_70161_v + vec3d.field_72449_c);
            }
        }

        public void func_70071_h_() {
            if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > this.maxLife || this.func_70072_I())) {
                this.func_70106_y();
            } else {
                this.setIdlePosition();
                if (!this.field_70170_p.field_72995_K && this.field_70173_aa > this.wait) {
                    if (this.shooter != null) {
                        double d = (double)this.field_70173_aa / (double)this.maxLife;
                        d = 1.0 - d * d * 0.8;
                        this.preExecuteParticles(this.range * d, this.width * d);
                    }
                    if (this.field_70173_aa < this.maxLife - 20 && this.field_70173_aa % 10 == 1) {
                        this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:flamethrow")), 1.0f, this.field_70146_Z.nextFloat() * 0.5f + 0.6f);
                    }
                }
            }
        }

        protected void preExecuteParticles(double range, double radius) {
            double angle = Math.atan(radius / range) * 180.0 / Math.PI;
            for (int i = 0; i < (int)((double)MathHelper.func_76133_a((double)radius) * 2.5); ++i) {
                Vec3d vec3d = Vec3d.func_189986_a((float)(this.shooter.field_70125_A + (float)((this.field_70146_Z.nextDouble() - 0.5) * angle * 3.0)), (float)(this.shooter.field_70177_z + (float)((this.field_70146_Z.nextDouble() - 0.5) * angle * 3.0))).func_186678_a(range * 0.1);
                this.field_70170_p.func_72838_d((Entity)new FlameParticle(this.shooter, this.field_70165_t, this.field_70163_u, this.field_70161_v, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, -12544, (float)vec3d.func_72433_c() * 5.0f + this.field_70146_Z.nextFloat() * 2.0f, (float)range * (this.field_70146_Z.nextFloat() * 0.5f + 0.5f)));
            }
            Particles.Renderer particles = new Particles.Renderer(this.field_70170_p);
            for (int i = 0; i < (int)(range * radius * 0.8); ++i) {
                Vec3d vec3d = Vec3d.func_189986_a((float)(this.shooter.field_70125_A + (float)((this.field_70146_Z.nextDouble() - 0.5) * angle * 3.0)), (float)(this.shooter.field_70177_z + (float)((this.field_70146_Z.nextDouble() - 0.5) * angle * 3.0))).func_186678_a(range * 0.1);
                particles.spawnParticles(Particles.Types.FLAME, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1, 0.0, 0.0, 0.0, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, -12544, (int)(vec3d.func_72433_c() * 50.0) + this.field_70146_Z.nextInt(20));
            }
            particles.send();
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu2
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                EC entity1 = new EC(entity, 1.0, power);
                entity1.wait = 0;
                entity1.maxLife = (int)(power * 10.0f);
                entity.field_70170_p.func_72838_d((Entity)entity1);
                return true;
            }
        }

        public static class Jutsu1
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:katon_gokamekeku")), SoundCategory.NEUTRAL, 5.0f, 1.0f);
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, (double)power * 0.8, (double)power * 1.5));
                return true;
            }
        }
    }
}

