/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAirPunch;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityFutonGreatBreakthrough
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 187;
    public static final int ENTITYID_RANGED = 188;

    public EntityFutonGreatBreakthrough(ElementsNarutomodMod instance) {
        super(instance, 450);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "futon_great_breakthrough"), 187).name("futon_great_breakthrough").tracker(64, 3, true).build());
    }

    public static class EC
    extends Entity {
        public static final float MAX_RANGE = 64.0f;
        private final AirPunch airPunch = new AirPunch();
        private EntityLivingBase user;
        private float power;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase userIn, float powerIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.power = powerIn;
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
        }

        protected void func_70088_a() {
        }

        public void func_70071_h_() {
            if (this.user != null) {
                this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                if (this.field_70173_aa == 1) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:wind")), 1.0f, this.power * 0.2f);
                }
                this.airPunch.execute(this.user, this.power, (double)this.power * 0.25);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > (int)this.power) {
                this.func_70106_y();
            }
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_70112_a(double distance) {
            double d = 68.5 * this.func_184183_bd();
            return distance < d * d;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                return true;
            }
        }

        public static class AirPunch
        extends ProcedureAirPunch {
            public AirPunch() {
                this.particlesDuring = null;
            }

            @Override
            public void execute(EntityLivingBase player, double range, double radius) {
                this.blockHardnessLimit = (float)range / 64.0f;
                super.execute(player, range, radius);
            }

            @Override
            protected void preExecuteParticles(EntityLivingBase player) {
                Vec3d vec0 = player.func_70040_Z();
                Vec3d vec = vec0.func_186678_a(2.0).func_72441_c(player.field_70165_t, player.field_70163_u + 1.5, player.field_70161_v);
                Particles.Renderer pRender = new Particles.Renderer(player.field_70170_p);
                for (int i = 1; i <= 50; ++i) {
                    Vec3d vec1 = vec0.func_186678_a((player.func_70681_au().nextDouble() * 0.8 + 0.2) * this.getRange(0) * 0.1);
                    pRender.spawnParticles(Particles.Types.SMOKE, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1, 0.0, 0.0, 0.0, vec1.field_72450_a + (player.func_70681_au().nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, vec1.field_72448_b + (player.func_70681_au().nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, vec1.field_72449_c + (player.func_70681_au().nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, -2130706433, 80 + player.func_70681_au().nextInt(20), (int)(16.0 / (player.func_70681_au().nextDouble() * 0.8 + 0.2)));
                }
                pRender.send();
            }

            @Override
            protected void attackEntityFrom(EntityLivingBase player, Entity target) {
                ProcedureUtils.pushEntity((Entity)player, target, this.getRange(0) * 1.6, 3.0f);
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                return (1.0f - (float)(Math.sqrt(player.func_174831_c(pos)) / MathHelper.func_151237_a((double)range, (double)0.0, (double)30.0))) * 0.2f;
            }
        }
    }
}

