/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.item.ItemJutsu;

@ElementsNarutomodMod.ModElement.Tag
public class EntityHidingInAsh
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 175;
    public static final int ENTITYID_RANGED = 176;

    public EntityHidingInAsh(ElementsNarutomodMod instance) {
        super(instance, 442);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "hiding_in_ash"), 175).name("hiding_in_ash").tracker(64, 3, true).build());
    }

    public static class EC
    extends Entity {
        private static final DataParameter<Integer> USER_ID = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Float> RANGE = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final int maxLife = 110;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase userIn, double rangeIn) {
            this(userIn.field_70170_p);
            this.setUser(userIn);
            this.setRange((float)rangeIn);
            this.setIdlePosition();
            userIn.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 110, 0, false, false));
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(USER_ID, (Object)-1);
            this.func_184212_Q().func_187214_a(RANGE, (Object)Float.valueOf(1.0f));
        }

        private void setUser(EntityLivingBase shooter) {
            this.func_184212_Q().func_187227_b(USER_ID, (Object)shooter.func_145782_y());
        }

        protected EntityLivingBase getUser() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(USER_ID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        public float getRange() {
            return ((Float)this.func_184212_Q().func_187225_a(RANGE)).floatValue();
        }

        protected void setRange(float range) {
            this.func_184212_Q().func_187227_b(RANGE, (Object)Float.valueOf(range));
        }

        protected void setIdlePosition() {
            EntityLivingBase user = this.getUser();
            if (user != null) {
                Vec3d vec3d = user.func_70040_Z();
                this.func_70107_b(user.field_70165_t + vec3d.field_72450_a, user.field_70163_u + (double)user.func_70047_e() + vec3d.field_72448_b - 0.2, user.field_70161_v + vec3d.field_72449_c);
            }
        }

        public void func_70071_h_() {
            this.setIdlePosition();
            if (this.field_70170_p.field_72995_K) {
                EntityLivingBase user = this.getUser();
                float range = this.getRange();
                for (int i = 0; i < (int)(range * 10.0f); ++i) {
                    Particles.spawnParticle(this.field_70170_p, Particles.Types.BURNING_ASH, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1, 0.0, 0.0, 0.0, (double)range * (this.field_70146_Z.nextDouble() - 0.5) * 0.1, (this.field_70146_Z.nextDouble() - 0.5) * (double)range * 0.1, (double)range * (this.field_70146_Z.nextDouble() - 0.5) * 0.1, user != null ? user.func_145782_y() : -1);
                }
            }
            if (this.field_70173_aa > 110) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:hiding_in_ash")), SoundCategory.NEUTRAL, 5.0f, 1.0f);
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                return true;
            }
        }
    }
}

