/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityIceSpear;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityShieldBase;
import net.narutomod.item.ItemHyoton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureSync;

@ElementsNarutomodMod.ModElement.Tag
public class EntityIceDome
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 224;
    public static final int ENTITYID_RANGED = 225;
    private static final float ENTITY_SCALE = 8.0f;

    public EntityIceDome(ElementsNarutomodMod instance) {
        super(instance, 535);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "ice_dome"), 224).name("ice_dome").tracker(64, 3, true).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EC.LivingHook());
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new CustomRender(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelDome
        extends ModelBase {
            private final ModelRenderer dome;
            private final ModelRenderer wall;
            private final ModelRenderer bone2;
            private final ModelRenderer bone6;
            private final ModelRenderer bone3;
            private final ModelRenderer bone7;
            private final ModelRenderer bone4;
            private final ModelRenderer bone8;
            private final ModelRenderer cube_r1;
            private final ModelRenderer cube_r2;
            private final ModelRenderer roof;
            private final ModelRenderer bone10;
            private final ModelRenderer bone12;
            private final ModelRenderer bone13;
            private final ModelRenderer bone18;
            private final ModelRenderer bone16;
            private final ModelRenderer bone14;
            private final ModelRenderer bone17;
            private final ModelRenderer cube_r3;
            private final ModelRenderer cube_r4;

            public ModelDome() {
                this.field_78090_t = 16;
                this.field_78089_u = 16;
                this.dome = new ModelRenderer((ModelBase)this);
                this.dome.func_78793_a(0.0f, 0.0f, 0.0f);
                this.wall = new ModelRenderer((ModelBase)this);
                this.wall.func_78793_a(0.0f, 0.0f, 0.0f);
                this.dome.func_78792_a(this.wall);
                this.bone2 = new ModelRenderer((ModelBase)this);
                this.bone2.func_78793_a(0.0f, -8.0f, -1.5f);
                this.wall.func_78792_a(this.bone2);
                this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 0, -4.0f, 0.0f, -8.0f, 8, 8, 0, 0.0f, false));
                this.bone6 = new ModelRenderer((ModelBase)this);
                this.bone6.func_78793_a(0.0f, 0.0f, 17.7f);
                this.wall.func_78792_a(this.bone6);
                this.bone6.field_78804_l.add(new ModelBox(this.bone6, 0, 0, -4.0f, -8.0f, -8.0f, 8, 8, 0, 0.0f, false));
                this.bone3 = new ModelRenderer((ModelBase)this);
                this.bone3.func_78793_a(4.0f, -16.0f, -9.5f);
                this.wall.func_78792_a(this.bone3);
                this.setRotationAngle(this.bone3, 0.0f, -0.7854f, 0.0f);
                this.bone3.field_78804_l.add(new ModelBox(this.bone3, 0, 0, 0.0f, 8.0f, 0.0f, 8, 8, 0, 0.0f, false));
                this.bone7 = new ModelRenderer((ModelBase)this);
                this.bone7.func_78793_a(-9.6f, -8.0f, 4.1f);
                this.wall.func_78792_a(this.bone7);
                this.setRotationAngle(this.bone7, 0.0f, -0.7854f, 0.0f);
                this.bone7.field_78804_l.add(new ModelBox(this.bone7, 0, 0, 0.0f, 0.0f, 0.0f, 8, 8, 0, 0.0f, false));
                this.bone4 = new ModelRenderer((ModelBase)this);
                this.bone4.func_78793_a(9.75f, -16.0f, -3.75f);
                this.wall.func_78792_a(this.bone4);
                this.setRotationAngle(this.bone4, 0.0f, -1.5708f, 0.0f);
                this.bone4.field_78804_l.add(new ModelBox(this.bone4, 0, 0, -0.1f, 8.0f, 0.1f, 8, 8, 0, 0.0f, false));
                this.bone8 = new ModelRenderer((ModelBase)this);
                this.bone8.func_78793_a(-9.55f, -16.0f, -3.75f);
                this.wall.func_78792_a(this.bone8);
                this.setRotationAngle(this.bone8, 0.0f, -1.5708f, 0.0f);
                this.bone8.field_78804_l.add(new ModelBox(this.bone8, 0, 0, -0.15f, 8.0f, 0.05f, 8, 8, 0, 0.0f, false));
                this.cube_r1 = new ModelRenderer((ModelBase)this);
                this.cube_r1.func_78793_a(9.6f, -8.0f, 4.2f);
                this.wall.func_78792_a(this.cube_r1);
                this.setRotationAngle(this.cube_r1, 0.0f, 0.7854f, 0.0f);
                this.cube_r1.field_78804_l.add(new ModelBox(this.cube_r1, 0, 0, -7.95f, 0.0f, -0.025f, 8, 8, 0, 0.0f, false));
                this.cube_r2 = new ModelRenderer((ModelBase)this);
                this.cube_r2.func_78793_a(-6.7f, -16.0f, -6.9f);
                this.wall.func_78792_a(this.cube_r2);
                this.setRotationAngle(this.cube_r2, 0.0f, 0.7854f, 0.0f);
                this.cube_r2.field_78804_l.add(new ModelBox(this.cube_r2, 0, 0, -4.2023f, 8.0f, 0.0457f, 8, 8, 0, 0.0f, false));
                this.roof = new ModelRenderer((ModelBase)this);
                this.roof.func_78793_a(0.0f, -16.0f, -9.5f);
                this.dome.func_78792_a(this.roof);
                this.bone10 = new ModelRenderer((ModelBase)this);
                this.bone10.func_78793_a(0.05f, 2.7f, 9.65f);
                this.roof.func_78792_a(this.bone10);
                this.setRotationAngle(this.bone10, -1.5708f, 0.0f, 0.0f);
                this.bone10.field_78804_l.add(new ModelBox(this.bone10, 0, 8, -4.0f, -4.0f, 0.0f, 8, 8, 0, 0.0f, false));
                this.bone12 = new ModelRenderer((ModelBase)this);
                this.bone12.func_78793_a(0.0f, 0.0f, 0.0f);
                this.roof.func_78792_a(this.bone12);
                this.setRotationAngle(this.bone12, -0.7854f, 0.0f, 0.0f);
                this.bone12.field_78804_l.add(new ModelBox(this.bone12, 0, 8, -4.0f, -2.3431f, 5.6569f, 8, 8, 0, 0.0f, false));
                this.bone13 = new ModelRenderer((ModelBase)this);
                this.bone13.func_78793_a(7.0f, 0.0f, 3.0f);
                this.roof.func_78792_a(this.bone13);
                this.setRotationAngle(this.bone13, -0.7854f, -0.7854f, 0.0f);
                this.bone13.field_78804_l.add(new ModelBox(this.bone13, 0, 8, -4.2426f, -2.3431f, 5.6569f, 8, 8, 0, 0.0f, false));
                this.bone18 = new ModelRenderer((ModelBase)this);
                this.bone18.func_78793_a(0.0f, 0.0f, 19.2f);
                this.roof.func_78792_a(this.bone18);
                this.setRotationAngle(this.bone18, 0.7854f, 0.0f, 0.0f);
                this.bone18.field_78804_l.add(new ModelBox(this.bone18, 0, 8, -4.0f, -2.3431f, -5.6569f, 8, 8, 0, 0.0f, false));
                this.bone16 = new ModelRenderer((ModelBase)this);
                this.bone16.func_78793_a(7.0f, 0.0f, 16.3f);
                this.roof.func_78792_a(this.bone16);
                this.setRotationAngle(this.bone16, 0.7854f, 0.7854f, 0.0f);
                this.bone16.field_78804_l.add(new ModelBox(this.bone16, 0, 8, -4.2426f, -2.3431f, -5.6569f, 8, 8, 0, 0.0f, false));
                this.bone14 = new ModelRenderer((ModelBase)this);
                this.bone14.func_78793_a(9.75f, 0.0f, 9.75f);
                this.roof.func_78792_a(this.bone14);
                this.setRotationAngle(this.bone14, -0.7854f, -1.5708f, 0.0f);
                this.bone14.field_78804_l.add(new ModelBox(this.bone14, 0, 8, -4.1f, -2.3431f, 5.7569f, 8, 8, 0, 0.0f, false));
                this.bone17 = new ModelRenderer((ModelBase)this);
                this.bone17.func_78793_a(-9.65f, 0.0f, 9.75f);
                this.roof.func_78792_a(this.bone17);
                this.setRotationAngle(this.bone17, -0.7854f, 1.5708f, 0.0f);
                this.bone17.field_78804_l.add(new ModelBox(this.bone17, 0, 8, -3.9f, -2.3431f, 5.7569f, 8, 8, 0, 0.0f, true));
                this.cube_r3 = new ModelRenderer((ModelBase)this);
                this.cube_r3.func_78793_a(-6.8f, 8.0f, 2.7f);
                this.roof.func_78792_a(this.cube_r3);
                this.setRotationAngle(this.cube_r3, -0.7854f, 0.7854f, 0.0f);
                this.cube_r3.field_78804_l.add(new ModelBox(this.cube_r3, 0, 8, -4.0609f, -8.0f, 0.0457f, 8, 8, 0, 0.0f, false));
                this.cube_r4 = new ModelRenderer((ModelBase)this);
                this.cube_r4.func_78793_a(-6.8f, 8.0f, 16.3f);
                this.roof.func_78792_a(this.cube_r4);
                this.setRotationAngle(this.cube_r4, 0.7854f, -0.7854f, 0.0f);
                this.cube_r4.field_78804_l.add(new ModelBox(this.cube_r4, 0, 8, -3.8609f, -7.9f, -0.0457f, 8, 8, 0, 0.0f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                this.dome.func_78785_a(f5);
                GlStateManager.func_179121_F();
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class CustomRender
        extends Render<EC> {
            private final ResourceLocation texture;
            private final ModelDome model;
            private final int growTime = 30;

            public CustomRender(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.texture = new ResourceLocation("narutomod:textures/dome_ice.png");
                this.model = new ModelDome();
                this.growTime = 30;
                this.field_76989_e = 0.0f;
            }

            public boolean shouldRender(EC entity, ICamera camera, double camX, double camY, double camZ) {
                return true;
            }

            public void doRender(EC entity, double x, double y, double z, float entityYaw, float pt) {
                GlStateManager.func_179094_E();
                this.func_180548_c((Entity)entity);
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179114_b((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                GlStateManager.func_179129_p();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179140_f();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)MathHelper.func_76131_a((float)((float)entity.field_70173_aa / (float)(this.growTime + 26)), (float)0.0f, (float)1.0f));
                this.model.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179145_e();
                GlStateManager.func_179089_o();
                GlStateManager.func_179084_k();
                GlStateManager.func_179118_c();
                GlStateManager.func_179121_F();
            }

            protected ResourceLocation getEntityTexture(EC entity) {
                return this.texture;
            }
        }
    }

    public static class EC
    extends EntityShieldBase {
        private final int talkTime = 26;
        private int shootSpearsTime;
        private List<EntityLivingBase> entitiesInside = Lists.newArrayList();
        private EntityLivingBase excludedEntity;

        public EC(World world) {
            super(world);
            this.field_70178_ae = false;
            this.func_70105_a(9.6f, 6.4f);
        }

        public EC(EntityLivingBase summonerIn, double x, double y, double z) {
            super(summonerIn, x, y, z);
            this.field_70178_ae = false;
            this.func_70105_a(9.6f, 6.4f);
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:ice_shoot_small")), 0.8f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
                for (int i = 0; i < this.field_70146_Z.nextInt(50) + 100; ++i) {
                    EntityIceSpear.EC.spawnShatteredShard(this.field_70170_p, this.field_70165_t + (double)(this.field_70130_N * (this.field_70146_Z.nextFloat() - 0.5f)), this.field_70163_u + (double)(this.field_70131_O * this.field_70146_Z.nextFloat()), this.field_70161_v + (double)(this.field_70130_N * (this.field_70146_Z.nextFloat() - 0.5f)), (this.field_70146_Z.nextDouble() - 0.5) * 0.05, 0.0, (this.field_70146_Z.nextDouble() - 0.5) * 0.05);
                }
                EntityLivingBase summoner = this.getSummoner();
                if (summoner != null && summoner.func_70644_a(MobEffects.field_76441_p)) {
                    summoner.func_184589_d(MobEffects.field_76441_p);
                }
            }
        }

        @Override
        public boolean func_184230_a(EntityPlayer entity, EnumHand hand) {
            return false;
        }

        public List<EntityLivingBase> getEntitiesInside() {
            return this.entitiesInside;
        }

        public void excludeEntity(EntityLivingBase entity) {
            this.excludedEntity = entity;
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.field_70170_p.field_72995_K && this.field_70173_aa % 40 == 1) {
                ProcedureSync.ResetBoundingBox.sendToServer((Entity)this);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa == this.talkTime) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:ice_formation")), 1.0f, 1.0f);
            }
            EntityLivingBase summoner = this.getSummoner();
            if (!this.field_70170_p.field_72995_K && summoner != null && this.field_70173_aa % 20 == 1) {
                summoner.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 23, 0, false, false));
            }
            if (this.field_70173_aa < 5) {
                for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())) {
                    if (!(entity instanceof EntityLivingBase) || entity.equals((Object)summoner) || entity.equals((Object)this.excludedEntity) || this.entitiesInside.contains(entity) || !this.func_174813_aQ().func_191500_a(entity.func_174813_aQ()).equals((Object)entity.func_174813_aQ())) continue;
                    this.entitiesInside.add((EntityLivingBase)entity);
                }
            }
            if (!this.field_70170_p.field_72995_K && this.shootSpearsTime > 0) {
                for (EntityLivingBase entityLivingBase : this.entitiesInside) {
                    if (!entityLivingBase.func_70089_S() || summoner.func_184191_r((Entity)entityLivingBase)) continue;
                    double d0 = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                    double d1 = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                    new EntityIceSpear.EC.Jutsu().createJutsu(this.field_70170_p, summoner, this.field_70165_t + d0 * 0.8, this.field_70163_u + (double)this.field_70131_O - 1.6, this.field_70161_v + d1 * 0.8, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)(entityLivingBase.field_70131_O / 2.0f), entityLivingBase.field_70161_v, 0.95f, 0.25f);
                }
                --this.shootSpearsTime;
            }
            if (!this.entitiesInside.isEmpty()) {
                Iterator<EntityLivingBase> iter = this.entitiesInside.iterator();
                while (iter.hasNext()) {
                    EntityLivingBase entityLivingBase = iter.next();
                    if (ItemJutsu.canTarget((Entity)entityLivingBase)) continue;
                    iter.remove();
                }
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && summoner != null && !Chakra.pathway(summoner).consume(ItemHyoton.ICEDOME.chakraUsage * 0.05)) {
                this.func_70106_y();
            }
            this.func_70674_bp();
        }

        public void shootSpears() {
            this.shootSpearsTime = 100;
        }

        @Override
        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76369_e || source == DamageSource.field_76379_h || source == DamageSource.field_76368_d || source == DamageSource.field_76366_f || source == DamageSource.field_82727_n) {
                return false;
            }
            Entity srcEntity = source.func_76364_f();
            if (srcEntity instanceof EntityIceSpear.EC) {
                return false;
            }
            if (srcEntity instanceof EntityLivingBase && this.entitiesInside.contains(srcEntity)) {
                Vec3d vec2 = srcEntity.func_174824_e(1.0f);
                Vec3d vec1 = vec2.func_178787_e(srcEntity.func_70040_Z().func_186678_a(3.0));
                RayTraceResult res = this.func_174813_aQ().func_72327_a(vec1, vec2);
                if (res == null || res.field_178784_b == EnumFacing.DOWN) {
                    return false;
                }
            }
            return super.func_70097_a(source, amount);
        }

        protected void func_85033_bc() {
            for (Entity entity : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(3.0))) {
                if (!(entity instanceof EntityLivingBase)) continue;
                this.func_82167_n(entity);
            }
        }

        protected void func_82167_n(Entity entityIn) {
            this.func_70108_f(entityIn);
        }

        public void func_70108_f(Entity entity) {
            if (!this.func_184223_x(entity) && !entity.func_184207_aI() && !entity.field_70145_X && ItemJutsu.canTarget(entity)) {
                this.doCollisions(entity);
            }
        }

        private List<EnumFacing> doCollisions(Entity entity) {
            AxisAlignedBB bb1 = this.func_174813_aQ();
            AxisAlignedBB bb2 = entity.func_174813_aQ();
            ArrayList list = Lists.newArrayList();
            if (!this.entitiesInside.contains(entity)) {
                if (entity.field_70159_w > 0.0 && bb2.field_72336_d > bb1.field_72340_a && entity.field_70142_S - (double)(entity.field_70130_N / 2.0f) < bb1.field_72340_a && bb2.field_72337_e > bb1.field_72338_b && bb2.field_72338_b < bb1.field_72337_e && bb2.field_72334_f > bb1.field_72339_c && bb2.field_72339_c < bb1.field_72334_f) {
                    list.add(EnumFacing.WEST);
                    entity.field_70159_w *= -0.1;
                    entity.field_70165_t = bb1.field_72340_a - (double)entity.field_70130_N * 0.5;
                }
                if (entity.field_70159_w < 0.0 && bb2.field_72340_a < bb1.field_72336_d && entity.field_70142_S + (double)(entity.field_70130_N / 2.0f) > bb1.field_72336_d && bb2.field_72337_e > bb1.field_72338_b && bb2.field_72338_b < bb1.field_72337_e && bb2.field_72334_f > bb1.field_72339_c && bb2.field_72339_c < bb1.field_72334_f) {
                    list.add(EnumFacing.EAST);
                    entity.field_70159_w *= -0.1;
                    entity.field_70165_t = bb1.field_72336_d + (double)entity.field_70130_N * 0.5;
                }
                if (entity.field_70179_y > 0.0 && bb2.field_72334_f > bb1.field_72339_c && entity.field_70136_U - (double)(entity.field_70130_N / 2.0f) < bb1.field_72339_c && bb2.field_72337_e > bb1.field_72338_b && bb2.field_72338_b < bb1.field_72337_e && bb2.field_72336_d > bb1.field_72340_a && bb2.field_72340_a < bb1.field_72336_d) {
                    list.add(EnumFacing.NORTH);
                    entity.field_70179_y *= -0.1;
                    entity.field_70161_v = bb1.field_72339_c - (double)entity.field_70130_N * 0.5;
                }
                if (entity.field_70179_y < 0.0 && bb2.field_72339_c < bb1.field_72334_f && entity.field_70136_U + (double)(entity.field_70130_N / 2.0f) > bb1.field_72334_f && bb2.field_72337_e > bb1.field_72338_b && bb2.field_72338_b < bb1.field_72337_e && bb2.field_72336_d > bb1.field_72340_a && bb2.field_72340_a < bb1.field_72336_d) {
                    list.add(EnumFacing.SOUTH);
                    entity.field_70179_y *= -0.1;
                    entity.field_70161_v = bb1.field_72334_f + (double)entity.field_70130_N * 0.5;
                }
                if (entity.field_70181_x > 0.0 && bb2.field_72337_e > bb1.field_72338_b && entity.field_70137_T < bb1.field_72338_b && bb2.field_72334_f > bb1.field_72339_c && bb2.field_72339_c < bb1.field_72334_f && bb2.field_72336_d > bb1.field_72340_a && bb2.field_72340_a < bb1.field_72336_d) {
                    list.add(EnumFacing.DOWN);
                    entity.field_70181_x *= -0.8;
                    entity.field_70163_u = bb1.field_72338_b - (double)entity.field_70131_O;
                }
                if (entity.field_70181_x < 0.0 && bb2.field_72338_b < bb1.field_72337_e && entity.field_70137_T + (double)entity.field_70131_O > bb1.field_72337_e && bb2.field_72334_f > bb1.field_72339_c && bb2.field_72339_c < bb1.field_72334_f && bb2.field_72336_d > bb1.field_72340_a && bb2.field_72340_a < bb1.field_72336_d) {
                    list.add(EnumFacing.UP);
                    entity.field_70181_x = 0.0;
                    entity.field_70163_u = bb1.field_72337_e;
                    entity.field_70122_E = true;
                }
            } else {
                if (bb2.field_72340_a < bb1.field_72340_a) {
                    list.add(EnumFacing.WEST);
                    entity.field_70159_w *= -0.1;
                    entity.field_70165_t = bb1.field_72340_a + (double)entity.field_70130_N * 0.5;
                }
                if (bb2.field_72336_d > bb1.field_72336_d) {
                    list.add(EnumFacing.EAST);
                    entity.field_70159_w *= -0.1;
                    entity.field_70165_t = bb1.field_72336_d - (double)entity.field_70130_N * 0.5;
                }
                if (bb2.field_72339_c < bb1.field_72339_c) {
                    list.add(EnumFacing.NORTH);
                    entity.field_70179_y *= -0.1;
                    entity.field_70161_v = bb1.field_72339_c + (double)entity.field_70130_N * 0.5;
                }
                if (bb2.field_72334_f > bb1.field_72334_f) {
                    list.add(EnumFacing.SOUTH);
                    entity.field_70179_y *= -0.1;
                    entity.field_70161_v = bb1.field_72334_f - (double)entity.field_70130_N * 0.5;
                }
                if (bb2.field_72338_b < bb1.field_72338_b) {
                    list.add(EnumFacing.DOWN);
                    entity.field_70181_x = 0.0;
                    entity.field_70163_u = bb1.field_72338_b;
                    entity.field_70122_E = true;
                }
                if (bb2.field_72337_e > bb1.field_72337_e) {
                    list.add(EnumFacing.UP);
                    entity.field_70181_x *= -0.8;
                    entity.field_70163_u = bb1.field_72337_e - (double)entity.field_70131_O;
                }
            }
            if (!list.isEmpty()) {
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                entity.field_70133_I = true;
            }
            return list;
        }

        @Override
        public double func_70042_X() {
            return this.field_70131_O;
        }

        public static class LivingHook {
            @SubscribeEvent
            public void onAttackedInsideDome(LivingAttackEvent event) {
                EC dome;
                EntityLivingBase target = event.getEntityLiving();
                if (!target.field_70170_p.field_72995_K && !(target instanceof EC) && (dome = (EC)target.field_70170_p.func_72857_a(EC.class, target.func_174813_aQ().func_186662_g(8.0), (Entity)target)) != null) {
                    Entity attacker = event.getSource().func_76346_g();
                    EntityLivingBase summoner = dome.getSummoner();
                    if (dome.entitiesInside.contains(target) == !dome.entitiesInside.contains(attacker) && !summoner.equals((Object)attacker) && !target.equals((Object)summoner)) {
                        event.setCanceled(true);
                        dome.func_70097_a(event.getSource(), event.getAmount());
                    }
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (!entity.func_184218_aH()) {
                    this.createJutsu(entity, entity.field_70165_t, entity.field_70163_u - 0.1, entity.field_70161_v);
                    return true;
                }
                if (entity.func_184187_bx() instanceof EC) {
                    ((EC)entity.func_184187_bx()).shootSpears();
                    return true;
                }
                return false;
            }

            public EC createJutsu(EntityLivingBase entity, double x, double y, double z) {
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:makyohyosho")), SoundCategory.NEUTRAL, 1.0f, 0.9f);
                EC entity1 = new EC(entity, x, y, z);
                entity.field_70170_p.func_72838_d((Entity)entity1);
                return entity1;
            }
        }
    }
}

