/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.item.ItemJiton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureSync;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityKikaichu
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 323;
    public static final int ENTITYID_RANGED = 324;

    public EntityKikaichu(ElementsNarutomodMod instance) {
        super(instance, 674);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "kikaichu"), 323).name("kikaichu").tracker(64, 3, true).build());
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "bugball"), 324).name("bugball").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new CustomRender(renderManager));
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new ECRender(renderManager));
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelBeetle
    extends ModelQuadruped {
        private final ModelRenderer Mouth1;
        private final ModelRenderer Mouth2;
        private final ModelRenderer Eye1;
        private final ModelRenderer Eye2;
        private final ModelRenderer wingLeft;
        private final ModelRenderer wingRight;
        private final ModelRenderer foreleg1;
        private final ModelRenderer foreleg2;
        private final ModelRenderer foreleg3;
        private final ModelRenderer foreleg4;
        private final ModelRenderer leg5;
        private final ModelRenderer foreleg5;
        private final ModelRenderer leg6;
        private final ModelRenderer foreleg6;

        public ModelBeetle() {
            super(12, 0.0f);
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.field_78150_a = new ModelRenderer((ModelBase)this);
            this.field_78150_a.func_78793_a(0.0f, -1.5f, -5.0f);
            this.setRotationAngle(this.field_78150_a, 0.3491f, 0.0f, 0.0f);
            this.field_78150_a.field_78804_l.add(new ModelBox(this.field_78150_a, 0, 0, -1.5f, 0.5f, -7.0f, 3, 2, 1, 0.0f, false));
            this.field_78150_a.field_78804_l.add(new ModelBox(this.field_78150_a, 15, 24, -1.5f, 0.0f, -6.0f, 3, 3, 3, 0.0f, false));
            this.field_78150_a.field_78804_l.add(new ModelBox(this.field_78150_a, 16, 17, -2.5f, 0.0f, -4.0f, 5, 3, 4, 0.1f, false));
            this.Mouth1 = new ModelRenderer((ModelBase)this);
            this.Mouth1.func_78793_a(-1.0f, 1.7352f, -6.5119f);
            this.field_78150_a.func_78792_a(this.Mouth1);
            this.setRotationAngle(this.Mouth1, 0.3491f, -0.2618f, 0.0f);
            this.Mouth1.field_78804_l.add(new ModelBox(this.Mouth1, 4, 6, -0.5f, -0.4852f, -1.9881f, 1, 1, 2, -0.1f, false));
            this.Mouth2 = new ModelRenderer((ModelBase)this);
            this.Mouth2.func_78793_a(1.0f, 1.7352f, -6.5119f);
            this.field_78150_a.func_78792_a(this.Mouth2);
            this.setRotationAngle(this.Mouth2, 0.3491f, 0.2618f, 0.0f);
            this.Mouth2.field_78804_l.add(new ModelBox(this.Mouth2, 4, 6, -0.5f, -0.4852f, -1.9881f, 1, 1, 2, -0.1f, true));
            this.Eye1 = new ModelRenderer((ModelBase)this);
            this.Eye1.func_78793_a(-1.25f, 0.4852f, -6.0119f);
            this.field_78150_a.func_78792_a(this.Eye1);
            this.Eye1.field_78804_l.add(new ModelBox(this.Eye1, 4, 3, -0.5f, -0.7352f, -0.4881f, 1, 1, 2, 0.0f, false));
            this.Eye2 = new ModelRenderer((ModelBase)this);
            this.Eye2.func_78793_a(1.25f, 0.4852f, -6.0119f);
            this.field_78150_a.func_78792_a(this.Eye2);
            this.Eye2.field_78804_l.add(new ModelBox(this.Eye2, 4, 3, -0.5f, -0.7352f, -0.4881f, 1, 1, 2, 0.0f, true));
            this.field_78148_b = new ModelRenderer((ModelBase)this);
            this.field_78148_b.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_78148_b.field_78804_l.add(new ModelBox(this.field_78148_b, 0, 0, -4.0f, -1.5f, -5.0f, 8, 4, 10, 0.0f, false));
            this.field_78148_b.field_78804_l.add(new ModelBox(this.field_78148_b, 0, 14, -3.5f, -1.0f, 5.0f, 7, 4, 3, 0.0f, false));
            this.field_78148_b.field_78804_l.add(new ModelBox(this.field_78148_b, 0, 21, -3.0f, 0.0f, 7.0f, 6, 3, 3, 0.0f, false));
            this.field_78148_b.field_78804_l.add(new ModelBox(this.field_78148_b, 26, 0, -2.5f, 1.0f, 9.0f, 5, 2, 2, 0.0f, false));
            this.wingLeft = new ModelRenderer((ModelBase)this);
            this.wingLeft.func_78793_a(1.0f, -1.75f, -4.0f);
            this.field_78148_b.func_78792_a(this.wingLeft);
            this.setRotationAngle(this.wingLeft, 0.0873f, 0.2618f, 0.0f);
            this.wingLeft.field_78804_l.add(new ModelBox(this.wingLeft, 28, 0, -3.0f, 0.0f, 0.0f, 6, 0, 12, 0.0f, false));
            this.wingRight = new ModelRenderer((ModelBase)this);
            this.wingRight.func_78793_a(-1.0f, -1.75f, -4.0f);
            this.field_78148_b.func_78792_a(this.wingRight);
            this.setRotationAngle(this.wingRight, 0.0873f, -0.2618f, 0.0f);
            this.wingRight.field_78804_l.add(new ModelBox(this.wingRight, 28, 0, -3.0f, 0.0f, 0.0f, 6, 0, 12, 0.0f, true));
            this.field_78149_c = new ModelRenderer((ModelBase)this);
            this.field_78149_c.func_78793_a(-3.0f, 2.0f, -4.0f);
            this.setRotationAngle(this.field_78149_c, 0.0f, -0.5236f, 0.5236f);
            this.field_78149_c.field_78804_l.add(new ModelBox(this.field_78149_c, 17, 14, -5.0f, -0.5f, -0.5f, 5, 1, 1, 0.0f, false));
            this.foreleg1 = new ModelRenderer((ModelBase)this);
            this.foreleg1.func_78793_a(-4.5f, 0.25f, 0.0f);
            this.field_78149_c.func_78792_a(this.foreleg1);
            this.foreleg1.field_78804_l.add(new ModelBox(this.foreleg1, 0, 3, -0.5f, -0.25f, -0.5f, 1, 5, 1, 0.0f, false));
            this.field_78146_d = new ModelRenderer((ModelBase)this);
            this.field_78146_d.func_78793_a(3.0f, 2.0f, -4.0f);
            this.setRotationAngle(this.field_78146_d, 0.0f, 0.5236f, -0.5236f);
            this.field_78146_d.field_78804_l.add(new ModelBox(this.field_78146_d, 17, 14, 0.0f, -0.5f, -0.5f, 5, 1, 1, 0.0f, true));
            this.foreleg2 = new ModelRenderer((ModelBase)this);
            this.foreleg2.func_78793_a(4.5f, 0.25f, 0.0f);
            this.field_78146_d.func_78792_a(this.foreleg2);
            this.foreleg2.field_78804_l.add(new ModelBox(this.foreleg2, 0, 3, -0.5f, -0.25f, -0.5f, 1, 5, 1, 0.0f, true));
            this.field_78147_e = new ModelRenderer((ModelBase)this);
            this.field_78147_e.func_78793_a(-3.0f, 2.0f, 0.0f);
            this.setRotationAngle(this.field_78147_e, 0.0f, 0.0f, 0.5236f);
            this.field_78147_e.field_78804_l.add(new ModelBox(this.field_78147_e, 17, 14, -5.0f, -0.5f, -0.5f, 5, 1, 1, 0.0f, false));
            this.foreleg3 = new ModelRenderer((ModelBase)this);
            this.foreleg3.func_78793_a(-4.5f, 0.25f, 0.0f);
            this.field_78147_e.func_78792_a(this.foreleg3);
            this.foreleg3.field_78804_l.add(new ModelBox(this.foreleg3, 0, 3, -0.5f, -0.25f, -0.5f, 1, 5, 1, 0.0f, false));
            this.field_78144_f = new ModelRenderer((ModelBase)this);
            this.field_78144_f.func_78793_a(3.0f, 2.0f, 0.0f);
            this.setRotationAngle(this.field_78144_f, 0.0f, 0.0f, -0.5236f);
            this.field_78144_f.field_78804_l.add(new ModelBox(this.field_78144_f, 17, 14, 0.0f, -0.5f, -0.5f, 5, 1, 1, 0.0f, true));
            this.foreleg4 = new ModelRenderer((ModelBase)this);
            this.foreleg4.func_78793_a(4.5f, 0.25f, 0.0f);
            this.field_78144_f.func_78792_a(this.foreleg4);
            this.foreleg4.field_78804_l.add(new ModelBox(this.foreleg4, 0, 3, -0.5f, -0.25f, -0.5f, 1, 5, 1, 0.0f, true));
            this.leg5 = new ModelRenderer((ModelBase)this);
            this.leg5.func_78793_a(-3.0f, 2.0f, 4.0f);
            this.setRotationAngle(this.leg5, 0.0f, 0.5236f, 0.5236f);
            this.leg5.field_78804_l.add(new ModelBox(this.leg5, 17, 14, -5.0f, -0.5f, -0.5f, 5, 1, 1, 0.0f, false));
            this.foreleg5 = new ModelRenderer((ModelBase)this);
            this.foreleg5.func_78793_a(-4.5f, 0.25f, 0.0f);
            this.leg5.func_78792_a(this.foreleg5);
            this.foreleg5.field_78804_l.add(new ModelBox(this.foreleg5, 0, 3, -0.5f, -0.25f, -0.5f, 1, 5, 1, 0.0f, false));
            this.leg6 = new ModelRenderer((ModelBase)this);
            this.leg6.func_78793_a(3.0f, 2.0f, 4.0f);
            this.setRotationAngle(this.leg6, 0.0f, -0.5236f, -0.5236f);
            this.leg6.field_78804_l.add(new ModelBox(this.leg6, 17, 14, 0.0f, -0.5f, -0.5f, 5, 1, 1, 0.0f, true));
            this.foreleg6 = new ModelRenderer((ModelBase)this);
            this.foreleg6.func_78793_a(4.5f, 0.25f, 0.0f);
            this.leg6.func_78792_a(this.foreleg6);
            this.foreleg6.field_78804_l.add(new ModelBox(this.foreleg6, 0, 3, -0.5f, -0.25f, -0.5f, 1, 5, 1, 0.0f, true));
        }

        public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
            this.func_78087_a(f, f1, f2, f3, f4, f5, entity);
            this.field_78150_a.func_78785_a(f5);
            this.field_78148_b.func_78785_a(f5);
            this.field_78149_c.func_78785_a(f5);
            this.field_78146_d.func_78785_a(f5);
            this.field_78147_e.func_78785_a(f5);
            this.field_78144_f.func_78785_a(f5);
            this.leg5.func_78785_a(f5);
            this.leg6.func_78785_a(f5);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
            if (e.field_70122_E) {
                this.setRotationAngle(this.wingRight, 0.0873f, -0.2618f, 0.0f);
                this.setRotationAngle(this.wingLeft, 0.0873f, 0.2618f, 0.0f);
            } else {
                float f6 = MathHelper.func_76126_a((float)f2);
                this.wingLeft.field_78795_f = 0.1964f + f6 * 0.0655f;
                this.wingLeft.field_78796_g = 0.7854f + f6 * 0.2618f;
                this.wingRight.field_78795_f = 0.1964f + f6 * 0.0655f;
                this.wingRight.field_78796_g = -0.7854f - f6 * 0.2618f;
            }
            this.field_78149_c.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * 1.4f * f1;
            this.field_78146_d.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * f1;
            this.field_78147_e.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * f1;
            this.field_78144_f.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * 1.4f * f1;
            this.leg5.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * 1.4f * f1;
            this.leg6.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * 1.4f * f1;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CustomRender
    extends Render<EntityCustom> {
        private final ResourceLocation TEXTURE;
        protected final ModelBeetle model;

        public CustomRender(RenderManager renderManager) {
            super(renderManager);
            this.TEXTURE = new ResourceLocation("narutomod:textures/beetle.png");
            this.model = new ModelBeetle();
        }

        public void doRender(EntityCustom entity, double x, double y, double z, float entityYaw, float partialTicks) {
            float f5 = entity.prevLimbSwingAmount + (entity.limbSwingAmount - entity.prevLimbSwingAmount) * partialTicks;
            float f6 = entity.limbSwing - entity.limbSwingAmount * (1.0f - partialTicks);
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            this.func_180548_c(entity);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)(y + 0.03125), (double)z);
            GlStateManager.func_179114_b((float)(-entity.field_70126_B - (entity.field_70177_z - entity.field_70126_B) * partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks - 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.1f, (float)0.1f, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.model.func_78088_a(entity, f6, f5, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EntityCustom entity) {
            return this.TEXTURE;
        }
    }

    public static class EntityCustom
    extends Entity {
        private EntityLivingBase host;
        private int idleTime;
        private int maxAge;
        public float prevLimbSwingAmount;
        public float limbSwingAmount;
        public float limbSwing;
        private double chakra;

        public EntityCustom(World worldIn) {
            super(worldIn);
            this.func_70105_a(0.1f, 0.1f);
            this.maxAge = 6000;
        }

        public EntityCustom(EntityLivingBase hostIn, double x, double y, double z, double mX, double mY, double mZ, int color, float scale, int maxAgeIn) {
            this(hostIn.field_70170_p);
            this.host = hostIn;
            this.func_70107_b(x, y, z);
            this.field_70159_w = mX;
            this.field_70181_x = mY;
            this.field_70179_y = mZ;
            float f1 = MathHelper.func_76133_a((double)(mX * mX + mZ * mZ));
            this.field_70177_z = (float)(-MathHelper.func_181159_b((double)mX, (double)mZ) * 57.29577951308232);
            this.field_70125_A = (float)(-MathHelper.func_181159_b((double)mY, (double)f1) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
            if (maxAgeIn > 0) {
                this.maxAge = maxAgeIn;
            }
        }

        protected void func_70088_a() {
        }

        public boolean func_70067_L() {
            return !this.field_70128_L;
        }

        public void updateLimbSwing() {
            if (this.field_70132_H) {
                this.prevLimbSwingAmount = this.limbSwingAmount;
                double d5 = this.field_70165_t - this.field_70169_q;
                double d7 = this.field_70161_v - this.field_70166_s;
                float f10 = MathHelper.func_76133_a((double)(d5 * d5 + d7 * d7)) * 4.0f;
                if (f10 > 1.0f) {
                    f10 = 1.0f;
                }
                this.limbSwingAmount += (f10 - this.limbSwingAmount) * 0.4f;
                this.limbSwing += this.limbSwingAmount;
            }
        }

        private void updateInFlightRotations() {
            float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = -((float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232));
            this.field_70125_A = -((float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232));
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        }

        public void func_70071_h_() {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.updateLimbSwing();
            this.updateInFlightRotations();
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.8;
            this.field_70179_y *= 0.8;
            if (!this.field_70170_p.field_72995_K) {
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ())) {
                    if (!entity.equals((Object)this.host)) {
                        if (!(this.chakra < 100.0) || !Chakra.pathway(entity).consume(0.25)) continue;
                        this.chakra += 0.25;
                        continue;
                    }
                    if (!(this.chakra > 0.0)) continue;
                    Chakra.pathway(this.host).consume(-this.chakra);
                    this.chakra = 0.0;
                }
            }
            int n = this.idleTime = this.getVelocity() < 0.001 ? this.idleTime + 1 : 0;
            if (!(this.field_70170_p.field_72995_K || this.field_70173_aa <= this.maxAge && this.idleTime <= 1000)) {
                this.func_70106_y();
            }
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76368_d || source == DamageSource.field_76369_e || source == DamageSource.field_76379_h || source == DamageSource.field_188406_j) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K && amount >= 1.0f) {
                this.func_70106_y();
                ((WorldServer)this.field_70170_p).func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                return true;
            }
            return false;
        }

        protected void func_180429_a(BlockPos pos, Block blockIn) {
        }

        public double getVelocity() {
            return ProcedureUtils.getVelocity(this);
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_70112_a(double distance) {
            return distance < 4096.0;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }

    public static class EC
    extends Entity {
        private EntityLivingBase user;
        private EntityLivingBase target;
        private ItemJiton.SwarmTarget bugsTarget;
        private static final int MAXTIME = 600;

        public EC(World worldIn) {
            super(worldIn);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(final EntityLivingBase userIn, EntityLivingBase targetIn, float power) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.target = targetIn;
            Vec3d vec = this.getUserVector();
            this.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            this.bugsTarget = new ItemJiton.SwarmTarget(this.field_70170_p, (int)(power * 50.0f), vec, this.getTargetVector(), new Vec3d(0.4, 0.4, 0.4), 0.6f, 0.05f, false, 1.0f, -1){

                @Override
                protected Entity createParticle(double x, double y, double z, double mx, double my, double mz, int c, float sc, int life) {
                    return new EntityCustom(userIn, x, y, z, mx, my, mz, c, sc, life);
                }

                @Override
                protected void playFlyingSound(double x, double y, double z, float volume, float pitch) {
                    if (this.getTicks() % 2 == 0) {
                        userIn.field_70170_p.func_184148_a(null, x, y, z, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bugs")), SoundCategory.BLOCKS, volume, pitch);
                    }
                }
            };
        }

        protected void func_70088_a() {
        }

        private Vec3d getUserVector() {
            return this.user.func_174791_d().func_72441_c(0.0, (double)(this.user.field_70131_O * 0.6667f), 0.0);
        }

        private AxisAlignedBB getTargetVector() {
            return this.target.func_174813_aQ();
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K && this.bugsTarget != null && !this.bugsTarget.shouldRemove()) {
                this.bugsTarget.forceRemove();
            }
        }

        public void func_70071_h_() {
            if (this.user != null && this.user.func_70089_S() && this.bugsTarget != null && !this.bugsTarget.shouldRemove() && this.target != null) {
                if (this.target.func_70089_S() && this.field_70173_aa < 600) {
                    if (this.bugsTarget.allParticlesReachedTarget()) {
                        this.bugsTarget.setTarget(this.getTargetVector(), 0.2f, 0.01f, false);
                    } else {
                        this.bugsTarget.setTarget(this.getTargetVector(), 0.6f, 0.05f, false);
                    }
                } else {
                    this.bugsTarget.setTarget(this.getUserVector(), 0.6f, 0.05f, true);
                }
                this.bugsTarget.onUpdate();
                this.func_174826_a(this.bugsTarget.getBorders());
                this.func_174829_m();
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        public void func_174826_a(AxisAlignedBB bb) {
            super.func_174826_a(bb);
            this.field_70130_N = (float)Math.min(bb.field_72336_d - bb.field_72340_a, bb.field_72334_f - bb.field_72339_c);
            this.field_70131_O = (float)(bb.field_72337_e - bb.field_72338_b);
        }

        public void func_174829_m() {
            super.func_174829_m();
            if (!this.field_70170_p.field_72995_K && this.isAddedToWorld()) {
                ProcedureSync.ResetBoundingBox.sendToTracking(this);
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                RayTraceResult result = ProcedureUtils.objectEntityLookingAt((Entity)entity, 30.0, 1.5, true);
                if (result != null) {
                    if (result.field_72308_g instanceof EC) {
                        result.field_72308_g.field_70173_aa = 600;
                        return false;
                    }
                    if (result.field_72308_g instanceof EntityLivingBase) {
                        entity.field_70170_p.func_72838_d((Entity)new EC(entity, (EntityLivingBase)result.field_72308_g, power));
                        return true;
                    }
                }
                return false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ECRender
    extends Render<EC> {
        public ECRender(RenderManager renderManagerIn) {
            super(renderManagerIn);
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return null;
        }
    }
}

