/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityLightningArc;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAoeCommand;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityKirin
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 373;
    public static final int ENTITYID_RANGED = 374;

    public EntityKirin(ElementsNarutomodMod instance) {
        super(instance, 734);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "kirin"), 373).name("kirin").tracker(128, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderDragon(renderManager));
    }

    public static void chargingEffects(EntityLivingBase player, float pct) {
        if (pct >= 0.8f && pct < 0.81f) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:kirin_dialog")), SoundCategory.PLAYERS, 5.0f, 1.0f);
        }
        for (int i = 0; i < player.func_70681_au().nextInt(11); ++i) {
            Vec3d vec = player.func_174791_d().func_72441_c((player.func_70681_au().nextDouble() - 0.5) * 120.0, 95.0 + player.func_70681_au().nextDouble() * 10.0, (player.func_70681_au().nextDouble() - 0.5) * 120.0);
            EntityLightningArc.Base entity = new EntityLightningArc.Base(player.field_70170_p, vec, player.func_70681_au().nextDouble() * 120.0 + 10.0, 0.0, 0.0, 0.0, -1073741569, 1, 0.0f, 0.0f).setStatic();
            player.field_70170_p.func_72838_d((Entity)entity);
        }
    }

    public static void startWeatherThunder(Entity entity) {
        entity.field_70170_p.func_72912_H().func_176142_i(0);
        entity.field_70170_p.func_72912_H().func_76080_g(600);
        entity.field_70170_p.func_72912_H().func_76090_f(600);
        entity.field_70170_p.func_72912_H().func_76084_b(true);
        entity.field_70170_p.func_72912_H().func_76069_a(true);
        entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u + 100.0, entity.field_70161_v, SoundEvents.field_187754_de, SoundCategory.WEATHER, 1000.0f, 0.8f + entity.field_70170_p.field_73012_v.nextFloat() * 0.2f);
    }

    @SideOnly(value=Side.CLIENT)
    public class ModelDragonHead
    extends ModelBase {
        private final ModelRenderer head;
        private final ModelRenderer bone;
        private final ModelRenderer bone2;
        private final ModelRenderer bone3;
        private final ModelRenderer teethUpper;
        private final ModelRenderer teethLower;
        private final ModelRenderer jaw;
        private final ModelRenderer hornRight;
        private final ModelRenderer hornRight0;
        private final ModelRenderer hornRight1;
        private final ModelRenderer hornRight2;
        private final ModelRenderer hornRight3;
        private final ModelRenderer hornRight4;
        private final ModelRenderer hornLeft;
        private final ModelRenderer hornLeft0;
        private final ModelRenderer hornLeft1;
        private final ModelRenderer hornLeft2;
        private final ModelRenderer hornLeft3;
        private final ModelRenderer hornLeft4;
        private final ModelRenderer[] whiskerLeft = new ModelRenderer[6];
        private final ModelRenderer[] whiskerRight = new ModelRenderer[6];
        private final ModelRenderer[] spine = new ModelRenderer[100];
        private final ModelRenderer eyes;

        public ModelDragonHead() {
            this.field_78090_t = 256;
            this.field_78089_u = 256;
            this.head = new ModelRenderer((ModelBase)this);
            this.head.func_78793_a(0.0f, 0.0f, 0.0f);
            this.head.field_78804_l.add(new ModelBox(this.head, 176, 44, -6.0f, 6.0f, -26.0f, 12, 5, 16, 1.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 112, 30, -8.0f, -1.0f, -11.0f, 16, 16, 16, 1.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 112, 0, -5.0f, 5.0f, -26.0f, 2, 2, 4, 1.0f, false));
            this.head.field_78804_l.add(new ModelBox(this.head, 112, 0, 3.0f, 5.0f, -26.0f, 2, 2, 4, 1.0f, true));
            this.teethUpper = new ModelRenderer((ModelBase)this);
            this.teethUpper.func_78793_a(0.0f, 24.0f, 0.0f);
            this.head.func_78792_a(this.teethUpper);
            this.teethUpper.field_78804_l.add(new ModelBox(this.teethUpper, 152, 146, -6.0f, -12.0f, -26.0f, 12, 2, 16, 0.5f, false));
            this.bone = new ModelRenderer((ModelBase)this);
            this.bone.func_78793_a(9.0f, 7.0f, -11.0f);
            this.head.func_78792_a(this.bone);
            this.setRotationAngle(this.bone, 0.0f, -0.7854f, 0.0f);
            this.bone.field_78804_l.add(new ModelBox(this.bone, 0, 200, 0.0f, -8.0f, 0.0f, 8, 16, 0, 0.0f, false));
            this.bone2 = new ModelRenderer((ModelBase)this);
            this.bone2.func_78793_a(-9.0f, 7.0f, -11.0f);
            this.head.func_78792_a(this.bone2);
            this.setRotationAngle(this.bone2, 0.0f, 0.7854f, 0.0f);
            this.bone2.field_78804_l.add(new ModelBox(this.bone2, 0, 200, -8.0f, -8.0f, 0.0f, 8, 16, 0, 0.0f, true));
            this.bone3 = new ModelRenderer((ModelBase)this);
            this.bone3.func_78793_a(0.0f, -2.0f, -11.0f);
            this.head.func_78792_a(this.bone3);
            this.setRotationAngle(this.bone3, -0.8727f, 0.0f, 0.0f);
            this.bone3.field_78804_l.add(new ModelBox(this.bone3, 0, 50, -8.0f, -10.0f, 0.0f, 16, 10, 0, 0.0f, false));
            this.jaw = new ModelRenderer((ModelBase)this);
            this.jaw.func_78793_a(0.0f, 11.0f, -9.0f);
            this.head.func_78792_a(this.jaw);
            this.jaw.field_78804_l.add(new ModelBox(this.jaw, 176, 65, -6.0f, 0.0f, -16.75f, 12, 4, 16, 1.0f, false));
            this.teethLower = new ModelRenderer((ModelBase)this);
            this.teethLower.func_78793_a(0.0f, 13.0f, 9.0f);
            this.jaw.func_78792_a(this.teethLower);
            this.teethLower.field_78804_l.add(new ModelBox(this.teethLower, 112, 144, -6.0f, -16.0f, -25.75f, 12, 2, 16, 0.5f, false));
            this.hornRight = new ModelRenderer((ModelBase)this);
            this.hornRight.func_78793_a(-6.0f, -2.0f, -13.0f);
            this.head.func_78792_a(this.hornRight);
            this.setRotationAngle(this.hornRight, 0.0873f, -0.5236f, 0.0f);
            this.hornRight.field_78804_l.add(new ModelBox(this.hornRight, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 1.0f, false));
            this.hornRight0 = new ModelRenderer((ModelBase)this);
            this.hornRight0.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight.func_78792_a(this.hornRight0);
            this.setRotationAngle(this.hornRight0, 0.0873f, 0.0873f, 0.0f);
            this.hornRight0.field_78804_l.add(new ModelBox(this.hornRight0, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.8f, false));
            this.hornRight1 = new ModelRenderer((ModelBase)this);
            this.hornRight1.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight0.func_78792_a(this.hornRight1);
            this.setRotationAngle(this.hornRight1, 0.0873f, 0.0873f, 0.0f);
            this.hornRight1.field_78804_l.add(new ModelBox(this.hornRight1, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.6f, false));
            this.hornRight2 = new ModelRenderer((ModelBase)this);
            this.hornRight2.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight1.func_78792_a(this.hornRight2);
            this.setRotationAngle(this.hornRight2, 0.0873f, 0.0873f, 0.0f);
            this.hornRight2.field_78804_l.add(new ModelBox(this.hornRight2, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.4f, false));
            this.hornRight3 = new ModelRenderer((ModelBase)this);
            this.hornRight3.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight2.func_78792_a(this.hornRight3);
            this.setRotationAngle(this.hornRight3, 0.0873f, 0.0873f, 0.0f);
            this.hornRight3.field_78804_l.add(new ModelBox(this.hornRight3, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.2f, false));
            this.hornRight4 = new ModelRenderer((ModelBase)this);
            this.hornRight4.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornRight3.func_78792_a(this.hornRight4);
            this.setRotationAngle(this.hornRight4, 0.0873f, 0.0873f, 0.0f);
            this.hornRight4.field_78804_l.add(new ModelBox(this.hornRight4, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.0f, false));
            this.hornLeft = new ModelRenderer((ModelBase)this);
            this.hornLeft.func_78793_a(6.0f, -2.0f, -13.0f);
            this.head.func_78792_a(this.hornLeft);
            this.setRotationAngle(this.hornLeft, 0.0873f, 0.5236f, 0.0f);
            this.hornLeft.field_78804_l.add(new ModelBox(this.hornLeft, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 1.0f, true));
            this.hornLeft0 = new ModelRenderer((ModelBase)this);
            this.hornLeft0.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft.func_78792_a(this.hornLeft0);
            this.setRotationAngle(this.hornLeft0, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft0.field_78804_l.add(new ModelBox(this.hornLeft0, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.8f, true));
            this.hornLeft1 = new ModelRenderer((ModelBase)this);
            this.hornLeft1.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft0.func_78792_a(this.hornLeft1);
            this.setRotationAngle(this.hornLeft1, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft1.field_78804_l.add(new ModelBox(this.hornLeft1, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.6f, true));
            this.hornLeft2 = new ModelRenderer((ModelBase)this);
            this.hornLeft2.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft1.func_78792_a(this.hornLeft2);
            this.setRotationAngle(this.hornLeft2, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft2.field_78804_l.add(new ModelBox(this.hornLeft2, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.4f, true));
            this.hornLeft3 = new ModelRenderer((ModelBase)this);
            this.hornLeft3.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft2.func_78792_a(this.hornLeft3);
            this.setRotationAngle(this.hornLeft3, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft3.field_78804_l.add(new ModelBox(this.hornLeft3, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.2f, true));
            this.hornLeft4 = new ModelRenderer((ModelBase)this);
            this.hornLeft4.func_78793_a(0.0f, 0.0f, 7.0f);
            this.hornLeft3.func_78792_a(this.hornLeft4);
            this.setRotationAngle(this.hornLeft4, 0.0873f, -0.0873f, 0.0f);
            this.hornLeft4.field_78804_l.add(new ModelBox(this.hornLeft4, 0, 0, -1.0f, -2.0f, 0.0f, 2, 4, 6, 0.0f, true));
            this.whiskerLeft[0] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[0].func_78793_a(6.0f, 6.0f, -24.0f);
            this.head.func_78792_a(this.whiskerLeft[0]);
            this.setRotationAngle(this.whiskerLeft[0], 0.0f, 1.0472f, 0.0f);
            this.whiskerLeft[0].field_78804_l.add(new ModelBox(this.whiskerLeft[0], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.8f, true));
            this.whiskerLeft[1] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[1].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[0].func_78792_a(this.whiskerLeft[1]);
            this.setRotationAngle(this.whiskerLeft[1], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[1].field_78804_l.add(new ModelBox(this.whiskerLeft[1], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.7f, true));
            this.whiskerLeft[2] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[2].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[1].func_78792_a(this.whiskerLeft[2]);
            this.setRotationAngle(this.whiskerLeft[2], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[2].field_78804_l.add(new ModelBox(this.whiskerLeft[2], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.6f, true));
            this.whiskerLeft[3] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[3].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[2].func_78792_a(this.whiskerLeft[3]);
            this.setRotationAngle(this.whiskerLeft[3], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[3].field_78804_l.add(new ModelBox(this.whiskerLeft[3], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.5f, true));
            this.whiskerLeft[4] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[4].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[3].func_78792_a(this.whiskerLeft[4]);
            this.setRotationAngle(this.whiskerLeft[4], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[4].field_78804_l.add(new ModelBox(this.whiskerLeft[4], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.4f, true));
            this.whiskerLeft[5] = new ModelRenderer((ModelBase)this);
            this.whiskerLeft[5].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerLeft[4].func_78792_a(this.whiskerLeft[5]);
            this.setRotationAngle(this.whiskerLeft[5], -0.0873f, -0.1745f, 0.0f);
            this.whiskerLeft[5].field_78804_l.add(new ModelBox(this.whiskerLeft[5], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.2f, true));
            this.whiskerRight[0] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[0].func_78793_a(-6.0f, 6.0f, -24.0f);
            this.head.func_78792_a(this.whiskerRight[0]);
            this.setRotationAngle(this.whiskerRight[0], 0.0f, -1.0472f, 0.0f);
            this.whiskerRight[0].field_78804_l.add(new ModelBox(this.whiskerRight[0], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.8f, false));
            this.whiskerRight[1] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[1].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[0].func_78792_a(this.whiskerRight[1]);
            this.setRotationAngle(this.whiskerRight[1], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[1].field_78804_l.add(new ModelBox(this.whiskerRight[1], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.7f, false));
            this.whiskerRight[2] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[2].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[1].func_78792_a(this.whiskerRight[2]);
            this.setRotationAngle(this.whiskerRight[2], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[2].field_78804_l.add(new ModelBox(this.whiskerRight[2], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.6f, false));
            this.whiskerRight[3] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[3].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[2].func_78792_a(this.whiskerRight[3]);
            this.setRotationAngle(this.whiskerRight[3], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[3].field_78804_l.add(new ModelBox(this.whiskerRight[3], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.5f, false));
            this.whiskerRight[4] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[4].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[3].func_78792_a(this.whiskerRight[4]);
            this.setRotationAngle(this.whiskerRight[4], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[4].field_78804_l.add(new ModelBox(this.whiskerRight[4], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.4f, false));
            this.whiskerRight[5] = new ModelRenderer((ModelBase)this);
            this.whiskerRight[5].func_78793_a(0.0f, 0.0f, 6.0f);
            this.whiskerRight[4].func_78792_a(this.whiskerRight[5]);
            this.setRotationAngle(this.whiskerRight[5], -0.0873f, 0.1745f, 0.0f);
            this.whiskerRight[5].field_78804_l.add(new ModelBox(this.whiskerRight[5], 0, 0, -1.0f, -1.0f, 0.0f, 2, 2, 6, 0.2f, false));
            for (int i = 0; i < this.spine.length; ++i) {
                this.spine[i] = new ModelRenderer((ModelBase)this);
                this.spine[i].field_78804_l.add(new ModelBox(this.spine[i], 192, 104, -5.0f, -4.5f, 0.0f, 10, 10, 10, 2.0f, false));
                this.spine[i].field_78804_l.add(new ModelBox(this.spine[i], 48, 0, -1.0f, -10.5f, 2.0f, 2, 4, 6, 1.0f, false));
                if (i == 0) {
                    this.spine[i].func_78793_a(0.0f, 6.5f, 7.0f);
                    continue;
                }
                this.spine[i].func_78793_a(0.0f, 0.0f, 11.0f);
                this.spine[i - 1].func_78792_a(this.spine[i]);
            }
            this.eyes = new ModelRenderer((ModelBase)this);
            this.eyes.func_78793_a(0.0f, 0.0f, 0.0f);
            this.eyes.field_78804_l.add(new ModelBox(this.eyes, 130, 50, -6.6f, 2.6f, -12.1f, 3, 2, 0, 0.0f, false));
            this.eyes.field_78804_l.add(new ModelBox(this.eyes, 130, 50, 3.6f, 2.6f, -12.1f, 3, 2, 0, 0.0f, true));
        }

        public void func_78088_a(Entity entityIn, float f, float f1, float f2, float f3, float f4, float f5) {
            this.head.func_78785_a(f5);
            this.spine[0].func_78785_a(f5);
            this.eyes.func_78785_a(f5);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_78087_a(float f0, float f1, float ageInTicks, float f3, float headPitch, float f5, Entity e) {
            int i;
            super.func_78087_a(f0, f1, ageInTicks, f3, headPitch, f5, e);
            EC entity = (EC)e;
            float pt = ageInTicks - (float)e.field_70173_aa;
            float f6 = (float)Math.PI / 180;
            this.head.field_78795_f = headPitch * f6;
            if (entity.ticksAlive > 60) {
                this.jaw.field_78795_f = 0.5236f;
            }
            for (i = 2; i < 6; ++i) {
                this.whiskerLeft[i].field_78808_h = 0.2618f * ageInTicks;
                this.whiskerRight[i].field_78808_h = -0.2618f * ageInTicks;
            }
            for (i = 0; i < this.spine.length; ++i) {
                if (i < entity.partRot.size()) {
                    this.spine[i].field_78806_j = true;
                    ProcedureUtils.Vec2f vec = (ProcedureUtils.Vec2f)entity.partRot.get(i);
                    this.spine[i].field_78795_f = -vec.y * f6;
                    this.spine[i].field_78796_g = -vec.x * f6;
                    continue;
                }
                this.spine[i].field_78806_j = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderDragon
    extends Render<EC> {
        private final ResourceLocation texture;
        private final ResourceLocation texture2;
        private final ModelDragonHead model;

        public RenderDragon(RenderManager renderManager) {
            super(renderManager);
            this.texture = new ResourceLocation("narutomod:textures/dragon_lightning.png");
            this.texture2 = new ResourceLocation("narutomod:textures/electric_armor.png");
            this.model = new ModelDragonHead();
            this.field_76989_e = 0.0f;
        }

        public boolean shouldRender(EC livingEntity, ICamera camera, double camX, double camY, double camZ) {
            return true;
        }

        public void doRender(EC entity, double x, double y, double z, float yaw, float pt) {
            float age = (float)entity.field_70173_aa + pt;
            float f0 = Math.min(age / 60.0f, 1.0f);
            float f1 = -entity.field_70126_B - MathHelper.func_76142_g((float)(entity.field_70177_z - entity.field_70126_B)) * pt;
            float f2 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * pt;
            boolean flag = entity.ticksAlive <= 60;
            float scale = entity.getEntityScale();
            this.model.func_78087_a(0.0f, 0.0f, age, 0.0f, 0.0f, 0.0625f, entity);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + scale), (float)((float)z));
            GlStateManager.func_179114_b((float)f1, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(f2 - 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179147_l();
            GlStateManager.func_179092_a((int)516, (float)0.001f);
            GlStateManager.func_179129_p();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179140_f();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            this.func_180548_c(entity);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(f0 * 0.5f));
            ((ModelDragonHead)this.model).teethUpper.field_78806_j = true;
            ((ModelDragonHead)this.model).teethLower.field_78806_j = true;
            ((ModelDragonHead)this.model).eyes.field_78806_j = true;
            this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_110776_a(this.texture2);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)(age * 0.01f), (float)(age * 0.01f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            ((ModelDragonHead)this.model).teethUpper.field_78806_j = false;
            ((ModelDragonHead)this.model).teethLower.field_78806_j = false;
            ((ModelDragonHead)this.model).eyes.field_78806_j = false;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(f0 * 0.5f));
            this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.065625f);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            this.func_180548_c(entity);
            ((ModelDragonHead)this.model).teethUpper.field_78806_j = false;
            ((ModelDragonHead)this.model).teethLower.field_78806_j = false;
            ((ModelDragonHead)this.model).eyes.field_78806_j = false;
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)1.0f, (float)(f0 * 0.3f));
            this.model.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.06875f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179089_o();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return this.texture;
        }
    }

    public static class EC
    extends EntityScalableProjectile.Base {
        private final int wait = 60;
        private Vec3d shootVec;
        private float prevHeadYaw;
        private float prevHeadPitch;
        private Vec3d lastVec;
        private final List<ProcedureUtils.Vec2f> partRot = Lists.newArrayList((Object[])new ProcedureUtils.Vec2f[]{new ProcedureUtils.Vec2f(45.0f, 0.0f), new ProcedureUtils.Vec2f(-45.0f, 0.0f), new ProcedureUtils.Vec2f(-45.0f, 0.0f), new ProcedureUtils.Vec2f(-22.5f, 0.0f), new ProcedureUtils.Vec2f(45.0f, 0.0f), new ProcedureUtils.Vec2f(45.0f, 0.0f), new ProcedureUtils.Vec2f(45.0f, 0.0f), new ProcedureUtils.Vec2f(-45.0f, 0.0f)});

        public EC(World w) {
            super(w);
            this.setOGSize(1.0f, 1.0f);
            this.setEntityScale(10.0f);
        }

        public EC(EntityLivingBase shooter) {
            super(shooter);
            this.setOGSize(1.0f, 1.0f);
            this.setEntityScale(10.0f);
            this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + 100.0, shooter.field_70161_v, shooter.field_70177_z, 80.0f);
            this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:dragon_roar")), 100.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
        }

        private void setWaitPosition() {
            if (this.shootVec != null) {
                ProcedureUtils.Vec2f v2f = ProcedureUtils.getYawPitchFromVec(this.shootVec);
                this.func_70101_b(v2f.x, v2f.y);
            } else if (this.shootingEntity != null) {
                Vec3d vec = this.shootingEntity instanceof EntityLiving && ((EntityLiving)this.shootingEntity).func_70638_az() != null ? ((EntityLiving)this.shootingEntity).func_70638_az().func_174791_d().func_178788_d(this.func_174791_d()) : ProcedureUtils.objectEntityLookingAt((Entity)this.shootingEntity, (double)50.0).field_72307_f.func_178788_d(this.func_174791_d());
                ProcedureUtils.Vec2f v2f = ProcedureUtils.getYawPitchFromVec(vec);
                this.func_70101_b(v2f.x, v2f.y);
            }
            this.field_70181_x -= this.ticksAlive <= this.wait / 2 ? 0.03 : 0.0;
        }

        private void shoot(double x, double y, double z) {
            this.func_70186_c(x, y, z, 1.2f, 0.0f);
            this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:lightning_shoot")), 100.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (!(this.field_70170_p.field_72995_K || this.ticksAlive <= 100 && this.shootingEntity != null && this.shootingEntity.func_70089_S())) {
                this.func_70106_y();
            } else {
                if (this.ticksAlive <= this.wait) {
                    if (this.lastVec == null) {
                        this.lastVec = this.func_174791_d();
                    }
                    this.setWaitPosition();
                } else if (!this.isLaunched()) {
                    this.field_70181_x = 0.0;
                    if (this.shootVec != null) {
                        this.shoot(this.shootVec.field_72450_a, this.shootVec.field_72448_b, this.shootVec.field_72449_c);
                    } else if (this.shootingEntity != null) {
                        Vec3d vec = this.shootingEntity instanceof EntityLiving && ((EntityLiving)this.shootingEntity).func_70638_az() != null ? ((EntityLiving)this.shootingEntity).func_70638_az().func_174791_d().func_178788_d(this.func_174791_d()) : ProcedureUtils.objectEntityLookingAt((Entity)this.shootingEntity, (double)50.0).field_72307_f.func_178788_d(this.func_174791_d());
                        this.shoot(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                    }
                }
                this.updateSegments();
                this.prevHeadYaw = this.field_70177_z;
                this.prevHeadPitch = this.field_70125_A;
            }
        }

        public void updateSegments() {
            Vec3d cposvec = this.func_174791_d();
            float slength = this.getEntityScale() * 11.0f * 0.0625f;
            ProcedureUtils.Vec2f vec = new ProcedureUtils.Vec2f(this.field_70177_z, this.field_70125_A).subtract(this.prevHeadYaw, this.prevHeadPitch);
            Vec3d vec4 = cposvec.func_178788_d(this.lastVec);
            double d4 = vec4.func_72433_c();
            if (d4 >= (double)slength) {
                int i;
                this.partRot.add(0, vec);
                for (i = 1; i < (int)(d4 / (double)slength); ++i) {
                    this.partRot.add(0, ProcedureUtils.Vec2f.ZERO);
                }
                this.lastVec = vec4.func_72432_b().func_186678_a((double)(slength * (float)i)).func_178787_e(this.lastVec);
            } else {
                this.partRot.set(0, this.partRot.get(0).add(vec));
            }
        }

        @Override
        public void renderParticles() {
            if (!this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 8; ++i) {
                    Vec3d vec = this.func_174791_d().func_72441_c((this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 2.0, (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N);
                    EntityLightningArc.Base entity = new EntityLightningArc.Base(this.field_70170_p, vec, this.field_70146_Z.nextDouble() * 15.0 + 15.0, this.field_70159_w, this.field_70181_x, this.field_70179_y, this.field_70130_N * 0.5f);
                    this.field_70170_p.func_72838_d((Entity)entity);
                }
            }
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (result.field_72308_g != null && result.field_72308_g.equals((Object)this.shootingEntity)) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_187752_dd, 5.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
                Vec3d vec = result.field_72308_g != null ? result.field_72308_g.func_174791_d() : result.field_72307_f;
                EntityLightningArc.Base entity = new EntityLightningArc.Base(this.field_70170_p, vec.func_178786_a(0.0, 5.0, 0.0), vec.func_72441_c(0.0, 150.0, 0.0), -1073741569, 40, 0.0f, 6.0f);
                this.field_70170_p.func_72838_d((Entity)entity);
                float size = this.getEntityScale();
                boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity);
                this.field_70170_p.func_72885_a((Entity)this.shootingEntity, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, size, flag, flag);
                ProcedureAoeCommand.set(this.field_70170_p, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 10.0).exclude(this).exclude((Entity)this.shootingEntity).setFire(15).damageEntities(ItemJutsu.causeJutsuDamage(this, this.shootingEntity), 100.0f * size);
            }
            this.func_70106_y();
        }

        @Override
        protected void checkOnGround() {
        }

        public boolean func_180427_aV() {
            return true;
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (power >= 1.0f) {
                    entity.field_70170_p.func_72838_d((Entity)new EC(entity));
                    if (entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_()) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 300, 0, false, false));
                        ItemJutsu.setCurrentJutsuCooldown(stack, entity, 3600L);
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

