/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.potion.PotionParalysis;
import net.narutomod.procedure.ProcedureSync;

@ElementsNarutomodMod.ModElement.Tag
public class EntityLightningArc
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 135;
    public static final int ENTITYID_RANGED = 136;
    private static final Random rng = new Random();

    public EntityLightningArc(ElementsNarutomodMod instance) {
        super(instance, 380);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(Base.class).id(new ResourceLocation("narutomod", "lightning_arc"), 135).name("lightning_arc").tracker(96, 3, true).build());
    }

    public static boolean onStruck(Entity entity, DamageSource source, float damage) {
        return EntityLightningArc.onStruck(entity, source, damage, 100, true);
    }

    public static boolean onStruck(Entity entity, DamageSource source, float damage, int paralysisTicks) {
        boolean retval = entity.func_70097_a(source, damage);
        boolean flag = entity.func_70027_ad();
        entity.func_70077_a(new EntityLightningBolt(entity.field_70170_p, 0.0, 0.0, 0.0, true));
        if (!flag) {
            entity.func_70066_B();
        }
        if (entity instanceof EntityLivingBase && paralysisTicks > 0) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(PotionParalysis.potion, paralysisTicks, 2 + (int)(damage * 0.1f), false, false));
        }
        return retval;
    }

    public static boolean onStruck(Entity entity, DamageSource source, float damage, int ticks, boolean spreadInWater) {
        if (spreadInWater && entity.func_70090_H()) {
            for (EntityLivingBase entity1 : entity.field_70170_p.func_72872_a(EntityLivingBase.class, entity.func_174813_aQ().func_186662_g(10.0))) {
                float f = entity1.func_70032_d(entity);
                if (!entity1.func_70090_H() || !(f <= 10.0f)) continue;
                EntityLightningArc.onStruck((Entity)entity1, source, damage * (1.0f - f * 0.1f), ticks);
            }
        }
        return EntityLightningArc.onStruck(entity, source, damage, ticks);
    }

    public static void spawnAsParticle(World world, double x, double y, double z, int ... param) {
        EntityLightningArc.spawnAsParticle(world, x, y, z, 0.3, 0.0, 0.15, 0.0, param);
    }

    public static void spawnAsParticle(World world, double x, double y, double z, double length, double xSpeed, double ySpeed, double zSpeed, int ... param) {
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new Base(world, new Vec3d(x, y, z), length, xSpeed, ySpeed, zSpeed, param.length > 0 ? param[0] : -1073741569, param.length > 1 ? param[1] : 0, 0.0f, 0.1f));
        } else {
            ProcedureSync.CPacketSpawnLightning.sendToServer(x, y, z, length, xSpeed, ySpeed, zSpeed, param);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(Base.class, renderManager -> new RenderCustom(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends Render<Base> {
            private final double segmentOffset = 0.1;
            private int maxRecursiveDepth;
            private final Random rand;

            public RenderCustom(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.segmentOffset = 0.1;
                this.rand = new Random();
            }

            public boolean shouldRender(Base livingEntity, ICamera camera, double camX, double camY, double camZ) {
                return true;
            }

            public void doRender(Base entity, double x, double y, double z, float entityYaw, float partialTicks) {
                this.maxRecursiveDepth = entity.getMaxRecursiveDepth();
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                Vec3d vec3d = entity.getEndVec().func_178786_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                GlStateManager.func_179114_b((float)((float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.29577951308232)), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)(-MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)MathHelper.func_76133_a((double)(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c))) * 57.29577951308232)), (float)1.0f, (float)0.0f, (float)0.0f);
                double d = entity.getThickness();
                d = d == 0.0 ? Math.max(vec3d.func_72433_c() * 0.004, 6.0E-4) : d;
                int color = entity.getColor();
                boolean isstatic = entity.isStatic();
                Base.SegmentInfo si = (Base.SegmentInfo)entity.branches.get(0);
                if (!isstatic || si.getTotal() == 0) {
                    entity.resetBranches();
                    this.calcSections(entity, new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, vec3d.func_72433_c()), 0, si);
                }
                float f = isstatic ? ((float)entity.getLifeSpan() - partialTicks) / 20.0f : 1.0f;
                GlStateManager.func_179090_x();
                GlStateManager.func_179141_d();
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_179129_p();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179140_f();
                for (int j = 0; j < entity.branches.size(); ++j) {
                    si = (Base.SegmentInfo)entity.branches.get(j);
                    for (int i = 0; i < si.getTotal(); ++i) {
                        this.renderSection(si.getFrom(i), si.getTo(i), d * (j == 0 ? 1.0 : 0.6), color, f, j > 0);
                    }
                }
                GlStateManager.func_179145_e();
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179089_o();
                GlStateManager.func_179084_k();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179118_c();
                GlStateManager.func_179098_w();
                GlStateManager.func_179121_F();
            }

            private void calcSections(Base entity, Vec3d fromVec, Vec3d toVec, int recursiveDepth, Base.SegmentInfo segdata) {
                if (recursiveDepth == this.maxRecursiveDepth) {
                    int i = segdata.getTotal();
                    segdata.setData(i, fromVec, toVec);
                    segdata.setTotal(i + 1);
                } else {
                    Vec3d vec3d = toVec.func_178788_d(fromVec).func_186678_a(0.5);
                    double offset = vec3d.func_72433_c() * this.segmentOffset;
                    vec3d = vec3d.func_72441_c(this.rand.nextGaussian() * offset, this.rand.nextGaussian() * offset, this.rand.nextGaussian() * offset);
                    this.calcSections(entity, fromVec, fromVec.func_178787_e(vec3d), recursiveDepth + 1, segdata);
                    this.calcSections(entity, fromVec.func_178787_e(vec3d), toVec, recursiveDepth + 1, segdata);
                    if (this.rand.nextInt(5) == 0) {
                        Base.SegmentInfo si = new Base.SegmentInfo();
                        this.calcSections(entity, fromVec.func_178787_e(vec3d), fromVec.func_178787_e(vec3d.func_186678_a(1.8)), recursiveDepth + 1, si);
                        entity.branches.add(si);
                    }
                }
            }

            private void renderSection(Vec3d fromVec, Vec3d toVec, double thickness, int color, float opacity, boolean isBranch) {
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(isBranch ? 160.0f : 240.0f), (float)(isBranch ? 160.0f : 240.0f));
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
                int r = (color & 0xFF0000) >> 16;
                int g = (color & 0xFF00) >> 8;
                int b = color & 0xFF;
                for (int i = 1; i <= 3; ++i) {
                    double w = thickness * (double)i;
                    int a = isBranch ? 64 : 240;
                    int r1 = r;
                    int g1 = g;
                    int b1 = b;
                    if (i == 1) {
                        r1 = 255;
                        g1 = 255;
                        b1 = 255;
                        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    } else {
                        a = i == 3 ? 16 : 32;
                        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    }
                    a = (int)((float)a * opacity);
                    bufferbuilder.func_181662_b(fromVec.field_72450_a - w, fromVec.field_72448_b - w, fromVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                    bufferbuilder.func_181662_b(toVec.field_72450_a - w, toVec.field_72448_b - w, toVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                    bufferbuilder.func_181662_b(fromVec.field_72450_a - w, fromVec.field_72448_b + w, fromVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                    bufferbuilder.func_181662_b(toVec.field_72450_a - w, toVec.field_72448_b + w, toVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                    bufferbuilder.func_181662_b(fromVec.field_72450_a + w, fromVec.field_72448_b + w, fromVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                    bufferbuilder.func_181662_b(toVec.field_72450_a + w, toVec.field_72448_b + w, toVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                    bufferbuilder.func_181662_b(fromVec.field_72450_a + w, fromVec.field_72448_b - w, fromVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                    bufferbuilder.func_181662_b(toVec.field_72450_a + w, toVec.field_72448_b - w, toVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                    bufferbuilder.func_181662_b(fromVec.field_72450_a - w, fromVec.field_72448_b - w, fromVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                    bufferbuilder.func_181662_b(toVec.field_72450_a - w, toVec.field_72448_b - w, toVec.field_72449_c).func_181669_b(r1, g1, b1, a).func_181675_d();
                }
                tessellator.func_78381_a();
            }

            protected ResourceLocation getEntityTexture(Base entity) {
                return null;
            }
        }
    }

    public static class Base
    extends Entity {
        private static final DataParameter<Float> END_X = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> END_Y = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> END_Z = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Float> THICKNESS = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Integer> MAX_RECURSIVE_DEPTH = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Boolean> IS_STATIC = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187198_h);
        private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private Vec3d ogEndVec;
        private float inaccuracy;
        private DamageSource damageSource;
        private EntityLivingBase excludeEntity;
        private float damageAmount;
        private boolean resetHurtResistantTime;
        private int paralysisTicks;
        private final List<SegmentInfo> branches = Lists.newArrayList((Object[])new SegmentInfo[]{new SegmentInfo()});

        public Base(World worldIn) {
            super(worldIn);
            this.func_70105_a(0.1f, 0.1f);
            this.field_70178_ae = true;
            this.field_70158_ak = true;
        }

        public Base(World worldIn, Vec3d centerVec, double length, double xMotion, double yMotion, double zMotion) {
            this(worldIn, centerVec, length, xMotion, yMotion, zMotion, -1073741569, 0, 0.0f, 0.1f);
        }

        public Base(World worldIn, Vec3d centerVec, double length, double xMotion, double yMotion, double zMotion, float inaccuracyIn) {
            this(worldIn, centerVec, length, xMotion, yMotion, zMotion, -1073741569, 0, 0.0f, inaccuracyIn);
        }

        public Base(World worldIn, Vec3d centerVec, double length, double xMotion, double yMotion, double zMotion, int color) {
            this(worldIn, centerVec, length, xMotion, yMotion, zMotion, color, 0, 0.0f, 0.1f);
        }

        public Base(World worldIn, Vec3d centerVec, double length, double xMotion, double yMotion, double zMotion, int color, int duration, float thickness, float inaccuracyIn) {
            this(worldIn, centerVec, centerVec.func_72441_c((rng.nextDouble() - 0.5) * length * 2.0, (rng.nextDouble() - 0.5) * length * 2.0, (rng.nextDouble() - 0.5) * length * 2.0), color, duration, inaccuracyIn, thickness);
            this.field_70159_w = xMotion;
            this.field_70181_x = yMotion;
            this.field_70179_y = zMotion;
        }

        public Base(World worldIn, Vec3d fromVec, Vec3d toVec) {
            this(worldIn, fromVec, toVec, -1, 0, 0.5f);
        }

        public Base(World worldIn, Vec3d fromVec, Vec3d toVec, int colorIn, int duration, float inaccuracyIn) {
            this(worldIn, fromVec, toVec, colorIn, duration, inaccuracyIn, 0.0f, 4);
        }

        public Base(World worldIn, Vec3d fromVec, Vec3d toVec, int colorIn, int duration, float inaccuracyIn, float thickness) {
            this(worldIn, fromVec, toVec, colorIn, duration, inaccuracyIn, thickness, 4);
        }

        public Base(World worldIn, Vec3d fromVec, Vec3d toVec, int colorIn, int duration, float inaccuracyIn, float thickness, int sections) {
            this(worldIn);
            this.func_70107_b(fromVec.field_72450_a, fromVec.field_72448_b, fromVec.field_72449_c);
            this.ogEndVec = toVec;
            this.setEndVec(toVec.func_72441_c(this.field_70146_Z.nextGaussian() * (double)inaccuracyIn, this.field_70146_Z.nextGaussian() * (double)inaccuracyIn, this.field_70146_Z.nextGaussian() * (double)inaccuracyIn));
            this.setColor(colorIn);
            if (duration > 0) {
                this.setLifeSpan(duration);
            }
            this.inaccuracy = inaccuracyIn;
            if (thickness != 0.0f) {
                this.setThickness(thickness);
            }
            this.setMaxRecursiveDepth(sections);
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(END_X, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(END_Y, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(END_Z, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(COLOR, (Object)-1);
            this.func_184212_Q().func_187214_a(THICKNESS, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(MAX_RECURSIVE_DEPTH, (Object)4);
            this.func_184212_Q().func_187214_a(IS_STATIC, (Object)false);
            this.func_184212_Q().func_187214_a(LIFE, (Object)(this.field_70146_Z.nextInt(3) + 1));
        }

        public Vec3d getEndVec() {
            return new Vec3d((double)((Float)this.func_184212_Q().func_187225_a(END_X)).floatValue(), (double)((Float)this.func_184212_Q().func_187225_a(END_Y)).floatValue(), (double)((Float)this.func_184212_Q().func_187225_a(END_Z)).floatValue());
        }

        private void setEndVec(Vec3d vec) {
            this.func_184212_Q().func_187227_b(END_X, (Object)Float.valueOf((float)vec.field_72450_a));
            this.func_184212_Q().func_187227_b(END_Y, (Object)Float.valueOf((float)vec.field_72448_b));
            this.func_184212_Q().func_187227_b(END_Z, (Object)Float.valueOf((float)vec.field_72449_c));
        }

        public int getColor() {
            return (Integer)this.func_184212_Q().func_187225_a(COLOR);
        }

        protected void setColor(int color) {
            this.func_184212_Q().func_187227_b(COLOR, (Object)color);
        }

        public float getThickness() {
            return ((Float)this.func_184212_Q().func_187225_a(THICKNESS)).floatValue();
        }

        private void setThickness(float f) {
            this.func_184212_Q().func_187227_b(THICKNESS, (Object)Float.valueOf(f));
        }

        private int getMaxRecursiveDepth() {
            return (Integer)this.func_184212_Q().func_187225_a(MAX_RECURSIVE_DEPTH);
        }

        private void setMaxRecursiveDepth(int depth) {
            this.func_184212_Q().func_187227_b(MAX_RECURSIVE_DEPTH, (Object)depth);
        }

        public boolean isStatic() {
            return (Boolean)this.func_184212_Q().func_187225_a(IS_STATIC);
        }

        public Base setStatic() {
            this.func_184212_Q().func_187227_b(IS_STATIC, (Object)true);
            this.setLifeSpan(20);
            return this;
        }

        private int getLifeSpan() {
            return (Integer)this.func_184212_Q().func_187225_a(LIFE);
        }

        private void setLifeSpan(int life) {
            this.func_184212_Q().func_187227_b(LIFE, (Object)life);
        }

        public void setDamage(DamageSource source, float amount, @Nullable EntityLivingBase entity) {
            this.setDamage(source, amount, false, entity, 100);
        }

        public void setDamage(DamageSource source, float amount, @Nullable EntityLivingBase entity, int paralysis) {
            this.setDamage(source, amount, false, entity, paralysis);
        }

        public void setDamage(DamageSource source, float amount, boolean resetHurtTime, @Nullable EntityLivingBase entity) {
            this.setDamage(source, amount, resetHurtTime, entity, 100);
        }

        public void setDamage(DamageSource source, float amount, boolean resetHurtTime, @Nullable EntityLivingBase entity, int paralysis) {
            this.damageSource = source;
            this.excludeEntity = entity;
            this.damageAmount = amount;
            this.resetHurtResistantTime = resetHurtTime;
            this.paralysisTicks = paralysis;
        }

        public void func_70071_h_() {
            if (this.inaccuracy > 0.0f) {
                this.setEndVec(this.ogEndVec.func_72441_c(((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.inaccuracy * 2.0, (double)(this.field_70146_Z.nextFloat() * this.inaccuracy * 2.0f), (double)(this.field_70146_Z.nextFloat() * this.inaccuracy * 2.0f)));
            }
            if (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0) {
                this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            }
            if (this.damageAmount > 0.0f) {
                for (Entity entity : this.field_70170_p.func_72839_b((Entity)this.excludeEntity, this.func_174813_aQ().func_72321_a(this.ogEndVec.field_72450_a - this.field_70165_t, this.ogEndVec.field_72448_b - this.field_70163_u, this.ogEndVec.field_72449_c - this.field_70161_v).func_186662_g(1.0))) {
                    if (entity.func_174813_aQ().func_72327_a(this.func_174791_d(), this.ogEndVec) == null) continue;
                    if (this.resetHurtResistantTime) {
                        entity.field_70172_ad = 10;
                    }
                    EntityLightningArc.onStruck(entity, this.damageSource, this.damageAmount, this.paralysisTicks, true);
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                int i = this.getLifeSpan();
                if (--i <= 0) {
                    this.func_70106_y();
                } else {
                    this.setLifeSpan(i);
                }
            }
        }

        public boolean func_180427_aV() {
            return true;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        private void resetBranches() {
            for (int i = 1; i < this.branches.size(); ++i) {
                this.branches.remove(i);
            }
            this.branches.get(0).setTotal(0);
        }

        static class SegmentInfo {
            final Vec3d[][] segment = new Vec3d[65][2];
            int totalSegments;

            SegmentInfo() {
            }

            void setData(int index, Vec3d from, Vec3d to) {
                this.segment[index][0] = from;
                this.segment[index][1] = to;
            }

            Vec3d getFrom(int index) {
                return this.segment[index][0];
            }

            Vec3d getTo(int index) {
                return this.segment[index][1];
            }

            void setTotal(int i) {
                this.totalSegments = i;
            }

            int getTotal() {
                return this.totalSegments;
            }
        }
    }
}

