/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.PlayerTracker;
import net.narutomod.entity.EntityClone;
import net.narutomod.item.ItemJutsu;
import net.narutomod.item.ItemRinnegan;
import net.narutomod.item.ItemSixPathSenjutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityLimboClone
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 161;
    public static final int ENTITYID_RANGED = 162;
    public static final double CHAKRA_USAGE = 500.0;

    public EntityLimboClone(ElementsNarutomodMod instance) {
        super(instance, 418);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "limbo_clone"), 161).name("limbo_clone").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderEC(renderManager));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EntityAttackedHook());
    }

    public class EntityAttackedHook {
        @SubscribeEvent
        public void onAttacked(LivingAttackEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            List<EC> list = EC.Jutsu.getLimboClones(entity);
            if (!list.isEmpty()) {
                for (EC clone : list) {
                    if (!(clone.func_70068_e((Entity)entity) <= 64.0)) continue;
                    if (event.getSource().func_188404_v() != null) {
                        Vec3d vec = event.getSource().func_188404_v().func_178788_d(entity.func_174791_d()).func_186678_a(event.getSource().func_76364_f() instanceof EntityLivingBase ? 0.5 : 0.8);
                        ProcedureUtils.Vec2f vec2 = ProcedureUtils.getYawPitchFromVec(vec);
                        clone.func_70080_a(entity.field_70165_t + vec.field_72450_a, entity.field_70163_u + vec.field_72448_b, entity.field_70161_v + vec.field_72449_c, vec2.x, vec2.y);
                    }
                    event.setCanceled(true);
                    clone.func_70097_a(event.getSource(), event.getAmount());
                    return;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderEC
    extends EntityClone.ClientRLM.RenderClone<EC> {
        public RenderEC(RenderManager renderManager) {
            EntityClone.ClientRLM clientRLM = EntityClone.ClientRLM.getInstance();
            clientRLM.getClass();
            super(renderManager);
            this.field_76989_e = 0.0f;
        }

        @Override
        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
            if (entity.canBeDetectedBy(this.field_76990_c.field_78734_h)) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                super.doRender(entity, x, y, z, entityYaw, partialTicks);
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }

        @Override
        protected void renderLayers(EC entity, float f0, float f1, float f2, float f3, float f4, float f5, float f6) {
            if (entity.canBeDetectedBy(this.field_76990_c.field_78734_h)) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
                super.renderLayers(entity, f0, f1, f2, f3, f4, f5, f6);
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }

        protected boolean canRenderName(EC entity) {
            return false;
        }
    }

    public static class EC
    extends EntityClone._Base {
        private final int lifeSpan = 400;

        public EC(World world) {
            super(world);
            this.func_184224_h(true);
        }

        public EC(EntityLivingBase user) {
            super(user);
            this.func_184224_h(true);
            this.func_174805_g(false);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(user instanceof EntityPlayer ? PlayerTracker.getNinjaLevel((EntityPlayer)user) : ProcedureUtils.getModifiedAttackDamage(user));
            this.field_70765_h = new EntityClone.AIFlyControl((EntityLiving)this);
        }

        @Override
        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityClone.AIFollowSummoner((EntityLiving)this, 0.8, 3.0f));
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
            this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(1.2);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1000.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
        }

        @Override
        protected PathNavigate func_175447_b(World worldIn) {
            PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)this, worldIn);
            pathnavigateflying.func_192879_a(false);
            pathnavigateflying.func_192877_c(true);
            pathnavigateflying.func_192878_b(true);
            return pathnavigateflying;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            Entity attacker = source.func_76346_g();
            if (attacker instanceof EntityLivingBase && this.canBeDetectedBy((Entity)((EntityLivingBase)attacker))) {
                return super.func_70097_a(source, amount);
            }
            if (attacker instanceof EntityLivingBase) {
                this.func_70604_c((EntityLivingBase)attacker);
            }
            return false;
        }

        public boolean func_70067_L() {
            return false;
        }

        public boolean func_70104_M() {
            return false;
        }

        private boolean canBeDetectedBy(Entity entity) {
            return entity.equals((Object)this.getSummoner()) || entity instanceof EntityLivingBase && ItemRinnegan.wearingRinnegan((EntityLivingBase)entity) || entity instanceof EntityPlayer && ProcedureUtils.hasItemInInventory((EntityPlayer)entity, ItemSixPathSenjutsu.block);
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.field_70173_aa > this.lifeSpan) {
                if (this.getSummoner() != null) {
                    this.func_82149_j((Entity)this.getSummoner());
                    this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                if (this.field_70173_aa > this.lifeSpan + 2) {
                    this.func_70106_y();
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ID_KEY = "LimboCloneEntityIds";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (!Jutsu.getLimboClones(entity).isEmpty()) {
                    return false;
                }
                entity.field_70170_p.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:rinbo_hengoku")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                int[] ids = new int[2];
                for (int i = 0; i < 2; ++i) {
                    EC entity1 = new EC(entity);
                    entity.field_70170_p.func_72838_d((Entity)entity1);
                    ids[i] = entity1.func_145782_y();
                }
                entity.getEntityData().func_74783_a(ID_KEY, ids);
                if (entity instanceof EntityPlayer) {
                    ItemJutsu.setCurrentJutsuCooldown(stack, (EntityLivingBase)((EntityPlayer)entity), 2000L);
                }
                return true;
            }

            public static List<EC> getLimboClones(EntityLivingBase entity) {
                ArrayList list = Lists.newArrayList();
                int[] ids = entity.getEntityData().func_74759_k(ID_KEY);
                for (int i = 0; i < ids.length; ++i) {
                    Entity entity1 = entity.field_70170_p.func_73045_a(ids[i]);
                    if (!(entity1 instanceof EC)) continue;
                    list.add((EC)entity1);
                }
                return list;
            }
        }
    }
}

