/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodMod;
import net.narutomod.entity.EntityClone;
import net.narutomod.entity.EntityHaku;
import net.narutomod.entity.EntityIrukaSensei;
import net.narutomod.entity.EntityItachi;
import net.narutomod.entity.EntityKisameHoshigaki;
import net.narutomod.entity.EntityMightGuy;
import net.narutomod.entity.EntitySakuraHaruno;
import net.narutomod.entity.EntityTenten;
import net.narutomod.entity.EntityZabuzaMomochi;
import net.narutomod.item.ItemOnBody;
import net.narutomod.potion.PotionFeatherFalling;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityNinjaMob
extends ElementsNarutomodMod.ModElement {
    public static final List<Class<? extends Base>> TeamKonoha = Arrays.asList(EntityTenten.EntityCustom.class, EntitySakuraHaruno.EntityCustom.class, EntityIrukaSensei.EntityCustom.class, EntityMightGuy.EntityCustom.class);
    public static final List<Class<? extends Base>> TeamZabuza = Arrays.asList(EntityZabuzaMomochi.EntityCustom.class, EntityHaku.EntityCustom.class);
    public static final List<Class<? extends Base>> TeamItachi = Arrays.asList(EntityItachi.EntityCustom.class, EntityKisameHoshigaki.EntityCustom.class);

    public EntityNinjaMob(ElementsNarutomodMod instance) {
        super(instance, 404);
    }

    @SubscribeEvent
    public void onSpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!event.isSpawner() && entity instanceof Base) {
            entity.func_70107_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
            if (!((Base)entity).func_70601_bi()) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        if (target instanceof Base) {
            InventoryMessage.sendTo((EntityPlayerMP)event.getEntityPlayer(), (Base)target);
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.elements.addNetworkMessage(ChakraMessage.Handler.class, ChakraMessage.class, Side.SERVER);
        this.elements.addNetworkMessage(InventoryMessage.Handler.class, InventoryMessage.class, Side.CLIENT);
        this.elements.addNetworkMessage(StandStillMessage.Handler.class, StandStillMessage.class, Side.CLIENT);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static class StandStillMessage
    implements IMessage {
        int id;
        int ticks;

        public StandStillMessage() {
        }

        public StandStillMessage(Base entity) {
            this.id = entity.func_145782_y();
            this.ticks = entity.standStillTicks;
        }

        public static void sendToTracking(Base entity) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new StandStillMessage(entity), (Entity)entity);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeInt(this.ticks);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.ticks = buf.readInt();
        }

        public static class Handler
        implements IMessageHandler<StandStillMessage, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(StandStillMessage message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> {
                    Entity entity = mc.field_71441_e.func_73045_a(message.id);
                    if (entity instanceof Base) {
                        ((Base)entity).standStillTicks = message.ticks;
                    }
                });
                return null;
            }
        }
    }

    public static class InventoryMessage
    implements IMessage {
        int id;
        List<ItemStack> list;

        public InventoryMessage() {
        }

        public InventoryMessage(Base entity) {
            this.id = entity.func_145782_y();
            this.list = entity.inventory;
        }

        public static void sendToTracking(Base entity) {
            NarutomodMod.PACKET_HANDLER.sendToAllTracking((IMessage)new InventoryMessage(entity), (Entity)entity);
        }

        public static void sendTo(EntityPlayerMP player, Base entity) {
            NarutomodMod.PACKET_HANDLER.sendTo((IMessage)new InventoryMessage(entity), player);
        }

        public void toBytes(ByteBuf buf) {
            PacketBuffer pbuf = new PacketBuffer(buf);
            pbuf.writeInt(this.id);
            int j = this.list.size();
            pbuf.writeInt(j);
            for (int i = 0; i < j; ++i) {
                pbuf.func_150788_a(this.list.get(i));
            }
        }

        public void fromBytes(ByteBuf buf) {
            PacketBuffer pbuf = new PacketBuffer(buf);
            this.id = pbuf.readInt();
            int j = pbuf.readInt();
            this.list = Lists.newArrayList();
            try {
                for (int i = 0; i < j; ++i) {
                    this.list.add(pbuf.func_150791_c());
                }
            }
            catch (Exception e) {
                new IOException("NinjaMob@inventory packet: ", e);
            }
        }

        public static class Handler
        implements IMessageHandler<InventoryMessage, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(InventoryMessage message, MessageContext context) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> {
                    Entity entity = mc.field_71441_e.func_73045_a(message.id);
                    if (entity instanceof Base) {
                        for (int i = 0; i < message.list.size() && i < 2; ++i) {
                            ((Base)entity).inventory.set(i, (Object)message.list.get(i));
                        }
                    }
                });
                return null;
            }
        }
    }

    public static class ChakraMessage
    implements IMessage {
        int id;
        double d0;
        double d1;

        public ChakraMessage() {
        }

        public ChakraMessage(Base entity, double max, double chakra) {
            this.id = entity.func_145782_y();
            this.d0 = max;
            this.d1 = chakra;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeDouble(this.d0);
            buf.writeDouble(this.d1);
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.d0 = buf.readDouble();
            this.d1 = buf.readDouble();
        }

        public static class Handler
        implements IMessageHandler<ChakraMessage, IMessage> {
            public IMessage onMessage(ChakraMessage message, MessageContext context) {
                EntityPlayerMP entity = context.getServerHandler().field_147369_b;
                entity.func_71121_q().func_152344_a(() -> {
                    World world = entity.field_70170_p;
                    if (!world.func_175667_e(new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v))) {
                        return;
                    }
                    Entity entity1 = world.func_73045_a(message.id);
                    if (entity1 instanceof Base) {
                        ((Base)entity1).chakraPathway.setMax(message.d0);
                        ((Base)entity1).chakraPathway.set(message.d1);
                    }
                });
                return null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class LayerInventoryItem
    implements LayerRenderer<Base> {
        private final RenderBiped renderer;

        public LayerInventoryItem(RenderBiped rendererIn) {
            this.renderer = rendererIn;
        }

        public void doRenderLayer(Base entityIn, float f1, float f2, float f3, float f4, float f5, float f6, float f7) {
            for (int i = 0; i < entityIn.inventory.size(); ++i) {
                ItemOnBody.Interface item;
                ItemStack stack = (ItemStack)entityIn.inventory.get(i);
                if (!(stack.func_77973_b() instanceof ItemOnBody.Interface) || (item = (ItemOnBody.Interface)stack.func_77973_b()).showOnBody() == ItemOnBody.BodyPart.NONE) continue;
                Vec3d offset = item.getOffset();
                GlStateManager.func_179094_E();
                ModelBiped model = (ModelBiped)this.renderer.func_177087_b();
                switch (item.showOnBody()) {
                    case HEAD: {
                        model.field_78116_c.func_78794_c(0.0625f);
                        break;
                    }
                    case TORSO: {
                        model.field_78115_e.func_78794_c(0.0625f);
                        break;
                    }
                    case RIGHT_ARM: {
                        model.field_178723_h.func_78794_c(0.0625f);
                        break;
                    }
                    case LEFT_ARM: {
                        model.field_178724_i.func_78794_c(0.0625f);
                        break;
                    }
                    case RIGHT_LEG: {
                        model.field_178721_j.func_78794_c(0.0625f);
                        break;
                    }
                    case LEFT_LEG: {
                        model.field_178722_k.func_78794_c(0.0625f);
                    }
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)offset.field_72450_a, (double)(-0.25 + offset.field_72448_b), (double)offset.field_72449_c);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.625f, (float)-0.625f, (float)-0.625f);
                Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)entityIn, stack, ItemCameraTransforms.TransformType.HEAD);
                GlStateManager.func_179121_F();
            }
        }

        public boolean func_177142_b() {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class RenderBase<T extends Base>
    extends RenderBiped<T> {
        public RenderBase(RenderManager renderManager, ModelBiped model) {
            super(renderManager, model, 0.5f);
            EntityClone.ClientRLM clientRLM = EntityClone.ClientRLM.getInstance();
            clientRLM.getClass();
            this.func_177094_a((LayerRenderer)clientRLM.new EntityClone.ClientRLM.BipedArmorLayer((RenderLivingBase<?>)this));
            this.func_177094_a(new LayerInventoryItem(this));
        }

        public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
            this.setPose(entity);
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }

        private void setPose(T entity) {
            ModelBiped model = (ModelBiped)this.func_177087_b();
            ItemStack itemstack = entity.func_184614_ca();
            ItemStack itemstack1 = entity.func_184592_cb();
            ModelBiped.ArmPose mainhandpose = ModelBiped.ArmPose.EMPTY;
            ModelBiped.ArmPose offhandpose = ModelBiped.ArmPose.EMPTY;
            if (!itemstack.func_190926_b()) {
                mainhandpose = ModelBiped.ArmPose.ITEM;
                if (entity.func_184605_cv() > 0) {
                    EnumAction enumaction = itemstack.func_77975_n();
                    if (enumaction == EnumAction.BLOCK) {
                        mainhandpose = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction == EnumAction.BOW) {
                        mainhandpose = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (!itemstack1.func_190926_b()) {
                offhandpose = ModelBiped.ArmPose.ITEM;
                if (entity.func_184605_cv() > 0) {
                    EnumAction enumaction1 = itemstack1.func_77975_n();
                    if (enumaction1 == EnumAction.BLOCK) {
                        offhandpose = ModelBiped.ArmPose.BLOCK;
                    } else if (enumaction1 == EnumAction.BOW) {
                        offhandpose = ModelBiped.ArmPose.BOW_AND_ARROW;
                    }
                }
            }
            if (entity.func_184591_cq() == EnumHandSide.RIGHT) {
                model.field_187076_m = mainhandpose;
                model.field_187075_l = offhandpose;
            } else {
                model.field_187076_m = offhandpose;
                model.field_187075_l = mainhandpose;
            }
        }
    }

    public static class SwimHelper
    extends EntityMoveHelper {
        public SwimHelper(EntityLiving entityIn) {
            super(entityIn);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d1 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d2 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                if (d3 < 1.6E-7) {
                    ProcedureUtils.multiplyVelocity((Entity)this.field_75648_a, 0.0);
                } else {
                    float f = (float)(this.field_75645_e * ProcedureUtils.getModifiedSpeed((EntityLivingBase)this.field_75648_a));
                    this.field_75648_a.field_70159_w = d0 / d3 * (double)f;
                    this.field_75648_a.field_70181_x = d1 / d3 * (double)f;
                    this.field_75648_a.field_70179_y = d2 / d3 * (double)f;
                    float f1 = -((float)MathHelper.func_181159_b((double)this.field_75648_a.field_70159_w, (double)this.field_75648_a.field_70179_y)) * 57.295776f;
                    this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f1, 10.0f);
                }
            }
        }
    }

    public static class MoveHelper
    extends EntityMoveHelper {
        public MoveHelper(EntityCreature entityIn) {
            super((EntityLiving)entityIn);
        }

        public void func_75641_c() {
            if (this.func_75640_a()) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d2 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d1 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.5E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f9 = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f9, 90.0f);
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (d2 > 0.01 && this.field_75648_a.field_70123_F) {
                    this.field_75648_a.field_70181_x = 0.42;
                } else if (d2 > (double)this.field_75648_a.field_70138_W && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.field_75648_a.field_70130_N)) {
                    this.field_75648_a.func_70683_ar().func_75660_a();
                    this.field_188491_h = EntityMoveHelper.Action.JUMPING;
                }
            } else {
                super.func_75641_c();
            }
        }
    }

    public static class NavigateGround
    extends PathNavigateGround {
        private BlockPos targetPosition;

        public NavigateGround(EntityLiving entityLivingIn, World worldIn) {
            super(entityLivingIn, worldIn);
        }

        public Path func_179680_a(BlockPos pos) {
            this.targetPosition = pos;
            return super.func_179680_a(pos);
        }

        public Path func_75494_a(Entity entityIn) {
            this.targetPosition = new BlockPos(entityIn);
            return super.func_75494_a(entityIn);
        }

        public boolean func_75497_a(Entity entityIn, double speedIn) {
            Path path = this.func_75494_a(entityIn);
            if (path != null) {
                return this.func_75484_a(path, speedIn);
            }
            this.targetPosition = new BlockPos(entityIn);
            this.field_75511_d = speedIn;
            return true;
        }

        public void func_75499_g() {
            super.func_75499_g();
            this.targetPosition = null;
        }

        public void func_75501_e() {
            if (!this.func_75500_f()) {
                super.func_75501_e();
            } else if (this.targetPosition != null) {
                double d0 = this.field_75515_a.field_70130_N * this.field_75515_a.field_70130_N;
                double d1 = (double)this.targetPosition.func_177956_o() - this.field_75515_a.field_70163_u;
                double d2 = this.field_75515_a.func_174831_c(new BlockPos(this.targetPosition.func_177958_n(), MathHelper.func_76128_c((double)this.field_75515_a.field_70163_u), this.targetPosition.func_177952_p()));
                if (d2 >= d0 && d1 <= (double)this.field_75515_a.field_70138_W && d1 >= -12.0 * (double)this.field_75515_a.field_70131_O) {
                    this.field_75515_a.func_70605_aq().func_75642_a((double)this.targetPosition.func_177958_n() + 0.5, (double)this.targetPosition.func_177956_o(), (double)this.targetPosition.func_177952_p() + 0.5, this.field_75511_d);
                } else {
                    this.targetPosition = null;
                }
            }
        }
    }

    public static class AIDefendEntity
    extends EntityAITarget {
        private final EntityLivingBase defendedEntity;

        public AIDefendEntity(Base ninjamob, EntityLivingBase protectedEntity) {
            super((EntityCreature)ninjamob, false);
            this.defendedEntity = protectedEntity;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase living;
            this.field_188509_g = this.defendedEntity.func_70643_av();
            if (this.field_188509_g == null && (living = this.defendedEntity.func_110144_aD()) != null && this.defendedEntity.field_70173_aa - this.defendedEntity.func_142013_aG() < 200) {
                this.field_188509_g = living;
            }
            if (this.field_188509_g == null && this.defendedEntity instanceof EntityLiving) {
                this.field_188509_g = ((EntityLiving)this.defendedEntity).func_70638_az();
            }
            return this.field_188509_g != null && this.func_75296_a(this.field_188509_g, false);
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.field_188509_g);
            super.func_75249_e();
        }
    }

    public static class AIAttackRangedJutsu<T extends EntityLiving>
    extends EntityAIBase {
        protected final T entity;
        private int attackCooldown;
        private final float attackRadius;
        private int attackTime;
        private Vec3d targetPos;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public AIAttackRangedJutsu(T entityIn, int cooldown, float maxDistance) {
            this.entity = entityIn;
            this.attackCooldown = cooldown;
            this.attackTime = cooldown;
            this.attackRadius = maxDistance;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            --this.attackTime;
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null && this.attackTime <= 0) {
                this.attackTime = 0;
                Vec3d vec = this.entity.func_174791_d().func_178788_d(target.func_174791_d()).func_72432_b().func_186678_a((double)this.attackRadius).func_178787_e(this.entity.func_174791_d());
                for (double d = vec.field_72448_b - 3.0; d < vec.field_72448_b + 7.0; d += 1.0) {
                    BlockPos pos = new BlockPos(vec.field_72450_a, d, vec.field_72449_c);
                    if (!this.entity.func_70661_as().func_188555_b(pos)) continue;
                    this.targetPos = new Vec3d((Vec3i)pos);
                    return true;
                }
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.targetPos != null && --this.attackTime >= -100;
        }

        public void func_75249_e() {
            double d0 = this.targetPos.field_72450_a - ((EntityLiving)this.entity).field_70165_t;
            double d1 = this.targetPos.field_72449_c - ((EntityLiving)this.entity).field_70161_v;
            double d4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            double d2 = this.targetPos.field_72448_b - ((EntityLiving)this.entity).field_70163_u + d4 * 0.2;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            if (d3 >= 1.0E-4) {
                ((EntityLiving)this.entity).field_70159_w = d0 / d3;
                ((EntityLiving)this.entity).field_70179_y = d1 / d3;
                ((EntityLiving)this.entity).field_70181_x = d2 / d3;
            }
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.entity.func_70638_az();
            if (entitylivingbase != null) {
                double d0 = this.entity.func_70032_d((Entity)entitylivingbase);
                if (d0 < (double)this.attackRadius - 2.0) {
                    this.entity.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else if (d0 > (double)this.attackRadius + 2.0) {
                    this.entity.func_70661_as().func_75497_a((Entity)entitylivingbase, 1.0);
                    this.strafingTime = -1;
                } else {
                    float f = (float)d0 / this.attackRadius;
                    ((IRangedAttackMob)this.entity).func_82196_d(entitylivingbase, MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f));
                    this.attackTime = MathHelper.func_76141_d((float)(f * (float)this.attackCooldown));
                    this.targetPos = null;
                    return;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)this.attackRadius + 2.0) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)this.attackRadius - 2.0) {
                        this.strafingBackwards = true;
                    }
                    this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -1.25f : 1.25f, 0.0f);
                    this.entity.func_70625_a((Entity)entitylivingbase, 30.0f, 30.0f);
                } else {
                    this.entity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
                }
            }
        }
    }

    public static class AIAttackRangedTactical<T extends EntityCreature>
    extends EntityAIBase {
        protected final T entity;
        private final double moveSpeedAmp;
        private int attackCooldown;
        private final float attackRadius;
        private final float maxAttackDistance;
        private int attackTime = -1;
        private int seeTime;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public AIAttackRangedTactical(T entityIn, double moveSpeed, int cooldown, float maxDistance) {
            this.entity = entityIn;
            this.moveSpeedAmp = moveSpeed;
            this.attackCooldown = cooldown;
            this.attackRadius = maxDistance;
            this.maxAttackDistance = maxDistance * maxDistance;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return this.entity.func_70638_az() != null;
        }

        public boolean func_75253_b() {
            return this.func_75250_a() || !this.entity.func_70661_as().func_75500_f();
        }

        public void func_75249_e() {
            super.func_75249_e();
            ((IRangedAttackMob)this.entity).func_184724_a(true);
        }

        public void func_75251_c() {
            super.func_75251_c();
            ((IRangedAttackMob)this.entity).func_184724_a(false);
            this.seeTime = 0;
            this.attackTime = -1;
            this.entity.func_184602_cy();
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.entity.func_70638_az();
            if (entitylivingbase != null) {
                boolean flag1;
                double d0 = this.entity.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
                boolean flag = this.entity.func_70635_at().func_75522_a((Entity)entitylivingbase);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                    this.entity.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else {
                    this.entity.func_70661_as().func_75497_a((Entity)entitylivingbase, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.entity.func_70681_au().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    this.entity.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                    this.entity.func_70625_a((Entity)entitylivingbase, 30.0f, 30.0f);
                } else {
                    this.entity.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
                }
                if (--this.attackTime == 0) {
                    if (!flag) {
                        return;
                    }
                    float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                    float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
                    ((IRangedAttackMob)this.entity).func_82196_d(entitylivingbase, lvt_5_1_);
                    this.attackTime = MathHelper.func_76141_d((float)(f * (float)this.attackCooldown));
                } else if (this.attackTime < 0) {
                    float f = MathHelper.func_76133_a((double)d0) / this.attackRadius;
                    this.attackTime = MathHelper.func_76141_d((float)(f * (float)this.attackCooldown));
                }
            }
        }
    }

    public static class AILeapAtTarget
    extends EntityAIBase {
        protected EntityLiving leaper;
        protected EntityLivingBase target;
        protected float leapStrength;

        public AILeapAtTarget(EntityLiving leapingEntity, float leapStrengthIn) {
            this.leaper = leapingEntity;
            this.leapStrength = leapStrengthIn;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            this.target = this.leaper.func_70638_az();
            if (this.target == null) {
                return false;
            }
            double d0 = this.leaper.func_70032_d((Entity)this.target);
            if (d0 >= 3.0 && d0 <= (double)this.leapStrength * 12.0 && this.leaper.field_70122_E) {
                return this.leaper.func_70681_au().nextInt(5) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return !this.leaper.field_70122_E;
        }

        public void func_75249_e() {
            double d0 = this.target.field_70165_t - this.leaper.field_70165_t;
            double d1 = this.target.field_70161_v - this.leaper.field_70161_v;
            double d4 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            double d2 = this.target.field_70163_u + (double)this.target.field_70131_O / 3.0 - this.leaper.field_70163_u + d4 * 0.2;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
            if (d3 >= 1.0E-4) {
                this.leaper.field_70159_w = d0 / d3 * (double)this.leapStrength;
                this.leaper.field_70179_y = d1 / d3 * (double)this.leapStrength;
                this.leaper.field_70181_x = d2 / d3 * (double)this.leapStrength;
            }
        }
    }

    public static abstract class Base
    extends EntityCreature {
        private static final DataParameter<Float> CHAKRA_MAX = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> CHAKRA = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187193_c);
        private final PathwayNinjaMob chakraPathway;
        private static final int inventorySize = 2;
        private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        public int peacefulTicks;
        private int standStillTicks;

        public Base(World worldIn, int level, double chakraAmountIn) {
            super(worldIn);
            this.func_70105_a(0.6f, 1.8f);
            this.field_70728_aV = level;
            this.field_70178_ae = false;
            this.field_70138_W = 16.0f;
            this.field_70765_h = new MoveHelper(this);
            this.func_94061_f(false);
            this.func_98053_h(false);
            this.func_96094_a(this.func_70005_c_());
            this.func_174805_g(true);
            this.chakraPathway = new PathwayNinjaMob(this, chakraAmountIn);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0 + 0.005 * (double)level * (double)level);
            this.func_70606_j(this.func_110138_aP());
        }

        protected PathNavigate func_175447_b(World worldIn) {
            NavigateGround navi = new NavigateGround((EntityLiving)this, worldIn);
            navi.func_179693_d(true);
            return navi;
        }

        protected void func_70088_a() {
            super.func_70088_a();
            this.func_184212_Q().func_187214_a(CHAKRA_MAX, (Object)Float.valueOf(0.0f));
            this.func_184212_Q().func_187214_a(CHAKRA, (Object)Float.valueOf(0.0f));
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        }

        public int func_82143_as() {
            return 12;
        }

        public boolean func_184652_a(EntityPlayer player) {
            return player.func_184812_l_();
        }

        public int getNinjaLevel() {
            return this.field_70728_aV;
        }

        public PathwayNinjaMob getChakraPathway() {
            return this.chakraPathway;
        }

        public double getChakra() {
            return this.chakraPathway.getAmount();
        }

        public boolean consumeChakra(double amount) {
            return this.chakraPathway.consume(amount);
        }

        private void fixOnClientSpawn() {
            if (this.field_70170_p.field_72995_K && this.field_70173_aa < 20) {
                this.chakraPathway.fixOnClientSpawn();
            }
        }

        protected void func_70619_bc() {
            super.func_70619_bc();
            EntityLivingBase target = this.func_70638_az();
            if (ProcedureUtils.isWeapon(this.getItemFromInventory(0)) || ProcedureUtils.isWeapon(this.func_184614_ca())) {
                boolean flag;
                boolean bl = flag = this.func_70643_av() != null || target != null || this.func_110144_aD() != null && this.field_70173_aa <= this.func_142013_aG() + 100;
                if (this.func_184614_ca().func_190926_b() == flag) {
                    this.swapWithInventory(EntityEquipmentSlot.MAINHAND, 0);
                }
            }
        }

        public void func_70071_h_() {
            this.fixOnClientSpawn();
            super.func_70071_h_();
            BlockPos pos = new BlockPos((Entity)this);
            if (this.field_70699_by instanceof PathNavigateGround && this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h && this.field_70170_p.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151586_h) {
                this.field_70181_x = 0.01;
                this.field_70122_E = true;
            }
            if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
                if (this.field_70173_aa % 200 == 1) {
                    this.func_70690_d(new PotionEffect(PotionFeatherFalling.potion, 201, 1, false, false));
                }
                this.chakraPathway.onUpdate();
                if (this instanceof IMob && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                    this.func_70106_y();
                }
            }
        }

        public void func_191986_a(float strafe, float vertical, float forward) {
            if (this.standStillTicks > 0) {
                strafe = 0.0f;
                forward = 0.0f;
                vertical = 0.0f;
                --this.standStillTicks;
            }
            super.func_191986_a(strafe, vertical, forward);
        }

        public void standStillFor(int ticks) {
            this.standStillTicks = ticks;
            StandStillMessage.sendToTracking(this);
        }

        public void func_70636_d() {
            this.decrementAnimations();
            super.func_70636_d();
        }

        protected float func_189749_co() {
            return 0.98f;
        }

        public boolean func_70652_k(Entity entityIn) {
            return ProcedureUtils.attackEntityAsMob((EntityLivingBase)this, entityIn);
        }

        protected void decrementAnimations() {
            this.func_82168_bl();
            for (ItemStack stack : this.func_184214_aD()) {
                if (stack.func_190926_b()) continue;
                stack.func_77945_a(this.field_70170_p, (Entity)this, 0, false);
            }
            for (ItemStack stack : this.inventory) {
                if (stack.func_190926_b()) continue;
                stack.func_77945_a(this.field_70170_p, (Entity)this, 0, false);
            }
        }

        public ItemStack getItemFromInventory(int slotno) {
            return slotno >= 0 && slotno < this.inventory.size() ? (ItemStack)this.inventory.get(slotno) : ItemStack.field_190927_a;
        }

        public void setItemToInventory(ItemStack stack, int slotno) {
            if (slotno >= 0 && slotno < this.inventory.size()) {
                this.inventory.set(slotno, (Object)stack);
            }
        }

        public void swapWithInventory(EntityEquipmentSlot slot, int slotno) {
            ItemStack stack = (ItemStack)this.inventory.get(slotno);
            this.inventory.set(slotno, (Object)this.func_184582_a(slot));
            this.func_184201_a(slot, stack);
            InventoryMessage.sendToTracking(this);
        }

        protected boolean isValidLightLevel() {
            BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
            if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
                return false;
            }
            int i = this.field_70170_p.func_175671_l(blockpos);
            if (this.field_70170_p.func_72911_I()) {
                int j = this.field_70170_p.func_175657_ab();
                this.field_70170_p.func_175692_b(10);
                i = this.field_70170_p.func_175671_l(blockpos);
                this.field_70170_p.func_175692_b(j);
            }
            return i <= this.field_70146_Z.nextInt(8);
        }

        public boolean func_70601_bi() {
            return super.func_70601_bi() && (!(this instanceof IMob) || this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.isValidLightLevel());
        }

        public SoundCategory func_184176_by() {
            return this instanceof IMob ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL;
        }

        public SoundEvent func_184639_G() {
            return null;
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return this instanceof IMob ? SoundEvents.field_187741_cz : SoundEvents.field_187543_bD;
        }

        public SoundEvent func_184615_bR() {
            return this instanceof IMob ? SoundEvents.field_187738_cy : SoundEvents.field_187661_by;
        }

        protected float func_70599_aP() {
            return 1.0f;
        }

        public Vec3d func_70040_Z() {
            return this.func_174806_f(this.field_70125_A, this.field_70759_as);
        }

        protected boolean canSeeInvisible(Entity entityIn) {
            if (entityIn.func_82150_aj()) {
                double d0 = entityIn.func_70032_d(entityIn);
                double d1 = ProcedureUtils.getFollowRange((EntityLivingBase)this);
                return d0 <= d1 * (entityIn.equals((Object)this.func_70643_av()) || entityIn.equals((Object)this.func_110144_aD()) || entityIn.equals((Object)this.func_70638_az()) ? 0.25 : 0.1);
            }
            return true;
        }

        public boolean func_70685_l(Entity entityIn) {
            return super.func_70685_l(entityIn) && this.canSeeInvisible(entityIn);
        }

        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74780_a("maxChakra", this.chakraPathway.getMax());
            compound.func_74780_a("chakra", this.getChakra());
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.inventory.size(); ++i) {
                ItemStack stack = (ItemStack)this.inventory.get(i);
                if (stack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("slotNo", i);
                stack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("sideInventory", (NBTBase)nbttaglist);
        }

        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            this.chakraPathway.setMax(compound.func_74769_h("maxChakra"));
            this.chakraPathway.set(compound.func_74769_h("chakra"));
            if (compound.func_150297_b("sideInventory", 9)) {
                NBTTagList nbttaglist = compound.func_150295_c("sideInventory", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound cmp = nbttaglist.func_150305_b(i);
                    int j = cmp.func_74762_e("slotNo");
                    if (j < 0 || j >= this.inventory.size()) continue;
                    this.inventory.set(j, (Object)new ItemStack(cmp));
                }
            }
        }

        public class PathwayNinjaMob
        extends Chakra.Pathway<Base> {
            protected PathwayNinjaMob(Base entityIn, double max) {
                super(entityIn);
                this.setMax(max);
                this.set(max);
            }

            private float getMaxFromSync() {
                return ((Float)Base.this.func_184212_Q().func_187225_a(CHAKRA_MAX)).floatValue();
            }

            @Override
            public double getMax() {
                float f = this.getMaxFromSync();
                return f == 0.0f ? super.getMax() : (double)f;
            }

            @Override
            public Chakra.Pathway<Base> setMax(double d) {
                Base.this.func_184212_Q().func_187227_b(CHAKRA_MAX, (Object)Float.valueOf((float)d));
                return super.setMax(d);
            }

            private void fixOnClientSpawn() {
                if ((double)this.getMaxFromSync() != super.getMax()) {
                    NarutomodMod.PACKET_HANDLER.sendToServer((IMessage)new ChakraMessage(Base.this, super.getMax(), super.getAmount()));
                }
            }

            @Override
            public double getAmount() {
                return this.getMaxFromSync() == 0.0f ? super.getAmount() : (double)((Float)Base.this.func_184212_Q().func_187225_a(CHAKRA)).floatValue();
            }

            @Override
            protected void set(double amountIn) {
                Base.this.func_184212_Q().func_187227_b(CHAKRA, (Object)Float.valueOf((float)amountIn));
                super.set(amountIn);
            }

            @Override
            protected void onUpdate() {
                if (!(((Base)this.user).func_70638_az() != null && ((Base)this.user).func_70638_az().func_70089_S() || ((Base)this.user).func_94060_bK() != null && ((Base)this.user).func_94060_bK().func_70089_S())) {
                    ++((Base)this.user).peacefulTicks;
                    if (((Base)this.user).peacefulTicks % 20 == 19) {
                        this.consume(-this.getMax() * 0.04);
                        if (((Base)this.user).func_110143_aJ() < ((Base)this.user).func_110138_aP()) {
                            ((Base)this.user).func_70606_j(((Base)this.user).func_110143_aJ() + 1.0f);
                        }
                    }
                } else {
                    ((Base)this.user).peacefulTicks = 0;
                }
            }
        }
    }
}

