/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.entity.EntityTailedBeast;
import net.narutomod.item.ItemDoton;
import net.narutomod.item.ItemFuton;
import net.narutomod.item.ItemJiton;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityOneTail
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 259;
    public static final int ENTITYID_RANGED = 260;
    private static final float MODELSCALE = 19.0f;
    private static final TailBeastManager tailBeastManager = new TailBeastManager();

    public EntityOneTail(ElementsNarutomodMod instance) {
        super(instance, 583);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "one_tail"), 259).name("one_tail").tracker(96, 3, true).egg(-3355648, -16737844).build());
    }

    public static TailBeastManager getBijuManager() {
        return tailBeastManager;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new RenderCustom(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelOneTail
        extends ModelBiped {
            private final ModelRenderer eyes;
            private final ModelRenderer cube_r1;
            private final ModelRenderer cube_r2;
            private final ModelRenderer cube_r3;
            private final ModelRenderer cube_r4;
            private final ModelRenderer cube_r5;
            private final ModelRenderer jaw;
            private final ModelRenderer bone3;
            private final ModelRenderer cube_r6;
            private final ModelRenderer bone4;
            private final ModelRenderer cube_r7;
            private final ModelRenderer rightArm;
            private final ModelRenderer cube_r8;
            private final ModelRenderer cube_r9;
            private final ModelRenderer cube_r10;
            private final ModelRenderer bone;
            private final ModelRenderer cube_r11;
            private final ModelRenderer cube_r12;
            private final ModelRenderer cube_r13;
            private final ModelRenderer cube_r14;
            private final ModelRenderer leftArm;
            private final ModelRenderer cube_r15;
            private final ModelRenderer cube_r16;
            private final ModelRenderer cube_r17;
            private final ModelRenderer bone2;
            private final ModelRenderer cube_r18;
            private final ModelRenderer cube_r19;
            private final ModelRenderer cube_r20;
            private final ModelRenderer cube_r21;
            private final ModelRenderer stomach;
            private final ModelRenderer cube_r22;
            private final ModelRenderer cube_r23;
            private final ModelRenderer upperbody;
            private final ModelRenderer cube_r24;
            private final ModelRenderer cube_r25;
            private final ModelRenderer cube_r26;
            private final ModelRenderer rightFoot;
            private final ModelRenderer cube_r27;
            private final ModelRenderer cube_r28;
            private final ModelRenderer cube_r29;
            private final ModelRenderer cube_r30;
            private final ModelRenderer cube_r31;
            private final ModelRenderer cube_r32;
            private final ModelRenderer leftFoot;
            private final ModelRenderer cube_r33;
            private final ModelRenderer cube_r34;
            private final ModelRenderer cube_r35;
            private final ModelRenderer cube_r36;
            private final ModelRenderer cube_r37;
            private final ModelRenderer[] tail = new ModelRenderer[9];
            private final float[] tailSwayX = new float[this.tail.length];
            private final float[] tailSwayY = new float[this.tail.length];
            private final float[] tailSwayZ = new float[this.tail.length];
            private final Random rand = new Random();

            public ModelOneTail() {
                this.field_78090_t = 64;
                this.field_78089_u = 64;
                this.field_178720_f = new ModelRenderer((ModelBase)this);
                this.field_178720_f.func_78793_a(0.0f, 21.0f, 3.0f);
                this.eyes = new ModelRenderer((ModelBase)this);
                this.eyes.func_78793_a(0.0f, -9.6f, -7.0f);
                this.field_178720_f.func_78792_a(this.eyes);
                this.eyes.field_78804_l.add(new ModelBox(this.eyes, 41, 4, -1.5f, -3.0f, -4.7f, 3, 1, 0, 0.0f, false));
                this.field_78115_e = new ModelRenderer((ModelBase)this);
                this.field_78115_e.func_78793_a(0.0f, 21.0f, 3.0f);
                this.field_78116_c = new ModelRenderer((ModelBase)this);
                this.field_78116_c.func_78793_a(0.0f, -9.6f, -7.0f);
                this.field_78115_e.func_78792_a(this.field_78116_c);
                this.field_78116_c.field_78804_l.add(new ModelBox(this.field_78116_c, 52, 8, -1.5f, -0.72f, -5.4006f, 3, 0, 3, 0.0f, false));
                this.cube_r1 = new ModelRenderer((ModelBase)this);
                this.cube_r1.func_78793_a(0.0f, -2.4f, -5.5f);
                this.field_78116_c.func_78792_a(this.cube_r1);
                this.setRotationAngle(this.cube_r1, 0.3054f, 0.0f, 0.0f);
                this.cube_r1.field_78804_l.add(new ModelBox(this.cube_r1, 58, 2, -1.0f, 0.55f, -0.2921f, 2, 1, 1, 0.1f, false));
                this.cube_r2 = new ModelRenderer((ModelBase)this);
                this.cube_r2.func_78793_a(0.0f, 12.6f, -1.5f);
                this.field_78116_c.func_78792_a(this.cube_r2);
                this.setRotationAngle(this.cube_r2, 0.1309f, 0.0f, 0.0f);
                this.cube_r2.field_78804_l.add(new ModelBox(this.cube_r2, 48, 0, -1.5f, -13.9f, -2.1f, 3, 0, 2, 0.0f, false));
                this.cube_r2.field_78804_l.add(new ModelBox(this.cube_r2, 48, 0, -1.5f, -14.9f, -2.1f, 3, 2, 2, 0.0f, false));
                this.cube_r3 = new ModelRenderer((ModelBase)this);
                this.cube_r3.func_78793_a(0.0f, 0.0f, -2.5f);
                this.field_78116_c.func_78792_a(this.cube_r3);
                this.setRotationAngle(this.cube_r3, -0.1745f, 0.0f, 0.0f);
                this.cube_r3.field_78804_l.add(new ModelBox(this.cube_r3, 0, 54, -2.0f, -3.2623f, -0.9368f, 4, 4, 3, -0.1f, false));
                this.cube_r4 = new ModelRenderer((ModelBase)this);
                this.cube_r4.func_78793_a(0.0f, -4.4193f, -0.8247f);
                this.field_78116_c.func_78792_a(this.cube_r4);
                this.setRotationAngle(this.cube_r4, -0.3491f, 0.0f, 0.0f);
                this.cube_r4.field_78804_l.add(new ModelBox(this.cube_r4, 50, 36, -2.0f, -0.0057f, 0.0f, 4, 4, 2, 0.0f, false));
                this.cube_r5 = new ModelRenderer((ModelBase)this);
                this.cube_r5.func_78793_a(0.0f, 13.0f, -1.5f);
                this.field_78116_c.func_78792_a(this.cube_r5);
                this.setRotationAngle(this.cube_r5, 0.0873f, 0.0f, 0.0f);
                this.cube_r5.field_78804_l.add(new ModelBox(this.cube_r5, 32, 35, -2.0f, -17.3f, -1.8f, 4, 4, 4, 0.0f, false));
                this.jaw = new ModelRenderer((ModelBase)this);
                this.jaw.func_78793_a(0.0f, -0.7346f, -2.3706f);
                this.field_78116_c.func_78792_a(this.jaw);
                this.setRotationAngle(this.jaw, 0.5236f, 0.0f, 0.0f);
                this.jaw.field_78804_l.add(new ModelBox(this.jaw, 47, 13, -1.5f, 0.0f, -2.9f, 3, 1, 3, 0.2f, false));
                this.jaw.field_78804_l.add(new ModelBox(this.jaw, 47, 13, -1.5f, 0.3f, -2.9f, 3, 0, 3, 0.2f, false));
                this.bone3 = new ModelRenderer((ModelBase)this);
                this.bone3.func_78793_a(-1.1f, -3.5f, -4.2f);
                this.field_78116_c.func_78792_a(this.bone3);
                this.setRotationAngle(this.bone3, 0.3491f, -0.1745f, 0.1745f);
                this.bone3.field_78804_l.add(new ModelBox(this.bone3, 58, 0, -1.1f, -0.6f, -0.8f, 2, 1, 1, 0.0f, false));
                this.cube_r6 = new ModelRenderer((ModelBase)this);
                this.cube_r6.func_78793_a(-0.8f, -0.3f, 0.1f);
                this.bone3.func_78792_a(this.cube_r6);
                this.setRotationAngle(this.cube_r6, 0.0f, -0.5236f, 0.0f);
                this.cube_r6.field_78804_l.add(new ModelBox(this.cube_r6, 0, 6, -0.5f, -0.4f, -0.1f, 1, 1, 2, -0.1f, false));
                this.bone4 = new ModelRenderer((ModelBase)this);
                this.bone4.func_78793_a(1.1f, -3.5f, -4.2f);
                this.field_78116_c.func_78792_a(this.bone4);
                this.setRotationAngle(this.bone4, 0.3491f, 0.1745f, -0.1745f);
                this.bone4.field_78804_l.add(new ModelBox(this.bone4, 58, 0, -0.9f, -0.6f, -0.8f, 2, 1, 1, 0.0f, true));
                this.cube_r7 = new ModelRenderer((ModelBase)this);
                this.cube_r7.func_78793_a(0.8f, -0.3f, 0.1f);
                this.bone4.func_78792_a(this.cube_r7);
                this.setRotationAngle(this.cube_r7, 0.0f, 0.5236f, 0.0f);
                this.cube_r7.field_78804_l.add(new ModelBox(this.cube_r7, 0, 6, -0.5f, -0.4f, -0.1f, 1, 1, 2, -0.1f, true));
                this.field_178723_h = new ModelRenderer((ModelBase)this);
                this.field_178723_h.func_78793_a(-4.0f, -9.0f, -4.5f);
                this.field_78115_e.func_78792_a(this.field_178723_h);
                this.rightArm = new ModelRenderer((ModelBase)this);
                this.rightArm.func_78793_a(4.0f, -2.0f, -1.0f);
                this.field_178723_h.func_78792_a(this.rightArm);
                this.setRotationAngle(this.rightArm, -0.2182f, 0.0f, 0.0873f);
                this.cube_r8 = new ModelRenderer((ModelBase)this);
                this.cube_r8.func_78793_a(-5.4741f, 1.5764f, -0.1412f);
                this.rightArm.func_78792_a(this.cube_r8);
                this.setRotationAngle(this.cube_r8, 0.1309f, 0.0f, 0.7854f);
                this.cube_r8.field_78804_l.add(new ModelBox(this.cube_r8, 20, 39, -0.5f, -2.25f, -2.0f, 2, 3, 4, 0.5f, false));
                this.cube_r9 = new ModelRenderer((ModelBase)this);
                this.cube_r9.func_78793_a(0.0f, 0.0f, 0.0f);
                this.rightArm.func_78792_a(this.cube_r9);
                this.setRotationAngle(this.cube_r9, 0.1309f, 0.0f, 0.2182f);
                this.cube_r9.field_78804_l.add(new ModelBox(this.cube_r9, 10, 37, -5.9032f, 2.6821f, -1.9955f, 2, 6, 3, 0.5f, false));
                this.cube_r10 = new ModelRenderer((ModelBase)this);
                this.cube_r10.func_78793_a(0.0f, 7.0f, 2.0f);
                this.rightArm.func_78792_a(this.cube_r10);
                this.setRotationAngle(this.cube_r10, -0.2618f, -0.0436f, 0.0f);
                this.cube_r10.field_78804_l.add(new ModelBox(this.cube_r10, 0, 37, -7.5298f, 0.4835f, -2.5163f, 2, 7, 3, 0.6f, false));
                this.bone = new ModelRenderer((ModelBase)this);
                this.bone.func_78793_a(-5.35f, 9.25f, -1.75f);
                this.rightArm.func_78792_a(this.bone);
                this.setRotationAngle(this.bone, 0.0f, -0.3054f, 0.0f);
                this.cube_r11 = new ModelRenderer((ModelBase)this);
                this.cube_r11.func_78793_a(-0.6f, 3.75f, 0.75f);
                this.bone.func_78792_a(this.cube_r11);
                this.setRotationAngle(this.cube_r11, 0.8026f, -0.3011f, -0.4101f);
                this.cube_r11.field_78804_l.add(new ModelBox(this.cube_r11, 0, 17, -0.029f, -1.1225f, -3.7507f, 1, 1, 3, 0.1f, false));
                this.cube_r12 = new ModelRenderer((ModelBase)this);
                this.cube_r12.func_78793_a(-0.4f, 3.75f, 0.75f);
                this.bone.func_78792_a(this.cube_r12);
                this.setRotationAngle(this.cube_r12, 0.6953f, 0.3893f, 0.1347f);
                this.cube_r12.field_78804_l.add(new ModelBox(this.cube_r12, 0, 17, -1.9419f, -1.0421f, -4.6535f, 1, 1, 3, 0.1f, false));
                this.cube_r13 = new ModelRenderer((ModelBase)this);
                this.cube_r13.func_78793_a(-0.6f, 3.75f, 0.75f);
                this.bone.func_78792_a(this.cube_r13);
                this.setRotationAngle(this.cube_r13, 0.6525f, 0.2185f, -0.0078f);
                this.cube_r13.field_78804_l.add(new ModelBox(this.cube_r13, 0, 17, -0.7793f, -1.0421f, -4.4548f, 1, 1, 3, 0.1f, false));
                this.cube_r14 = new ModelRenderer((ModelBase)this);
                this.cube_r14.func_78793_a(-0.6f, 3.75f, 0.75f);
                this.bone.func_78792_a(this.cube_r14);
                this.setRotationAngle(this.cube_r14, 0.6392f, 0.1139f, -0.0876f);
                this.cube_r14.field_78804_l.add(new ModelBox(this.cube_r14, 0, 17, 0.3597f, -1.0421f, -4.536f, 1, 1, 3, 0.1f, false));
                this.field_178724_i = new ModelRenderer((ModelBase)this);
                this.field_178724_i.func_78793_a(4.0f, -9.0f, -4.5f);
                this.field_78115_e.func_78792_a(this.field_178724_i);
                this.leftArm = new ModelRenderer((ModelBase)this);
                this.leftArm.func_78793_a(-4.0f, -2.0f, -1.0f);
                this.field_178724_i.func_78792_a(this.leftArm);
                this.setRotationAngle(this.leftArm, -0.2182f, 0.0f, -0.0873f);
                this.cube_r15 = new ModelRenderer((ModelBase)this);
                this.cube_r15.func_78793_a(5.4741f, 1.5764f, -0.1412f);
                this.leftArm.func_78792_a(this.cube_r15);
                this.setRotationAngle(this.cube_r15, 0.1309f, 0.0f, -0.7854f);
                this.cube_r15.field_78804_l.add(new ModelBox(this.cube_r15, 20, 39, -1.5f, -2.25f, -2.0f, 2, 3, 4, 0.5f, true));
                this.cube_r16 = new ModelRenderer((ModelBase)this);
                this.cube_r16.func_78793_a(0.0f, 0.0f, 0.0f);
                this.leftArm.func_78792_a(this.cube_r16);
                this.setRotationAngle(this.cube_r16, 0.1309f, 0.0f, -0.2182f);
                this.cube_r16.field_78804_l.add(new ModelBox(this.cube_r16, 10, 37, 3.9032f, 2.6821f, -1.9955f, 2, 6, 3, 0.5f, true));
                this.cube_r17 = new ModelRenderer((ModelBase)this);
                this.cube_r17.func_78793_a(0.0f, 7.0f, 2.0f);
                this.leftArm.func_78792_a(this.cube_r17);
                this.setRotationAngle(this.cube_r17, -0.2618f, 0.0436f, 0.0f);
                this.cube_r17.field_78804_l.add(new ModelBox(this.cube_r17, 0, 37, 5.5298f, 0.4835f, -2.5163f, 2, 7, 3, 0.6f, true));
                this.bone2 = new ModelRenderer((ModelBase)this);
                this.bone2.func_78793_a(5.35f, 9.25f, -1.75f);
                this.leftArm.func_78792_a(this.bone2);
                this.setRotationAngle(this.bone2, 0.0f, 0.3054f, 0.0f);
                this.cube_r18 = new ModelRenderer((ModelBase)this);
                this.cube_r18.func_78793_a(0.6f, 3.75f, 0.75f);
                this.bone2.func_78792_a(this.cube_r18);
                this.setRotationAngle(this.cube_r18, 0.8026f, 0.3011f, 0.4101f);
                this.cube_r18.field_78804_l.add(new ModelBox(this.cube_r18, 0, 17, -0.971f, -1.1225f, -3.7507f, 1, 1, 3, 0.1f, true));
                this.cube_r19 = new ModelRenderer((ModelBase)this);
                this.cube_r19.func_78793_a(0.4f, 3.75f, 0.75f);
                this.bone2.func_78792_a(this.cube_r19);
                this.setRotationAngle(this.cube_r19, 0.6953f, -0.3893f, -0.1347f);
                this.cube_r19.field_78804_l.add(new ModelBox(this.cube_r19, 0, 17, 0.9419f, -1.0421f, -4.6535f, 1, 1, 3, 0.1f, true));
                this.cube_r20 = new ModelRenderer((ModelBase)this);
                this.cube_r20.func_78793_a(0.6f, 3.75f, 0.75f);
                this.bone2.func_78792_a(this.cube_r20);
                this.setRotationAngle(this.cube_r20, 0.6525f, -0.2185f, 0.0078f);
                this.cube_r20.field_78804_l.add(new ModelBox(this.cube_r20, 0, 17, -0.2207f, -1.0421f, -4.4548f, 1, 1, 3, 0.1f, true));
                this.cube_r21 = new ModelRenderer((ModelBase)this);
                this.cube_r21.func_78793_a(0.6f, 3.75f, 0.75f);
                this.bone2.func_78792_a(this.cube_r21);
                this.setRotationAngle(this.cube_r21, 0.6392f, -0.1139f, 0.0876f);
                this.cube_r21.field_78804_l.add(new ModelBox(this.cube_r21, 0, 17, -1.3597f, -1.0421f, -4.536f, 1, 1, 3, 0.1f, true));
                this.stomach = new ModelRenderer((ModelBase)this);
                this.stomach.func_78793_a(0.0f, 3.0f, -6.6f);
                this.field_78115_e.func_78792_a(this.stomach);
                this.setRotationAngle(this.stomach, -0.2618f, 0.0f, 0.0f);
                this.cube_r22 = new ModelRenderer((ModelBase)this);
                this.cube_r22.func_78793_a(0.0f, -12.4f, -3.7f);
                this.stomach.func_78792_a(this.cube_r22);
                this.setRotationAngle(this.cube_r22, 0.2182f, 0.0f, 0.0f);
                this.cube_r22.field_78804_l.add(new ModelBox(this.cube_r22, 36, 8, -3.0f, 5.0769f, -1.8502f, 6, 7, 1, 0.0f, false));
                this.cube_r23 = new ModelRenderer((ModelBase)this);
                this.cube_r23.func_78793_a(4.5f, -5.5f, 1.2f);
                this.stomach.func_78792_a(this.cube_r23);
                this.setRotationAngle(this.cube_r23, 0.2182f, 0.0f, 0.0f);
                this.cube_r23.field_78804_l.add(new ModelBox(this.cube_r23, 0, 0, -9.0f, -3.7037f, -4.4076f, 9, 8, 9, 0.0f, false));
                this.upperbody = new ModelRenderer((ModelBase)this);
                this.upperbody.func_78793_a(0.0f, 3.0f, -5.5f);
                this.field_78115_e.func_78792_a(this.upperbody);
                this.upperbody.field_78804_l.add(new ModelBox(this.upperbody, 24, 22, -4.0f, -14.8158f, -3.1398f, 8, 3, 8, 0.1f, false));
                this.cube_r24 = new ModelRenderer((ModelBase)this);
                this.cube_r24.func_78793_a(0.0f, -15.1581f, 0.4507f);
                this.upperbody.func_78792_a(this.cube_r24);
                this.setRotationAngle(this.cube_r24, -0.3054f, 0.0f, 0.0f);
                this.cube_r24.field_78804_l.add(new ModelBox(this.cube_r24, 7, 54, -4.0f, -1.0f, -3.3f, 8, 3, 7, -0.05f, false));
                this.cube_r25 = new ModelRenderer((ModelBase)this);
                this.cube_r25.func_78793_a(0.0f, 0.0f, 0.0f);
                this.upperbody.func_78792_a(this.cube_r25);
                this.setRotationAngle(this.cube_r25, 0.1745f, 0.0f, 0.0f);
                this.cube_r25.field_78804_l.add(new ModelBox(this.cube_r25, 0, 17, -4.0f, -12.0f, -0.9f, 8, 5, 8, 0.4f, false));
                this.field_178721_j = new ModelRenderer((ModelBase)this);
                this.field_178721_j.func_78793_a(-4.5f, -3.0f, -2.75f);
                this.field_78115_e.func_78792_a(this.field_178721_j);
                this.cube_r26 = new ModelRenderer((ModelBase)this);
                this.cube_r26.func_78793_a(5.5f, 6.0f, -1.75f);
                this.field_178721_j.func_78792_a(this.cube_r26);
                this.setRotationAngle(this.cube_r26, -0.1289f, 0.0227f, 0.1731f);
                this.cube_r26.field_78804_l.add(new ModelBox(this.cube_r26, 44, 53, -9.0f, -6.0f, -1.0f, 5, 6, 5, 0.0f, false));
                this.rightFoot = new ModelRenderer((ModelBase)this);
                this.rightFoot.func_78793_a(4.75f, 5.75f, -1.75f);
                this.field_178721_j.func_78792_a(this.rightFoot);
                this.cube_r27 = new ModelRenderer((ModelBase)this);
                this.cube_r27.func_78793_a(0.0f, -0.1f, 0.0f);
                this.rightFoot.func_78792_a(this.cube_r27);
                this.setRotationAngle(this.cube_r27, 0.0894f, 0.2173f, 0.0193f);
                this.cube_r27.field_78804_l.add(new ModelBox(this.cube_r27, 27, 43, -8.0f, -0.75f, -4.3f, 1, 1, 5, 0.1f, false));
                this.cube_r28 = new ModelRenderer((ModelBase)this);
                this.cube_r28.func_78793_a(-1.0f, -0.1f, 0.0f);
                this.rightFoot.func_78792_a(this.cube_r28);
                this.setRotationAngle(this.cube_r28, 0.088f, 0.1304f, 0.0115f);
                this.cube_r28.field_78804_l.add(new ModelBox(this.cube_r28, 43, 38, -5.5f, -0.75f, -3.5f, 1, 1, 5, 0.1f, false));
                this.cube_r29 = new ModelRenderer((ModelBase)this);
                this.cube_r29.func_78793_a(-1.0f, -0.1f, 0.0f);
                this.rightFoot.func_78792_a(this.cube_r29);
                this.setRotationAngle(this.cube_r29, 0.0876f, 0.0869f, 0.0076f);
                this.cube_r29.field_78804_l.add(new ModelBox(this.cube_r29, 20, 46, -4.0f, -0.75f, -3.25f, 1, 1, 4, 0.1f, false));
                this.cube_r30 = new ModelRenderer((ModelBase)this);
                this.cube_r30.func_78793_a(-1.0f, -0.1f, 0.0f);
                this.rightFoot.func_78792_a(this.cube_r30);
                this.setRotationAngle(this.cube_r30, 0.1526f, -0.4332f, -0.053f);
                this.cube_r30.field_78804_l.add(new ModelBox(this.cube_r30, 0, 47, -1.95f, -0.8f, -1.1f, 1, 1, 4, 0.1f, false));
                this.cube_r31 = new ModelRenderer((ModelBase)this);
                this.cube_r31.func_78793_a(0.0f, 0.0f, 0.0f);
                this.rightFoot.func_78792_a(this.cube_r31);
                this.setRotationAngle(this.cube_r31, -0.0175f, 0.0f, 0.0f);
                this.cube_r31.field_78804_l.add(new ModelBox(this.cube_r31, 34, 44, -8.0f, -1.0f, 1.35f, 5, 1, 2, 0.2f, false));
                this.field_178722_k = new ModelRenderer((ModelBase)this);
                this.field_178722_k.func_78793_a(4.5f, -3.0f, -2.75f);
                this.field_78115_e.func_78792_a(this.field_178722_k);
                this.cube_r32 = new ModelRenderer((ModelBase)this);
                this.cube_r32.func_78793_a(-5.5f, 6.0f, -1.75f);
                this.field_178722_k.func_78792_a(this.cube_r32);
                this.setRotationAngle(this.cube_r32, -0.1289f, -0.0227f, -0.1731f);
                this.cube_r32.field_78804_l.add(new ModelBox(this.cube_r32, 44, 53, 4.0f, -6.0f, -1.0f, 5, 6, 5, 0.0f, true));
                this.leftFoot = new ModelRenderer((ModelBase)this);
                this.leftFoot.func_78793_a(-4.75f, 5.75f, -1.75f);
                this.field_178722_k.func_78792_a(this.leftFoot);
                this.cube_r33 = new ModelRenderer((ModelBase)this);
                this.cube_r33.func_78793_a(0.0f, -0.1f, 0.0f);
                this.leftFoot.func_78792_a(this.cube_r33);
                this.setRotationAngle(this.cube_r33, 0.0894f, -0.2173f, -0.0193f);
                this.cube_r33.field_78804_l.add(new ModelBox(this.cube_r33, 27, 43, 7.0f, -0.75f, -4.3f, 1, 1, 5, 0.1f, true));
                this.cube_r34 = new ModelRenderer((ModelBase)this);
                this.cube_r34.func_78793_a(1.0f, -0.1f, 0.0f);
                this.leftFoot.func_78792_a(this.cube_r34);
                this.setRotationAngle(this.cube_r34, 0.088f, -0.1304f, -0.0115f);
                this.cube_r34.field_78804_l.add(new ModelBox(this.cube_r34, 43, 38, 4.5f, -0.75f, -3.5f, 1, 1, 5, 0.1f, true));
                this.cube_r35 = new ModelRenderer((ModelBase)this);
                this.cube_r35.func_78793_a(1.0f, -0.1f, 0.0f);
                this.leftFoot.func_78792_a(this.cube_r35);
                this.setRotationAngle(this.cube_r35, 0.0876f, -0.0869f, -0.0076f);
                this.cube_r35.field_78804_l.add(new ModelBox(this.cube_r35, 20, 46, 3.0f, -0.75f, -3.25f, 1, 1, 4, 0.1f, true));
                this.cube_r36 = new ModelRenderer((ModelBase)this);
                this.cube_r36.func_78793_a(1.0f, -0.1f, 0.0f);
                this.leftFoot.func_78792_a(this.cube_r36);
                this.setRotationAngle(this.cube_r36, 0.1526f, 0.4332f, 0.053f);
                this.cube_r36.field_78804_l.add(new ModelBox(this.cube_r36, 0, 47, 0.95f, -0.8f, -1.1f, 1, 1, 4, 0.1f, true));
                this.cube_r37 = new ModelRenderer((ModelBase)this);
                this.cube_r37.func_78793_a(0.0f, 0.0f, 0.0f);
                this.leftFoot.func_78792_a(this.cube_r37);
                this.setRotationAngle(this.cube_r37, -0.0175f, 0.0f, 0.0f);
                this.cube_r37.field_78804_l.add(new ModelBox(this.cube_r37, 34, 44, 3.0f, -1.0f, 1.35f, 5, 1, 2, 0.2f, true));
                this.tail[0] = new ModelRenderer((ModelBase)this);
                this.tail[0].func_78793_a(0.0f, 20.0f, 3.0f);
                this.setRotationAngle(this.tail[0], -1.0472f, 0.0f, 0.0f);
                this.tail[0].field_78804_l.add(new ModelBox(this.tail[0], 0, 0, -1.0f, -3.5f, -1.0f, 2, 4, 2, 2.2f, false));
                this.tail[1] = new ModelRenderer((ModelBase)this);
                this.tail[1].func_78793_a(0.0f, -4.0f, 0.0f);
                this.tail[0].func_78792_a(this.tail[1]);
                this.setRotationAngle(this.tail[1], 0.4363f, 0.0f, 0.2618f);
                this.tail[1].field_78804_l.add(new ModelBox(this.tail[1], 0, 0, -1.0f, -5.5f, -1.0f, 2, 4, 2, 2.0f, false));
                this.tail[2] = new ModelRenderer((ModelBase)this);
                this.tail[2].func_78793_a(0.0f, -6.0f, 0.0f);
                this.tail[1].func_78792_a(this.tail[2]);
                this.setRotationAngle(this.tail[2], 0.4363f, 0.0f, 0.2618f);
                this.tail[2].field_78804_l.add(new ModelBox(this.tail[2], 0, 0, -1.0f, -5.5f, -1.0f, 2, 4, 2, 1.8f, false));
                this.tail[3] = new ModelRenderer((ModelBase)this);
                this.tail[3].func_78793_a(0.0f, -6.0f, 0.0f);
                this.tail[2].func_78792_a(this.tail[3]);
                this.setRotationAngle(this.tail[3], 0.4363f, 0.0f, 0.2618f);
                this.tail[3].field_78804_l.add(new ModelBox(this.tail[3], 0, 0, -1.0f, -5.5f, -1.0f, 2, 4, 2, 1.6f, false));
                this.tail[4] = new ModelRenderer((ModelBase)this);
                this.tail[4].func_78793_a(0.0f, -5.0f, 0.0f);
                this.tail[3].func_78792_a(this.tail[4]);
                this.setRotationAngle(this.tail[4], 0.4363f, 0.0f, -0.2618f);
                this.tail[4].field_78804_l.add(new ModelBox(this.tail[4], 0, 0, -1.0f, -5.5f, -1.0f, 2, 4, 2, 1.4f, false));
                this.tail[5] = new ModelRenderer((ModelBase)this);
                this.tail[5].func_78793_a(0.0f, -5.0f, 0.0f);
                this.tail[4].func_78792_a(this.tail[5]);
                this.setRotationAngle(this.tail[5], 0.4363f, 0.0f, -0.2618f);
                this.tail[5].field_78804_l.add(new ModelBox(this.tail[5], 0, 0, -1.0f, -5.5f, -1.0f, 2, 4, 2, 1.2f, false));
                this.tail[6] = new ModelRenderer((ModelBase)this);
                this.tail[6].func_78793_a(0.0f, -5.25f, 0.0f);
                this.tail[5].func_78792_a(this.tail[6]);
                this.setRotationAngle(this.tail[6], 0.4363f, 0.0f, -0.2618f);
                this.tail[6].field_78804_l.add(new ModelBox(this.tail[6], 0, 0, -1.0f, -5.0f, -1.0f, 2, 4, 2, 0.6f, false));
                this.tail[7] = new ModelRenderer((ModelBase)this);
                this.tail[7].func_78793_a(0.0f, -4.5f, 0.0f);
                this.tail[6].func_78792_a(this.tail[7]);
                this.setRotationAngle(this.tail[7], 0.4363f, 0.0f, -0.2618f);
                this.tail[7].field_78804_l.add(new ModelBox(this.tail[7], 0, 0, -1.0f, -4.5f, -1.0f, 2, 4, 2, 0.0f, false));
                this.tail[8] = new ModelRenderer((ModelBase)this);
                this.tail[8].func_78793_a(0.0f, -4.0f, 0.0f);
                this.tail[7].func_78792_a(this.tail[8]);
                this.setRotationAngle(this.tail[8], 0.3491f, 0.0f, -0.1745f);
                this.tail[8].field_78804_l.add(new ModelBox(this.tail[8], 0, 0, -1.0f, -3.5f, -1.0f, 2, 4, 2, -0.4f, false));
                for (int j = 1; j < this.tail.length; ++j) {
                    this.tailSwayX[j] = (this.rand.nextFloat() * 0.1745f + 0.1745f) * (this.rand.nextBoolean() ? -1.0f : 1.0f);
                    this.tailSwayZ[j] = (this.rand.nextFloat() * 0.1745f + 0.1745f) * (this.rand.nextBoolean() ? -1.0f : 1.0f);
                    this.tailSwayY[j] = this.rand.nextFloat() * 0.0873f + 0.0873f;
                }
            }

            public void func_78088_a(Entity entity, float f0, float f1, float f2, float f3, float f4, float f5) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)-27.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)19.0f, (float)19.0f, (float)19.0f);
                this.field_78115_e.func_78785_a(f5);
                this.tail[0].func_78785_a(f5);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                this.field_178720_f.func_78785_a(f5);
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }

            public void func_78087_a(float f0, float f1, float f2, float f3, float f4, float f5, Entity e) {
                super.func_78087_a(f0 * 2.0f / e.field_70131_O, f1, f2, f3, f4, f5, e);
                this.field_78116_c.field_78797_d += -9.6f;
                this.field_178723_h.func_78793_a(-4.0f, -9.0f, -4.5f);
                this.field_178724_i.func_78793_a(4.0f, -9.0f, -4.5f);
                this.field_178721_j.func_78793_a(-4.5f, -3.0f, -3.75f);
                this.field_178722_k.func_78793_a(4.5f, -3.0f, -3.75f);
                for (int j = 1; j < this.tail.length; ++j) {
                    this.tail[j].field_78795_f = j <= 5 ? 0.2618f + MathHelper.func_76126_a((float)((f2 - (float)j) * 0.05f)) * this.tailSwayX[j] : 0.2618f + MathHelper.func_76126_a((float)((f2 - (float)j) * 0.05f)) * this.tailSwayX[j];
                    this.tail[j].field_78808_h = MathHelper.func_76134_b((float)((f2 - (float)j) * 0.05f)) * this.tailSwayZ[j];
                    this.tail[j].field_78796_g = MathHelper.func_76126_a((float)((f2 - (float)j) * 0.1f)) * this.tailSwayY[j];
                }
                if (((EntityCustom)e).isShooting()) {
                    this.field_78116_c.field_78795_f += -0.5236f;
                    this.jaw.field_78795_f = 0.7854f;
                } else {
                    this.jaw.field_78795_f = 0.0f;
                }
                if (((EntityCustom)e).isFaceDown()) {
                    this.field_78115_e.field_78798_e = 10.0f;
                    this.field_78115_e.field_78795_f = 0.8727f;
                    this.field_78116_c.field_78795_f = -0.2618f;
                    this.field_178723_h.field_78795_f = -1.3963f;
                    this.field_178724_i.field_78795_f = -1.3963f;
                    this.field_178721_j.field_78795_f = 0.8727f;
                    this.field_178722_k.field_78795_f = 0.8727f;
                    this.tail[0].field_78798_e = 10.0f;
                    this.tail[0].field_78795_f = -1.4835f;
                } else {
                    this.field_78115_e.field_78798_e = 3.0f;
                    this.field_78115_e.field_78795_f = 0.0f;
                    this.tail[0].field_78798_e = 3.0f;
                    this.tail[0].field_78795_f = -1.0472f;
                }
                ModelOneTail.func_178685_a((ModelRenderer)this.field_78115_e, (ModelRenderer)this.field_178720_f);
                ModelOneTail.func_178685_a((ModelRenderer)this.field_78116_c, (ModelRenderer)this.eyes);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class RenderCustom
        extends EntityTailedBeast.ClientOnly.Renderer<EntityCustom> {
            private final ResourceLocation TEXTURE;

            public RenderCustom(RenderManager renderManagerIn) {
                super(renderManagerIn, (ModelBase)new ModelOneTail(), 9.5f);
                this.TEXTURE = new ResourceLocation("narutomod:textures/onetail.png");
            }

            protected ResourceLocation getEntityTexture(EntityCustom entity) {
                return this.TEXTURE;
            }
        }
    }

    public static class EntityCustom
    extends EntityTailedBeast.Base {
        public EntityCustom(World world) {
            super(world);
            this.func_70105_a(7.6f, 20.1875f);
            this.field_70728_aV = 12000;
            this.field_70138_W = this.field_70131_O / 3.0f;
        }

        public EntityCustom(EntityPlayer player) {
            super(player);
            this.func_70105_a(7.6f, 20.1875f);
            this.field_70728_aV = 12000;
            this.field_70138_W = this.field_70131_O / 3.0f;
        }

        @Override
        public float getModelScale() {
            return 19.0f;
        }

        @Override
        public void setFaceDown(boolean down) {
            super.setFaceDown(down);
            this.func_70105_a(this.field_70130_N, 19.0f * (down ? 0.625f : 1.0625f));
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10000.0);
            this.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111128_a(30.0);
        }

        @Override
        public EntityBijuManager getBijuManager() {
            return tailBeastManager;
        }

        @Override
        public double func_70042_X() {
            return this.isFaceDown() ? 3.5625 : (double)this.field_70131_O + 0.35;
        }

        public void func_184232_k(Entity passenger) {
            Vec3d[] vec = new Vec3d[]{new Vec3d(4.75, 0.0, 0.0)};
            if (this.func_184196_w(passenger)) {
                int i = this.func_184188_bt().indexOf(passenger);
                Vec3d vec2 = vec[i].func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
                passenger.func_70107_b(this.field_70165_t + vec2.field_72450_a, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v + vec2.field_72449_c);
            }
        }

        @Override
        public float getFuuinBeamHeight() {
            return this.isFaceDown() ? 3.5625f : super.getFuuinBeamHeight();
        }

        public SoundEvent func_184639_G() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:shukaku_roar"));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(""));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(""));
        }
    }

    public static class Save
    extends EntityTailedBeast.SaveBase {
        private static final String DATA_NAME = "narutomod_onetail";
        private static Save instance = null;

        public Save() {
            super(DATA_NAME);
        }

        public Save(String name) {
            super(name);
        }

        @Override
        public Save loadData() {
            instance = null;
            return this.getInstance();
        }

        @Override
        public void resetData() {
            super.resetData();
            instance = null;
        }

        public static Save getInstance() {
            MapStorage storage;
            if (instance == null && (instance = (Save)(storage = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0).func_175693_T()).func_75742_a(Save.class, DATA_NAME)) == null) {
                instance = new Save();
                storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
            }
            return instance;
        }

        @Override
        protected EntityBijuManager getBijuManager() {
            return tailBeastManager;
        }

        @Override
        protected EntityTailedBeast.Base createEntity(World world) {
            return new EntityCustom(world);
        }
    }

    public static class TailBeastManager
    extends EntityBijuManager<EntityCustom> {
        public TailBeastManager() {
            super(EntityCustom.class, 1);
        }

        @Override
        public void setVesselEntity(@Nullable Entity player, boolean dirty) {
            super.setVesselEntity(player, dirty);
            if (player instanceof EntityPlayer && !ProcedureUtils.hasItemInInventory((EntityPlayer)player, ItemJiton.block)) {
                ItemStack stack = new ItemStack(ItemJiton.block);
                ItemJiton.setSandType(stack, ItemJiton.Type.SAND);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)player), (ItemStack)stack);
                if (!ProcedureUtils.hasItemInInventory((EntityPlayer)player, ItemFuton.block)) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)player), (ItemStack)new ItemStack(ItemFuton.block));
                }
                if (!ProcedureUtils.hasItemInInventory((EntityPlayer)player, ItemDoton.block)) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)((EntityPlayer)player), (ItemStack)new ItemStack(ItemDoton.block));
                }
            }
        }

        @Override
        public void markDirty() {
            Save.getInstance().func_76185_a();
        }
    }
}

