/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureAirPunch;

@ElementsNarutomodMod.ModElement.Tag
public class EntityPoisonMist
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 211;
    public static final int ENTITYID_RANGED = 212;

    public EntityPoisonMist(ElementsNarutomodMod instance) {
        super(instance, 526);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "poison_mist"), 211).name("poison_mist").tracker(64, 3, true).build());
    }

    public static class EC
    extends Entity {
        private final AirPunch airPunch = new AirPunch();
        private EntityLivingBase user;
        private float power;

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
        }

        public EC(EntityLivingBase userIn, float powerIn) {
            this(userIn.field_70170_p);
            this.user = userIn;
            this.power = powerIn;
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
        }

        protected void func_70088_a() {
        }

        public void func_70071_h_() {
            if (this.user != null) {
                this.func_70107_b(this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                if (this.field_70173_aa % 5 == 1) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:windecho")), 1.0f, this.power * 0.2f);
                }
                this.airPunch.execute(this.user, this.power, (double)this.power * 0.25);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > (int)this.power * 2) {
                this.func_70106_y();
            }
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, power));
                return true;
            }
        }

        public class AirPunch
        extends ProcedureAirPunch {
            public AirPunch() {
                this.blockHardnessLimit = 1.0f;
                this.particlesDuring = null;
            }

            @Override
            protected void preExecuteParticles(EntityLivingBase player) {
                Vec3d vec = player.func_70040_Z().func_186678_a(2.0);
                Particles.Renderer particles = new Particles.Renderer(player.field_70170_p);
                for (int i = 1; i <= 50; ++i) {
                    Vec3d vec1 = player.func_70040_Z().func_186678_a((EC.this.field_70146_Z.nextDouble() * 0.8 + 0.2) * this.getRange(0) * 0.09);
                    particles.spawnParticles(Particles.Types.SMOKE, player.field_70165_t + vec.field_72450_a, player.field_70163_u + 1.5 + vec.field_72448_b, player.field_70161_v + vec.field_72449_c, 1, 0.0, 0.0, 0.0, vec1.field_72450_a + (EC.this.field_70146_Z.nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, vec1.field_72448_b + (EC.this.field_70146_Z.nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, vec1.field_72449_c + (EC.this.field_70146_Z.nextDouble() - 0.5) * this.getFarRadius(0) * 0.15, -10289051, 80 + EC.this.field_70146_Z.nextInt(20), 0, 0, -1, 0);
                }
                particles.send();
            }

            @Override
            protected void attackEntityFrom(EntityLivingBase player, Entity target) {
                if (target instanceof EntityLivingBase) {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 300, 2));
                }
            }

            @Override
            protected float getBreakChance(BlockPos pos, EntityLivingBase player, double range) {
                return 0.0f;
            }
        }
    }
}

