/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.item.ItemNinjutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityPuppet
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 282;
    public static final int ENTITYID_RANGED = 283;

    public EntityPuppet(ElementsNarutomodMod instance) {
        super(instance, 603);
    }

    public static class ClientClass {

        @SideOnly(value=Side.CLIENT)
        public static class LayerChakraStrings
        implements LayerRenderer<Base> {
            private static final ResourceLocation FUUIN_TEXTURE = new ResourceLocation("narutomod:textures/fuuin_beam_blue.png");
            private final RenderLiving renderer;

            public LayerChakraStrings(RenderLiving rendererIn) {
                this.renderer = rendererIn;
            }

            public void doRenderLayer(Base entity, float _1, float _2, float pt, float _3, float _4, float _5, float _6) {
                EntityLivingBase owner = entity.getOwner();
                if (owner != null) {
                    float f = ((float)entity.field_70173_aa + pt) * 0.01f;
                    float offset = entity.field_70131_O * 0.1f;
                    double dx = owner.field_70142_S + (owner.field_70165_t - owner.field_70142_S) * (double)pt - (entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)pt);
                    double dy = owner.field_70137_T + (owner.field_70163_u - owner.field_70137_T) * (double)pt - (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)pt + (double)offset);
                    double dz = owner.field_70136_U + (owner.field_70161_v - owner.field_70136_U) * (double)pt - (entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)pt);
                    double dxz = MathHelper.func_76133_a((double)(dx * dx + dz * dz));
                    double max_l = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
                    float rot_y = (float)(-Math.atan2(dx, dz)) * 180.0f / (float)Math.PI - ProcedureUtils.interpolateRotation(entity.field_70760_ar, entity.field_70761_aq, pt);
                    float rot_x = (float)(-Math.atan2(dy, dxz)) * 180.0f / (float)Math.PI;
                    this.renderer.func_110776_a(FUUIN_TEXTURE);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)(-offset + 0.5f), (float)0.0f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)rot_y, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)(rot_x - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder bufferbuilder = tessellator.func_178180_c();
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179129_p();
                    GlStateManager.func_179103_j((int)7425);
                    float f5 = 0.0f - f;
                    float f6 = (float)max_l / 32.0f - f;
                    bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181709_i);
                    for (int j = 0; j <= 8; ++j) {
                        float f7 = MathHelper.func_76126_a((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f)) * 0.008f;
                        float f8 = MathHelper.func_76134_b((float)((float)(j % 8) * ((float)Math.PI * 2) / 8.0f)) * 0.008f;
                        float f9 = (float)(j % 8) / 8.0f;
                        bufferbuilder.func_181662_b((double)f7, (double)f8, 0.0).func_187315_a((double)f9, (double)f5).func_181669_b(255, 255, 255, 128).func_181675_d();
                        bufferbuilder.func_181662_b((double)f7, (double)f8, (double)((float)max_l)).func_187315_a((double)f9, (double)f6).func_181669_b(255, 255, 255, 128).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179103_j((int)7424);
                    RenderHelper.func_74519_b();
                    GlStateManager.func_179121_F();
                }
            }

            public boolean func_177142_b() {
                return false;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static abstract class Renderer<T extends Base>
        extends RenderLiving<T> {
            public Renderer(RenderManager renderManagerIn, ModelBase model, float shadowsize) {
                super(renderManagerIn, model, shadowsize);
                this.func_177094_a(new LayerChakraStrings(this));
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static class ModelScroll
        extends ModelBase {
            private final ModelRenderer hinge;
            private final ModelRenderer[] bone = new ModelRenderer[14];

            public ModelScroll() {
                this.field_78090_t = 16;
                this.field_78089_u = 16;
                this.hinge = new ModelRenderer((ModelBase)this);
                this.hinge.func_78793_a(0.0f, -0.85f, 0.0f);
                this.hinge.field_78804_l.add(new ModelBox(this.hinge, 0, 0, -4.0f, -0.5f, -0.5f, 4, 1, 1, 0.1f, false));
                this.hinge.field_78804_l.add(new ModelBox(this.hinge, 0, 0, 0.0f, -0.5f, -0.5f, 4, 1, 1, 0.1f, true));
                this.bone[0] = new ModelRenderer((ModelBase)this);
                this.bone[0].func_78793_a(0.0f, 0.0f, 0.5f);
                this.setRotationAngle(this.bone[0], -1.5708f, 0.0f, 0.0f);
                this.bone[0].field_78804_l.add(new ModelBox(this.bone[0], 0, 2, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[1] = new ModelRenderer((ModelBase)this);
                this.bone[1].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[0].func_78792_a(this.bone[1]);
                this.setRotationAngle(this.bone[1], -1.0472f, 0.0f, 0.0f);
                this.bone[1].field_78804_l.add(new ModelBox(this.bone[1], 0, 3, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[2] = new ModelRenderer((ModelBase)this);
                this.bone[2].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[1].func_78792_a(this.bone[2]);
                this.setRotationAngle(this.bone[2], -1.0472f, 0.0f, 0.0f);
                this.bone[2].field_78804_l.add(new ModelBox(this.bone[2], 0, 4, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[3] = new ModelRenderer((ModelBase)this);
                this.bone[3].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[2].func_78792_a(this.bone[3]);
                this.setRotationAngle(this.bone[3], -1.0472f, 0.0f, 0.0f);
                this.bone[3].field_78804_l.add(new ModelBox(this.bone[3], 0, 5, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[4] = new ModelRenderer((ModelBase)this);
                this.bone[4].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[3].func_78792_a(this.bone[4]);
                this.setRotationAngle(this.bone[4], -1.0472f, 0.0f, 0.0f);
                this.bone[4].field_78804_l.add(new ModelBox(this.bone[4], 0, 6, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[5] = new ModelRenderer((ModelBase)this);
                this.bone[5].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[4].func_78792_a(this.bone[5]);
                this.setRotationAngle(this.bone[5], -1.0472f, 0.0f, 0.0f);
                this.bone[5].field_78804_l.add(new ModelBox(this.bone[5], 0, 7, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[6] = new ModelRenderer((ModelBase)this);
                this.bone[6].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[5].func_78792_a(this.bone[6]);
                this.setRotationAngle(this.bone[6], -1.0472f, 0.0f, 0.0f);
                this.bone[6].field_78804_l.add(new ModelBox(this.bone[6], 0, 8, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[7] = new ModelRenderer((ModelBase)this);
                this.bone[7].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[6].func_78792_a(this.bone[7]);
                this.setRotationAngle(this.bone[7], -1.0472f, 0.0f, 0.0f);
                this.bone[7].field_78804_l.add(new ModelBox(this.bone[7], 0, 9, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[8] = new ModelRenderer((ModelBase)this);
                this.bone[8].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[7].func_78792_a(this.bone[8]);
                this.setRotationAngle(this.bone[8], -1.0472f, 0.0f, 0.0f);
                this.bone[8].field_78804_l.add(new ModelBox(this.bone[8], 0, 10, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[9] = new ModelRenderer((ModelBase)this);
                this.bone[9].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[8].func_78792_a(this.bone[9]);
                this.setRotationAngle(this.bone[9], -1.0472f, 0.0f, 0.0f);
                this.bone[9].field_78804_l.add(new ModelBox(this.bone[9], 0, 11, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[10] = new ModelRenderer((ModelBase)this);
                this.bone[10].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[9].func_78792_a(this.bone[10]);
                this.setRotationAngle(this.bone[10], -1.0472f, 0.0f, 0.0f);
                this.bone[10].field_78804_l.add(new ModelBox(this.bone[10], 0, 12, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[11] = new ModelRenderer((ModelBase)this);
                this.bone[11].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[10].func_78792_a(this.bone[11]);
                this.setRotationAngle(this.bone[11], -1.0472f, 0.0f, 0.0f);
                this.bone[11].field_78804_l.add(new ModelBox(this.bone[11], 0, 13, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[12] = new ModelRenderer((ModelBase)this);
                this.bone[12].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[11].func_78792_a(this.bone[12]);
                this.setRotationAngle(this.bone[12], -1.0472f, 0.0f, 0.0f);
                this.bone[12].field_78804_l.add(new ModelBox(this.bone[12], 0, 14, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
                this.bone[13] = new ModelRenderer((ModelBase)this);
                this.bone[13].func_78793_a(0.0f, 1.0f, 0.0f);
                this.bone[12].func_78792_a(this.bone[13]);
                this.setRotationAngle(this.bone[13], -1.0472f, 0.0f, 0.0f);
                this.bone[13].field_78804_l.add(new ModelBox(this.bone[13], 0, 15, -4.0f, 0.0f, 0.0f, 8, 1, 0, 0.0f, false));
            }

            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                this.func_78087_a(f, f1, f2, f3, f4, f5, entity);
                this.hinge.func_78785_a(f5);
                this.bone[0].func_78785_a(f5);
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }

            public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity e) {
                super.func_78087_a(f, f1, f2, f3, f4, f5, e);
                for (int i = 1; i < this.bone.length; ++i) {
                    this.bone[i].field_78795_f = MathHelper.func_76131_a((float)(1.0f - f2 + (float)i), (float)0.0f, (float)1.0f) * -1.0472f;
                }
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static abstract class RenderScroll<T extends Entity>
        extends Render<T> {
            private final ModelScroll model = new ModelScroll();

            public RenderScroll(RenderManager renderManager) {
                super(renderManager);
                this.field_76989_e = 0.1f;
            }

            public void func_76986_a(T bullet, double d, double d1, double d2, float f, float f1) {
                this.func_180548_c((Entity)bullet);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)d), (float)((float)d1), (float)((float)d2));
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                GlStateManager.func_179114_b((float)(-f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(180.0f - ((Entity)bullet).field_70127_C - (((Entity)bullet).field_70125_A - ((Entity)bullet).field_70127_C) * f1), (float)1.0f, (float)0.0f, (float)0.0f);
                this.model.func_78088_a((Entity)bullet, 0.0f, 0.0f, f1 + (float)((Entity)bullet).field_70173_aa, 0.0f, 0.0f, 0.0625f);
                GlStateManager.func_179121_F();
            }
        }
    }

    public static abstract class Base
    extends EntityCreature {
        private static final DataParameter<Integer> OWNERID = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> REAL_AGE = EntityDataManager.func_187226_a(Base.class, (DataSerializer)DataSerializers.field_187192_b);

        public Base(World worldIn) {
            super(worldIn);
            this.field_70728_aV = 0;
            this.func_110163_bv();
            this.func_94061_f(true);
            this.field_70699_by = new PathNavigateFlying((EntityLiving)this, worldIn);
            this.field_70765_h = new FlyHelper(this);
        }

        public Base(EntityLivingBase ownerIn) {
            this(ownerIn.field_70170_p);
            if (ownerIn instanceof EntityPlayer) {
                ItemStack stack = ProcedureUtils.getMatchingItemStack((EntityPlayer)ownerIn, ItemNinjutsu.block);
                if (stack != null && ((ItemNinjutsu.RangedItem)stack.func_77973_b()).canActivateJutsu(stack, ItemNinjutsu.PUPPET, (EntityPlayer)ownerIn) == EnumActionResult.SUCCESS) {
                    this.setOwner(ownerIn);
                }
            } else {
                this.setOwner(ownerIn);
            }
        }

        protected void func_70088_a() {
            super.func_70088_a();
            this.field_70180_af.func_187214_a(OWNERID, (Object)-1);
            this.field_70180_af.func_187214_a(REAL_AGE, (Object)0);
        }

        private void setAge(int age) {
            this.field_70180_af.func_187227_b(REAL_AGE, (Object)age);
        }

        public int getAge() {
            return (Integer)this.func_184212_Q().func_187225_a(REAL_AGE);
        }

        @Nullable
        protected EntityLivingBase getOwner() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(OWNERID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        protected void setOwner(@Nullable EntityLivingBase player) {
            this.func_184212_Q().func_187227_b(OWNERID, (Object)(player != null ? player.func_145782_y() : -1));
            this.func_94061_f(player == null);
        }

        protected Vec3d getOffsetToOwner() {
            return new Vec3d(0.0, 0.0, 4.0);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            Vec3d vec = this.getOffsetToOwner();
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIStayInFrontOfOwner(this, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
            this.field_70715_bh.func_75776_a(0, (EntityAIBase)new AICopyOwnerTarget(this));
        }

        protected boolean func_70692_ba() {
            return false;
        }

        protected Item func_146068_u() {
            return null;
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(100.0);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
            this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.4);
        }

        protected SoundEvent func_184615_bR() {
            return null;
        }

        protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
            return null;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source.func_76352_a()) {
                amount *= 0.2f;
            }
            return super.func_70097_a(source, amount);
        }

        protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
            ItemStack stack = player.func_184586_b(hand);
            if (!this.field_70170_p.field_72995_K && stack.func_77973_b() == ItemNinjutsu.block && ItemNinjutsu.getCurrentJutsu(stack) == ItemNinjutsu.PUPPET) {
                this.setOwner((EntityLivingBase)(player.equals((Object)this.getOwner()) ? null : player));
                return true;
            }
            return false;
        }

        public void func_70636_d() {
            this.func_82168_bl();
            super.func_70636_d();
        }

        public void func_70071_h_() {
            this.setAge(this.getAge() + 1);
            this.field_70143_R = 0.0f;
            this.func_70674_bp();
            super.func_70071_h_();
            EntityLivingBase owner = this.getOwner();
            this.func_189654_d(owner != null);
            if (owner != null && this.getVelocity() > 0.1 && this.field_70173_aa % 2 == 0) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:wood_click")), 0.6f, this.field_70146_Z.nextFloat() * 0.6f + 0.6f);
            }
            if (!this.field_70170_p.field_72995_K && owner != null && this.func_70068_e((Entity)owner) > 1600.0) {
                this.setOwner(null);
            }
        }

        public Vec3d func_70040_Z() {
            return this.func_174806_f(this.field_70125_A, this.field_70759_as);
        }

        public double getVelocity() {
            return MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        }

        public void func_70037_a(NBTTagCompound compound) {
            super.func_70037_a(compound);
            this.setAge(compound.func_74762_e("age"));
        }

        public void func_70014_b(NBTTagCompound compound) {
            super.func_70014_b(compound);
            compound.func_74768_a("age", this.getAge());
        }

        public class AICopyOwnerTarget
        extends EntityAITarget {
            private Base attacker;

            public AICopyOwnerTarget(Base creature) {
                super((EntityCreature)creature, false);
                this.attacker = creature;
            }

            public boolean func_75250_a() {
                EntityLivingBase owner = this.attacker.getOwner();
                this.field_188509_g = owner instanceof EntityLiving ? ((EntityLiving)owner).func_70638_az() : (owner != null ? (owner.func_70643_av() != null ? owner.func_70643_av() : owner.func_110144_aD()) : null);
                return this.field_188509_g != null && this.func_75296_a(this.field_188509_g, false);
            }

            public void func_75249_e() {
                this.attacker.func_70624_b(this.field_188509_g);
                super.func_75249_e();
            }
        }

        public class AIChargeAttack
        extends EntityAIBase {
            private Base attacker;

            public AIChargeAttack(Base attackerIn) {
                this.attacker = attackerIn;
                this.func_75248_a(1);
            }

            public boolean func_75250_a() {
                if (this.attacker.func_70638_az() != null && !this.attacker.func_70605_aq().func_75640_a() && this.attacker.field_70146_Z.nextInt(5) == 0) {
                    return this.attacker.func_70068_e((Entity)this.attacker.func_70638_az()) > 4.0;
                }
                return false;
            }

            public boolean func_75253_b() {
                return this.attacker.func_70605_aq().func_75640_a() && this.attacker.func_70638_az() != null && this.attacker.func_70638_az().func_70089_S();
            }

            public void func_75249_e() {
                EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
                Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                this.attacker.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 2.0);
            }

            public void func_75246_d() {
                EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
                if (this.attacker.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                    this.attacker.func_70652_k((Entity)entitylivingbase);
                } else if (this.attacker.func_70068_e((Entity)entitylivingbase) < 9.0) {
                    Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                    this.attacker.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 2.0);
                }
            }
        }

        public class AIStayInFrontOfOwner
        extends EntityAIBase {
            private final Base entity;
            private EntityLivingBase owner;
            private final Vec3d offsetVec;

            public AIStayInFrontOfOwner(Base entityIn, double offX, double offY, double offZ) {
                this.entity = entityIn;
                this.offsetVec = new Vec3d(offX, offY, offZ);
                this.func_75248_a(3);
            }

            public boolean func_75250_a() {
                EntityLivingBase entitylb = this.entity.getOwner();
                if (entitylb == null) {
                    return false;
                }
                if (entitylb instanceof EntityPlayer && ((EntityPlayer)entitylb).func_175149_v()) {
                    return false;
                }
                if (this.entity.func_70068_e((Entity)entitylb) > 1600.0) {
                    return false;
                }
                this.owner = entitylb;
                return true;
            }

            public boolean func_75253_b() {
                return this.owner != null && this.entity.func_70068_e((Entity)this.owner) <= 1600.0;
            }

            public void func_75251_c() {
                this.owner = null;
            }

            public void func_75246_d() {
                if (this.owner != null) {
                    Vec3d vec = this.offsetVec.func_178785_b(-this.owner.field_70177_z * (float)Math.PI / 180.0f).func_178787_e(this.owner.func_174791_d());
                    BlockPos pos = new BlockPos(vec);
                    for (int i = 0; i < 4 && !this.isOpenPath(this.entity.field_70170_p, pos.func_177981_b(i)); ++i) {
                        vec = vec.func_72441_c(0.0, 1.01, 0.0);
                    }
                    this.entity.func_70605_aq().func_75642_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, this.entity.func_70011_f(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c));
                }
            }

            private boolean isOpenPath(World world, BlockPos pos) {
                return world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) == null && world.func_180495_p(pos.func_177984_a()).func_185890_d((IBlockAccess)world, pos.func_177984_a()) == null;
            }
        }

        public class FlyHelper
        extends EntityMoveHelper {
            public FlyHelper(Base entityIn) {
                super((EntityLiving)entityIn);
            }

            public void func_75641_c() {
                if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                    double d1 = this.field_75647_c - this.field_75648_a.field_70163_u;
                    double d2 = this.field_75644_d - this.field_75648_a.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    if (d3 < 1.6E-7) {
                        ProcedureUtils.multiplyVelocity((Entity)this.field_75648_a, 0.0);
                    } else {
                        float f1;
                        float f = (float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111126_e()) * 0.1f;
                        this.field_75648_a.field_70159_w += d0 / d3 * (double)f;
                        this.field_75648_a.field_70181_x += d1 / d3 * (double)f;
                        this.field_75648_a.field_70179_y += d2 / d3 * (double)f;
                        this.field_75648_a.field_70761_aq = this.field_75648_a.field_70177_z = (f1 = -((float)MathHelper.func_181159_b((double)this.field_75648_a.field_70159_w, (double)this.field_75648_a.field_70179_y)) * 57.295776f);
                    }
                }
            }
        }
    }
}

