/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityNinjaMerchant;
import net.narutomod.entity.EntityNinjaMob;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.item.ItemIryoJutsu;
import net.narutomod.item.ItemMilitaryRationsPill;
import net.narutomod.item.ItemMilitaryRationsPillGold;
import net.narutomod.item.ItemScrollEnhancedStrength;
import net.narutomod.item.ItemScrollHealing;
import net.narutomod.potion.PotionChakraEnhancedStrength;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySakuraHaruno
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 168;
    public static final int ENTITYID_RANGED = 169;

    public EntitySakuraHaruno(ElementsNarutomodMod instance) {
        super(instance, 439);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EntityCustom.class).id(new ResourceLocation("narutomod", "sakura_haruno"), 168).name("sakura_haruno").tracker(64, 3, true).egg(-3407668, -26215).build());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EntityCustom.LivingHook());
        EntityRegistry.addSpawn(EntityCustom.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])new Biome[]{Biomes.field_76767_f, Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_76785_t, Biomes.field_76782_w, Biomes.field_150574_L, Biomes.field_76792_x, Biomes.field_76772_c, Biomes.field_150585_R, Biomes.field_76768_g, Biomes.field_76784_u, Biomes.field_150578_U, Biomes.field_150581_V, Biomes.field_185441_Q, Biomes.field_185444_T, Biomes.field_185448_Z, Biomes.field_185429_aa, Biomes.field_185446_X, Biomes.field_185447_Y, Biomes.field_185430_ab, Biomes.field_150590_f, Biomes.field_185432_ad, Biomes.field_185433_ae});
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EntityCustom.class, renderManager -> new EntityNinjaMob.RenderBase<EntityCustom>(renderManager, (ModelBiped)new ModelBiped64slim()){
                private final ResourceLocation texture;
                {
                    super(renderManager, model);
                    this.texture = new ResourceLocation("narutomod:textures/sakura_slim.png");
                }

                protected ResourceLocation getEntityTexture(EntityCustom entity) {
                    return this.texture;
                }

                protected void preRenderCallback(EntityCustom entity, float partialTickTime) {
                    float f = 0.875f;
                    GlStateManager.func_179152_a((float)f, (float)f, (float)f);
                }
            });
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelBiped64slim
        extends ModelBiped {
            public ModelBiped64slim() {
                this.field_78090_t = 64;
                this.field_78089_u = 64;
                this.field_187075_l = ModelBiped.ArmPose.EMPTY;
                this.field_187076_m = ModelBiped.ArmPose.EMPTY;
                this.field_78116_c = new ModelRenderer((ModelBase)this);
                this.field_78116_c.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78116_c.field_78804_l.add(new ModelBox(this.field_78116_c, 0, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.0f, false));
                this.field_178720_f = new ModelRenderer((ModelBase)this);
                this.field_178720_f.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_178720_f.field_78804_l.add(new ModelBox(this.field_178720_f, 32, 0, -4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f, false));
                this.field_78115_e = new ModelRenderer((ModelBase)this);
                this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 16, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.0f, false));
                this.field_78115_e.field_78804_l.add(new ModelBox(this.field_78115_e, 16, 32, -4.0f, 0.0f, -2.0f, 8, 12, 4, 0.25f, false));
                this.field_178723_h = new ModelRenderer((ModelBase)this);
                this.field_178723_h.func_78793_a(-5.0f, 2.0f, 0.0f);
                this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 16, -2.0f, -2.0f, -2.0f, 3, 12, 4, 0.0f, false));
                this.field_178723_h.field_78804_l.add(new ModelBox(this.field_178723_h, 40, 32, -2.0f, -2.0f, -2.0f, 3, 12, 4, 0.25f, false));
                this.field_178724_i = new ModelRenderer((ModelBase)this);
                this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
                this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 32, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, 0.0f, false));
                this.field_178724_i.field_78804_l.add(new ModelBox(this.field_178724_i, 48, 48, -1.0f, -2.0f, -2.0f, 3, 12, 4, 0.25f, false));
                this.field_178721_j = new ModelRenderer((ModelBase)this);
                this.field_178721_j.func_78793_a(-1.9f, 12.0f, 0.0f);
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 16, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
                this.field_178721_j.field_78804_l.add(new ModelBox(this.field_178721_j, 0, 32, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
                this.field_178722_k = new ModelRenderer((ModelBase)this);
                this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 16, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f, false));
                this.field_178722_k.field_78804_l.add(new ModelBox(this.field_178722_k, 0, 48, -2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f, false));
            }
        }
    }

    public static class EntityCustom
    extends EntityNinjaMerchant.Base {
        private EntityLivingBase healTarget;
        private List<EntityLivingBase> healableEntities = Lists.newArrayList();

        public EntityCustom(World world) {
            super(world, 80);
            this.func_70105_a(0.525f, 1.75f);
            Arrays.fill(this.field_82174_bp, 0.0f);
        }

        @Override
        public Map<EntityNinjaMerchant.TradeLevel, MerchantRecipeList> getTrades() {
            HashMap trades = Maps.newHashMap();
            MerchantRecipeList commonTrades = new MerchantRecipeList();
            commonTrades.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 1), ItemStack.field_190927_a, new ItemStack(Items.field_151168_bH, 3), 0, 1));
            commonTrades.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 5), ItemStack.field_190927_a, new ItemStack(ItemMilitaryRationsPill.block, 2), 0, 1));
            MerchantRecipeList uncommonTrades = new MerchantRecipeList();
            uncommonTrades.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 20), ItemStack.field_190927_a, new ItemStack(ItemScrollHealing.block, 1), 0, 1));
            uncommonTrades.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 15), ItemStack.field_190927_a, new ItemStack(ItemMilitaryRationsPillGold.block, 1, 1), 0, 1));
            MerchantRecipeList rareTrades = new MerchantRecipeList();
            rareTrades.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, 45), ItemStack.field_190927_a, new ItemStack(ItemScrollEnhancedStrength.block, 1), 0, 1));
            trades.put(EntityNinjaMerchant.TradeLevel.COMMON, commonTrades);
            trades.put(EntityNinjaMerchant.TradeLevel.UNCOMMON, uncommonTrades);
            trades.put(EntityNinjaMerchant.TradeLevel.RARE, rareTrades);
            return trades;
        }

        public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
            livingdata = super.func_180482_a(difficulty, livingdata);
            ItemStack iryoJutsu = new ItemStack(ItemIryoJutsu.block);
            ItemIryoJutsu.RangedItem item = (ItemIryoJutsu.RangedItem)iryoJutsu.func_77973_b();
            item.setOwner(iryoJutsu, (EntityLivingBase)this);
            item.enableJutsu(iryoJutsu, ItemIryoJutsu.HEALING, true);
            item.addCurrentJutsuXp(iryoJutsu, item.getCurrentJutsuRequiredXp(iryoJutsu));
            this.setItemToInventory(iryoJutsu, 0);
            return livingdata;
        }

        @Override
        protected void func_110147_ax() {
            super.func_110147_ax();
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        }

        @Override
        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget(this, EntityZombie.class, false, false){

                public boolean func_75250_a() {
                    return this.func_110175_bO() && super.func_75250_a();
                }
            });
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget(this, EntityCreeper.class, false, false){

                public boolean func_75250_a() {
                    return this.func_110175_bO() && super.func_75250_a();
                }
            });
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIHeal(this, 1.2));
        }

        public boolean func_184191_r(Entity entityIn) {
            return EntityNinjaMob.TeamKonoha.contains(entityIn.getClass()) || this.healableEntities.contains(entityIn);
        }

        @Override
        public boolean func_70601_bi() {
            return super.func_70601_bi() && this.field_70170_p.func_72872_a(EntityCustom.class, this.func_174813_aQ().func_72314_b(128.0, 16.0, 128.0)).isEmpty();
        }

        protected float func_70647_i() {
            return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 2.4f;
        }

        @Nullable
        public EntityLivingBase getHealTarget() {
            return this.healTarget;
        }

        public void setHealTarget(@Nullable EntityLivingBase target) {
            if (target == null == (this.func_184614_ca().func_77973_b() == ItemIryoJutsu.block)) {
                this.func_184602_cy();
                this.swapWithInventory(EntityEquipmentSlot.MAINHAND, 0);
            }
            this.healTarget = target;
        }

        public boolean canHealEntity(EntityLivingBase entity) {
            return this.healableEntities.contains(entity) || this.func_184191_r((Entity)entity) || entity instanceof EntityVillager;
        }

        public void addHealableEntity(EntityLivingBase entity) {
            this.healableEntities.add(entity);
        }

        public void healTargetEntity() {
            if (this.healTarget != null && this.func_184614_ca().func_77973_b() == ItemIryoJutsu.block) {
                if ((double)this.func_70032_d((Entity)this.healTarget) <= 0.8 * (double)(this.field_70130_N + this.healTarget.field_70130_N)) {
                    if (!this.func_184587_cr()) {
                        this.func_184598_c(EnumHand.MAIN_HAND);
                    }
                } else if (this.func_184587_cr()) {
                    this.func_184602_cy();
                }
            }
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source != DamageSource.field_76380_i && amount >= this.func_110143_aJ()) {
                amount = this.func_110143_aJ() - 1.0f;
            }
            return super.func_70097_a(source, amount);
        }

        @Override
        public boolean func_70652_k(Entity entityIn) {
            boolean flag = super.func_70652_k(entityIn);
            if (flag) {
                ProcedureUtils.pushEntity((Entity)this, entityIn, 10.0, 1.5f);
            }
            return flag;
        }

        @Override
        public void func_70636_d() {
            super.func_70636_d();
            if (this.field_70173_aa % 20 == 0) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(10.0f);
                }
                this.func_70690_d(new PotionEffect(PotionChakraEnhancedStrength.potion, 21, 10, false, false));
            }
        }

        protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        }

        protected boolean func_146066_aG() {
            return false;
        }

        public static class LivingHook {
            @SubscribeEvent
            public void onLivingDrop(LivingDropsEvent event) {
                if (event.getEntity() instanceof EntityCustom) {
                    event.setCanceled(true);
                }
            }
        }

        public class AIHeal
        extends EntityAIBase {
            private final EntityCustom entity;
            private final double speed;
            private final int chance;
            private EntityLivingBase target;
            private int delayCounter;
            private Vec3d lastVec;

            public AIHeal(EntityCustom healer, double speedIn) {
                this(healer, speedIn, 40);
            }

            public AIHeal(EntityCustom healer, double speedIn, int chanceIn) {
                this.entity = healer;
                this.speed = speedIn;
                this.chance = chanceIn;
                this.func_75248_a(3);
            }

            public boolean func_75250_a() {
                Predicate canHeal = Predicates.and((Predicate)EntitySelectors.field_188444_d, (Predicate)new Predicate<EntityLivingBase>(){

                    public boolean apply(@Nullable EntityLivingBase p_apply_1_) {
                        return p_apply_1_ != null && p_apply_1_.func_110143_aJ() < p_apply_1_.func_110138_aP() * 0.4f && AIHeal.this.entity.canHealEntity(p_apply_1_) && AIHeal.this.inRange((Entity)p_apply_1_);
                    }
                });
                EntityLivingBase livingentity = this.entity.getHealTarget();
                if (livingentity == null && this.entity.func_110175_bO() && this.entity.field_70146_Z.nextInt(this.chance) == 0) {
                    double d = this.entity.func_110174_bM();
                    AxisAlignedBB bb = new AxisAlignedBB(this.entity.func_180486_cf()).func_72314_b(d, 8.0, d);
                    livingentity = ProcedureUtils.findNearestEntityWithinAABB(this.entity.field_70170_p, EntityLivingBase.class, bb, (Entity)this.entity, canHeal);
                }
                if (livingentity != null && livingentity.func_70089_S() && canHeal.apply((Object)livingentity)) {
                    this.target = livingentity;
                }
                return this.target != null;
            }

            private boolean inRange(Entity entityIn) {
                return (double)this.entity.func_70032_d(entityIn) <= ProcedureUtils.getFollowRange((EntityLivingBase)this.entity);
            }

            public boolean func_75253_b() {
                return this.target.func_70089_S() && this.inRange((Entity)this.target) && this.target.func_110143_aJ() < this.target.func_110138_aP() * 0.9f;
            }

            public void func_75249_e() {
                this.entity.setHealTarget(this.target);
                this.entity.func_70661_as().func_75497_a((Entity)this.target, this.speed);
            }

            public void func_75251_c() {
                this.target = null;
                this.entity.setHealTarget(null);
                this.entity.func_70661_as().func_75499_g();
            }

            public void func_75246_d() {
                Vec3d vec = this.target.func_174824_e(1.0f).func_178786_a(0.0, 0.3, 0.0);
                this.entity.func_70671_ap().func_75650_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 30.0f, 30.0f);
                double d0 = this.entity.func_70068_e((Entity)this.target);
                --this.delayCounter;
                if (this.delayCounter <= 0 && (this.lastVec == null || this.target.func_70092_e(this.lastVec.field_72450_a, this.lastVec.field_72448_b, this.lastVec.field_72449_c) >= 1.0 || this.entity.func_70681_au().nextFloat() < 0.05f)) {
                    double d;
                    this.lastVec = this.target.func_174791_d();
                    this.delayCounter = 4 + this.entity.func_70681_au().nextInt(7);
                    double d2 = d = d0 < 9.0 ? this.speed * 0.4 : this.speed;
                    if (!this.entity.func_70661_as().func_75497_a((Entity)this.target, d)) {
                        this.delayCounter += 15;
                    }
                }
                this.entity.healTargetEntity();
            }
        }
    }
}

