/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.Particles;
import net.narutomod.entity.EntityScalableProjectile;
import net.narutomod.item.ItemGourd;
import net.narutomod.item.ItemJiton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySandBullet
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 202;
    public static final int ENTITYID_RANGED = 203;
    private static final Random rand = new Random();
    private static final Map<ItemStack, List<ItemJiton.SwarmTarget>> posMap = Maps.newHashMap();

    public EntitySandBullet(ElementsNarutomodMod instance) {
        super(instance, 519);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "sand_bullet"), 202).name("sand_bullet").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new CustomRender(renderManager));
    }

    @Nullable
    private static List<ItemJiton.SwarmTarget> getStartPosList(ItemStack stack) {
        List<ItemJiton.SwarmTarget> list = posMap.get(stack);
        if (list != null) {
            return list;
        }
        for (Map.Entry<ItemStack, List<ItemJiton.SwarmTarget>> entry : posMap.entrySet()) {
            if (!ItemStack.func_77989_b((ItemStack)entry.getKey(), (ItemStack)stack)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addPos(ItemStack stack, EntityLivingBase entity, float power) {
        ArrayList list = EntitySandBullet.getStartPosList(stack);
        if (list == null) {
            list = Lists.newArrayList();
            posMap.put(stack, list);
        }
        list.add(new ItemJiton.SwarmTarget(entity.field_70170_p, 1, ItemGourd.getMouthPos(entity), new Vec3d(entity.field_70165_t + (entity.func_70681_au().nextDouble() - 0.5) * (double)power * 2.0, entity.field_70163_u + (double)entity.func_70047_e() + (entity.func_70681_au().nextDouble() - 0.5) * 2.0, entity.field_70161_v + (entity.func_70681_au().nextDouble() - 0.5) * (double)power * 2.0), new Vec3d(0.1, 0.2, 0.1), 0.5f, 0.01f, false, 0.5f, ItemJiton.getSandType(stack).getColor()));
    }

    public static void updateSwarms(ItemStack stack) {
        List<ItemJiton.SwarmTarget> list = EntitySandBullet.getStartPosList(stack);
        if (list != null && !list.isEmpty()) {
            for (ItemJiton.SwarmTarget st : list) {
                st.onUpdate();
            }
        }
    }

    public static class EC
    extends EntityScalableProjectile.Base {
        private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private int delay;

        public EC(World worldIn) {
            super(worldIn);
            this.setOGSize(0.2f, 0.2f);
        }

        public EC(EntityLivingBase shooter, ItemJiton.Type sandType) {
            this(shooter, sandType, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, 0);
        }

        public EC(EntityLivingBase shooter, ItemJiton.Type sandType, double x, double y, double z, int delayTicks) {
            super(shooter);
            this.setOGSize(0.2f, 0.2f);
            this.func_70107_b(x, y, z);
            this.setColor(sandType.getColor());
            this.delay = delayTicks;
        }

        @Override
        protected void func_70088_a() {
            super.func_70088_a();
            this.field_70180_af.func_187214_a(COLOR, (Object)0);
        }

        public int getColor() {
            return (Integer)this.field_70180_af.func_187225_a(COLOR);
        }

        protected void setColor(int color) {
            this.field_70180_af.func_187227_b(COLOR, (Object)color);
        }

        @Override
        public void func_70071_h_() {
            if (this.ticksAlive >= this.delay && this.shootingEntity != null) {
                Vec3d vec = this.shootingEntity.func_70040_Z();
                this.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.2f, 0.1f);
            }
            super.func_70071_h_();
            if (this.ticksAlive > this.delay + 80) {
                this.func_70106_y();
            }
        }

        @Override
        protected void onImpact(RayTraceResult result) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:bullet_impact")), 1.0f, 0.4f + this.field_70146_Z.nextFloat() * 0.6f);
                this.field_70170_p.func_72876_a((Entity)this.shootingEntity, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, 3.0f, ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this.shootingEntity));
                if (result.field_72308_g instanceof EntityLivingBase) {
                    result.field_72308_g.field_70172_ad = 10;
                    result.field_72308_g.func_70097_a(ItemJutsu.causeJutsuDamage(this, this.shootingEntity).func_76349_b(), 15.0f);
                    ProcedureUtils.pushEntity(this, result.field_72308_g, 10.0, 3.0f);
                }
                this.func_70106_y();
            }
        }

        @Override
        protected void checkOnGround() {
        }

        @Override
        public void renderParticles() {
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                List list = EntitySandBullet.getStartPosList(stack);
                if (list != null) {
                    Iterator iter = list.iterator();
                    int i = 0;
                    while (iter.hasNext()) {
                        ItemJiton.SwarmTarget st = (ItemJiton.SwarmTarget)iter.next();
                        Vec3d vec = st.getTargetPos();
                        this.createJutsu(ItemJiton.getSandType(stack), entity, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, i);
                        st.forceRemove();
                        iter.remove();
                        ++i;
                    }
                } else {
                    this.createJutsu(ItemJiton.getSandType(stack), entity, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v, 0);
                }
                return true;
            }

            public void createJutsu(ItemJiton.Type type, EntityLivingBase entity, double x, double y, double z, int delay) {
                entity.field_70170_p.func_184148_a(null, x, y, z, SoundEvents.field_187753_eE, SoundCategory.BLOCKS, 0.5f, entity.func_70681_au().nextFloat() * 0.4f + 0.6f);
                entity.field_70170_p.func_72838_d((Entity)new EC(entity, type, x, y, z, delay));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class CustomRender
    extends Render<EC> {
        public CustomRender(RenderManager renderManagerIn) {
            super(renderManagerIn);
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
            Particles.spawnParticle(entity.field_70170_p, Particles.Types.SUSPENDED, x + this.field_76990_c.field_78730_l, y + this.field_76990_c.field_78731_m + 0.1, z + this.field_76990_c.field_78728_n, 10, 0.1, 0.1, 0.1, 0.0, 0.0, 0.0, entity.getColor(), 15, 5);
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return null;
        }
    }
}

