/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.entity.EntityBeamBase;
import net.narutomod.entity.EntityBijuManager;
import net.narutomod.entity.EntityRendererRegister;
import net.narutomod.item.ItemJutsu;
import net.narutomod.potion.PotionHeaviness;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntitySealingChains
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 245;
    public static final int ENTITYID_RANGED = 246;

    public EntitySealingChains(ElementsNarutomodMod instance) {
        super(instance, 574);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "sealing_chains"), 245).name("sealing_chains").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        new Renderer().register();
    }

    public static class Renderer
    extends EntityRendererRegister {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void register() {
            RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new CustomRender(renderManager));
        }

        @SideOnly(value=Side.CLIENT)
        public class ModelChainLink
        extends EntityBeamBase.Model {
            private final ModelRenderer chain;
            private final ModelRenderer[] link = new ModelRenderer[640];
            private final ModelRenderer tip;

            public void addLinks(int howmany) {
                howmany = MathHelper.func_76125_a((int)howmany, (int)1, (int)this.link.length);
                for (int i = 0; i < this.link.length; ++i) {
                    this.link[i].field_78806_j = i < howmany;
                }
                this.tip.func_78793_a(0.0f, (float)howmany * 2.5f, 0.0f);
            }

            public ModelChainLink() {
                this.field_78090_t = 16;
                this.field_78089_u = 16;
                this.chain = new ModelRenderer((ModelBase)this);
                for (int i = 0; i < this.link.length; ++i) {
                    this.link[i] = new ModelRenderer((ModelBase)this);
                    this.setRotationAngle(this.link[i], 0.0f, (float)((double)i * Math.PI * 0.4722222), 0.0f);
                    this.link[i].func_78793_a(0.0f, (float)i * 2.5f, 0.0f);
                    this.link[i].field_78804_l.add(new ModelBox(this.link[i], 0, 0, -0.5f, 0.0f, -1.0f, 1, 3, 2, 0.0f, false));
                    this.link[i].field_78804_l.add(new ModelBox(this.link[i], 8, 2, -0.5f, 0.0f, -1.0f, 1, 3, 2, 0.2f, false));
                    this.chain.func_78792_a(this.link[i]);
                }
                this.tip = new ModelRenderer((ModelBase)this);
                this.setRotationAngle(this.tip, 0.0f, -0.7854f, 0.0f);
                this.chain.func_78792_a(this.tip);
                this.addLinks(1);
                ModelRenderer bone = new ModelRenderer((ModelBase)this);
                bone.func_78793_a(0.0f, 2.0f, 0.0f);
                this.tip.func_78792_a(bone);
                this.setRotationAngle(bone, 0.0f, 0.0f, 0.7854f);
                bone.field_78804_l.add(new ModelBox(bone, 1, 10, -1.0f, -1.0f, 0.0f, 2, 2, 0, 0.0f, false));
                bone.field_78804_l.add(new ModelBox(bone, 12, 2, -1.0f, -1.0f, 0.0f, 2, 2, 0, 0.2f, false));
                bone = new ModelRenderer((ModelBase)this);
                bone.func_78793_a(0.0f, 2.0f, 0.0f);
                this.tip.func_78792_a(bone);
                this.setRotationAngle(bone, -0.7854f, 0.0f, 0.0f);
                bone.field_78804_l.add(new ModelBox(bone, 2, 8, 0.0f, -1.0f, -1.0f, 0, 2, 2, 0.0f, false));
                bone.field_78804_l.add(new ModelBox(bone, 12, 2, 0.0f, -1.0f, -1.0f, 0, 2, 2, 0.2f, false));
                ModelRenderer bone2 = new ModelRenderer((ModelBase)this);
                bone2.func_78793_a(0.0f, 3.0f, 0.0f);
                this.tip.func_78792_a(bone2);
                this.setRotationAngle(bone2, 0.0f, 0.0f, 0.7854f);
                bone2.field_78804_l.add(new ModelBox(bone2, 1, 10, -1.0f, -1.0f, 0.0f, 2, 2, 0, 0.0f, false));
                bone2.field_78804_l.add(new ModelBox(bone2, 12, 2, -1.0f, -1.0f, 0.0f, 2, 2, 0, 0.2f, false));
                bone2 = new ModelRenderer((ModelBase)this);
                bone2.func_78793_a(0.0f, 3.0f, 0.0f);
                this.tip.func_78792_a(bone2);
                this.setRotationAngle(bone2, -0.7854f, 0.0f, 0.0f);
                bone2.field_78804_l.add(new ModelBox(bone2, 2, 8, 0.0f, -1.0f, -1.0f, 0, 2, 2, 0.0f, false));
                bone2.field_78804_l.add(new ModelBox(bone2, 12, 2, 0.0f, -1.0f, -1.0f, 0, 2, 2, 0.2f, false));
            }

            @Override
            public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
                this.chain.func_78785_a(f5);
            }

            public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
                modelRenderer.field_78795_f = x;
                modelRenderer.field_78796_g = y;
                modelRenderer.field_78808_h = z;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public class CustomRender
        extends EntityBeamBase.Renderer<EC> {
            private final ResourceLocation texture;
            private final ModelChainLink model;

            public CustomRender(RenderManager renderManagerIn) {
                super(renderManagerIn);
                this.texture = new ResourceLocation("narutomod:textures/chainlink_gold.png");
                this.model = new ModelChainLink();
            }

            @Override
            public EntityBeamBase.Model getMainModel(EC entity) {
                this.model.addLinks(MathHelper.func_76123_f((float)(entity.getBeamLength() * 6.4f)) - 1);
                return this.model;
            }

            @Override
            public void doRender(EC bullet, double x, double y, double z, float yaw, float pt) {
                EntityLivingBase shooter = bullet.getShooter();
                if (shooter != null) {
                    bullet.func_70107_b(shooter.field_70142_S + (shooter.field_70165_t - shooter.field_70142_S) * (double)pt, shooter.field_70137_T + (shooter.field_70163_u - shooter.field_70137_T) * (double)pt + (double)(shooter.field_70131_O / 2.0f), shooter.field_70136_U + (shooter.field_70161_v - shooter.field_70136_U) * (double)pt);
                    x = bullet.field_70165_t - this.func_177068_d().field_78730_l;
                    y = bullet.field_70163_u - this.func_177068_d().field_78731_m;
                    z = bullet.field_70161_v - this.func_177068_d().field_78728_n;
                }
                if (bullet.getTarget() != null) {
                    ProcedureUtils.Vec2f vec2f = ProcedureUtils.getYawPitchFromVec(bullet.getTargetAttachVec().func_178788_d(bullet.func_174791_d()));
                    this.func_180548_c(bullet);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                    GlStateManager.func_179114_b((float)(-vec2f.x), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(90.0f + vec2f.y), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179129_p();
                    GlStateManager.func_179140_f();
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    this.getMainModel(bullet).func_78088_a(bullet, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179121_F();
                }
            }

            @Override
            protected ResourceLocation getEntityTexture(EC entity) {
                return this.texture;
            }
        }
    }

    public static class EC
    extends EntityBeamBase.Base {
        private static final DataParameter<Integer> TARGET_ID = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Float> TARGET_OFFX = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> TARGET_OFFY = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private static final DataParameter<Float> TARGET_OFFZ = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187193_c);
        private double initialDistance;
        private int slowAmplifier;
        private int retractTime = -1;
        private final double baseChakraDrainOnTarget = 10.0;

        public EC(World worldIn) {
            super(worldIn);
            this.field_70178_ae = true;
        }

        public EC(World worldIn, double x, double y, double z, EntityLivingBase targetIn) {
            super(worldIn, x, y, z);
            this.setTarget(targetIn);
            this.updatePosition();
        }

        public EC(EntityLivingBase shooter, EntityLivingBase targetIn) {
            super(shooter);
            this.setTarget(targetIn);
            this.updatePosition();
        }

        @Override
        protected void func_70088_a() {
            super.func_70088_a();
            this.field_70180_af.func_187214_a(TARGET_ID, (Object)-1);
            this.field_70180_af.func_187214_a(TARGET_OFFX, (Object)Float.valueOf(0.0f));
            this.field_70180_af.func_187214_a(TARGET_OFFY, (Object)Float.valueOf(0.0f));
            this.field_70180_af.func_187214_a(TARGET_OFFZ, (Object)Float.valueOf(0.0f));
        }

        @Nullable
        private EntityLivingBase getTarget() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(TARGET_ID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        private void setTarget(EntityLivingBase targetIn) {
            this.field_70180_af.func_187227_b(TARGET_ID, (Object)targetIn.func_145782_y());
            if (targetIn.func_70644_a(PotionHeaviness.potion)) {
                this.setTargetAttachVec((this.field_70146_Z.nextDouble() - 0.5) * (double)targetIn.field_70130_N * 0.9, this.field_70146_Z.nextDouble() * ((double)targetIn.func_70047_e() - 0.2 * (double)targetIn.field_70131_O) + 0.1 * (double)targetIn.field_70131_O, (this.field_70146_Z.nextDouble() - 0.5) * (double)targetIn.field_70130_N * 0.9);
                this.slowAmplifier = targetIn.func_70660_b(PotionHeaviness.potion).func_76458_c() + 1;
            } else {
                this.setTargetAttachVec(0.0, (double)targetIn.func_70047_e() - 0.1 * (double)targetIn.field_70131_O, 0.0);
                this.slowAmplifier = 1;
            }
            this.initialDistance = (double)this.func_70032_d((Entity)targetIn) - 1.0;
        }

        private void setTargetAttachVec(double x, double y, double z) {
            this.field_70180_af.func_187227_b(TARGET_OFFX, (Object)Float.valueOf((float)x));
            this.field_70180_af.func_187227_b(TARGET_OFFY, (Object)Float.valueOf((float)y));
            this.field_70180_af.func_187227_b(TARGET_OFFZ, (Object)Float.valueOf((float)z));
        }

        private Vec3d getTargetAttachVec() {
            EntityLivingBase target = this.getTarget();
            return target.func_174791_d().func_72441_c((double)((Float)this.field_70180_af.func_187225_a(TARGET_OFFX)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(TARGET_OFFY)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(TARGET_OFFZ)).floatValue());
        }

        private boolean isTargetable(@Nullable Entity targetIn) {
            return ItemJutsu.canTarget(targetIn) && (double)this.func_70032_d(targetIn) < this.initialDistance * 2.0;
        }

        @Override
        protected void updatePosition() {
            EntityLivingBase shooter = this.getShooter();
            if (shooter != null) {
                this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)(shooter.field_70131_O / 2.0f), shooter.field_70161_v);
            }
            if (!this.field_70170_p.field_72995_K && this.getTarget() != null) {
                double scale;
                Vec3d vec = this.getTargetAttachVec().func_178788_d(this.func_174791_d());
                double d = scale = this.retractTime >= 0 ? (double)this.retractTime / (double)this.getMaxRetractTime() : Math.min((double)this.field_70173_aa / vec.func_72433_c(), 1.0);
                if (scale < 1.0 && this.field_70173_aa % 10 == 0) {
                    this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:chains")), 1.0f, this.field_70146_Z.nextFloat() * 0.6f + 0.2f);
                }
                vec = vec.func_186678_a(scale);
                this.shoot(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
        }

        @Override
        public void func_70071_h_() {
            super.func_70071_h_();
            EntityLivingBase target = this.getTarget();
            if (this.shootingEntity != null && this.shootingEntity.func_70089_S() && this.isTargetable((Entity)target)) {
                if (this.retractTime < 0) {
                    double d;
                    if (this.field_70173_aa % 20 == 19) {
                        target.func_70690_d(new PotionEffect(PotionHeaviness.potion, 22, this.slowAmplifier));
                        d = this.shootingEntity instanceof EntityLivingBase ? Chakra.getLevel((EntityLivingBase)this.shootingEntity) * 0.02 : 1.0;
                        Chakra.pathway(target).consume(this.baseChakraDrainOnTarget * d);
                    }
                    if ((d = (double)this.func_70032_d((Entity)target)) > this.initialDistance && !target.func_184196_w(this.shootingEntity)) {
                        Vec3d vec = this.shootingEntity.func_174791_d().func_178788_d(target.func_174791_d()).func_72432_b().func_186678_a(0.2 * d / this.initialDistance);
                        target.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                        target.field_70133_I = true;
                    }
                    if (target instanceof EntityBijuManager.ITailBeast && this.shootingEntity instanceof EntityPlayer && ((EntityPlayer)this.shootingEntity).func_184812_l_() && ProcedureUtils.getModifiedSpeed(target) < 0.05) {
                        ((EntityBijuManager.ITailBeast)target).fuuinIntoVessel(this.shootingEntity, 400);
                    }
                } else if (--this.retractTime < 0) {
                    this.func_70106_y();
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }

        private int getMaxRetractTime() {
            return 20;
        }

        public void retract() {
            this.retractTime = this.getMaxRetractTime();
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                if (entity.func_70093_af()) {
                    for (EC entity1 : entity.field_70170_p.func_72872_a(EC.class, entity.func_174813_aQ().func_186662_g(1.0))) {
                        entity1.retract();
                    }
                } else {
                    RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 50.0);
                    if (res != null && res.field_72308_g instanceof EntityLivingBase) {
                        entity.field_70170_p.func_72838_d((Entity)new EC(entity, (EntityLivingBase)res.field_72308_g));
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

