/*
 * Decompiled with CFR 0.152.
 */
package net.narutomod.entity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.narutomod.Chakra;
import net.narutomod.ElementsNarutomodMod;
import net.narutomod.NarutomodModVariables;
import net.narutomod.PlayerInput;
import net.narutomod.item.ItemInton;
import net.narutomod.item.ItemJutsu;
import net.narutomod.procedure.ProcedureUtils;

@ElementsNarutomodMod.ModElement.Tag
public class EntityShadowImitation
extends ElementsNarutomodMod.ModElement {
    public static final int ENTITYID = 293;
    public static final int ENTITYID_RANGED = 294;

    public EntityShadowImitation(ElementsNarutomodMod instance) {
        super(instance, 618);
    }

    @Override
    public void initElements() {
        this.elements.entities.add(() -> EntityEntryBuilder.create().entity(EC.class).id(new ResourceLocation("narutomod", "shadow_imitation"), 293).name("shadow_imitation").tracker(64, 3, true).build());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInit(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EC.class, renderManager -> new RenderCustom(renderManager));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EC.PlayerHook());
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderCustom
    extends Render<EC> {
        private final ResourceLocation TEXTURE;

        public RenderCustom(RenderManager renderManagerIn) {
            super(renderManagerIn);
            this.TEXTURE = new ResourceLocation("narutomod:textures/black.png");
        }

        public boolean shouldRender(EC livingEntity, ICamera camera, double camX, double camY, double camZ) {
            return true;
        }

        public void doRender(EC entity, double x, double y, double z, float entityYaw, float partialTicks) {
            EntityLivingBase user = entity.getUser();
            EntityLivingBase target = entity.getTarget();
            if (user != null && target != null) {
                double d0 = user.field_70142_S + (user.field_70165_t - user.field_70142_S) * (double)partialTicks;
                double d1 = user.field_70137_T + (user.field_70163_u - user.field_70137_T) * (double)partialTicks;
                double d2 = user.field_70136_U + (user.field_70161_v - user.field_70136_U) * (double)partialTicks;
                double d3 = target.field_70142_S + (target.field_70165_t - target.field_70142_S) * (double)partialTicks;
                double d4 = target.field_70137_T + (target.field_70163_u - target.field_70137_T) * (double)partialTicks;
                double d5 = target.field_70136_U + (target.field_70161_v - target.field_70136_U) * (double)partialTicks;
                int i0 = MathHelper.func_76128_c((double)d0);
                int i1 = MathHelper.func_76128_c((double)Math.min(d1, d4)) - 10;
                int i2 = MathHelper.func_76128_c((double)d2);
                int i3 = MathHelper.func_76128_c((double)d3);
                int i4 = MathHelper.func_76128_c((double)Math.max(d1, d4)) + 1;
                int i5 = MathHelper.func_76128_c((double)d5);
                World world = this.field_76990_c.field_78722_g;
                this.field_76990_c.field_78724_e.func_110577_a(this.TEXTURE);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179132_a((boolean)false);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)new BlockPos(i0, i1, i2), (BlockPos)new BlockPos(i3, i4, i5))) {
                    IBlockState blockstate = world.func_180495_p(blockpos);
                    if (blockstate.func_185901_i() == EnumBlockRenderType.INVISIBLE || !blockstate.func_185917_h()) continue;
                    AxisAlignedBB axisalignedbb = blockstate.func_185900_c((IBlockAccess)world, blockpos).func_186670_a(blockpos);
                    if (!(blockpos.func_177957_d(d0, d1, d2) < 0.25 * (double)entity.field_70173_aa * (double)entity.field_70173_aa) || axisalignedbb.func_72321_a(0.0, (double)i4 - axisalignedbb.field_72337_e, 0.0).func_72327_a(new Vec3d(d0, d1, d2), new Vec3d(d3, d4, d5)) == null) continue;
                    double d6 = axisalignedbb.field_72340_a - this.field_76990_c.field_78730_l;
                    double d7 = axisalignedbb.field_72336_d - this.field_76990_c.field_78730_l;
                    double d8 = axisalignedbb.field_72338_b - this.field_76990_c.field_78731_m;
                    double d9 = axisalignedbb.field_72337_e - this.field_76990_c.field_78731_m;
                    double d10 = axisalignedbb.field_72339_c - this.field_76990_c.field_78728_n;
                    double d11 = axisalignedbb.field_72334_f - this.field_76990_c.field_78728_n;
                    bufferbuilder.func_181662_b(d6, d9 + 0.01, d10).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d6, d9 + 0.01, d11).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7, d9 + 0.01, d11).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7, d9 + 0.01, d10).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7 + 0.01, d9, d10).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7 + 0.01, d9, d11).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7 + 0.01, d8, d11).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7 + 0.01, d8, d10).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d6 - 0.01, d8, d10).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d6 - 0.01, d8, d11).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d6 - 0.01, d9, d11).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d6 - 0.01, d9, d10).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7, d8, d11 + 0.01).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7, d9, d11 + 0.01).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d6, d9, d11 + 0.01).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d6, d8, d11 + 0.01).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d6, d8, d10 - 0.01).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d6, d9, d10 - 0.01).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7, d9, d10 - 0.01).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                    bufferbuilder.func_181662_b(d7, d8, d10 - 0.01).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, 0.5f).func_181675_d();
                }
                tessellator.func_78381_a();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179132_a((boolean)true);
            }
        }

        protected ResourceLocation getEntityTexture(EC entity) {
            return this.TEXTURE;
        }
    }

    public static class EC
    extends Entity
    implements PlayerInput.Hook.IHandler {
        private static final DataParameter<Integer> USER_ID = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private static final DataParameter<Integer> TARGET_ID = EntityDataManager.func_187226_a(EC.class, (DataSerializer)DataSerializers.field_187192_b);
        private double chakraBurn;
        private PlayerInput.Hook userInput = new PlayerInput.Hook();

        public EC(World world) {
            super(world);
            this.func_70105_a(0.01f, 0.01f);
            this.field_70178_ae = true;
        }

        public EC(EntityLivingBase userIn, EntityLivingBase targetIn, double chakraUsagePerSec) {
            this(userIn.field_70170_p);
            this.setUser(userIn);
            this.setTarget(targetIn);
            this.func_70107_b(userIn.field_70165_t, userIn.field_70163_u, userIn.field_70161_v);
            this.chakraBurn = chakraUsagePerSec + ProcedureUtils.getPunchDamage(targetIn) * 5.0;
        }

        protected void func_70088_a() {
            this.func_184212_Q().func_187214_a(USER_ID, (Object)-1);
            this.func_184212_Q().func_187214_a(TARGET_ID, (Object)-1);
        }

        private void setUser(@Nullable EntityLivingBase entity) {
            this.func_184212_Q().func_187227_b(USER_ID, (Object)(entity != null ? entity.func_145782_y() : -1));
        }

        @Nullable
        private EntityLivingBase getUser() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(USER_ID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        private void setTarget(@Nullable EntityLivingBase entity) {
            this.func_184212_Q().func_187227_b(TARGET_ID, (Object)(entity != null ? entity.func_145782_y() : -1));
        }

        @Nullable
        private EntityLivingBase getTarget() {
            Entity entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(TARGET_ID)).intValue());
            return entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        }

        @Override
        public void handlePacket(@Nullable PlayerInput.Hook.MovementPacket movementPacket, @Nullable PlayerInput.Hook.MousePacket mousePacket) {
            if (movementPacket != null) {
                this.userInput.copyMovementInput(movementPacket);
            }
            if (mousePacket != null) {
                this.userInput.copyMouseInput(mousePacket);
            }
        }

        public void func_70106_y() {
            super.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                EntityLivingBase user = this.getUser();
                EntityLivingBase target = this.getTarget();
                if (user instanceof EntityPlayerMP) {
                    PlayerInput.Hook.copyInputFrom((EntityPlayerMP)user, this, false);
                }
                if (target != null) {
                    PlayerInput.Hook.haltTargetInput(target, false);
                }
                if (user != null) {
                    Jutsu.removeEntity(user, this.func_145782_y());
                }
            }
        }

        public void func_70071_h_() {
            EntityLivingBase user = this.getUser();
            EntityLivingBase target = this.getTarget();
            if (!this.field_70170_p.field_72995_K) {
                if (user != null && user.func_70089_S() && ItemJutsu.canTarget((Entity)target) && this.canTargetBeSeen()) {
                    this.func_70107_b(user.field_70165_t, user.field_70163_u, user.field_70161_v);
                    if (user.getEntityData().func_74767_n(NarutomodModVariables.JutsuKey2Pressed) || this.field_70173_aa % 20 == 1 && !Chakra.pathway(user).consume(this.chakraBurn)) {
                        this.func_70106_y();
                    } else {
                        if (this.field_70173_aa == 1) {
                            this.func_184185_a((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("narutomod:shadow_sfx")), 1.0f, 1.0f);
                            PlayerInput.Hook.haltTargetInput(target, true);
                            if (user instanceof EntityPlayer) {
                                PlayerInput.Hook.copyInputFrom((EntityPlayerMP)user, this, true);
                            }
                        }
                        if (this.userInput.hasNewMovementInput()) {
                            this.userInput.handleMovement(target);
                        }
                        if (this.userInput.hasNewMouseEvent()) {
                            this.userInput.handleMouseEvent(target);
                        }
                    }
                } else {
                    this.func_70106_y();
                }
            }
        }

        public boolean canTargetBeSeen() {
            EntityLivingBase user = this.getUser();
            EntityLivingBase target = this.getTarget();
            return this.field_70170_p.func_147447_a(user.func_174824_e(1.0f), target.func_174824_e(1.0f), false, true, false) == null || this.field_70170_p.func_147447_a(user.func_174824_e(1.0f), target.func_174791_d().func_72441_c(0.0, 0.2, 0.0), false, true, false) == null;
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }

        public static class PlayerHook {
            @SubscribeEvent
            public void onChangeDimension(EntityTravelToDimensionEvent event) {
                int[] intarray;
                Entity entity = event.getEntity();
                if (entity instanceof EntityLivingBase && (intarray = entity.getEntityData().func_74759_k("ShadowImitationEntityIdKey")).length > 0) {
                    for (int i = 0; i < intarray.length; ++i) {
                        Entity entity1 = entity.field_70170_p.func_73045_a(intarray[i]);
                        if (!(entity1 instanceof EC)) continue;
                        entity1.func_70106_y();
                    }
                    entity.getEntityData().func_82580_o("ShadowImitationEntityIdKey");
                }
            }
        }

        public static class Jutsu
        implements ItemJutsu.IJutsuCallback {
            private static final String ECENTITYID = "ShadowImitationEntityIdKey";

            @Override
            public boolean createJutsu(ItemStack stack, EntityLivingBase entity, float power) {
                int[] oldintarray;
                RayTraceResult res = ProcedureUtils.objectEntityLookingAt((Entity)entity, 30.0);
                if (res != null && res.field_72308_g instanceof EntityLivingBase && !this.intarrayContains(entity.field_70170_p, oldintarray = entity.getEntityData().func_74759_k(ECENTITYID), res.field_72308_g.func_145782_y())) {
                    int[] newintarray = new int[oldintarray.length + 1];
                    for (int i = 0; i < oldintarray.length; ++i) {
                        newintarray[i] = oldintarray[i];
                    }
                    EC entity1 = new EC(entity, (EntityLivingBase)res.field_72308_g, ItemInton.SHADOW_IMITATION.chakraUsage);
                    entity.field_70170_p.func_72838_d((Entity)entity1);
                    newintarray[oldintarray.length] = entity1.func_145782_y();
                    entity.getEntityData().func_74783_a(ECENTITYID, newintarray);
                    return true;
                }
                return false;
            }

            private boolean intarrayContains(World world, int[] intarray, int i) {
                for (int j = 0; j < intarray.length; ++j) {
                    EntityLivingBase target;
                    Entity entity = world.func_73045_a(intarray[j]);
                    if (!(entity instanceof EC) || (target = ((EC)entity).getTarget()) == null || target.func_145782_y() != i) continue;
                    return true;
                }
                return false;
            }

            public static void removeEntity(EntityLivingBase user, int entityId) {
                int[] oldintarray = user.getEntityData().func_74759_k(ECENTITYID);
                if (oldintarray.length > 1) {
                    int[] newintarray = new int[oldintarray.length - 1];
                    int i = 0;
                    for (int j = 0; j < oldintarray.length; ++j) {
                        if (oldintarray[j] == entityId) continue;
                        newintarray[i++] = oldintarray[j];
                    }
                    user.getEntityData().func_74783_a(ECENTITYID, newintarray);
                } else {
                    user.getEntityData().func_82580_o(ECENTITYID);
                }
            }

            private String intarrayTargets2String(World world, int[] intarray) {
                String s = "[";
                for (int i = 0; i < intarray.length; ++i) {
                    Entity entity = world.func_73045_a(intarray[i]);
                    if (!(entity instanceof EC)) continue;
                    if (i > 0) {
                        s = s + ", ";
                    }
                    s = s + ((EC)entity).getTarget().func_145782_y();
                }
                return s + "]";
            }
        }
    }
}

